/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.trans.steps.transexecutor;

import java.util.ArrayList;
import java.util.List;
import org.pentaho.di.core.Const;
import org.pentaho.di.core.Result;
import org.pentaho.di.core.ResultFile;
import org.pentaho.di.core.RowMetaAndData;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.exception.KettleStepException;
import org.pentaho.di.core.logging.KettleLogStore;
import org.pentaho.di.core.logging.LoggingRegistry;
import org.pentaho.di.core.row.RowDataUtil;
import org.pentaho.di.core.row.RowMeta;
import org.pentaho.di.core.row.RowMetaInterface;
import org.pentaho.di.i18n.BaseMessages;
import org.pentaho.di.job.DelegationListener;
import org.pentaho.di.trans.Trans;
import org.pentaho.di.trans.TransExecutionConfiguration;
import org.pentaho.di.trans.TransMeta;
import org.pentaho.di.trans.step.BaseStep;
import org.pentaho.di.trans.step.RowAdapter;
import org.pentaho.di.trans.step.StepDataInterface;
import org.pentaho.di.trans.step.StepInterface;
import org.pentaho.di.trans.step.StepMeta;
import org.pentaho.di.trans.step.StepMetaDataCombi;
import org.pentaho.di.trans.step.StepMetaInterface;
import org.pentaho.di.trans.steps.TransStepUtil;
import org.pentaho.di.trans.steps.transexecutor.TransExecutorData;
import org.pentaho.di.trans.steps.transexecutor.TransExecutorMeta;
import org.pentaho.di.trans.steps.transexecutor.TransExecutorParameters;

public class TransExecutor
extends BaseStep
implements StepInterface {
    private static final Class<?> PKG = TransExecutorMeta.class;
    private TransExecutorMeta meta;
    private TransExecutorData data;

    public TransExecutor(StepMeta stepMeta, StepDataInterface stepDataInterface, int copyNr, TransMeta transMeta, Trans trans) {
        super(stepMeta, stepDataInterface, copyNr, transMeta, trans);
    }

    @Override
    public boolean processRow(StepMetaInterface smi, StepDataInterface sdi) throws KettleException {
        try {
            long now;
            this.meta = (TransExecutorMeta)smi;
            this.setData((TransExecutorData)sdi);
            Object[] row = this.getRow();
            if (row == null) {
                this.executeTransformation();
                this.setOutputDone();
                return false;
            }
            if (this.first) {
                this.first = false;
                this.initOnFirstProcessingIteration();
            }
            if (this.getData().getExecutorStepOutputRowMeta() != null) {
                this.putRowTo(this.getData().getExecutorStepOutputRowMeta(), row, this.getData().getExecutorStepOutputRowSet());
            }
            boolean newGroup = false;
            if (this.getData().groupSize >= 0) {
                if (this.getData().groupSize != 0 && this.getData().groupBuffer.size() >= this.getData().groupSize) {
                    newGroup = true;
                }
            } else if (this.getData().groupFieldIndex >= 0) {
                Object groupFieldData = row[this.getData().groupFieldIndex];
                if (this.getData().prevGroupFieldData != null && this.getData().groupFieldMeta.compare(this.getData().prevGroupFieldData, groupFieldData) != 0) {
                    newGroup = true;
                }
                this.getData().prevGroupFieldData = groupFieldData;
            } else if (this.getData().groupTime > 0 && (now = System.currentTimeMillis()) - this.getData().groupTimeStart >= (long)this.getData().groupTime) {
                newGroup = true;
            }
            if (newGroup) {
                this.executeTransformation();
            }
            this.getData().groupBuffer.add(new RowMetaAndData(this.getInputRowMeta(), row));
            return true;
        }
        catch (Exception e) {
            throw new KettleException(BaseMessages.getString(PKG, (String)"TransExecutor.UnexpectedError", (String[])new String[0]), (Throwable)e);
        }
    }

    private void initOnFirstProcessingIteration() throws KettleException {
        this.getData().setInputRowMeta(this.getInputRowMeta());
        this.getData().setExecutionResultsOutputRowMeta((RowMetaInterface)new RowMeta());
        if (this.meta.getExecutionResultTargetStepMeta() != null) {
            this.meta.prepareExecutionResultsFields(this.getData().getExecutionResultsOutputRowMeta(), this.meta.getExecutionResultTargetStepMeta());
            this.getData().setExecutionResultRowSet(this.findOutputRowSet(this.meta.getExecutionResultTargetStepMeta().getName()));
        }
        this.getData().setResultFilesOutputRowMeta((RowMetaInterface)new RowMeta());
        if (this.meta.getResultFilesTargetStepMeta() != null) {
            this.meta.prepareExecutionResultsFileFields(this.getData().getResultFilesOutputRowMeta(), this.meta.getResultFilesTargetStepMeta());
            this.getData().setResultFilesRowSet(this.findOutputRowSet(this.meta.getResultFilesTargetStepMeta().getName()));
        }
        this.getData().setResultRowsOutputRowMeta((RowMetaInterface)new RowMeta());
        if (this.meta.getOutputRowsSourceStepMeta() != null) {
            this.meta.prepareResultsRowsFields(this.getData().getResultRowsOutputRowMeta());
            this.getData().setResultRowsRowSet(this.findOutputRowSet(this.meta.getOutputRowsSourceStepMeta().getName()));
        }
        if (this.meta.getExecutorsOutputStepMeta() != null) {
            this.getData().setExecutorStepOutputRowMeta(this.getInputRowMeta().clone());
            this.getData().setExecutorStepOutputRowSet(this.findOutputRowSet(this.meta.getExecutorsOutputStepMeta().getName()));
        }
        this.getData().groupFieldIndex = -1;
        if (!Const.isEmpty((String)this.getData().groupField)) {
            this.getData().groupFieldIndex = this.getInputRowMeta().indexOfValue(this.getData().groupField);
            if (this.getData().groupFieldIndex < 0) {
                throw new KettleException(BaseMessages.getString(PKG, (String)"TransExecutor.Exception.GroupFieldNotFound", (String[])new String[]{this.getData().groupField}));
            }
            this.getData().groupFieldMeta = this.getInputRowMeta().getValueMeta(this.getData().groupFieldIndex);
        }
    }

    private void executeTransformation() throws KettleException {
        if (this.getData().groupBuffer.isEmpty()) {
            return;
        }
        this.getData().groupTimeStart = System.currentTimeMillis();
        Trans executorTrans = this.getData().getExecutorTrans();
        if (executorTrans != null) {
            KettleLogStore.discardLines((String)executorTrans.getLogChannelId(), (boolean)false);
            LoggingRegistry.getInstance().removeIncludingChildren(executorTrans.getLogChannelId());
        }
        executorTrans = this.createInternalTrans();
        this.getData().setExecutorTrans(executorTrans);
        this.passParametersToTrans();
        this.getTrans().getActiveSubtransformations().put(this.getStepname(), executorTrans);
        Result result = new Result();
        result.setRows(this.getData().groupBuffer);
        executorTrans.setPreviousResult(result);
        try {
            executorTrans.prepareExecution(this.getTrans().getArguments());
            if (this.meta.getOutputRowsSourceStepMeta() != null) {
                List<StepMetaDataCombi> internalTransformationSteps = executorTrans.getSteps();
                StepInterface stepInterface = internalTransformationSteps.get((int)(internalTransformationSteps.size() - 1)).step;
                stepInterface.addRowListener(new RowAdapter(){

                    @Override
                    public void rowWrittenEvent(RowMetaInterface rowMeta, Object[] row) throws KettleStepException {
                        TransExecutor.this.putRowTo(rowMeta, row, TransExecutor.this.getData().getResultRowsRowSet());
                    }
                });
            }
            executorTrans.startThreads();
            for (DelegationListener delegationListener : this.getTrans().getDelegationListeners()) {
                delegationListener.transformationDelegationStarted(executorTrans, new TransExecutionConfiguration());
            }
            executorTrans.waitUntilFinished();
            result = executorTrans.getResult();
        }
        catch (KettleException e) {
            this.log.logError("An error occurred executing the transformation: ", (Throwable)e);
            result.setResult(false);
            result.setNrErrors(1L);
        }
        this.collectExecutionResults(result);
        this.collectExecutionResultFiles(result);
        this.getData().groupBuffer.clear();
    }

    private Trans createInternalTrans() throws KettleException {
        Trans executorTrans = new Trans(this.getData().getExecutorTransMeta(), this);
        executorTrans.setParentTrans(this.getTrans());
        executorTrans.setLogLevel(this.getLogLevel());
        executorTrans.setArguments(this.getTrans().getArguments());
        if (this.meta.getParameters().isInheritingAllVariables()) {
            executorTrans.shareVariablesWith(this);
        }
        executorTrans.setInternalKettleVariables(this);
        executorTrans.copyParametersFrom(this.getData().getExecutorTransMeta());
        executorTrans.setPreview(this.getTrans().isPreview());
        TransStepUtil.initServletConfig(this.getTrans(), executorTrans);
        return executorTrans;
    }

    private void passParametersToTrans() throws KettleException {
        TransExecutorParameters parameters = this.meta.getParameters();
        Trans internalTrans = this.getData().getExecutorTrans();
        internalTrans.clearParameters();
        String[] parameterNames = internalTrans.listParameters();
        for (int i = 0; i < parameters.getVariable().length; ++i) {
            String value;
            String variable = parameters.getVariable()[i];
            String fieldName = parameters.getField()[i];
            String inputValue = parameters.getInput()[i];
            if (!Const.isEmpty((String)fieldName)) {
                int idx = this.getInputRowMeta().indexOfValue(fieldName);
                if (idx < 0) {
                    throw new KettleException(BaseMessages.getString(PKG, (String)"TransExecutor.Exception.UnableToFindField", (String[])new String[]{fieldName}));
                }
                value = this.getData().groupBuffer.get(0).getString(idx, "");
            } else {
                value = this.environmentSubstitute(inputValue);
            }
            if (Const.indexOfString((String)variable, (String[])parameterNames) < 0) {
                internalTrans.setVariable(variable, Const.NVL((String)value, (String)""));
                continue;
            }
            internalTrans.setParameterValue(variable, Const.NVL((String)value, (String)""));
        }
        internalTrans.activateParameters();
    }

    private void collectExecutionResults(Result result) throws KettleException {
        if (this.meta.getExecutionResultTargetStepMeta() != null) {
            Object[] outputRow = RowDataUtil.allocateRowData((int)this.getData().getExecutionResultsOutputRowMeta().size());
            int idx = 0;
            if (!Const.isEmpty((String)this.meta.getExecutionTimeField())) {
                outputRow[idx++] = System.currentTimeMillis() - this.getData().groupTimeStart;
            }
            if (!Const.isEmpty((String)this.meta.getExecutionResultField())) {
                outputRow[idx++] = result.getResult();
            }
            if (!Const.isEmpty((String)this.meta.getExecutionNrErrorsField())) {
                outputRow[idx++] = result.getNrErrors();
            }
            if (!Const.isEmpty((String)this.meta.getExecutionLinesReadField())) {
                outputRow[idx++] = result.getNrLinesRead();
            }
            if (!Const.isEmpty((String)this.meta.getExecutionLinesWrittenField())) {
                outputRow[idx++] = result.getNrLinesWritten();
            }
            if (!Const.isEmpty((String)this.meta.getExecutionLinesInputField())) {
                outputRow[idx++] = result.getNrLinesInput();
            }
            if (!Const.isEmpty((String)this.meta.getExecutionLinesOutputField())) {
                outputRow[idx++] = result.getNrLinesOutput();
            }
            if (!Const.isEmpty((String)this.meta.getExecutionLinesRejectedField())) {
                outputRow[idx++] = result.getNrLinesRejected();
            }
            if (!Const.isEmpty((String)this.meta.getExecutionLinesUpdatedField())) {
                outputRow[idx++] = result.getNrLinesUpdated();
            }
            if (!Const.isEmpty((String)this.meta.getExecutionLinesDeletedField())) {
                outputRow[idx++] = result.getNrLinesDeleted();
            }
            if (!Const.isEmpty((String)this.meta.getExecutionFilesRetrievedField())) {
                outputRow[idx++] = result.getNrFilesRetrieved();
            }
            if (!Const.isEmpty((String)this.meta.getExecutionExitStatusField())) {
                outputRow[idx++] = (long)result.getExitStatus();
            }
            if (!Const.isEmpty((String)this.meta.getExecutionLogTextField())) {
                String channelId = this.getData().getExecutorTrans().getLogChannelId();
                String logText = KettleLogStore.getAppender().getBuffer(channelId, false).toString();
                outputRow[idx++] = logText;
            }
            if (!Const.isEmpty((String)this.meta.getExecutionLogChannelIdField())) {
                outputRow[idx++] = this.getData().getExecutorTrans().getLogChannelId();
            }
            this.putRowTo(this.getData().getExecutionResultsOutputRowMeta(), outputRow, this.getData().getExecutionResultRowSet());
        }
    }

    private void collectExecutionResultFiles(Result result) throws KettleException {
        if (this.meta.getResultFilesTargetStepMeta() != null && result.getResultFilesList() != null) {
            for (ResultFile resultFile : result.getResultFilesList()) {
                Object[] targetRow = RowDataUtil.allocateRowData((int)this.getData().getResultFilesOutputRowMeta().size());
                int idx = 0;
                targetRow[idx++] = resultFile.getFile().getName().toString();
                this.putRowTo(this.getData().getResultFilesOutputRowMeta(), targetRow, this.getData().getResultFilesRowSet());
            }
        }
    }

    @Override
    public boolean init(StepMetaInterface smi, StepDataInterface sdi) {
        this.meta = (TransExecutorMeta)smi;
        this.setData((TransExecutorData)sdi);
        if (super.init(smi, sdi)) {
            try {
                this.meta.setRepository(this.getTransMeta().getRepository());
                this.getData().setExecutorTransMeta(TransExecutorMeta.loadTransMeta(this.meta, this.meta.getRepository(), this.meta.getMetaStore(), this));
                if (this.getData().getExecutorTransMeta() != null) {
                    this.getData().groupBuffer = new ArrayList<RowMetaAndData>();
                    this.getData().groupSize = !Const.isEmpty((String)this.meta.getGroupSize()) ? Const.toInt((String)this.environmentSubstitute(this.meta.getGroupSize()), (int)-1) : -1;
                    this.getData().groupTime = !Const.isEmpty((String)this.meta.getGroupTime()) ? Const.toInt((String)this.environmentSubstitute(this.meta.getGroupTime()), (int)-1) : -1;
                    this.getData().groupTimeStart = System.currentTimeMillis();
                    if (!Const.isEmpty((String)this.meta.getGroupField())) {
                        this.getData().groupField = this.environmentSubstitute(this.meta.getGroupField());
                    }
                    return true;
                }
                this.logError("No valid transformation was specified nor loaded!");
                return false;
            }
            catch (Exception e) {
                this.logError("Unable to load the transformation executor because of an error : ", e);
            }
        }
        return false;
    }

    @Override
    public void dispose(StepMetaInterface smi, StepDataInterface sdi) {
        this.getData().groupBuffer = null;
        super.dispose(smi, sdi);
    }

    @Override
    public void stopRunning(StepMetaInterface stepMetaInterface, StepDataInterface stepDataInterface) throws KettleException {
        if (this.getData().getExecutorTrans() != null) {
            this.getData().getExecutorTrans().stopAll();
        }
    }

    @Override
    public void stopAll() {
        if (this.getData().getExecutorTrans() != null) {
            this.getData().getExecutorTrans().stopAll();
        }
        super.stopAll();
    }

    public Trans getExecutorTrans() {
        return this.getData().getExecutorTrans();
    }

    TransExecutorData getData() {
        return this.data;
    }

    private void setData(TransExecutorData data) {
        this.data = data;
    }
}

