/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.trans.steps.singlethreader;

import java.util.ArrayList;
import org.pentaho.di.core.Const;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.exception.KettleStepException;
import org.pentaho.di.core.logging.KettleLogStore;
import org.pentaho.di.core.row.RowMetaInterface;
import org.pentaho.di.i18n.BaseMessages;
import org.pentaho.di.trans.SingleThreadedTransExecutor;
import org.pentaho.di.trans.Trans;
import org.pentaho.di.trans.TransMeta;
import org.pentaho.di.trans.step.BaseStep;
import org.pentaho.di.trans.step.RowAdapter;
import org.pentaho.di.trans.step.StepDataInterface;
import org.pentaho.di.trans.step.StepInterface;
import org.pentaho.di.trans.step.StepMeta;
import org.pentaho.di.trans.step.StepMetaInterface;
import org.pentaho.di.trans.steps.TransStepUtil;
import org.pentaho.di.trans.steps.mapping.MappingValueRename;
import org.pentaho.di.trans.steps.mappinginput.MappingInputData;
import org.pentaho.di.trans.steps.singlethreader.SingleThreaderData;
import org.pentaho.di.trans.steps.singlethreader.SingleThreaderMeta;

public class SingleThreader
extends BaseStep
implements StepInterface {
    private static Class<?> PKG = SingleThreaderMeta.class;
    private SingleThreaderMeta meta;
    private SingleThreaderData data;

    public SingleThreader(StepMeta stepMeta, StepDataInterface stepDataInterface, int copyNr, TransMeta transMeta, Trans trans) {
        super(stepMeta, stepDataInterface, copyNr, transMeta, trans);
    }

    @Override
    public boolean processRow(StepMetaInterface smi, StepDataInterface sdi) throws KettleException {
        boolean timeWindow;
        this.meta = (SingleThreaderMeta)smi;
        this.setData((SingleThreaderData)sdi);
        Object[] row = this.getRow();
        if (row == null) {
            if (this.getData().batchCount > 0) {
                this.getData().batchCount = 0;
                return this.execOneIteration();
            }
            this.setOutputDone();
            return false;
        }
        if (this.first) {
            this.first = false;
            this.getData().startTime = System.currentTimeMillis();
        }
        this.getData().rowProducer.putRow(this.getInputRowMeta(), row);
        ++this.getData().batchCount;
        if (this.getStepMeta().isDoingErrorHandling()) {
            this.getData().errorBuffer.add(row);
        }
        boolean countWindow = this.getData().batchSize > 0 && this.getData().batchCount >= this.getData().batchSize;
        boolean bl = timeWindow = this.getData().batchTime > 0 && System.currentTimeMillis() - this.getData().startTime > (long)this.getData().batchTime;
        if (countWindow || timeWindow) {
            this.getData().batchCount = 0;
            boolean more = this.execOneIteration();
            if (!more) {
                this.setOutputDone();
                return false;
            }
            this.getData().startTime = System.currentTimeMillis();
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean execOneIteration() {
        boolean more = false;
        try {
            more = this.getData().executor.oneIteration();
            if (this.getData().executor.isStopped() || this.getData().executor.getErrors() > 0L) {
                boolean bl = this.handleError();
                return bl;
            }
        }
        catch (Exception e) {
            this.setErrors(1L);
            this.stopAll();
            this.logError(BaseMessages.getString(PKG, (String)"SingleThreader.Log.ErrorOccurredInSubTransformation", (String[])new String[0]));
            boolean bl = false;
            return bl;
        }
        finally {
            if (this.getStepMeta().isDoingErrorHandling()) {
                this.getData().errorBuffer.clear();
            }
        }
        return more;
    }

    private boolean handleError() throws KettleStepException {
        if (this.getStepMeta().isDoingErrorHandling()) {
            int lastLogLine = KettleLogStore.getLastBufferLineNr();
            StringBuffer logText = KettleLogStore.getAppender().getBuffer(this.getData().mappingTrans.getLogChannelId(), false, this.getData().lastLogLine);
            this.getData().lastLogLine = lastLogLine;
            for (Object[] row : this.getData().errorBuffer) {
                this.putError(this.getInputRowMeta(), row, 1L, logText.toString(), null, "STR-001");
            }
            this.getData().executor.clearError();
            return true;
        }
        this.setErrors(1L);
        this.stopAll();
        this.logError(BaseMessages.getString(PKG, (String)"SingleThreader.Log.ErrorOccurredInSubTransformation", (String[])new String[0]));
        return false;
    }

    private void passParameters() throws KettleException {
        int i;
        String[] parameterValues;
        String[] parameters;
        if (this.meta.isPassingAllParameters()) {
            parameters = this.getData().mappingTransMeta.listParameters();
            parameterValues = new String[parameters.length];
            for (i = 0; i < parameters.length; ++i) {
                parameterValues[i] = this.getVariable(parameters[i]);
            }
        } else {
            parameters = this.meta.getParameters();
            parameterValues = new String[parameters.length];
            for (i = 0; i < parameters.length; ++i) {
                parameterValues[i] = this.environmentSubstitute(this.meta.getParameterValues()[i]);
            }
        }
        for (i = 0; i < parameters.length; ++i) {
            String value = Const.NVL((String)parameterValues[i], (String)"");
            this.getData().mappingTrans.setParameterValue(parameters[i], value);
        }
        this.getData().mappingTrans.activateParameters();
    }

    public void prepareMappingExecution() throws KettleException {
        this.getData().mappingTransMeta.setTransformationType(TransMeta.TransformationType.SingleThreaded);
        this.getData().mappingTrans = new Trans(this.getData().mappingTransMeta, this.getTrans());
        this.passParameters();
        this.getData().mappingTrans.getTransMeta().setUsingThreadPriorityManagment(false);
        this.getData().mappingTrans.setParentTrans(this.getTrans());
        this.getData().mappingTrans.setSafeModeEnabled(this.getTrans().isSafeModeEnabled());
        this.getData().mappingTrans.setGatheringMetrics(this.getTrans().isGatheringMetrics());
        this.getData().mappingTrans.setMappingStepName(this.getStepname());
        this.initServletConfig();
        this.getData().mappingTrans.prepareExecution(null);
        if (this.getData().injectStepMeta.isMappingInput()) {
            MappingInputData mappingInputData = (MappingInputData)this.getData().mappingTrans.findDataInterface(this.getData().injectStepMeta.getName());
            mappingInputData.sourceSteps = new StepInterface[0];
            mappingInputData.valueRenames = new ArrayList<MappingValueRename>();
        }
        this.getData().rowProducer = this.getData().mappingTrans.addRowProducer(this.meta.getInjectStep(), 0);
        StepInterface retrieveStep = this.getData().mappingTrans.getStepInterface(this.meta.getRetrieveStep(), 0);
        retrieveStep.addRowListener(new RowAdapter(){

            @Override
            public void rowWrittenEvent(RowMetaInterface rowMeta, Object[] row) throws KettleStepException {
                SingleThreader.this.putRow(rowMeta, row);
            }
        });
        this.getData().mappingTrans.startThreads();
        this.getData().executor = new SingleThreadedTransExecutor(this.getData().mappingTrans);
        try {
            boolean ok = this.getData().executor.init();
            if (!ok) {
                throw new KettleException(BaseMessages.getString(PKG, (String)"SingleThreader.Exception.UnableToInitSingleThreadedTransformation", (String[])new String[0]));
            }
        }
        catch (KettleException e) {
            throw new KettleException(BaseMessages.getString(PKG, (String)"SingleThreader.Exception.UnableToPrepareExecutionOfMapping", (String[])new String[0]), (Throwable)e);
        }
        this.getTrans().getActiveSubtransformations().put(this.getStepname(), this.getData().mappingTrans);
    }

    void initServletConfig() {
        TransStepUtil.initServletConfig(this.getTrans(), this.getData().getMappingTrans());
    }

    @Override
    public boolean init(StepMetaInterface smi, StepDataInterface sdi) {
        this.meta = (SingleThreaderMeta)smi;
        this.setData((SingleThreaderData)sdi);
        if (super.init(smi, sdi)) {
            try {
                this.getData().batchSize = Const.toInt((String)this.environmentSubstitute(this.meta.getBatchSize()), (int)0);
                this.getData().batchTime = Const.toInt((String)this.environmentSubstitute(this.meta.getBatchTime()), (int)0);
                this.meta.setRepository(this.getTransMeta().getRepository());
                this.getData().mappingTransMeta = SingleThreaderMeta.loadSingleThreadedTransMeta(this.meta, this.meta.getRepository(), this);
                if (this.getData().mappingTransMeta != null) {
                    String retrieveStepName;
                    String injectStepName = this.environmentSubstitute(this.meta.getInjectStep());
                    this.getData().injectStepMeta = this.getData().mappingTransMeta.findStep(injectStepName);
                    if (this.getData().injectStepMeta == null) {
                        this.logError("The inject step with name '" + injectStepName + "' couldn't be found in the sub-transformation");
                    }
                    if (!Const.isEmpty((String)(retrieveStepName = this.environmentSubstitute(this.meta.getRetrieveStep())))) {
                        this.getData().retrieveStepMeta = this.getData().mappingTransMeta.findStep(retrieveStepName);
                        if (this.getData().retrieveStepMeta == null) {
                            this.logError("The retrieve step with name '" + retrieveStepName + "' couldn't be found in the sub-transformation");
                        }
                    }
                    this.prepareMappingExecution();
                    if (this.getStepMeta().isDoingErrorHandling()) {
                        this.getData().errorBuffer = new ArrayList<Object[]>();
                    }
                    return true;
                }
                this.logError("No valid mapping was specified!");
                return false;
            }
            catch (Exception e) {
                this.logError("Unable to load the mapping transformation because of an error : " + e.toString());
                this.logError(Const.getStackTracker((Throwable)e));
            }
        }
        return false;
    }

    @Override
    public void dispose(StepMetaInterface smi, StepDataInterface sdi) {
        try {
            this.getData().executor.dispose();
        }
        catch (KettleException e) {
            this.log.logError("Error disposing of sub-transformation: ", (Throwable)e);
        }
        super.dispose(smi, sdi);
    }

    @Override
    public void stopRunning(StepMetaInterface stepMetaInterface, StepDataInterface stepDataInterface) throws KettleException {
        if (this.getData().mappingTrans != null) {
            this.getData().mappingTrans.stopAll();
        }
    }

    @Override
    public void stopAll() {
        if (this.getData().mappingTrans != null) {
            this.getData().mappingTrans.stopAll();
        }
        super.stopAll();
    }

    public Trans getMappingTrans() {
        return this.getData().mappingTrans;
    }

    SingleThreaderData getData() {
        return this.data;
    }

    private void setData(SingleThreaderData data) {
        this.data = data;
    }
}

