/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.trans.steps.databaselookup;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.List;
import org.pentaho.di.core.Const;
import org.pentaho.di.core.RowMetaAndData;
import org.pentaho.di.core.TimedRow;
import org.pentaho.di.core.database.Database;
import org.pentaho.di.core.database.DatabaseMeta;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.exception.KettleStepException;
import org.pentaho.di.core.logging.LoggingObjectInterface;
import org.pentaho.di.core.row.RowDataUtil;
import org.pentaho.di.core.row.RowMeta;
import org.pentaho.di.core.row.RowMetaInterface;
import org.pentaho.di.core.row.ValueMeta;
import org.pentaho.di.core.row.ValueMetaInterface;
import org.pentaho.di.core.row.value.ValueMetaFactory;
import org.pentaho.di.core.variables.VariableSpace;
import org.pentaho.di.i18n.BaseMessages;
import org.pentaho.di.trans.Trans;
import org.pentaho.di.trans.TransMeta;
import org.pentaho.di.trans.step.BaseStep;
import org.pentaho.di.trans.step.StepDataInterface;
import org.pentaho.di.trans.step.StepInterface;
import org.pentaho.di.trans.step.StepMeta;
import org.pentaho.di.trans.step.StepMetaInterface;
import org.pentaho.di.trans.steps.databaselookup.DatabaseLookupData;
import org.pentaho.di.trans.steps.databaselookup.DatabaseLookupMeta;

public class DatabaseLookup
extends BaseStep
implements StepInterface {
    private static Class<?> PKG = DatabaseLookupMeta.class;
    private DatabaseLookupMeta meta;
    private DatabaseLookupData data;

    public DatabaseLookup(StepMeta stepMeta, StepDataInterface stepDataInterface, int copyNr, TransMeta transMeta, Trans trans) {
        super(stepMeta, stepDataInterface, copyNr, transMeta, trans);
    }

    private synchronized Object[] lookupValues(RowMetaInterface inputRowMeta, Object[] row) throws KettleException {
        int i;
        Object[] add;
        Object[] outputRow = RowDataUtil.resizeArray((Object[])row, (int)this.data.outputRowMeta.size());
        Object[] lookupRow = new Object[this.data.lookupMeta.size()];
        int lookupIndex = 0;
        for (int i2 = 0; i2 < this.meta.getStreamKeyField1().length; ++i2) {
            ValueMetaInterface value;
            ValueMetaInterface input;
            if (this.data.keynrs[i2] >= 0) {
                input = inputRowMeta.getValueMeta(this.data.keynrs[i2]);
                value = this.data.lookupMeta.getValueMeta(lookupIndex);
                lookupRow[lookupIndex] = row[this.data.keynrs[i2]];
                if (input.getType() != value.getType() || 1 == input.getStorageType()) {
                    lookupRow[lookupIndex] = value.convertData(input, lookupRow[lookupIndex]);
                    value.setStorageType(0);
                }
                ++lookupIndex;
            }
            if (this.data.keynrs2[i2] < 0) continue;
            input = inputRowMeta.getValueMeta(this.data.keynrs2[i2]);
            value = this.data.lookupMeta.getValueMeta(lookupIndex);
            lookupRow[lookupIndex] = row[this.data.keynrs2[i2]];
            if (input.getType() != value.getType() || 1 == input.getStorageType()) {
                lookupRow[lookupIndex] = value.convertData(input, lookupRow[lookupIndex]);
                value.setStorageType(0);
            }
            ++lookupIndex;
        }
        boolean cache_now = false;
        boolean cacheHit = false;
        if (this.meta.isCached()) {
            add = this.getRowFromCache(this.data.lookupMeta, lookupRow);
            if (add != null) {
                cacheHit = true;
            }
        } else {
            add = null;
        }
        if (!(add != null || this.meta.isCached() && this.meta.isLoadingAllDataInCache() && !this.data.hasDBCondition)) {
            if (this.log.isRowLevel()) {
                this.logRowlevel(BaseMessages.getString(PKG, (String)"DatabaseLookup.Log.AddedValuesToLookupRow1", (String[])new String[0]) + this.meta.getStreamKeyField1().length + BaseMessages.getString(PKG, (String)"DatabaseLookup.Log.AddedValuesToLookupRow2", (String[])new String[0]) + this.data.lookupMeta.getString(lookupRow));
            }
            this.data.db.setValuesLookup(this.data.lookupMeta, lookupRow);
            add = this.data.db.getLookup(this.meta.isFailingOnMultipleResults());
            cache_now = true;
        }
        if (add == null) {
            if (this.meta.isEatingRowOnLookupFailure()) {
                return null;
            }
            if (this.getStepMeta().isDoingErrorHandling()) {
                this.putError(this.getInputRowMeta(), row, 1L, "No lookup found", null, "DBL001");
                return null;
            }
            if (this.log.isRowLevel()) {
                this.logRowlevel(BaseMessages.getString(PKG, (String)"DatabaseLookup.Log.NoResultsFoundAfterLookup", (String[])new String[0]));
            }
            add = new Object[this.data.returnMeta.size()];
            for (i = 0; i < this.meta.getReturnValueField().length; ++i) {
                add[i] = this.data.nullif[i] != null ? this.data.nullif[i] : null;
            }
        } else {
            if (this.log.isRowLevel()) {
                this.logRowlevel(BaseMessages.getString(PKG, (String)"DatabaseLookup.Log.FoundResultsAfterLookup", (String[])new String[0]) + Arrays.toString(add));
            }
            if (!cacheHit) {
                this.incrementLinesInput();
                int[] types = this.meta.getReturnValueDefaultType();
                for (int i3 = 0; i3 < types.length; ++i3) {
                    ValueMetaInterface returned = this.data.db.getReturnRowMeta().getValueMeta(i3);
                    ValueMetaInterface expected = this.data.returnMeta.getValueMeta(i3);
                    if (returned == null || types[i3] <= 0 || types[i3] == returned.getType()) continue;
                    add[i3] = expected.convertData(returned, add[i3]);
                }
            }
        }
        if (this.meta.isCached() && cache_now && !this.meta.isLoadingAllDataInCache() && this.data.allEquals) {
            this.storeRowInCache(this.data.lookupMeta, lookupRow, add);
        }
        for (i = 0; i < this.data.returnMeta.size(); ++i) {
            outputRow[inputRowMeta.size() + i] = add[i];
        }
        return outputRow;
    }

    private void storeRowInCache(RowMetaInterface lookupMeta, Object[] lookupRow, Object[] add) {
        RowMetaAndData rowMetaAndData = new RowMetaAndData(lookupMeta, lookupRow);
        this.data.look.put(rowMetaAndData, new TimedRow(add));
        if (!this.meta.isLoadingAllDataInCache() && this.meta.getCacheSize() > 0 && this.data.look.size() > this.meta.getCacheSize()) {
            ArrayList<RowMetaAndData> keys = new ArrayList<RowMetaAndData>(this.data.look.keySet());
            ArrayList<Date> samples = new ArrayList<Date>();
            int incr = keys.size() / 10;
            if (incr == 0) {
                incr = 1;
            }
            for (int k = 0; k < keys.size(); k += incr) {
                RowMetaAndData key = (RowMetaAndData)keys.get(k);
                TimedRow timedRow = this.data.look.get(key);
                samples.add(timedRow.getLogDate());
            }
            Collections.sort(samples);
            if (samples.size() > 1) {
                Date smallest = (Date)samples.get(1);
                for (RowMetaAndData key : keys) {
                    TimedRow timedRow = this.data.look.get(key);
                    if (timedRow.getLogDate().compareTo(smallest) >= 0) continue;
                    this.data.look.remove(key);
                }
            }
        }
    }

    private Object[] getRowFromCache(RowMetaInterface lookupMeta, Object[] lookupRow) throws KettleException {
        if (this.data.allEquals) {
            TimedRow timedRow = this.data.look.get(new RowMetaAndData(this.data.lookupMeta, lookupRow));
            if (timedRow != null) {
                return timedRow.getRow();
            }
        } else if (!this.data.hasDBCondition) {
            Enumeration<RowMetaAndData> keys = this.data.look.keys();
            while (keys.hasMoreElements()) {
                TimedRow timedRow;
                RowMetaAndData key = keys.nextElement();
                boolean match = true;
                int lookupIndex = 0;
                for (int i = 0; i < this.data.conditions.length && match; ++i) {
                    ValueMetaInterface cmpMeta = lookupMeta.getValueMeta(lookupIndex);
                    Object cmpData = lookupRow[lookupIndex];
                    ValueMetaInterface keyMeta = key.getValueMeta(i);
                    Object keyData = key.getData()[i];
                    switch (this.data.conditions[i]) {
                        case 0: {
                            match = cmpMeta.compare(cmpData, keyMeta, keyData) == 0;
                            break;
                        }
                        case 1: {
                            match = cmpMeta.compare(cmpData, keyMeta, keyData) != 0;
                            break;
                        }
                        case 2: {
                            match = cmpMeta.compare(cmpData, keyMeta, keyData) > 0;
                            break;
                        }
                        case 3: {
                            match = cmpMeta.compare(cmpData, keyMeta, keyData) >= 0;
                            break;
                        }
                        case 4: {
                            match = cmpMeta.compare(cmpData, keyMeta, keyData) < 0;
                            break;
                        }
                        case 5: {
                            match = cmpMeta.compare(cmpData, keyMeta, keyData) <= 0;
                            break;
                        }
                        case 8: {
                            match = keyMeta.isNull(keyData);
                            break;
                        }
                        case 9: {
                            match = !keyMeta.isNull(keyData);
                            break;
                        }
                        case 7: {
                            ValueMetaInterface cmpMeta2 = lookupMeta.getValueMeta(lookupIndex + 1);
                            Object cmpData2 = lookupRow[lookupIndex + 1];
                            boolean bl = match = keyMeta.compare(keyData, cmpMeta, cmpData) >= 0;
                            if (match) {
                                match = keyMeta.compare(keyData, cmpMeta2, cmpData2) <= 0;
                            }
                            ++lookupIndex;
                            break;
                        }
                        default: {
                            match = false;
                            this.data.hasDBCondition = true;
                        }
                    }
                    ++lookupIndex;
                }
                if (!match || (timedRow = this.data.look.get(key)) == null) continue;
                return timedRow.getRow();
            }
        }
        return null;
    }

    @Override
    public boolean processRow(StepMetaInterface smi, StepDataInterface sdi) throws KettleException {
        this.meta = (DatabaseLookupMeta)smi;
        this.data = (DatabaseLookupData)sdi;
        Object[] r = this.getRow();
        if (r == null) {
            this.setOutputDone();
            return false;
        }
        if (this.first) {
            int i;
            int i2;
            this.first = false;
            this.data.outputRowMeta = this.getInputRowMeta().clone();
            this.meta.getFields(this.data.outputRowMeta, this.getStepname(), null, null, this, this.repository, this.metaStore);
            if (this.meta.isCached()) {
                this.data.look = this.meta.getCacheSize() > 0 ? new Hashtable((int)((double)this.meta.getCacheSize() * 1.5)) : new Hashtable();
            }
            this.data.db.setLookup(this.environmentSubstitute(this.meta.getSchemaName()), this.environmentSubstitute(this.meta.getTablename()), this.meta.getTableKeyField(), this.meta.getKeyCondition(), this.meta.getReturnValueField(), this.meta.getReturnValueNewName(), this.meta.getOrderByClause(), this.meta.isFailingOnMultipleResults());
            if (this.log.isDetailed()) {
                this.logDetailed(BaseMessages.getString(PKG, (String)"DatabaseLookup.Log.CheckingRow", (String[])new String[0]) + this.getInputRowMeta().getString(r));
            }
            this.data.keynrs = new int[this.meta.getStreamKeyField1().length];
            this.data.keynrs2 = new int[this.meta.getStreamKeyField1().length];
            for (i2 = 0; i2 < this.meta.getStreamKeyField1().length; ++i2) {
                this.data.keynrs[i2] = this.getInputRowMeta().indexOfValue(this.meta.getStreamKeyField1()[i2]);
                if (this.data.keynrs[i2] < 0 && !"IS NULL".equalsIgnoreCase(this.meta.getKeyCondition()[i2]) && !"IS NOT NULL".equalsIgnoreCase(this.meta.getKeyCondition()[i2])) {
                    throw new KettleStepException(BaseMessages.getString(PKG, (String)"DatabaseLookup.ERROR0001.FieldRequired1.Exception", (String[])new String[0]) + this.meta.getStreamKeyField1()[i2] + BaseMessages.getString(PKG, (String)"DatabaseLookup.ERROR0001.FieldRequired2.Exception", (String[])new String[0]));
                }
                this.data.keynrs2[i2] = this.getInputRowMeta().indexOfValue(this.meta.getStreamKeyField2()[i2]);
                if (this.data.keynrs2[i2] < 0 && "BETWEEN".equalsIgnoreCase(this.meta.getKeyCondition()[i2])) {
                    throw new KettleStepException(BaseMessages.getString(PKG, (String)"DatabaseLookup.ERROR0001.FieldRequired3.Exception", (String[])new String[0]) + this.meta.getStreamKeyField2()[i2] + BaseMessages.getString(PKG, (String)"DatabaseLookup.ERROR0001.FieldRequired4.Exception", (String[])new String[0]));
                }
                if (!this.log.isDebug()) continue;
                this.logDebug(BaseMessages.getString(PKG, (String)"DatabaseLookup.Log.FieldHasIndex1", (String[])new String[0]) + this.meta.getStreamKeyField1()[i2] + BaseMessages.getString(PKG, (String)"DatabaseLookup.Log.FieldHasIndex2", (String[])new String[0]) + this.data.keynrs[i2]);
            }
            this.data.nullif = new Object[this.meta.getReturnValueField().length];
            for (i2 = 0; i2 < this.meta.getReturnValueField().length; ++i2) {
                ValueMeta stringMeta = new ValueMeta("string", 2);
                ValueMetaInterface returnMeta = this.data.outputRowMeta.getValueMeta(i2 + this.getInputRowMeta().size());
                this.data.nullif[i2] = !Const.isEmpty((String)this.meta.getReturnValueDefault()[i2]) ? returnMeta.convertData((ValueMetaInterface)stringMeta, (Object)this.meta.getReturnValueDefault()[i2]) : null;
            }
            this.data.keytypes = new int[this.meta.getTableKeyField().length];
            String schemaTable = this.meta.getDatabaseMeta().getQuotedSchemaTableCombination(this.environmentSubstitute(this.meta.getSchemaName()), this.environmentSubstitute(this.meta.getTablename()));
            RowMetaInterface fields = this.data.db.getTableFields(schemaTable);
            if (fields != null) {
                for (i = 0; i < this.meta.getTableKeyField().length; ++i) {
                    ValueMetaInterface key = fields.searchValueMeta(this.meta.getTableKeyField()[i]);
                    if (key == null) {
                        throw new KettleStepException(BaseMessages.getString(PKG, (String)"DatabaseLookup.ERROR0001.FieldRequired5.Exception", (String[])new String[0]) + this.meta.getTableKeyField()[i] + BaseMessages.getString(PKG, (String)"DatabaseLookup.ERROR0001.FieldRequired6.Exception", (String[])new String[0]));
                    }
                    this.data.keytypes[i] = key.getType();
                }
            } else {
                throw new KettleStepException(BaseMessages.getString(PKG, (String)"DatabaseLookup.ERROR0002.UnableToDetermineFieldsOfTable", (String[])new String[0]) + schemaTable + "]");
            }
            this.data.lookupMeta = new RowMeta();
            for (i = 0; i < this.meta.getStreamKeyField1().length; ++i) {
                ValueMetaInterface value;
                ValueMetaInterface inputValueMeta;
                if (this.data.keynrs[i] >= 0) {
                    inputValueMeta = this.getInputRowMeta().getValueMeta(this.data.keynrs[i]);
                    value = ValueMetaFactory.cloneValueMeta((ValueMetaInterface)inputValueMeta, (int)this.data.keytypes[i]);
                    this.data.lookupMeta.addValueMeta(value);
                }
                if (this.data.keynrs2[i] < 0) continue;
                inputValueMeta = this.getInputRowMeta().getValueMeta(this.data.keynrs2[i]);
                value = ValueMetaFactory.cloneValueMeta((ValueMetaInterface)inputValueMeta, (int)this.data.keytypes[i]);
                this.data.lookupMeta.addValueMeta(value);
            }
            this.data.returnMeta = new RowMeta();
            for (i = 0; i < this.meta.getReturnValueField().length; ++i) {
                ValueMetaInterface v = this.data.outputRowMeta.getValueMeta(this.getInputRowMeta().size() + i).clone();
                this.data.returnMeta.addValueMeta(v);
            }
            if (this.meta.isCached() && this.meta.isLoadingAllDataInCache()) {
                this.loadAllTableDataIntoTheCache();
            }
        }
        if (this.log.isRowLevel()) {
            this.logRowlevel(BaseMessages.getString(PKG, (String)"DatabaseLookup.Log.GotRowFromPreviousStep", (String[])new String[0]) + this.getInputRowMeta().getString(r));
        }
        try {
            Object[] outputRow = this.lookupValues(this.getInputRowMeta(), r);
            if (outputRow != null) {
                this.putRow(this.data.outputRowMeta, outputRow);
                if (this.log.isRowLevel()) {
                    this.logRowlevel(BaseMessages.getString(PKG, (String)"DatabaseLookup.Log.WroteRowToNextStep", (String[])new String[0]) + this.getInputRowMeta().getString(r));
                }
                if (this.checkFeedback(this.getLinesRead())) {
                    this.logBasic("linenr " + this.getLinesRead());
                }
            }
        }
        catch (KettleException e) {
            if (this.getStepMeta().isDoingErrorHandling()) {
                this.putError(this.getInputRowMeta(), r, 1L, e.getMessage(), null, "DBLOOKUPD001");
            }
            this.logError(BaseMessages.getString(PKG, (String)"DatabaseLookup.ERROR003.UnexpectedErrorDuringProcessing", (String[])new String[0]) + e.getMessage());
            this.setErrors(1L);
            this.stopAll();
            this.setOutputDone();
            return false;
        }
        return true;
    }

    private void loadAllTableDataIntoTheCache() throws KettleException {
        DatabaseMeta dbMeta = this.meta.getDatabaseMeta();
        try {
            List rows;
            int i;
            String sql = "SELECT ";
            for (i = 0; i < this.meta.getStreamKeyField1().length; ++i) {
                if (i > 0) {
                    sql = sql + ", ";
                }
                sql = sql + dbMeta.quoteField(this.meta.getTableKeyField()[i]);
            }
            for (i = 0; i < this.meta.getReturnValueField().length; ++i) {
                sql = sql + ", " + dbMeta.quoteField(this.meta.getReturnValueField()[i]);
            }
            sql = sql + " FROM " + dbMeta.getQuotedSchemaTableCombination(this.environmentSubstitute(this.meta.getSchemaName()), this.environmentSubstitute(this.meta.getTablename()));
            if (this.meta.getOrderByClause() != null && this.meta.getOrderByClause().length() != 0) {
                sql = sql + " ORDER BY " + this.meta.getOrderByClause();
            }
            if ((rows = this.data.db.getRows(sql, 0)) != null && rows.size() > 0) {
                RowMetaInterface returnRowMeta = this.data.db.getReturnRowMeta();
                for (Object[] row : rows) {
                    int index = 0;
                    RowMeta keyMeta = new RowMeta();
                    Object[] keyData = new Object[this.meta.getStreamKeyField1().length];
                    for (int i2 = 0; i2 < this.meta.getStreamKeyField1().length; ++i2) {
                        keyData[i2] = row[index];
                        keyMeta.addValueMeta(returnRowMeta.getValueMeta(index++));
                    }
                    Object[] valueData = new Object[this.data.returnMeta.size()];
                    for (int i3 = 0; i3 < this.data.returnMeta.size(); ++i3) {
                        valueData[i3] = row[index++];
                    }
                    this.storeRowInCache((RowMetaInterface)keyMeta, keyData, valueData);
                    this.incrementLinesInput();
                }
            }
        }
        catch (Exception e) {
            throw new KettleException((Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void stopRunning(StepMetaInterface smi, StepDataInterface sdi) throws KettleException {
        this.meta = (DatabaseLookupMeta)smi;
        this.data = (DatabaseLookupData)sdi;
        if (this.data.db != null && !this.data.isCanceled) {
            Database database = this.data.db;
            synchronized (database) {
                this.data.db.cancelQuery();
            }
            this.data.isCanceled = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean init(StepMetaInterface smi, StepDataInterface sdi) {
        block12: {
            this.meta = (DatabaseLookupMeta)smi;
            this.data = (DatabaseLookupData)sdi;
            if (super.init(smi, sdi)) {
                if (this.meta.getDatabaseMeta() == null) {
                    this.logError(BaseMessages.getString(PKG, (String)"DatabaseLookup.Init.ConnectionMissing", (String[])new String[]{this.getStepname()}));
                    return false;
                }
                this.data.db = this.getDatabase(this.meta.getDatabaseMeta());
                this.data.db.shareVariablesWith((VariableSpace)this);
                try {
                    if (this.getTransMeta().isUsingUniqueConnections()) {
                        Trans trans = this.getTrans();
                        synchronized (trans) {
                            this.data.db.connect(this.getTrans().getTransactionId(), this.getPartitionID());
                        }
                    } else {
                        this.data.db.connect(this.getPartitionID());
                    }
                    this.data.db.setCommit(100);
                    if (this.log.isDetailed()) {
                        this.logDetailed(BaseMessages.getString(PKG, (String)"DatabaseLookup.Log.ConnectedToDatabase", (String[])new String[0]));
                    }
                    this.data.allEquals = true;
                    this.data.hasDBCondition = false;
                    this.data.conditions = new int[this.meta.getKeyCondition().length];
                    for (int i = 0; i < this.meta.getKeyCondition().length; ++i) {
                        this.data.conditions[i] = Const.indexOfString((String)this.meta.getKeyCondition()[i], (String[])DatabaseLookupMeta.conditionStrings);
                        if (!"=".equals(this.meta.getKeyCondition()[i])) {
                            this.data.allEquals = false;
                        }
                        if (this.data.conditions[i] != 6) continue;
                        this.data.hasDBCondition = true;
                    }
                    return true;
                }
                catch (Exception e) {
                    this.logError(BaseMessages.getString(PKG, (String)"DatabaseLookup.ERROR0004.UnexpectedErrorDuringInit", (String[])new String[0]) + e.toString());
                    if (this.data.db == null) break block12;
                    this.data.db.disconnect();
                }
            }
        }
        return false;
    }

    @Override
    public void dispose(StepMetaInterface smi, StepDataInterface sdi) {
        this.meta = (DatabaseLookupMeta)smi;
        this.data = (DatabaseLookupData)sdi;
        if (this.data.db != null) {
            this.data.db.disconnect();
        }
        this.data.look = null;
        super.dispose(smi, sdi);
    }

    Database getDatabase(DatabaseMeta meta) {
        return new Database((LoggingObjectInterface)this, meta);
    }
}

