/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.trans.sql;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.pentaho.di.core.row.RowMetaInterface;

public class TransDataCache {
    private Map<String, RowMetaInterface> rowMetaMap = new HashMap<String, RowMetaInterface>();
    private Map<String, List<Object[]>> rowDataMap = new HashMap<String, List<Object[]>>();
    private static TransDataCache cache;

    public static TransDataCache getInstance() {
        if (cache == null) {
            cache = new TransDataCache();
        }
        return cache;
    }

    private TransDataCache() {
    }

    public void store(String serviceName, RowMetaInterface rowMeta, List<Object[]> rowData) {
        this.rowMetaMap.put(serviceName, rowMeta);
        this.rowDataMap.put(serviceName, rowData);
    }

    public RowMetaInterface retrieveRowMeta(String serviceName) {
        return this.rowMetaMap.get(serviceName);
    }

    public List<Object[]> retrieveRowData(String serviceName) {
        return this.rowDataMap.get(serviceName);
    }

    public void remove(String serviceName) {
        this.rowMetaMap.remove(serviceName);
        this.rowDataMap.remove(serviceName);
    }
}

