/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.job.entries.folderscompare;

import java.io.BufferedInputStream;
import java.io.DataInputStream;
import java.io.FilterInputStream;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.vfs.FileObject;
import org.apache.commons.vfs.FileSelectInfo;
import org.apache.commons.vfs.FileSelector;
import org.apache.commons.vfs.FileType;
import org.pentaho.di.cluster.SlaveServer;
import org.pentaho.di.core.CheckResultInterface;
import org.pentaho.di.core.Const;
import org.pentaho.di.core.Result;
import org.pentaho.di.core.database.DatabaseMeta;
import org.pentaho.di.core.exception.KettleDatabaseException;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.exception.KettleFileException;
import org.pentaho.di.core.exception.KettleXMLException;
import org.pentaho.di.core.variables.VariableSpace;
import org.pentaho.di.core.vfs.KettleVFS;
import org.pentaho.di.core.xml.XMLHandler;
import org.pentaho.di.i18n.BaseMessages;
import org.pentaho.di.job.JobMeta;
import org.pentaho.di.job.entry.JobEntryBase;
import org.pentaho.di.job.entry.JobEntryInterface;
import org.pentaho.di.job.entry.validator.AbstractFileValidator;
import org.pentaho.di.job.entry.validator.AndValidator;
import org.pentaho.di.job.entry.validator.JobEntryValidatorUtils;
import org.pentaho.di.job.entry.validator.ValidatorContext;
import org.pentaho.di.repository.ObjectId;
import org.pentaho.di.repository.Repository;
import org.pentaho.metastore.api.IMetaStore;
import org.w3c.dom.Node;

public class JobEntryFoldersCompare
extends JobEntryBase
implements Cloneable,
JobEntryInterface {
    private static Class<?> PKG = JobEntryFoldersCompare.class;
    private String filename1 = null;
    private String filename2 = null;
    private String wildcard = null;
    private String compareonly = "all";
    private boolean includesubfolders = false;
    private boolean comparefilecontent = false;
    private boolean comparefilesize = false;

    public JobEntryFoldersCompare(String n) {
        super(n, "");
    }

    public void setCompareOnly(String comparevalue) {
        this.compareonly = comparevalue;
    }

    public String getCompareOnly() {
        return this.compareonly;
    }

    public JobEntryFoldersCompare() {
        this("");
    }

    @Override
    public Object clone() {
        JobEntryFoldersCompare je = (JobEntryFoldersCompare)super.clone();
        return je;
    }

    @Override
    public String getXML() {
        StringBuffer retval = new StringBuffer(50);
        retval.append(super.getXML());
        retval.append("      ").append(XMLHandler.addTagValue((String)"include_subfolders", (boolean)this.includesubfolders));
        retval.append("      ").append(XMLHandler.addTagValue((String)"compare_filecontent", (boolean)this.comparefilecontent));
        retval.append("      ").append(XMLHandler.addTagValue((String)"compare_filesize", (boolean)this.comparefilesize));
        retval.append("      ").append(XMLHandler.addTagValue((String)"compareonly", (String)this.compareonly));
        retval.append("      ").append(XMLHandler.addTagValue((String)"wildcard", (String)this.wildcard));
        retval.append("      ").append(XMLHandler.addTagValue((String)"filename1", (String)this.filename1));
        retval.append("      ").append(XMLHandler.addTagValue((String)"filename2", (String)this.filename2));
        return retval.toString();
    }

    @Override
    public void loadXML(Node entrynode, List<DatabaseMeta> databases, List<SlaveServer> slaveServers, Repository rep, IMetaStore metaStore) throws KettleXMLException {
        try {
            super.loadXML(entrynode, databases, slaveServers);
            this.includesubfolders = "Y".equalsIgnoreCase(XMLHandler.getTagValue((Node)entrynode, (String)"include_subfolders"));
            this.comparefilecontent = "Y".equalsIgnoreCase(XMLHandler.getTagValue((Node)entrynode, (String)"compare_filecontent"));
            this.comparefilesize = "Y".equalsIgnoreCase(XMLHandler.getTagValue((Node)entrynode, (String)"compare_filesize"));
            this.compareonly = XMLHandler.getTagValue((Node)entrynode, (String)"compareonly");
            this.wildcard = XMLHandler.getTagValue((Node)entrynode, (String)"wildcard");
            this.filename1 = XMLHandler.getTagValue((Node)entrynode, (String)"filename1");
            this.filename2 = XMLHandler.getTagValue((Node)entrynode, (String)"filename2");
        }
        catch (KettleXMLException xe) {
            throw new KettleXMLException(BaseMessages.getString(PKG, (String)"JobFoldersCompare.Meta.UnableLoadXML", (String[])new String[]{xe.getMessage()}));
        }
    }

    @Override
    public void loadRep(Repository rep, IMetaStore metaStore, ObjectId id_jobentry, List<DatabaseMeta> databases, List<SlaveServer> slaveServers) throws KettleException {
        try {
            this.includesubfolders = rep.getJobEntryAttributeBoolean(id_jobentry, "include_subfolders");
            this.comparefilecontent = rep.getJobEntryAttributeBoolean(id_jobentry, "compare_filecontent");
            this.comparefilesize = rep.getJobEntryAttributeBoolean(id_jobentry, "compare_filesize");
            this.compareonly = rep.getJobEntryAttributeString(id_jobentry, "compareonly");
            this.wildcard = rep.getJobEntryAttributeString(id_jobentry, "wildcard");
            this.filename1 = rep.getJobEntryAttributeString(id_jobentry, "filename1");
            this.filename2 = rep.getJobEntryAttributeString(id_jobentry, "filename2");
        }
        catch (KettleException dbe) {
            throw new KettleException(BaseMessages.getString(PKG, (String)"JobFoldersCompare.Meta.UnableLoadRep", (String[])new String[]{"" + id_jobentry, dbe.getMessage()}));
        }
    }

    @Override
    public void saveRep(Repository rep, IMetaStore metaStore, ObjectId id_job) throws KettleException {
        try {
            rep.saveJobEntryAttribute(id_job, this.getObjectId(), "include_subfolders", this.includesubfolders);
            rep.saveJobEntryAttribute(id_job, this.getObjectId(), "compare_filecontent", this.comparefilecontent);
            rep.saveJobEntryAttribute(id_job, this.getObjectId(), "compare_filesize", this.comparefilesize);
            rep.saveJobEntryAttribute(id_job, this.getObjectId(), "compareonly", this.compareonly);
            rep.saveJobEntryAttribute(id_job, this.getObjectId(), "wildcard", this.wildcard);
            rep.saveJobEntryAttribute(id_job, this.getObjectId(), "filename1", this.filename1);
            rep.saveJobEntryAttribute(id_job, this.getObjectId(), "filename2", this.filename2);
        }
        catch (KettleDatabaseException dbe) {
            throw new KettleException(BaseMessages.getString(PKG, (String)"JobFoldersCompare.Meta.UnableSaveRep", (String[])new String[]{"" + id_job, dbe.getMessage()}));
        }
    }

    public void setIncludeSubfolders(boolean includeSubfolders) {
        this.includesubfolders = includeSubfolders;
    }

    public boolean isIncludeSubfolders() {
        return this.includesubfolders;
    }

    public void setCompareFileContent(boolean comparefilecontent) {
        this.comparefilecontent = comparefilecontent;
    }

    public boolean isCompareFileContent() {
        return this.comparefilecontent;
    }

    public void setCompareFileSize(boolean comparefilesize) {
        this.comparefilesize = comparefilesize;
    }

    public boolean isCompareFileSize() {
        return this.comparefilesize;
    }

    public String getRealWildcard() {
        return this.environmentSubstitute(this.getWildcard());
    }

    public String getRealFilename1() {
        return this.environmentSubstitute(this.getFilename1());
    }

    public String getRealFilename2() {
        return this.environmentSubstitute(this.getFilename2());
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected boolean equalFileContents(FileObject file1, FileObject file2) throws KettleFileException {
        FilterInputStream in1 = null;
        FilterInputStream in2 = null;
        try {
            in1 = new DataInputStream(new BufferedInputStream(KettleVFS.getInputStream((String)KettleVFS.getFilename((FileObject)file1), (VariableSpace)this)));
            in2 = new DataInputStream(new BufferedInputStream(KettleVFS.getInputStream((String)KettleVFS.getFilename((FileObject)file2), (VariableSpace)this)));
            while (in1.available() != 0 && in2.available() != 0) {
                char ch2;
                char ch1 = (char)((DataInputStream)in1).readByte();
                if (ch1 == (ch2 = (char)((DataInputStream)in2).readByte())) continue;
                boolean bl = false;
                return bl;
            }
            if (in1.available() != in2.available()) {
                boolean bl = false;
                return bl;
            }
            boolean bl = true;
            return bl;
        }
        catch (IOException e) {
            throw new KettleFileException((Throwable)e);
        }
        finally {
            if (in1 != null) {
                try {
                    in1.close();
                }
                catch (IOException ignored) {}
            }
            if (in2 != null) {
                try {
                    in2.close();
                }
                catch (Exception ignored) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Result execute(Result previousResult, int nr) {
        Result result = previousResult;
        result.setResult(false);
        boolean ok = true;
        String realFilename1 = this.getRealFilename1();
        String realFilename2 = this.getRealFilename2();
        FileObject folder1 = null;
        FileObject folder2 = null;
        FileObject filefolder1 = null;
        FileObject filefolder2 = null;
        try {
            if (this.filename1 != null && this.filename2 != null) {
                folder1 = KettleVFS.getFileObject((String)realFilename1, (VariableSpace)this);
                folder2 = KettleVFS.getFileObject((String)realFilename2, (VariableSpace)this);
                if (folder1.exists() && folder2.exists()) {
                    if (!folder1.getType().equals(folder2.getType())) {
                        this.logError(BaseMessages.getString(PKG, (String)"JobFoldersCompare.Log.CanNotCompareFilesFolders", (String[])new String[0]));
                        if (folder1.getType() == FileType.FILE) {
                            this.logError(BaseMessages.getString(PKG, (String)"JobFoldersCompare.Log.IsAFile", (String[])new String[]{realFilename1}));
                        } else if (folder1.getType() == FileType.FOLDER) {
                            this.logError(BaseMessages.getString(PKG, (String)"JobFoldersCompare.Log.IsAFolder", (String[])new String[]{realFilename1}));
                        } else {
                            this.logError(BaseMessages.getString(PKG, (String)"JobFoldersCompare.Log.IsUnknownFileType", (String[])new String[]{realFilename1}));
                        }
                        if (folder2.getType() == FileType.FILE) {
                            this.logError(BaseMessages.getString(PKG, (String)"JobFoldersCompare.Log.IsAFile", (String[])new String[]{realFilename2}));
                        } else if (folder2.getType() == FileType.FOLDER) {
                            this.logError(BaseMessages.getString(PKG, (String)"JobFoldersCompare.Log.IsAFolder", (String[])new String[]{realFilename2}));
                        } else {
                            this.logError(BaseMessages.getString(PKG, (String)"JobFoldersCompare.Log.IsUnknownFileType", (String[])new String[]{realFilename2}));
                        }
                    } else if (folder1.getType() == FileType.FILE) {
                        if (this.equalFileContents(folder1, folder2)) {
                            result.setResult(true);
                        } else {
                            result.setResult(false);
                        }
                    } else if (folder1.getType() == FileType.FOLDER) {
                        FileObject[] list1 = folder1.findFiles((FileSelector)new TextFileSelector(folder1.toString()));
                        FileObject[] list2 = folder2.findFiles((FileSelector)new TextFileSelector(folder2.toString()));
                        int lenList1 = list1.length;
                        int lenList2 = list2.length;
                        if (this.log.isDetailed()) {
                            this.logDetailed(BaseMessages.getString(PKG, (String)"JobFoldersCompare.Log.FolderContains", (String[])new String[]{realFilename1, "" + lenList1}));
                            this.logDetailed(BaseMessages.getString(PKG, (String)"JobFoldersCompare.Log.FolderContains", (String[])new String[]{realFilename2, "" + lenList2}));
                        }
                        if (lenList1 == lenList2) {
                            int i;
                            HashMap<String, String> collection1 = new HashMap<String, String>();
                            HashMap<String, String> collection2 = new HashMap<String, String>();
                            for (i = 0; i < list1.length; ++i) {
                                collection1.put(list1[i].getName().getBaseName(), list1[i].toString());
                            }
                            for (i = 0; i < list2.length; ++i) {
                                collection2.put(list2[i].getName().getBaseName(), list2[i].toString());
                            }
                            Set entrees = collection1.entrySet();
                            for (Map.Entry entree : entrees) {
                                long filefolder2_size;
                                long filefolder1_size;
                                if (!collection2.containsKey(entree.getKey())) {
                                    ok = false;
                                    if (!this.log.isDetailed()) continue;
                                    this.logDetailed(BaseMessages.getString(PKG, (String)"JobFoldersCompare.Log.FileCanNotBeFoundIn", (String[])new String[]{((String)entree.getKey()).toString(), realFilename2}));
                                    continue;
                                }
                                if (this.log.isDebug()) {
                                    this.logDebug(BaseMessages.getString(PKG, (String)"JobFoldersCompare.Log.FileIsFoundIn", (String[])new String[]{((String)entree.getKey()).toString(), realFilename2}));
                                }
                                filefolder1 = KettleVFS.getFileObject((String)((String)entree.getValue()).toString(), (VariableSpace)this);
                                filefolder2 = KettleVFS.getFileObject((String)((String)collection2.get(entree.getKey())).toString(), (VariableSpace)this);
                                if (!filefolder2.getType().equals(filefolder1.getType())) {
                                    ok = false;
                                    if (this.log.isDetailed()) {
                                        this.logDetailed(BaseMessages.getString(PKG, (String)"JobFoldersCompare.Log.FilesNotSameType", (String[])new String[]{filefolder1.toString(), filefolder2.toString()}));
                                    }
                                    if (filefolder1.getType() == FileType.FILE) {
                                        this.logError(BaseMessages.getString(PKG, (String)"JobFoldersCompare.Log.IsAFile", (String[])new String[]{filefolder1.toString()}));
                                    } else if (filefolder1.getType() == FileType.FOLDER) {
                                        this.logError(BaseMessages.getString(PKG, (String)"JobFoldersCompare.Log.IsAFolder", (String[])new String[]{filefolder1.toString()}));
                                    } else {
                                        this.logError(BaseMessages.getString(PKG, (String)"JobFoldersCompare.Log.IsUnknownFileType", (String[])new String[]{filefolder1.toString()}));
                                    }
                                    if (filefolder2.getType() == FileType.FILE) {
                                        this.logError(BaseMessages.getString(PKG, (String)"JobFoldersCompare.Log.IsAFile", (String[])new String[]{filefolder2.toString()}));
                                        continue;
                                    }
                                    if (filefolder2.getType() == FileType.FOLDER) {
                                        this.logError(BaseMessages.getString(PKG, (String)"JobFoldersCompare.Log.IsAFolder", (String[])new String[]{filefolder2.toString()}));
                                        continue;
                                    }
                                    this.logError(BaseMessages.getString(PKG, (String)"JobFoldersCompare.Log.IsUnknownFileType", (String[])new String[]{filefolder2.toString()}));
                                    continue;
                                }
                                if (filefolder2.getType() != FileType.FILE) continue;
                                if (this.comparefilesize && (filefolder1_size = filefolder1.getContent().getSize()) != (filefolder2_size = filefolder2.getContent().getSize())) {
                                    ok = false;
                                    if (this.log.isDetailed()) {
                                        this.logDetailed(BaseMessages.getString(PKG, (String)"JobFoldersCompare.Log.FilesNotSameSize", (String[])new String[]{filefolder1.toString(), filefolder2.toString()}));
                                        this.logDetailed(BaseMessages.getString(PKG, (String)"JobFoldersCompare.Log.SizeFileIs", (String[])new String[]{filefolder1.toString(), "" + filefolder1_size}));
                                        this.logDetailed(BaseMessages.getString(PKG, (String)"JobFoldersCompare.Log.SizeFileIs", (String[])new String[]{filefolder2.toString(), "" + filefolder2_size}));
                                    }
                                }
                                if (!ok || !this.comparefilecontent || this.equalFileContents(filefolder1, filefolder2)) continue;
                                ok = false;
                                if (!this.log.isDetailed()) continue;
                                this.logDetailed(BaseMessages.getString(PKG, (String)"JobFoldersCompare.Log.FilesNotSameContent", (String[])new String[]{filefolder1.toString(), filefolder2.toString()}));
                            }
                            result.setResult(ok);
                        } else if (this.log.isDetailed()) {
                            this.logDetailed(BaseMessages.getString(PKG, (String)"JobFoldersCompare.Log.FoldersDifferentFiles", (String[])new String[]{realFilename1.toString(), realFilename2.toString()}));
                        }
                    }
                } else {
                    if (!folder1.exists()) {
                        this.logError(BaseMessages.getString(PKG, (String)"JobFileCompare.Log.FileNotExist", (String[])new String[]{realFilename1}));
                    }
                    if (!folder2.exists()) {
                        this.logError(BaseMessages.getString(PKG, (String)"JobFileCompare.Log.FileNotExist", (String[])new String[]{realFilename2}));
                    }
                    result.setResult(false);
                    result.setNrErrors(1L);
                }
            } else {
                this.logError(BaseMessages.getString(PKG, (String)"JobFoldersCompare.Log.Need2Files", (String[])new String[0]));
            }
        }
        catch (Exception e) {
            result.setResult(false);
            result.setNrErrors(1L);
            this.logError(BaseMessages.getString(PKG, (String)"JobFoldersCompare.Log.ErrorComparing", (String[])new String[]{realFilename2, realFilename2, e.getMessage()}));
        }
        finally {
            try {
                if (folder1 != null) {
                    folder1.close();
                    folder1 = null;
                }
                if (folder2 != null) {
                    folder2.close();
                    folder2 = null;
                }
                if (filefolder1 != null) {
                    filefolder1.close();
                    filefolder1 = null;
                }
                if (filefolder2 != null) {
                    filefolder2.close();
                    filefolder2 = null;
                }
            }
            catch (IOException e) {}
        }
        return result;
    }

    private boolean GetFileWildcard(String selectedfile) {
        Pattern pattern = null;
        boolean getIt = true;
        if (!Const.isEmpty((String)this.wildcard) && (pattern = Pattern.compile(this.wildcard)) != null) {
            Matcher matcher = pattern.matcher(selectedfile);
            getIt = matcher.matches();
        }
        return getIt;
    }

    @Override
    public boolean evaluates() {
        return true;
    }

    public void setWildcard(String wildcard) {
        this.wildcard = wildcard;
    }

    public String getWildcard() {
        return this.wildcard;
    }

    public void setFilename1(String filename) {
        this.filename1 = filename;
    }

    public String getFilename1() {
        return this.filename1;
    }

    public void setFilename2(String filename) {
        this.filename2 = filename;
    }

    public String getFilename2() {
        return this.filename2;
    }

    @Override
    public void check(List<CheckResultInterface> remarks, JobMeta jobMeta, VariableSpace space, Repository repository, IMetaStore metaStore) {
        ValidatorContext ctx = new ValidatorContext();
        AbstractFileValidator.putVariableSpace(ctx, this.getVariables());
        AndValidator.putValidators(ctx, JobEntryValidatorUtils.notNullValidator(), JobEntryValidatorUtils.fileExistsValidator());
        JobEntryValidatorUtils.andValidator().validate(this, "filename1", remarks, ctx);
        JobEntryValidatorUtils.andValidator().validate(this, "filename2", remarks, ctx);
    }

    private class TextFileSelector
    implements FileSelector {
        String source_folder = null;

        public TextFileSelector(String sourcefolderin) {
            if (!Const.isEmpty((String)sourcefolderin)) {
                this.source_folder = sourcefolderin;
            }
        }

        public boolean includeFile(FileSelectInfo info) {
            boolean returncode = false;
            try {
                if (!info.getFile().toString().equals(this.source_folder)) {
                    String short_filename = info.getFile().getName().getBaseName();
                    if (info.getFile().getParent().equals(info.getBaseFolder())) {
                        if (info.getFile().getType() == FileType.FILE && JobEntryFoldersCompare.this.compareonly.equals("only_files") || info.getFile().getType() == FileType.FOLDER && JobEntryFoldersCompare.this.compareonly.equals("only_folders") || JobEntryFoldersCompare.this.GetFileWildcard(short_filename) && JobEntryFoldersCompare.this.compareonly.equals("specify") || JobEntryFoldersCompare.this.compareonly.equals("all")) {
                            returncode = true;
                        }
                    } else if (JobEntryFoldersCompare.this.includesubfolders && (info.getFile().getType() == FileType.FILE && JobEntryFoldersCompare.this.compareonly.equals("only_files") || info.getFile().getType() == FileType.FOLDER && JobEntryFoldersCompare.this.compareonly.equals("only_folders") || JobEntryFoldersCompare.this.GetFileWildcard(short_filename) && JobEntryFoldersCompare.this.compareonly.equals("specify") || JobEntryFoldersCompare.this.compareonly.equals("all"))) {
                        returncode = true;
                    }
                }
            }
            catch (Exception e) {
                JobEntryFoldersCompare.this.logError("Error while finding files ... in [" + info.getFile().toString() + "]. Exception :" + e.getMessage());
                returncode = false;
            }
            return returncode;
        }

        public boolean traverseDescendents(FileSelectInfo info) {
            return true;
        }
    }
}

