/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.job.entries.createfile;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.vfs.FileObject;
import org.pentaho.di.cluster.SlaveServer;
import org.pentaho.di.core.CheckResultInterface;
import org.pentaho.di.core.Result;
import org.pentaho.di.core.ResultFile;
import org.pentaho.di.core.database.DatabaseMeta;
import org.pentaho.di.core.exception.KettleDatabaseException;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.exception.KettleXMLException;
import org.pentaho.di.core.variables.VariableSpace;
import org.pentaho.di.core.variables.Variables;
import org.pentaho.di.core.vfs.KettleVFS;
import org.pentaho.di.core.xml.XMLHandler;
import org.pentaho.di.i18n.BaseMessages;
import org.pentaho.di.job.Job;
import org.pentaho.di.job.JobMeta;
import org.pentaho.di.job.entry.JobEntryBase;
import org.pentaho.di.job.entry.JobEntryInterface;
import org.pentaho.di.job.entry.validator.AbstractFileValidator;
import org.pentaho.di.job.entry.validator.AndValidator;
import org.pentaho.di.job.entry.validator.JobEntryValidatorUtils;
import org.pentaho.di.job.entry.validator.ValidatorContext;
import org.pentaho.di.repository.ObjectId;
import org.pentaho.di.repository.Repository;
import org.pentaho.metastore.api.IMetaStore;
import org.w3c.dom.Node;

public class JobEntryCreateFile
extends JobEntryBase
implements Cloneable,
JobEntryInterface {
    private static Class<?> PKG = JobEntryCreateFile.class;
    private String filename = null;
    private boolean failIfFileExists = true;
    private boolean addfilenameresult = false;

    public JobEntryCreateFile(String n) {
        super(n, "");
    }

    public JobEntryCreateFile() {
        this("");
    }

    @Override
    public Object clone() {
        JobEntryCreateFile je = (JobEntryCreateFile)super.clone();
        return je;
    }

    @Override
    public String getXML() {
        StringBuffer retval = new StringBuffer(50);
        retval.append(super.getXML());
        retval.append("      ").append(XMLHandler.addTagValue((String)"filename", (String)this.filename));
        retval.append("      ").append(XMLHandler.addTagValue((String)"fail_if_file_exists", (boolean)this.failIfFileExists));
        retval.append("      ").append(XMLHandler.addTagValue((String)"add_filename_result", (boolean)this.addfilenameresult));
        return retval.toString();
    }

    @Override
    public void loadXML(Node entrynode, List<DatabaseMeta> databases, List<SlaveServer> slaveServers, Repository rep, IMetaStore metaStore) throws KettleXMLException {
        try {
            super.loadXML(entrynode, databases, slaveServers);
            this.filename = XMLHandler.getTagValue((Node)entrynode, (String)"filename");
            this.failIfFileExists = "Y".equalsIgnoreCase(XMLHandler.getTagValue((Node)entrynode, (String)"fail_if_file_exists"));
            this.addfilenameresult = "Y".equalsIgnoreCase(XMLHandler.getTagValue((Node)entrynode, (String)"add_filename_result"));
        }
        catch (KettleXMLException xe) {
            throw new KettleXMLException("Unable to load job entry of type 'create file' from XML node", (Throwable)xe);
        }
    }

    @Override
    public void loadRep(Repository rep, IMetaStore metaStore, ObjectId id_jobentry, List<DatabaseMeta> databases, List<SlaveServer> slaveServers) throws KettleException {
        try {
            this.filename = rep.getJobEntryAttributeString(id_jobentry, "filename");
            this.failIfFileExists = rep.getJobEntryAttributeBoolean(id_jobentry, "fail_if_file_exists");
            this.addfilenameresult = rep.getJobEntryAttributeBoolean(id_jobentry, "add_filename_result");
        }
        catch (KettleException dbe) {
            throw new KettleException("Unable to load job entry of type 'create file' from the repository for id_jobentry=" + id_jobentry, (Throwable)dbe);
        }
    }

    @Override
    public void saveRep(Repository rep, IMetaStore metaStore, ObjectId id_job) throws KettleException {
        try {
            rep.saveJobEntryAttribute(id_job, this.getObjectId(), "filename", this.filename);
            rep.saveJobEntryAttribute(id_job, this.getObjectId(), "fail_if_file_exists", this.failIfFileExists);
            rep.saveJobEntryAttribute(id_job, this.getObjectId(), "add_filename_result", this.addfilenameresult);
        }
        catch (KettleDatabaseException dbe) {
            throw new KettleException("Unable to save job entry of type 'create file' to the repository for id_job=" + id_job, (Throwable)dbe);
        }
    }

    public void setFilename(String filename) {
        this.filename = filename;
    }

    @Override
    public String getFilename() {
        return this.filename;
    }

    @Override
    public String getRealFilename() {
        return this.environmentSubstitute(this.getFilename());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public Result execute(Result previousResult, int nr) throws KettleException {
        Result result = previousResult;
        result.setResult(false);
        if (this.filename != null) {
            String realFilename = this.getRealFilename();
            FileObject fileObject = null;
            try {
                fileObject = KettleVFS.getFileObject((String)realFilename, (VariableSpace)this);
                if (fileObject.exists()) {
                    if (this.isFailIfFileExists()) {
                        result.setResult(false);
                        this.logError("File [" + realFilename + "] exists, failing.");
                    } else {
                        result.setResult(true);
                        this.logBasic("File [" + realFilename + "] already exists, not recreating.");
                    }
                    if (!this.isAddFilenameToResult()) return result;
                    this.addFilenameToResult(realFilename, result, this.parentJob);
                    return result;
                }
                fileObject.createFile();
                this.logBasic("File [" + realFilename + "] created!");
                if (this.isAddFilenameToResult()) {
                    this.addFilenameToResult(realFilename, result, this.parentJob);
                }
                result.setResult(true);
                return result;
            }
            catch (IOException e) {
                this.logError("Could not create file [" + realFilename + "], exception: " + e.getMessage());
                result.setResult(false);
                result.setNrErrors(1L);
                return result;
            }
            finally {
                if (fileObject != null) {
                    try {
                        fileObject.close();
                        fileObject = null;
                    }
                    catch (IOException ex) {}
                }
            }
        }
        this.logError("No filename is defined.");
        return result;
    }

    private void addFilenameToResult(String targetFilename, Result result, Job parentJob) throws KettleException {
        FileObject targetFile = null;
        try {
            targetFile = KettleVFS.getFileObject((String)targetFilename, (VariableSpace)this);
            ResultFile resultFile = new ResultFile(0, targetFile, parentJob.getJobname(), this.toString());
            resultFile.setComment("");
            result.getResultFiles().put(resultFile.getFile().toString(), resultFile);
            if (this.log.isDetailed()) {
                this.logDetailed(BaseMessages.getString(PKG, (String)"JobEntryCreateFile.FileAddedToResult", (String[])new String[]{targetFilename}));
            }
        }
        catch (Exception e) {
            throw new KettleException((Throwable)e);
        }
        finally {
            try {
                targetFile.close();
                targetFile = null;
            }
            catch (Exception e) {}
        }
    }

    @Override
    public boolean evaluates() {
        return true;
    }

    public boolean isFailIfFileExists() {
        return this.failIfFileExists;
    }

    public void setFailIfFileExists(boolean failIfFileExists) {
        this.failIfFileExists = failIfFileExists;
    }

    public boolean isAddFilenameToResult() {
        return this.addfilenameresult;
    }

    public void setAddFilenameToResult(boolean addfilenameresult) {
        this.addfilenameresult = addfilenameresult;
    }

    public static void main(String[] args) {
        ArrayList<CheckResultInterface> remarks = new ArrayList<CheckResultInterface>();
        new JobEntryCreateFile().check(remarks, null, (VariableSpace)new Variables(), null, null);
        System.out.printf("Remarks: %s\n", remarks);
    }

    @Override
    public void check(List<CheckResultInterface> remarks, JobMeta jobMeta, VariableSpace space, Repository repository, IMetaStore metaStore) {
        ValidatorContext ctx = new ValidatorContext();
        AbstractFileValidator.putVariableSpace(ctx, this.getVariables());
        AndValidator.putValidators(ctx, JobEntryValidatorUtils.notNullValidator(), JobEntryValidatorUtils.fileDoesNotExistValidator());
        JobEntryValidatorUtils.andValidator().validate(this, "filename", remarks, ctx);
    }
}

