/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.imp.rules;

import java.util.ArrayList;
import java.util.List;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.xml.XMLHandler;
import org.pentaho.di.imp.rule.ImportRuleInterface;
import org.pentaho.di.imp.rule.ImportValidationFeedback;
import org.pentaho.di.imp.rule.ImportValidationResultType;
import org.pentaho.di.imp.rules.BaseImportRule;
import org.pentaho.di.trans.TransMeta;
import org.w3c.dom.Node;

public class TransformationHasANoteImportRule
extends BaseImportRule
implements ImportRuleInterface {
    @Override
    public List<ImportValidationFeedback> verifyRule(Object subject) {
        ArrayList<ImportValidationFeedback> feedback = new ArrayList<ImportValidationFeedback>();
        if (!this.isEnabled()) {
            return feedback;
        }
        if (!(subject instanceof TransMeta)) {
            return feedback;
        }
        TransMeta transMeta = (TransMeta)subject;
        if (transMeta.nrNotes() == 0) {
            feedback.add(new ImportValidationFeedback(this, ImportValidationResultType.ERROR, "There is not even a single note in the transformation."));
        } else {
            feedback.add(new ImportValidationFeedback(this, ImportValidationResultType.APPROVAL, "At least one not is present in the transformation."));
        }
        return feedback;
    }

    @Override
    public String getXML() {
        StringBuilder xml = new StringBuilder();
        xml.append(XMLHandler.openTag((String)XML_TAG));
        xml.append(super.getXML());
        xml.append(XMLHandler.closeTag((String)XML_TAG));
        return xml.toString();
    }

    @Override
    public void loadXML(Node ruleNode) throws KettleException {
        super.loadXML(ruleNode);
    }
}

