/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.vfs.provider.temp;

import java.io.File;
import java.util.Collection;
import org.apache.commons.vfs.FileName;
import org.apache.commons.vfs.FileObject;
import org.apache.commons.vfs.FileSystem;
import org.apache.commons.vfs.FileSystemException;
import org.apache.commons.vfs.FileSystemOptions;
import org.apache.commons.vfs.FileType;
import org.apache.commons.vfs.provider.AbstractFileProvider;
import org.apache.commons.vfs.provider.FileProvider;
import org.apache.commons.vfs.provider.UriParser;
import org.apache.commons.vfs.provider.local.DefaultLocalFileProvider;
import org.apache.commons.vfs.provider.local.LocalFileSystem;

public class TemporaryFileProvider
extends AbstractFileProvider
implements FileProvider,
Comparable {
    private File rootFile;

    public TemporaryFileProvider(File file) {
        this();
        this.rootFile = file;
    }

    public TemporaryFileProvider() {
    }

    public int compareTo(Object object) {
        int n;
        int n2 = this.hashCode();
        if (n2 < (n = object.hashCode())) {
            return -1;
        }
        if (n2 > n) {
            return 1;
        }
        return 0;
    }

    public synchronized FileObject findFile(FileObject fileObject, String string, FileSystemOptions fileSystemOptions) throws FileSystemException {
        StringBuffer stringBuffer = new StringBuffer(string);
        String string2 = UriParser.extractScheme(string, stringBuffer);
        UriParser.fixSeparators(stringBuffer);
        FileType fileType = UriParser.normalisePath(stringBuffer);
        String string3 = stringBuffer.toString();
        FileSystem fileSystem = this.findFileSystem(this, fileSystemOptions);
        if (fileSystem == null) {
            if (this.rootFile == null) {
                this.rootFile = this.getContext().getTemporaryFileStore().allocateFile("tempfs");
            }
            FileName fileName = this.getContext().parseURI(string2 + ":" + "/");
            fileSystem = new LocalFileSystem(fileName, this.rootFile.getAbsolutePath(), fileSystemOptions);
            this.addFileSystem(this, fileSystem);
        }
        return fileSystem.resolveFile(string3);
    }

    public Collection getCapabilities() {
        return DefaultLocalFileProvider.capabilities;
    }
}

