/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.vfs.provider.mime;

import java.io.IOException;
import java.io.InputStream;
import java.util.Collection;
import javax.mail.MessagingException;
import javax.mail.Part;
import javax.mail.internet.MimeMessage;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.commons.vfs.Capability;
import org.apache.commons.vfs.FileName;
import org.apache.commons.vfs.FileObject;
import org.apache.commons.vfs.FileSystem;
import org.apache.commons.vfs.FileSystemException;
import org.apache.commons.vfs.FileSystemOptions;
import org.apache.commons.vfs.provider.AbstractFileSystem;
import org.apache.commons.vfs.provider.mime.MimeFileObject;
import org.apache.commons.vfs.provider.mime.MimeFileProvider;
import org.apache.commons.vfs.util.SharedRandomContentInputStream;

public class MimeFileSystem
extends AbstractFileSystem
implements FileSystem {
    private Log log = LogFactory.getLog(MimeFileSystem.class);
    public static final String NULL_BP_NAME = "_body_part_";
    public static final String CONTENT_NAME = "_content";
    public static final String PREAMBLE_CHARSET = "UTF-8";
    private InputStream mimeStream = null;

    protected MimeFileSystem(FileName fileName, FileObject fileObject, FileSystemOptions fileSystemOptions) {
        super(fileName, fileObject, fileSystemOptions);
    }

    protected FileObject createFile(FileName fileName) throws FileSystemException {
        return new MimeFileObject(fileName, null, this);
    }

    protected void addCapabilities(Collection collection) {
        collection.addAll(MimeFileProvider.capabilities);
    }

    protected void doCloseCommunicationLink() {
        try {
            if (this.mimeStream == null) {
                return;
            }
            this.closeMimeStream();
            this.mimeStream = null;
        }
        catch (IOException iOException) {
            this.log.warn((Object)iOException.getLocalizedMessage(), (Throwable)iOException);
        }
    }

    private void closeMimeStream() throws IOException {
        if (this.mimeStream instanceof SharedRandomContentInputStream) {
            ((SharedRandomContentInputStream)this.mimeStream).closeAll();
        } else {
            this.mimeStream.close();
        }
    }

    public Part createCommunicationLink() throws IOException, MessagingException {
        FileObject fileObject;
        if (this.mimeStream != null) {
            this.closeMimeStream();
        }
        if (!(fileObject = this.getParentLayer()).exists()) {
            return null;
        }
        this.mimeStream = fileObject.getFileSystem().hasCapability(Capability.RANDOM_ACCESS_READ) ? new SharedRandomContentInputStream(fileObject) : this.getParentLayer().getContent().getInputStream();
        return new MimeMessage(null, this.mimeStream);
    }
}

