/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.vfs.provider.ftp;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Calendar;
import java.util.Collections;
import java.util.Map;
import java.util.TreeMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.commons.net.ftp.FTPFile;
import org.apache.commons.vfs.FileName;
import org.apache.commons.vfs.FileNotFolderException;
import org.apache.commons.vfs.FileObject;
import org.apache.commons.vfs.FileSystem;
import org.apache.commons.vfs.FileSystemException;
import org.apache.commons.vfs.FileType;
import org.apache.commons.vfs.RandomAccessContent;
import org.apache.commons.vfs.provider.AbstractFileObject;
import org.apache.commons.vfs.provider.UriParser;
import org.apache.commons.vfs.provider.ftp.FtpClient;
import org.apache.commons.vfs.provider.ftp.FtpFileSystem;
import org.apache.commons.vfs.provider.ftp.FtpRandomAccessContent;
import org.apache.commons.vfs.util.FileObjectUtils;
import org.apache.commons.vfs.util.Messages;
import org.apache.commons.vfs.util.MonitorInputStream;
import org.apache.commons.vfs.util.MonitorOutputStream;
import org.apache.commons.vfs.util.RandomAccessMode;

public class FtpFileObject
extends AbstractFileObject {
    private static final Map EMPTY_FTP_FILE_MAP = Collections.unmodifiableMap(new TreeMap());
    private static final FTPFile UNKNOWN = new FTPFile();
    private Log log = LogFactory.getLog(FtpFileObject.class);
    private final FtpFileSystem ftpFs;
    private final String relPath;
    private FTPFile fileInfo;
    private Map children;
    private FileObject linkDestination;
    private boolean inRefresh;

    protected FtpFileObject(FileName fileName, FtpFileSystem ftpFileSystem, FileName fileName2) throws FileSystemException {
        super(fileName, ftpFileSystem);
        this.ftpFs = ftpFileSystem;
        String string = UriParser.decode(fileName2.getRelativeName(fileName));
        this.relPath = ".".equals(string) ? null : string;
    }

    private FTPFile getChildFile(String string, boolean bl) throws IOException {
        if (bl && !this.inRefresh) {
            this.children = null;
        }
        this.doGetChildren();
        if (this.children == null) {
            return null;
        }
        FTPFile fTPFile = (FTPFile)this.children.get(string);
        return fTPFile;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doGetChildren() throws IOException {
        if (this.children != null) {
            return;
        }
        FtpClient ftpClient = this.ftpFs.getClient();
        try {
            String string = this.fileInfo != null && this.fileInfo.isSymbolicLink() ? this.getFileSystem().getFileSystemManager().resolveName(this.getParent().getName(), this.fileInfo.getLink()).getPath() : this.relPath;
            FTPFile[] fTPFileArray = ftpClient.listFiles(string);
            if (fTPFileArray == null || fTPFileArray.length == 0) {
                this.children = EMPTY_FTP_FILE_MAP;
            } else {
                this.children = new TreeMap();
                for (int i = 0; i < fTPFileArray.length; ++i) {
                    FTPFile fTPFile = fTPFileArray[i];
                    if (fTPFile == null) {
                        if (!this.log.isDebugEnabled()) continue;
                        this.log.debug((Object)Messages.getString("vfs.provider.ftp/invalid-directory-entry.debug", new Object[]{new Integer(i), this.relPath}));
                        continue;
                    }
                    if (".".equals(fTPFile.getName()) || "..".equals(fTPFile.getName())) continue;
                    this.children.put(fTPFile.getName(), fTPFile);
                }
            }
        }
        finally {
            this.ftpFs.putClient(ftpClient);
        }
    }

    protected void doAttach() throws IOException {
    }

    private void getInfo(boolean bl) throws IOException {
        FTPFile fTPFile;
        FtpFileObject ftpFileObject = (FtpFileObject)FileObjectUtils.getAbstractFileObject(this.getParent());
        if (ftpFileObject != null) {
            fTPFile = ftpFileObject.getChildFile(UriParser.decode(this.getName().getBaseName()), bl);
        } else {
            fTPFile = new FTPFile();
            fTPFile.setType(1);
        }
        this.fileInfo = fTPFile == null ? UNKNOWN : fTPFile;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void refresh() throws FileSystemException {
        if (!this.inRefresh) {
            try {
                this.inRefresh = true;
                super.refresh();
                FileSystem fileSystem = this.getFileSystem();
                synchronized (fileSystem) {
                    this.fileInfo = null;
                }
            }
            finally {
                this.inRefresh = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doDetach() {
        FileSystem fileSystem = this.getFileSystem();
        synchronized (fileSystem) {
            this.fileInfo = null;
            this.children = null;
        }
    }

    protected void onChildrenChanged(FileName fileName, FileType fileType) {
        if (this.children != null && fileType.equals(FileType.IMAGINARY)) {
            try {
                this.children.remove(UriParser.decode(fileName.getBaseName()));
            }
            catch (FileSystemException fileSystemException) {
                throw new RuntimeException(fileSystemException.getMessage());
            }
        } else {
            this.children = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void onChange() throws IOException {
        this.children = null;
        if (this.getType().equals(FileType.IMAGINARY)) {
            FileSystem fileSystem = this.getFileSystem();
            synchronized (fileSystem) {
                this.fileInfo = UNKNOWN;
            }
            return;
        }
        this.getInfo(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected FileType doGetType() throws Exception {
        FileSystem fileSystem = this.getFileSystem();
        synchronized (fileSystem) {
            if (this.fileInfo == null) {
                this.getInfo(false);
            }
            if (this.fileInfo == UNKNOWN) {
                return FileType.IMAGINARY;
            }
            if (this.fileInfo.isDirectory()) {
                return FileType.FOLDER;
            }
            if (this.fileInfo.isFile()) {
                return FileType.FILE;
            }
            if (this.fileInfo.isSymbolicLink()) {
                return this.getLinkDestination().getType();
            }
        }
        throw new FileSystemException("vfs.provider.ftp/get-type.error", this.getName());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private FileObject getLinkDestination() throws FileSystemException {
        if (this.linkDestination == null) {
            String string;
            Object object = this.getFileSystem();
            synchronized (object) {
                string = this.fileInfo.getLink();
            }
            object = this.getName().getParent();
            if (object == null) {
                object = this.getName();
            }
            FileName fileName = this.getFileSystem().getFileSystemManager().resolveName((FileName)object, string);
            this.linkDestination = this.getFileSystem().resolveFile(fileName);
        }
        return this.linkDestination;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected FileObject[] doListChildrenResolved() throws Exception {
        FileSystem fileSystem = this.getFileSystem();
        synchronized (fileSystem) {
            if (this.fileInfo != null && this.fileInfo.isSymbolicLink()) {
                return this.getLinkDestination().getChildren();
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FileObject[] getChildren() throws FileSystemException {
        try {
            if (this.doGetType() != FileType.FOLDER) {
                throw new FileNotFolderException(this.getName());
            }
        }
        catch (Exception exception) {
            throw new FileNotFolderException(this.getName(), (Throwable)exception);
        }
        try {
            this.inRefresh = true;
            FileObject[] fileObjectArray = super.getChildren();
            return fileObjectArray;
        }
        finally {
            this.inRefresh = false;
        }
    }

    protected String[] doListChildren() throws Exception {
        this.doGetChildren();
        if (this.children == null) {
            return null;
        }
        String[] stringArray = new String[this.children.size()];
        int n = -1;
        for (FTPFile fTPFile : this.children.values()) {
            stringArray[++n] = fTPFile.getName();
        }
        return UriParser.encode(stringArray);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doDelete() throws Exception {
        FileSystem fileSystem = this.getFileSystem();
        synchronized (fileSystem) {
            boolean bl;
            FtpClient ftpClient = this.ftpFs.getClient();
            try {
                bl = this.fileInfo.isDirectory() ? ftpClient.removeDirectory(this.relPath) : ftpClient.deleteFile(this.relPath);
            }
            finally {
                this.ftpFs.putClient(ftpClient);
            }
            if (!bl) {
                throw new FileSystemException("vfs.provider.ftp/delete-file.error", this.getName());
            }
            this.fileInfo = null;
            this.children = EMPTY_FTP_FILE_MAP;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doRename(FileObject fileObject) throws Exception {
        FileSystem fileSystem = this.getFileSystem();
        synchronized (fileSystem) {
            boolean bl;
            FtpClient ftpClient = this.ftpFs.getClient();
            try {
                String string = this.getName().getPath();
                String string2 = fileObject.getName().getPath();
                bl = ftpClient.rename(string, string2);
            }
            finally {
                this.ftpFs.putClient(ftpClient);
            }
            if (!bl) {
                throw new FileSystemException("vfs.provider.ftp/rename-file.error", new Object[]{this.getName().toString(), fileObject});
            }
            this.fileInfo = null;
            this.children = EMPTY_FTP_FILE_MAP;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doCreateFolder() throws Exception {
        boolean bl;
        FtpClient ftpClient = this.ftpFs.getClient();
        try {
            bl = ftpClient.makeDirectory(this.relPath);
        }
        finally {
            this.ftpFs.putClient(ftpClient);
        }
        if (!bl) {
            throw new FileSystemException("vfs.provider.ftp/create-folder.error", this.getName());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected long doGetContentSize() throws Exception {
        FileSystem fileSystem = this.getFileSystem();
        synchronized (fileSystem) {
            if (this.fileInfo.isSymbolicLink()) {
                return this.getLinkDestination().getContent().getSize();
            }
            return this.fileInfo.getSize();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected long doGetLastModifiedTime() throws Exception {
        FileSystem fileSystem = this.getFileSystem();
        synchronized (fileSystem) {
            if (this.fileInfo.isSymbolicLink()) {
                return this.getLinkDestination().getContent().getLastModifiedTime();
            }
            Calendar calendar = this.fileInfo.getTimestamp();
            if (calendar == null) {
                return 0L;
            }
            return calendar.getTime().getTime();
        }
    }

    protected InputStream doGetInputStream() throws Exception {
        FtpClient ftpClient = this.ftpFs.getClient();
        try {
            InputStream inputStream = ftpClient.retrieveFileStream(this.relPath);
            if (inputStream == null) {
                throw new FileNotFoundException(this.getName().toString());
            }
            return new FtpInputStream(ftpClient, inputStream);
        }
        catch (Exception exception) {
            this.ftpFs.putClient(ftpClient);
            throw exception;
        }
    }

    protected RandomAccessContent doGetRandomAccessContent(RandomAccessMode randomAccessMode) throws Exception {
        return new FtpRandomAccessContent(this, randomAccessMode);
    }

    protected OutputStream doGetOutputStream(boolean bl) throws Exception {
        FtpClient ftpClient = this.ftpFs.getClient();
        try {
            OutputStream outputStream = null;
            outputStream = bl ? ftpClient.appendFileStream(this.relPath) : ftpClient.storeFileStream(this.relPath);
            if (outputStream == null) {
                throw new FileSystemException("vfs.provider.ftp/output-error.debug", new Object[]{this.getName(), ftpClient.getReplyString()});
            }
            return new FtpOutputStream(ftpClient, outputStream);
        }
        catch (Exception exception) {
            this.ftpFs.putClient(ftpClient);
            throw exception;
        }
    }

    String getRelPath() {
        return this.relPath;
    }

    FtpInputStream getInputStream(long l) throws IOException {
        FtpClient ftpClient = this.ftpFs.getClient();
        try {
            InputStream inputStream = ftpClient.retrieveFileStream(this.relPath, l);
            if (inputStream == null) {
                throw new FileSystemException("vfs.provider.ftp/input-error.debug", new Object[]{this.getName(), ftpClient.getReplyString()});
            }
            return new FtpInputStream(ftpClient, inputStream);
        }
        catch (IOException iOException) {
            this.ftpFs.putClient(ftpClient);
            throw iOException;
        }
    }

    private class FtpOutputStream
    extends MonitorOutputStream {
        private final FtpClient client;

        public FtpOutputStream(FtpClient ftpClient, OutputStream outputStream) {
            super(outputStream);
            this.client = ftpClient;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void onClose() throws IOException {
            boolean bl;
            try {
                bl = this.client.completePendingCommand();
            }
            finally {
                FtpFileObject.this.ftpFs.putClient(this.client);
            }
            if (!bl) {
                throw new FileSystemException("vfs.provider.ftp/finish-put.error", FtpFileObject.this.getName());
            }
        }
    }

    class FtpInputStream
    extends MonitorInputStream {
        private final FtpClient client;

        public FtpInputStream(FtpClient ftpClient, InputStream inputStream) {
            super(inputStream);
            this.client = ftpClient;
        }

        void abort() throws IOException {
            this.client.abort();
            this.close();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void onClose() throws IOException {
            boolean bl;
            try {
                bl = this.client.completePendingCommand();
            }
            finally {
                FtpFileObject.this.ftpFs.putClient(this.client);
            }
            if (!bl) {
                throw new FileSystemException("vfs.provider.ftp/finish-get.error", FtpFileObject.this.getName());
            }
        }
    }
}

