/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.vfs.provider.ftp;

import java.io.IOException;
import org.apache.commons.net.ftp.FTPClient;
import org.apache.commons.net.ftp.FTPClientConfig;
import org.apache.commons.net.ftp.FTPReply;
import org.apache.commons.net.ftp.parser.FTPFileEntryParserFactory;
import org.apache.commons.vfs.FileSystemException;
import org.apache.commons.vfs.FileSystemOptions;
import org.apache.commons.vfs.provider.ftp.FtpFileSystemConfigBuilder;
import org.apache.commons.vfs.util.UserAuthenticatorUtils;

public final class FtpClientFactory {
    private static final int BUFSZ = 40;

    private FtpClientFactory() {
    }

    public static FTPClient createConnection(String string, int n, char[] cArray, char[] cArray2, String string2, FileSystemOptions fileSystemOptions) throws FileSystemException {
        if (cArray == null) {
            cArray = "anonymous".toCharArray();
        }
        if (cArray2 == null) {
            cArray2 = "anonymous".toCharArray();
        }
        try {
            Object object;
            Object object2;
            Object object3;
            Object object4;
            FTPFileEntryParserFactory fTPFileEntryParserFactory;
            FTPClient fTPClient = new FTPClient();
            String string3 = FtpFileSystemConfigBuilder.getInstance().getEntryParser(fileSystemOptions);
            if (string3 != null) {
                fTPFileEntryParserFactory = new FTPClientConfig(string3);
                String string4 = FtpFileSystemConfigBuilder.getInstance().getServerLanguageCode(fileSystemOptions);
                if (string4 != null) {
                    fTPFileEntryParserFactory.setServerLanguageCode(string4);
                }
                if ((object4 = FtpFileSystemConfigBuilder.getInstance().getDefaultDateFormat(fileSystemOptions)) != null) {
                    fTPFileEntryParserFactory.setDefaultDateFormatStr((String)object4);
                }
                if ((object3 = FtpFileSystemConfigBuilder.getInstance().getRecentDateFormat(fileSystemOptions)) != null) {
                    fTPFileEntryParserFactory.setRecentDateFormatStr((String)object3);
                }
                if ((object2 = FtpFileSystemConfigBuilder.getInstance().getServerTimeZoneId(fileSystemOptions)) != null) {
                    fTPFileEntryParserFactory.setServerTimeZoneId((String)object2);
                }
                if ((object = FtpFileSystemConfigBuilder.getInstance().getShortMonthNames(fileSystemOptions)) != null) {
                    StringBuffer stringBuffer = new StringBuffer(40);
                    for (int i = 0; i < ((String[])object).length; ++i) {
                        if (stringBuffer.length() > 0) {
                            stringBuffer.append("|");
                        }
                        stringBuffer.append(object[i]);
                    }
                    fTPFileEntryParserFactory.setShortMonthNames(stringBuffer.toString());
                }
                fTPClient.configure((FTPClientConfig)fTPFileEntryParserFactory);
            }
            if ((fTPFileEntryParserFactory = FtpFileSystemConfigBuilder.getInstance().getEntryParserFactory(fileSystemOptions)) != null) {
                fTPClient.setParserFactory(fTPFileEntryParserFactory);
            }
            try {
                fTPClient.connect(string, n);
                int n2 = fTPClient.getReplyCode();
                if (!FTPReply.isPositiveCompletion((int)n2)) {
                    throw new FileSystemException("vfs.provider.ftp/connect-rejected.error", string);
                }
                if (!fTPClient.login(UserAuthenticatorUtils.toString(cArray), UserAuthenticatorUtils.toString(cArray2))) {
                    throw new FileSystemException("vfs.provider.ftp/login.error", new Object[]{string, UserAuthenticatorUtils.toString(cArray)}, null);
                }
                if (!fTPClient.setFileType(2)) {
                    throw new FileSystemException("vfs.provider.ftp/set-binary.error", string);
                }
                object4 = FtpFileSystemConfigBuilder.getInstance().getDataTimeout(fileSystemOptions);
                if (object4 != null) {
                    fTPClient.setDataTimeout(((Integer)object4).intValue());
                }
                if ((object3 = FtpFileSystemConfigBuilder.getInstance().getSoTimeout(fileSystemOptions)) != null) {
                    fTPClient.setSoTimeout(((Integer)object3).intValue());
                }
                object2 = FtpFileSystemConfigBuilder.getInstance().getUserDirIsRoot(fileSystemOptions);
                if (!(string2 == null || object2 != null && ((Boolean)object2).booleanValue() || fTPClient.changeWorkingDirectory(string2))) {
                    throw new FileSystemException("vfs.provider.ftp/change-work-directory.error", string2);
                }
                object = FtpFileSystemConfigBuilder.getInstance().getPassiveMode(fileSystemOptions);
                if (object != null && ((Boolean)object).booleanValue()) {
                    fTPClient.enterLocalPassiveMode();
                }
            }
            catch (IOException iOException) {
                if (fTPClient.isConnected()) {
                    fTPClient.disconnect();
                }
                throw iOException;
            }
            return fTPClient;
        }
        catch (Exception exception) {
            throw new FileSystemException("vfs.provider.ftp/connect.error", new Object[]{string}, (Throwable)exception);
        }
    }
}

