/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.vfs.impl;

import java.io.File;
import java.lang.reflect.Constructor;
import java.net.URLStreamHandler;
import java.net.URLStreamHandlerFactory;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.commons.vfs.CacheStrategy;
import org.apache.commons.vfs.FileContentInfoFactory;
import org.apache.commons.vfs.FileName;
import org.apache.commons.vfs.FileObject;
import org.apache.commons.vfs.FileSystem;
import org.apache.commons.vfs.FileSystemConfigBuilder;
import org.apache.commons.vfs.FileSystemException;
import org.apache.commons.vfs.FileSystemManager;
import org.apache.commons.vfs.FileSystemOptions;
import org.apache.commons.vfs.FileType;
import org.apache.commons.vfs.FilesCache;
import org.apache.commons.vfs.NameScope;
import org.apache.commons.vfs.VFS;
import org.apache.commons.vfs.cache.SoftRefFilesCache;
import org.apache.commons.vfs.impl.DecoratedFileObject;
import org.apache.commons.vfs.impl.DefaultVfsComponentContext;
import org.apache.commons.vfs.impl.FileContentInfoFilenameFactory;
import org.apache.commons.vfs.impl.FileTypeMap;
import org.apache.commons.vfs.impl.URLStreamHandlerProxy;
import org.apache.commons.vfs.impl.VirtualFileProvider;
import org.apache.commons.vfs.operations.FileOperationProvider;
import org.apache.commons.vfs.provider.AbstractFileName;
import org.apache.commons.vfs.provider.AbstractFileProvider;
import org.apache.commons.vfs.provider.DefaultURLStreamHandler;
import org.apache.commons.vfs.provider.FileProvider;
import org.apache.commons.vfs.provider.FileReplicator;
import org.apache.commons.vfs.provider.LocalFileProvider;
import org.apache.commons.vfs.provider.TemporaryFileStore;
import org.apache.commons.vfs.provider.UriParser;
import org.apache.commons.vfs.provider.VfsComponent;

public class DefaultFileSystemManager
implements FileSystemManager {
    private LocalFileProvider localFileProvider;
    private FileProvider defaultProvider;
    private FileReplicator fileReplicator;
    private final Map providers = new HashMap();
    private final ArrayList components = new ArrayList();
    private FileObject baseFile;
    private FilesCache filesCache;
    private CacheStrategy fileCacheStrategy;
    private Class fileObjectDecorator;
    private Constructor fileObjectDecoratorConst;
    private FileContentInfoFactory fileContentInfoFactory;
    private Log log = LogFactory.getLog(this.getClass());
    private final DefaultVfsComponentContext context = new DefaultVfsComponentContext(this);
    private TemporaryFileStore tempFileStore;
    private final FileTypeMap map = new FileTypeMap();
    private final VirtualFileProvider vfsProvider = new VirtualFileProvider();
    private boolean init;
    private final Map operationProviders = new HashMap();

    protected Log getLogger() {
        return this.log;
    }

    public void addProvider(String string, FileProvider fileProvider) throws FileSystemException {
        this.addProvider(new String[]{string}, fileProvider);
    }

    public void addProvider(String[] stringArray, FileProvider fileProvider) throws FileSystemException {
        String string;
        int n;
        for (n = 0; n < stringArray.length; ++n) {
            string = stringArray[n];
            if (!this.providers.containsKey(string)) continue;
            throw new FileSystemException("vfs.impl/multiple-providers-for-scheme.error", string);
        }
        this.setupComponent(fileProvider);
        for (n = 0; n < stringArray.length; ++n) {
            string = stringArray[n];
            this.providers.put(string, fileProvider);
        }
        if (fileProvider instanceof LocalFileProvider && this.localFileProvider == null) {
            this.localFileProvider = (LocalFileProvider)fileProvider;
        }
    }

    public boolean hasProvider(String string) {
        return this.providers.containsKey(string);
    }

    public void addExtensionMap(String string, String string2) {
        this.map.addExtension(string, string2);
    }

    public void addMimeTypeMap(String string, String string2) {
        this.map.addMimeType(string, string2);
    }

    public void setDefaultProvider(FileProvider fileProvider) throws FileSystemException {
        this.setupComponent(fileProvider);
        this.defaultProvider = fileProvider;
    }

    public FilesCache getFilesCache() {
        return this.filesCache;
    }

    public void setFilesCache(FilesCache filesCache) throws FileSystemException {
        if (this.init) {
            throw new FileSystemException("vfs.impl/already-inited.error");
        }
        this.filesCache = filesCache;
    }

    public void setCacheStrategy(CacheStrategy cacheStrategy) throws FileSystemException {
        if (this.init) {
            throw new FileSystemException("vfs.impl/already-inited.error");
        }
        this.fileCacheStrategy = cacheStrategy;
    }

    public CacheStrategy getCacheStrategy() {
        return this.fileCacheStrategy;
    }

    public Class getFileObjectDecorator() {
        return this.fileObjectDecorator;
    }

    public Constructor getFileObjectDecoratorConst() {
        return this.fileObjectDecoratorConst;
    }

    public void setFileObjectDecorator(Class clazz) throws FileSystemException {
        if (this.init) {
            throw new FileSystemException("vfs.impl/already-inited.error");
        }
        if (!DecoratedFileObject.class.isAssignableFrom(clazz)) {
            throw new FileSystemException("vfs.impl/invalid-decorator.error", clazz.getName());
        }
        try {
            this.fileObjectDecoratorConst = clazz.getConstructor(FileObject.class);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            throw new FileSystemException("vfs.impl/invalid-decorator.error", clazz.getName(), (Throwable)noSuchMethodException);
        }
        this.fileObjectDecorator = clazz;
    }

    public FileContentInfoFactory getFileContentInfoFactory() {
        return this.fileContentInfoFactory;
    }

    public void setFileContentInfoFactory(FileContentInfoFactory fileContentInfoFactory) throws FileSystemException {
        if (this.init) {
            throw new FileSystemException("vfs.impl/already-inited.error");
        }
        this.fileContentInfoFactory = fileContentInfoFactory;
    }

    public void setReplicator(FileReplicator fileReplicator) throws FileSystemException {
        this.setupComponent(fileReplicator);
        this.fileReplicator = fileReplicator;
    }

    public void setTemporaryFileStore(TemporaryFileStore temporaryFileStore) throws FileSystemException {
        this.setupComponent(temporaryFileStore);
        this.tempFileStore = temporaryFileStore;
    }

    public void setLogger(Log log) {
        this.log = log;
    }

    private void setupComponent(Object object) throws FileSystemException {
        if (!this.components.contains(object)) {
            if (object instanceof VfsComponent) {
                VfsComponent vfsComponent = (VfsComponent)object;
                vfsComponent.setLogger(this.getLogger());
                vfsComponent.setContext(this.context);
                vfsComponent.init();
            }
            this.components.add(object);
        }
    }

    private void closeComponent(Object object) {
        if (object != null && this.components.contains(object)) {
            if (object instanceof VfsComponent) {
                VfsComponent vfsComponent = (VfsComponent)object;
                vfsComponent.close();
            }
            this.components.remove(object);
        }
    }

    public FileReplicator getReplicator() throws FileSystemException {
        if (this.fileReplicator == null) {
            throw new FileSystemException("vfs.impl/no-replicator.error");
        }
        return this.fileReplicator;
    }

    public TemporaryFileStore getTemporaryFileStore() throws FileSystemException {
        if (this.tempFileStore == null) {
            throw new FileSystemException("vfs.impl/no-temp-file-store.error");
        }
        return this.tempFileStore;
    }

    public void init() throws FileSystemException {
        if (this.filesCache == null) {
            this.filesCache = new SoftRefFilesCache();
        }
        if (this.fileContentInfoFactory == null) {
            this.fileContentInfoFactory = new FileContentInfoFilenameFactory();
        }
        if (this.fileCacheStrategy == null) {
            this.fileCacheStrategy = CacheStrategy.ON_RESOLVE;
        }
        this.setupComponent(this.filesCache);
        this.setupComponent(this.vfsProvider);
        this.init = true;
    }

    public void close() {
        if (!this.init) {
            return;
        }
        for (Object v : this.providers.values()) {
            this.closeComponent(v);
        }
        this.closeComponent(this.defaultProvider);
        this.closeComponent(this.fileReplicator);
        this.closeComponent(this.tempFileStore);
        this.components.clear();
        this.providers.clear();
        this.filesCache.close();
        this.localFileProvider = null;
        this.defaultProvider = null;
        this.fileReplicator = null;
        this.tempFileStore = null;
        this.init = false;
    }

    public void freeUnusedResources() {
        if (!this.init) {
            return;
        }
        for (AbstractFileProvider abstractFileProvider : this.providers.values()) {
            abstractFileProvider.freeUnusedResources();
        }
    }

    public void setBaseFile(FileObject fileObject) throws FileSystemException {
        this.baseFile = fileObject;
    }

    public void setBaseFile(File file) throws FileSystemException {
        this.baseFile = this.getLocalFileProvider().findLocalFile(file);
    }

    public FileObject getBaseFile() throws FileSystemException {
        return this.baseFile;
    }

    public FileObject resolveFile(String string) throws FileSystemException {
        return this.resolveFile(this.getBaseFile(), string);
    }

    public FileObject resolveFile(String string, FileSystemOptions fileSystemOptions) throws FileSystemException {
        return this.resolveFile(this.getBaseFile(), string, fileSystemOptions);
    }

    public FileObject resolveFile(File file, String string) throws FileSystemException {
        FileObject fileObject = this.getLocalFileProvider().findLocalFile(file);
        return this.resolveFile(fileObject, string);
    }

    public FileObject resolveFile(FileObject fileObject, String string) throws FileSystemException {
        return this.resolveFile(fileObject, string, fileObject == null ? null : fileObject.getFileSystem().getFileSystemOptions());
    }

    public FileObject resolveFile(FileObject fileObject, String string, FileSystemOptions fileSystemOptions) throws FileSystemException {
        FileProvider fileProvider;
        FileObject fileObject2 = fileObject != null && VFS.isUriStyle() && fileObject.getName().getType() == FileType.FILE ? fileObject.getParent() : fileObject;
        UriParser.checkUriEncoding(string);
        if (string == null) {
            throw new IllegalArgumentException();
        }
        String string2 = UriParser.extractScheme(string);
        if (string2 != null && (fileProvider = (FileProvider)this.providers.get(string2)) != null) {
            return fileProvider.findFile(fileObject2, string, fileSystemOptions);
        }
        if (this.localFileProvider != null && this.localFileProvider.isAbsoluteLocalName(string)) {
            return this.localFileProvider.findLocalFile(string);
        }
        if (string2 != null) {
            if (this.defaultProvider == null) {
                throw new FileSystemException("vfs.impl/unknown-scheme.error", new Object[]{string2, string});
            }
            return this.defaultProvider.findFile(fileObject2, string, fileSystemOptions);
        }
        if (fileObject2 == null) {
            throw new FileSystemException("vfs.impl/find-rel-file.error", string);
        }
        return fileObject2.resolveFile(string);
    }

    public FileName resolveName(FileName fileName, String string) throws FileSystemException {
        return this.resolveName(fileName, string, NameScope.FILE_SYSTEM);
    }

    public FileName resolveName(FileName fileName, String string, NameScope nameScope) throws FileSystemException {
        String string2;
        FileName fileName2 = fileName != null && VFS.isUriStyle() && fileName.getType() == FileType.FILE ? fileName.getParent() : fileName;
        StringBuffer stringBuffer = new StringBuffer(string);
        UriParser.fixSeparators(stringBuffer);
        String string3 = UriParser.extractScheme(stringBuffer.toString());
        if (string.length() == 0 || string3 == null && stringBuffer.charAt(0) != '/') {
            if (!VFS.isUriStyle()) {
                stringBuffer.insert(0, '/');
            }
            stringBuffer.insert(0, fileName2.getPath());
        }
        FileType fileType = UriParser.normalisePath(stringBuffer);
        String string4 = stringBuffer.toString();
        if (!AbstractFileName.checkName(fileName2.getPath(), string4, nameScope)) {
            throw new FileSystemException("vfs.provider/invalid-descendent-name.error", string);
        }
        if (string3 != null) {
            string2 = string4;
        } else {
            string3 = fileName2.getScheme();
            string2 = fileName2.getRootURI() + string4;
        }
        FileProvider fileProvider = (FileProvider)this.providers.get(string3);
        if (fileProvider != null) {
            return fileProvider.parseUri(fileName2, string2);
        }
        if (string3 != null && this.defaultProvider != null) {
            return this.defaultProvider.parseUri(fileName2, string2);
        }
        return ((AbstractFileName)fileName2).createName(string4, fileType);
    }

    public FileName resolveURI(String string) throws FileSystemException {
        FileProvider fileProvider;
        UriParser.checkUriEncoding(string);
        if (string == null) {
            throw new IllegalArgumentException();
        }
        String string2 = UriParser.extractScheme(string);
        if (string2 != null && (fileProvider = (FileProvider)this.providers.get(string2)) != null) {
            return fileProvider.parseUri(null, string);
        }
        if (this.localFileProvider != null && this.localFileProvider.isAbsoluteLocalName(string)) {
            return this.localFileProvider.parseUri(null, string);
        }
        if (string2 != null) {
            if (this.defaultProvider == null) {
                throw new FileSystemException("vfs.impl/unknown-scheme.error", new Object[]{string2, string});
            }
            return this.defaultProvider.parseUri(null, string);
        }
        if (this.baseFile == null) {
            throw new FileSystemException("vfs.impl/find-rel-file.error", string);
        }
        return this.resolveName(this.baseFile.getName(), string, NameScope.FILE_SYSTEM);
    }

    public FileObject toFileObject(File file) throws FileSystemException {
        return this.getLocalFileProvider().findLocalFile(file);
    }

    public FileObject createFileSystem(String string, FileObject fileObject) throws FileSystemException {
        FileProvider fileProvider = (FileProvider)this.providers.get(string);
        if (fileProvider == null) {
            throw new FileSystemException("vfs.impl/unknown-provider.error", new Object[]{string, fileObject});
        }
        return fileProvider.createFileSystem(string, fileObject, fileObject.getFileSystem().getFileSystemOptions());
    }

    public FileObject createFileSystem(FileObject fileObject) throws FileSystemException {
        String string = this.map.getScheme(fileObject);
        if (string == null) {
            throw new FileSystemException("vfs.impl/no-provider-for-file.error", fileObject);
        }
        return this.createFileSystem(string, fileObject);
    }

    public boolean canCreateFileSystem(FileObject fileObject) throws FileSystemException {
        return this.map.getScheme(fileObject) != null;
    }

    public FileObject createVirtualFileSystem(FileObject fileObject) throws FileSystemException {
        return this.vfsProvider.createFileSystem(fileObject);
    }

    public FileObject createVirtualFileSystem(String string) throws FileSystemException {
        return this.vfsProvider.createFileSystem(string);
    }

    private LocalFileProvider getLocalFileProvider() throws FileSystemException {
        if (this.localFileProvider == null) {
            throw new FileSystemException("vfs.impl/no-local-file-provider.error");
        }
        return this.localFileProvider;
    }

    public URLStreamHandlerFactory getURLStreamHandlerFactory() {
        return new VfsStreamHandlerFactory();
    }

    public void closeFileSystem(FileSystem fileSystem) {
        this.getFilesCache().clear(fileSystem);
        this._closeFileSystem(fileSystem);
    }

    public void _closeFileSystem(FileSystem fileSystem) {
        FileProvider fileProvider = (FileProvider)this.providers.get(fileSystem.getRootName().getScheme());
        if (fileProvider != null) {
            ((AbstractFileProvider)fileProvider).closeFileSystem(fileSystem);
        }
    }

    public String[] getSchemes() {
        String[] stringArray = new String[this.providers.size()];
        this.providers.keySet().toArray(stringArray);
        return stringArray;
    }

    public Collection getProviderCapabilities(String string) throws FileSystemException {
        FileProvider fileProvider = (FileProvider)this.providers.get(string);
        if (fileProvider == null) {
            throw new FileSystemException("vfs.impl/unknown-scheme.error", new Object[]{string});
        }
        return fileProvider.getCapabilities();
    }

    public FileSystemConfigBuilder getFileSystemConfigBuilder(String string) throws FileSystemException {
        FileProvider fileProvider = (FileProvider)this.providers.get(string);
        if (fileProvider == null) {
            throw new FileSystemException("vfs.impl/unknown-scheme.error", new Object[]{string});
        }
        return fileProvider.getConfigBuilder();
    }

    public void addOperationProvider(String string, FileOperationProvider fileOperationProvider) throws FileSystemException {
        this.addOperationProvider(new String[]{string}, fileOperationProvider);
    }

    public void addOperationProvider(String[] stringArray, FileOperationProvider fileOperationProvider) throws FileSystemException {
        for (int i = 0; i < stringArray.length; ++i) {
            List<FileOperationProvider> list;
            String string = stringArray[i];
            if (!this.operationProviders.containsKey(string)) {
                list = new ArrayList();
                this.operationProviders.put(string, list);
            }
            if ((list = (List)this.operationProviders.get(string)).contains(fileOperationProvider)) {
                throw new FileSystemException("vfs.operation/operation-provider-already-added.error", string);
            }
            this.setupComponent(fileOperationProvider);
            list.add(fileOperationProvider);
        }
    }

    public FileOperationProvider[] getOperationProviders(String string) throws FileSystemException {
        List list = (List)this.operationProviders.get(string);
        if (list == null || list.size() == 0) {
            return null;
        }
        return list.toArray(new FileOperationProvider[0]);
    }

    final class VfsStreamHandlerFactory
    implements URLStreamHandlerFactory {
        VfsStreamHandlerFactory() {
        }

        public URLStreamHandler createURLStreamHandler(String string) {
            FileProvider fileProvider = (FileProvider)DefaultFileSystemManager.this.providers.get(string);
            if (fileProvider != null) {
                return new DefaultURLStreamHandler(DefaultFileSystemManager.this.context);
            }
            return new URLStreamHandlerProxy();
        }
    }
}

