/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.vfs;

import org.apache.commons.vfs.FileSystemOptions;

public abstract class FileSystemConfigBuilder {
    private static final String PREFIX = "vfs.";
    private static final String ROOTURI = "rootURI";
    private final String prefix;

    protected FileSystemConfigBuilder() {
        this.prefix = PREFIX;
    }

    protected FileSystemConfigBuilder(String string) {
        this.prefix = PREFIX + string;
    }

    public void setRootURI(FileSystemOptions fileSystemOptions, String string) {
        this.setParam(fileSystemOptions, ROOTURI, string);
    }

    public String getRootURI(FileSystemOptions fileSystemOptions) {
        return this.getString(fileSystemOptions, ROOTURI);
    }

    protected void setParam(FileSystemOptions fileSystemOptions, String string, Object object) {
        fileSystemOptions.setOption(this.getConfigClass(), string, object);
    }

    protected Object getParam(FileSystemOptions fileSystemOptions, String string) {
        if (fileSystemOptions == null) {
            return null;
        }
        return fileSystemOptions.getOption(this.getConfigClass(), string);
    }

    protected boolean hasParam(FileSystemOptions fileSystemOptions, String string) {
        return fileSystemOptions != null && fileSystemOptions.hasOption(this.getConfigClass(), string);
    }

    protected boolean hasObject(FileSystemOptions fileSystemOptions, String string) {
        return this.hasParam(fileSystemOptions, string) || System.getProperties().containsKey(PREFIX + string);
    }

    protected Boolean getBoolean(FileSystemOptions fileSystemOptions, String string) {
        return this.getBoolean(fileSystemOptions, string, null);
    }

    protected boolean getBoolean(FileSystemOptions fileSystemOptions, String string, boolean bl) {
        return this.getBoolean(fileSystemOptions, string, new Boolean(bl));
    }

    protected Boolean getBoolean(FileSystemOptions fileSystemOptions, String string, Boolean bl) {
        Boolean bl2 = (Boolean)this.getParam(fileSystemOptions, string);
        if (bl2 == null) {
            String string2 = System.getProperty(PREFIX + string);
            if (string2 == null) {
                return bl;
            }
            bl2 = Boolean.valueOf(string2);
        }
        return bl2;
    }

    protected Byte getByte(FileSystemOptions fileSystemOptions, String string) {
        return this.getByte(fileSystemOptions, string, null);
    }

    protected byte getByte(FileSystemOptions fileSystemOptions, String string, byte by) {
        return this.getByte(fileSystemOptions, string, new Byte(by));
    }

    protected Byte getByte(FileSystemOptions fileSystemOptions, String string, Byte by) {
        Byte by2 = (Byte)this.getParam(fileSystemOptions, string);
        if (by2 == null) {
            String string2 = System.getProperty(this.prefix + string);
            if (string2 == null) {
                return by;
            }
            by2 = Byte.valueOf(string2);
        }
        return by2;
    }

    protected Character getCharacter(FileSystemOptions fileSystemOptions, String string) {
        return this.getCharacter(fileSystemOptions, string, null);
    }

    protected char getCharacter(FileSystemOptions fileSystemOptions, String string, char c) {
        return this.getCharacter(fileSystemOptions, string, new Character(c)).charValue();
    }

    protected Character getCharacter(FileSystemOptions fileSystemOptions, String string, Character c) {
        Character c2 = (Character)this.getParam(fileSystemOptions, string);
        if (c2 == null) {
            String string2 = System.getProperty(this.prefix + string);
            if (string2 == null || string2.length() <= 0) {
                return c;
            }
            c2 = new Character(string2.charAt(0));
        }
        return c2;
    }

    protected Double getDouble(FileSystemOptions fileSystemOptions, String string) {
        return this.getDouble(fileSystemOptions, string, null);
    }

    protected double getDouble(FileSystemOptions fileSystemOptions, String string, double d) {
        return this.getDouble(fileSystemOptions, string, new Double(d));
    }

    protected Double getDouble(FileSystemOptions fileSystemOptions, String string, Double d) {
        Double d2 = (Double)this.getParam(fileSystemOptions, string);
        if (d2 == null) {
            String string2 = System.getProperty(this.prefix + string);
            if (string2 == null || string2.length() <= 0) {
                return d;
            }
            d2 = Double.valueOf(string2);
        }
        return d2;
    }

    protected Float getFloat(FileSystemOptions fileSystemOptions, String string) {
        return this.getFloat(fileSystemOptions, string, null);
    }

    protected float getFloat(FileSystemOptions fileSystemOptions, String string, float f) {
        return this.getFloat(fileSystemOptions, string, new Float(f)).floatValue();
    }

    protected Float getFloat(FileSystemOptions fileSystemOptions, String string, Float f) {
        Float f2 = (Float)this.getParam(fileSystemOptions, string);
        if (f2 == null) {
            String string2 = System.getProperty(this.prefix + string);
            if (string2 == null || string2.length() <= 0) {
                return f;
            }
            f2 = Float.valueOf(string2);
        }
        return f2;
    }

    protected Integer getInteger(FileSystemOptions fileSystemOptions, String string) {
        return this.getInteger(fileSystemOptions, string, null);
    }

    protected int getInteger(FileSystemOptions fileSystemOptions, String string, int n) {
        return this.getInteger(fileSystemOptions, string, new Integer(n));
    }

    protected Integer getInteger(FileSystemOptions fileSystemOptions, String string, Integer n) {
        Integer n2 = (Integer)this.getParam(fileSystemOptions, string);
        if (n2 == null) {
            String string2 = System.getProperty(this.prefix + string);
            if (string2 == null) {
                return n;
            }
            n2 = Integer.valueOf(string2);
        }
        return n2;
    }

    protected Long getLong(FileSystemOptions fileSystemOptions, String string) {
        return this.getLong(fileSystemOptions, string, null);
    }

    protected long getLong(FileSystemOptions fileSystemOptions, String string, long l) {
        return this.getLong(fileSystemOptions, string, new Long(l));
    }

    protected Long getLong(FileSystemOptions fileSystemOptions, String string, Long l) {
        Long l2 = (Long)this.getParam(fileSystemOptions, string);
        if (l2 == null) {
            String string2 = System.getProperty(this.prefix + string);
            if (string2 == null) {
                return l;
            }
            l2 = Long.valueOf(string2);
        }
        return l2;
    }

    protected Short getShort(FileSystemOptions fileSystemOptions, String string) {
        return this.getShort(fileSystemOptions, string, null);
    }

    protected short getShort(FileSystemOptions fileSystemOptions, String string, short s) {
        return this.getShort(fileSystemOptions, string, new Short(s));
    }

    protected Short getShort(FileSystemOptions fileSystemOptions, String string, Short s) {
        Short s2 = (Short)this.getParam(fileSystemOptions, string);
        if (s2 == null) {
            String string2 = System.getProperty(this.prefix + string);
            if (string2 == null) {
                return s;
            }
            s2 = Short.valueOf(string2);
        }
        return s2;
    }

    protected String getString(FileSystemOptions fileSystemOptions, String string) {
        return this.getString(fileSystemOptions, string, null);
    }

    protected String getString(FileSystemOptions fileSystemOptions, String string, String string2) {
        String string3 = (String)this.getParam(fileSystemOptions, string);
        if (string3 == null && (string3 = System.getProperty(this.prefix + string)) == null) {
            return string2;
        }
        return string3;
    }

    protected abstract Class getConfigClass();
}

