/*
 * Decompiled with CFR 0.152.
 */
package org.quartz.impl;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.quartz.SchedulerException;

class SchedulerDetailsSetter {
    private static final Log LOGGER = LogFactory.getLog(SchedulerDetailsSetter.class);

    private SchedulerDetailsSetter() {
    }

    static void setDetails(Object target, String schedulerName, String schedulerId) throws SchedulerException {
        SchedulerDetailsSetter.set(target, "setInstanceName", schedulerName);
        SchedulerDetailsSetter.set(target, "setInstanceId", schedulerId);
    }

    private static void set(Object target, String method, String value) throws SchedulerException {
        Method setter;
        try {
            setter = target.getClass().getMethod(method, String.class);
        }
        catch (SecurityException e) {
            LOGGER.error((Object)e);
            return;
        }
        catch (NoSuchMethodException e) {
            LOGGER.warn((Object)(target.getClass().getName() + " does not contain public method " + method + "(String)"));
            return;
        }
        if (Modifier.isAbstract(setter.getModifiers())) {
            LOGGER.warn((Object)(target.getClass().getName() + " does not implement " + method + "(String)"));
            return;
        }
        try {
            setter.invoke(target, value);
        }
        catch (InvocationTargetException ite) {
            throw new SchedulerException(ite.getTargetException());
        }
        catch (Exception e) {
            throw new SchedulerException(e);
        }
    }
}

