/*
 * Decompiled with CFR 0.152.
 */
package org.quartz;

import java.util.Date;
import java.util.List;
import org.quartz.Calendar;
import org.quartz.JobExecutionContext;
import org.quartz.JobExecutionException;
import org.quartz.SchedulerException;
import org.quartz.Trigger;
import org.quartz.TriggerUtils;

public class DateIntervalTrigger
extends Trigger {
    private static final long serialVersionUID = -2635982274232850343L;
    public static final int MISFIRE_INSTRUCTION_FIRE_ONCE_NOW = 1;
    public static final int MISFIRE_INSTRUCTION_DO_NOTHING = 2;
    private static final int YEAR_TO_GIVEUP_SCHEDULING_AT = 2299;
    private Date startTime = null;
    private Date endTime = null;
    private Date nextFireTime = null;
    private Date previousFireTime = null;
    private int repeatInterval = 0;
    private IntervalUnit repeatIntervalUnit = IntervalUnit.DAY;
    private int timesTriggered = 0;
    private boolean complete = false;

    public DateIntervalTrigger() {
    }

    public DateIntervalTrigger(String name, IntervalUnit intervalUnit, int repeatInterval) {
        this(name, null, intervalUnit, repeatInterval);
    }

    public DateIntervalTrigger(String name, String group, IntervalUnit intervalUnit, int repeatInterval) {
        this(name, group, new Date(), null, intervalUnit, repeatInterval);
    }

    public DateIntervalTrigger(String name, Date startTime, Date endTime, IntervalUnit intervalUnit, int repeatInterval) {
        this(name, null, startTime, endTime, intervalUnit, repeatInterval);
    }

    public DateIntervalTrigger(String name, String group, Date startTime, Date endTime, IntervalUnit intervalUnit, int repeatInterval) {
        super(name, group);
        this.setStartTime(startTime);
        this.setEndTime(endTime);
        this.setRepeatIntervalUnit(intervalUnit);
        this.setRepeatInterval(repeatInterval);
    }

    public DateIntervalTrigger(String name, String group, String jobName, String jobGroup, Date startTime, Date endTime, IntervalUnit intervalUnit, int repeatInterval) {
        super(name, group, jobName, jobGroup);
        this.setStartTime(startTime);
        this.setEndTime(endTime);
        this.setRepeatIntervalUnit(intervalUnit);
        this.setRepeatInterval(repeatInterval);
    }

    public Date getStartTime() {
        if (this.startTime == null) {
            this.startTime = new Date();
        }
        return this.startTime;
    }

    public void setStartTime(Date startTime) {
        if (startTime == null) {
            throw new IllegalArgumentException("Start time cannot be null");
        }
        Date eTime = this.getEndTime();
        if (eTime != null && startTime != null && eTime.before(startTime)) {
            throw new IllegalArgumentException("End time cannot be before start time");
        }
        this.startTime = startTime;
    }

    public Date getEndTime() {
        return this.endTime;
    }

    public void setEndTime(Date endTime) {
        Date sTime = this.getStartTime();
        if (sTime != null && endTime != null && sTime.after(endTime)) {
            throw new IllegalArgumentException("End time cannot be before start time");
        }
        this.endTime = endTime;
    }

    public IntervalUnit getRepeatIntervalUnit() {
        return this.repeatIntervalUnit;
    }

    public void setRepeatIntervalUnit(IntervalUnit intervalUnit) {
        this.repeatIntervalUnit = intervalUnit;
    }

    public int getRepeatInterval() {
        return this.repeatInterval;
    }

    public void setRepeatInterval(int repeatInterval) {
        if (repeatInterval < 0) {
            throw new IllegalArgumentException("Repeat interval must be >= 1");
        }
        this.repeatInterval = repeatInterval;
    }

    public int getTimesTriggered() {
        return this.timesTriggered;
    }

    public void setTimesTriggered(int timesTriggered) {
        this.timesTriggered = timesTriggered;
    }

    protected boolean validateMisfireInstruction(int misfireInstruction) {
        if (misfireInstruction < 0) {
            return false;
        }
        return misfireInstruction <= 2;
    }

    public void updateAfterMisfire(Calendar cal) {
        int instr = this.getMisfireInstruction();
        if (instr == 0) {
            instr = 1;
        }
        if (instr == 2) {
            Date newFireTime = this.getFireTimeAfter(new Date());
            while (newFireTime != null && cal != null && !cal.isTimeIncluded(newFireTime.getTime())) {
                newFireTime = this.getFireTimeAfter(newFireTime);
            }
            this.setNextFireTime(newFireTime);
        } else if (instr == 1) {
            // empty if block
        }
    }

    public void triggered(Calendar calendar) {
        ++this.timesTriggered;
        this.previousFireTime = this.nextFireTime;
        this.nextFireTime = this.getFireTimeAfter(this.nextFireTime);
        while (this.nextFireTime != null && calendar != null && !calendar.isTimeIncluded(this.nextFireTime.getTime())) {
            this.nextFireTime = this.getFireTimeAfter(this.nextFireTime);
            if (this.nextFireTime == null) break;
            java.util.Calendar c = java.util.Calendar.getInstance();
            c.setTime(this.nextFireTime);
            if (c.get(1) <= 2299) continue;
            this.nextFireTime = null;
        }
    }

    public void updateWithNewCalendar(Calendar calendar, long misfireThreshold) {
        this.nextFireTime = this.getFireTimeAfter(this.previousFireTime);
        if (this.nextFireTime == null || calendar == null) {
            return;
        }
        Date now = new Date();
        while (this.nextFireTime != null && !calendar.isTimeIncluded(this.nextFireTime.getTime())) {
            long diff;
            this.nextFireTime = this.getFireTimeAfter(this.nextFireTime);
            if (this.nextFireTime == null) break;
            java.util.Calendar c = java.util.Calendar.getInstance();
            c.setTime(this.nextFireTime);
            if (c.get(1) > 2299) {
                this.nextFireTime = null;
            }
            if (this.nextFireTime == null || !this.nextFireTime.before(now) || (diff = now.getTime() - this.nextFireTime.getTime()) < misfireThreshold) continue;
            this.nextFireTime = this.getFireTimeAfter(this.nextFireTime);
        }
    }

    public Date computeFirstFireTime(Calendar calendar) {
        this.nextFireTime = this.getStartTime();
        while (this.nextFireTime != null && calendar != null && !calendar.isTimeIncluded(this.nextFireTime.getTime())) {
            this.nextFireTime = this.getFireTimeAfter(this.nextFireTime);
            if (this.nextFireTime == null) break;
            java.util.Calendar c = java.util.Calendar.getInstance();
            c.setTime(this.nextFireTime);
            if (c.get(1) <= 2299) continue;
            return null;
        }
        return this.nextFireTime;
    }

    public int executionComplete(JobExecutionContext context, JobExecutionException result) {
        if (result != null && result.refireImmediately()) {
            return 1;
        }
        if (result != null && result.unscheduleFiringTrigger()) {
            return 2;
        }
        if (result != null && result.unscheduleAllTriggers()) {
            return 4;
        }
        if (!this.mayFireAgain()) {
            return 3;
        }
        return 0;
    }

    public Date getNextFireTime() {
        return this.nextFireTime;
    }

    public Date getPreviousFireTime() {
        return this.previousFireTime;
    }

    public void setNextFireTime(Date nextFireTime) {
        this.nextFireTime = nextFireTime;
    }

    public void setPreviousFireTime(Date previousFireTime) {
        this.previousFireTime = previousFireTime;
    }

    public Date getFireTimeAfter(Date afterTime) {
        long endMillis;
        if (this.complete) {
            return null;
        }
        afterTime = afterTime == null ? new Date(System.currentTimeMillis() + 1000L) : new Date(afterTime.getTime() + 1000L);
        long startMillis = this.getStartTime().getTime();
        long afterMillis = afterTime.getTime();
        long l = endMillis = this.getEndTime() == null ? Long.MAX_VALUE : this.getEndTime().getTime();
        if (endMillis <= afterMillis) {
            return null;
        }
        if (afterMillis < startMillis) {
            return new Date(startMillis);
        }
        long secondsAfterStart = (afterMillis - startMillis) / 1000L;
        Date time = null;
        long repeatLong = this.getRepeatInterval();
        java.util.Calendar sTime = java.util.Calendar.getInstance();
        sTime.setTime(this.getStartTime());
        sTime.setLenient(true);
        if (this.getRepeatIntervalUnit().equals((Object)IntervalUnit.SECOND)) {
            long jumpCount = secondsAfterStart / repeatLong;
            if (secondsAfterStart % repeatLong != 0L) {
                ++jumpCount;
            }
            sTime.add(13, this.getRepeatInterval() * (int)jumpCount);
            time = sTime.getTime();
        } else if (this.getRepeatIntervalUnit().equals((Object)IntervalUnit.MINUTE)) {
            long jumpCount = secondsAfterStart / (repeatLong * 60L);
            if (secondsAfterStart % (repeatLong * 60L) != 0L) {
                ++jumpCount;
            }
            sTime.add(12, this.getRepeatInterval() * (int)jumpCount);
            time = sTime.getTime();
        } else if (this.getRepeatIntervalUnit().equals((Object)IntervalUnit.HOUR)) {
            long jumpCount = secondsAfterStart / (repeatLong * 60L * 60L);
            if (secondsAfterStart % (repeatLong * 60L * 60L) != 0L) {
                ++jumpCount;
            }
            sTime.add(10, this.getRepeatInterval() * (int)jumpCount);
            time = sTime.getTime();
        } else if (this.getRepeatIntervalUnit().equals((Object)IntervalUnit.DAY)) {
            long jumpCount = secondsAfterStart / (repeatLong * 24L * 60L * 60L);
            if (secondsAfterStart % (repeatLong * 24L * 60L * 60L) != 0L) {
                ++jumpCount;
            }
            sTime.add(6, this.getRepeatInterval() * (int)jumpCount);
            time = sTime.getTime();
        } else if (this.getRepeatIntervalUnit().equals((Object)IntervalUnit.WEEK)) {
            long jumpCount = secondsAfterStart / (repeatLong * 7L * 24L * 60L * 60L);
            if (secondsAfterStart % (repeatLong * 7L * 24L * 60L * 60L) != 0L) {
                ++jumpCount;
            }
            sTime.add(6, this.getRepeatInterval() * (int)jumpCount * 7);
            time = sTime.getTime();
        } else if (this.getRepeatIntervalUnit().equals((Object)IntervalUnit.MONTH)) {
            while (sTime.getTime().before(afterTime) && sTime.get(1) < 2299) {
                sTime.setLenient(true);
                sTime.add(2, this.getRepeatInterval());
            }
            time = sTime.getTime();
        } else if (this.getRepeatIntervalUnit().equals((Object)IntervalUnit.YEAR)) {
            while (sTime.getTime().before(afterTime) && sTime.get(1) < 2299) {
                sTime.add(1, this.getRepeatInterval());
            }
            time = sTime.getTime();
        }
        if (endMillis <= time.getTime()) {
            return null;
        }
        return time;
    }

    public Date getFinalFireTime() {
        if (this.complete || this.getEndTime() == null) {
            return null;
        }
        Date beforeTime = new Date(this.getEndTime().getTime() - 1000L);
        long startMillis = this.getStartTime().getTime();
        long beforeMillis = beforeTime.getTime();
        if (beforeMillis < startMillis) {
            return new Date(startMillis);
        }
        long secondsAfterStart = (beforeMillis - startMillis) / 1000L;
        Date time = null;
        long repeatLong = this.getRepeatInterval();
        if (this.getRepeatIntervalUnit().equals((Object)IntervalUnit.SECOND)) {
            long jumpCount = secondsAfterStart / repeatLong;
            if (secondsAfterStart % repeatLong != 0L) {
                ++jumpCount;
            }
            time = new Date(startMillis + repeatLong * --jumpCount * 1000L);
        } else if (this.getRepeatIntervalUnit().equals((Object)IntervalUnit.MINUTE)) {
            long jumpCount = secondsAfterStart / (repeatLong * 60L);
            if (secondsAfterStart % (repeatLong * 60L) != 0L) {
                ++jumpCount;
            }
            time = new Date(startMillis + repeatLong * --jumpCount * 60L * 1000L);
        } else if (this.getRepeatIntervalUnit().equals((Object)IntervalUnit.HOUR)) {
            long jumpCount = secondsAfterStart / (repeatLong * 60L * 60L);
            if (secondsAfterStart % (repeatLong * 60L * 60L) != 0L) {
                ++jumpCount;
            }
            time = new Date(startMillis + repeatLong * --jumpCount * 60L * 60L * 1000L);
        } else if (this.getRepeatIntervalUnit().equals((Object)IntervalUnit.DAY)) {
            long jumpCount = secondsAfterStart / (repeatLong * 24L * 60L * 60L);
            if (secondsAfterStart % (repeatLong * 24L * 60L * 60L) != 0L) {
                ++jumpCount;
            }
            time = new Date(startMillis + repeatLong * --jumpCount * 24L * 60L * 60L * 1000L);
        } else if (this.getRepeatIntervalUnit().equals((Object)IntervalUnit.WEEK)) {
            long jumpCount = secondsAfterStart / (repeatLong * 7L * 24L * 60L * 60L);
            if (secondsAfterStart % (repeatLong * 7L * 24L * 60L * 60L) != 0L) {
                ++jumpCount;
            }
            time = new Date(startMillis + repeatLong * --jumpCount * 7L * 24L * 60L * 60L * 1000L);
        } else if (this.getRepeatIntervalUnit().equals((Object)IntervalUnit.MONTH)) {
            java.util.Calendar cal = java.util.Calendar.getInstance();
            cal.setTime(this.getStartTime());
            cal.setLenient(true);
            while (cal.getTime().before(beforeTime) && cal.get(1) < 2299) {
                cal.add(2, this.getRepeatInterval());
            }
            cal.add(2, -this.getRepeatInterval());
            time = cal.getTime();
        } else if (this.getRepeatIntervalUnit().equals((Object)IntervalUnit.YEAR)) {
            java.util.Calendar cal = java.util.Calendar.getInstance();
            cal.setTime(this.getStartTime());
            cal.setLenient(true);
            while (cal.getTime().before(beforeTime) && cal.get(1) < 2299) {
                cal.add(1, this.getRepeatInterval());
            }
            cal.add(1, -this.getRepeatInterval());
            time = cal.getTime();
        }
        if (time.getTime() < startMillis) {
            return this.startTime;
        }
        return time;
    }

    public boolean mayFireAgain() {
        return this.getNextFireTime() != null;
    }

    public void validate() throws SchedulerException {
        super.validate();
        if (this.repeatInterval < 1) {
            throw new SchedulerException("Repeat Interval cannot be zero.", 100);
        }
    }

    public static void main(String[] args) {
        DateIntervalTrigger dt = new DateIntervalTrigger("foo", IntervalUnit.YEAR, 5);
        dt.setStartTime(TriggerUtils.getEvenMinuteDate(new Date()));
        List times = TriggerUtils.computeFireTimes(dt, null, 25);
        for (int i = 0; i < times.size(); ++i) {
            System.err.println("firetime = " + times.get(i));
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum IntervalUnit {
        SECOND,
        MINUTE,
        HOUR,
        DAY,
        WEEK,
        MONTH,
        YEAR;

    }
}

