/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.platform.scheduler2.quartz;

import java.util.Date;
import org.quartz.impl.calendar.BaseCalendar;

public class QuartzSchedulerAvailability
extends BaseCalendar {
    private static final long serialVersionUID = 8419843512264409846L;
    Date startTime;
    Date endTime;

    public QuartzSchedulerAvailability(Date startTime, Date endTime) {
        this.startTime = startTime;
        this.endTime = endTime;
    }

    public long getNextIncludedTime(long arg0) {
        long nextIncludedDate = 0L;
        Date date = new Date(arg0);
        if (this.startTime != null && this.endTime != null) {
            if (!date.before(this.startTime) && date.before(this.endTime)) {
                nextIncludedDate = arg0 + 1L;
            } else if (date.before(this.startTime)) {
                nextIncludedDate = this.startTime.getTime();
            }
        } else if (this.startTime != null) {
            nextIncludedDate = date.before(this.startTime) ? this.startTime.getTime() : arg0 + 1L;
        } else if (this.endTime != null && date.before(this.endTime)) {
            nextIncludedDate = arg0 + 1L;
        }
        return nextIncludedDate;
    }

    public boolean isTimeIncluded(long arg0) {
        boolean isIncluded = false;
        Date date = new Date(arg0);
        if (this.startTime != null && this.endTime != null) {
            isIncluded = !date.before(this.startTime) && !date.after(this.endTime);
        } else if (this.startTime != null) {
            isIncluded = !date.before(this.startTime);
        } else if (this.endTime != null) {
            isIncluded = !date.after(this.endTime);
        }
        return isIncluded;
    }

    public Date getStartTime() {
        return this.startTime;
    }

    public Date getEndTime() {
        return this.endTime;
    }
}

