/*
 * Decompiled with CFR 0.152.
 */
package pt.webdetails.cdf.dd.reader.factory;

import org.pentaho.platform.engine.core.system.PentahoSessionHolder;
import org.pentaho.platform.engine.security.SecurityParameterProvider;
import pt.webdetails.cdf.dd.reader.factory.IResourceLoader;
import pt.webdetails.cdf.dd.util.Utils;
import pt.webdetails.cpf.repository.api.FileAccess;
import pt.webdetails.cpf.repository.api.IACAccess;
import pt.webdetails.cpf.repository.api.IRWAccess;
import pt.webdetails.cpf.repository.api.IReadAccess;

public class SystemResourceLoader
implements IResourceLoader {
    private IReadAccess reader;
    private IACAccess accessControl;
    private IRWAccess writer;

    public SystemResourceLoader() {
    }

    public SystemResourceLoader(String path) {
        this.reader = Utils.getAppropriateReadAccess((String)path);
        this.writer = Utils.getAppropriateWriteAccess((String)path);
        this.accessControl = new IACAccess(){

            public boolean hasAccess(String file, FileAccess access) {
                return SystemResourceLoader.this.isAdmin();
            }
        };
    }

    @Override
    public IReadAccess getReader() {
        return this.reader;
    }

    @Override
    public IACAccess getAccessControl() {
        return this.accessControl;
    }

    @Override
    public IRWAccess getWriter() {
        return this.writer;
    }

    protected boolean isAdmin() {
        SecurityParameterProvider securityParams = new SecurityParameterProvider(PentahoSessionHolder.getSession());
        return securityParams.getParameter("principalAdministrator").equals("true");
    }
}

