/*
 * Decompiled with CFR 0.152.
 */
package pt.webdetails.cdf.dd.reader.factory;

import org.apache.commons.lang.StringUtils;
import pt.webdetails.cdf.dd.CdeEngine;
import pt.webdetails.cdf.dd.ICdeEnvironment;
import pt.webdetails.cdf.dd.reader.factory.IResourceLoader;
import pt.webdetails.cdf.dd.reader.factory.SolutionResourceLoader;
import pt.webdetails.cdf.dd.reader.factory.SystemResourceLoader;
import pt.webdetails.cpf.repository.api.IContentAccessFactory;

public class ResourceLoaderFactory {
    public IResourceLoader getResourceLoader(String dashboardPath) {
        if (this.isSystem(dashboardPath)) {
            return this.getSystemResourceLoader(dashboardPath);
        }
        return this.getSolutionResourceLoader(dashboardPath);
    }

    protected boolean isSystem(String path) {
        if (path.isEmpty()) {
            return false;
        }
        ICdeEnvironment env = this.getCdeEnvironment();
        IContentAccessFactory factory = this.getContentAccessFactory(env);
        if ((path = StringUtils.strip((String)path.toLowerCase(), (String)"/")).startsWith(this.getSystemDir(env))) {
            return true;
        }
        if (path.startsWith(this.getPluginRepositoryDir(env))) {
            return false;
        }
        if (this.isSystemStaticResource(factory, path)) {
            return true;
        }
        if (this.isRepositoryStaticResource(factory, path)) {
            return false;
        }
        return false;
    }

    protected SystemResourceLoader getSystemResourceLoader(String path) {
        return new SystemResourceLoader(path);
    }

    protected SolutionResourceLoader getSolutionResourceLoader(String path) {
        return new SolutionResourceLoader(path);
    }

    protected ICdeEnvironment getCdeEnvironment() {
        return CdeEngine.getInstance().getEnvironment();
    }

    protected IContentAccessFactory getContentAccessFactory(ICdeEnvironment environment) {
        return environment.getContentAccessFactory();
    }

    protected String getSystemDir(ICdeEnvironment environment) {
        return environment.getSystemDir() + "/";
    }

    protected String getPluginRepositoryDir(ICdeEnvironment environment) {
        return environment.getPluginRepositoryDir() + "/";
    }

    protected boolean isSystemStaticResource(IContentAccessFactory factory, String path) {
        return factory.getPluginSystemReader(null).fileExists(path);
    }

    protected boolean isRepositoryStaticResource(IContentAccessFactory factory, String path) {
        return factory.getUserContentAccess(null).fileExists(path);
    }
}

