/*
 * Decompiled with CFR 0.152.
 */
package pt.webdetails.cdf.dd.datasources;

import net.sf.json.JSON;
import net.sf.json.JSONSerializer;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import pt.webdetails.cdf.dd.InterPluginBroker;
import pt.webdetails.cdf.dd.datasources.IDataSourceProvider;
import pt.webdetails.cdf.dd.datasources.InvalidDataSourceProviderException;

public class DataSourceProvider
implements IDataSourceProvider {
    public static final String DATA_SOURCE_DEFINITION_METHOD_NAME = "listDataAccessTypes";
    String pluginId;
    private static Log logger = LogFactory.getLog(DataSourceProvider.class);

    public DataSourceProvider(String pluginId) throws InvalidDataSourceProviderException {
        assert (pluginId != null);
        this.pluginId = pluginId;
    }

    public JSON getDataSourceDefinitions(boolean refresh) {
        try {
            String dsDefinitions = InterPluginBroker.getDataSourceDefinitions(this.pluginId, null, DATA_SOURCE_DEFINITION_METHOD_NAME, refresh);
            return JSONSerializer.toJSON((Object)dsDefinitions);
        }
        catch (Exception ex) {
            logger.error((Object)ex.getMessage(), (Throwable)ex);
            return null;
        }
    }

    public String getId() {
        return this.pluginId;
    }

    public String toString() {
        return String.format("DataSourceProvider [pluginId=%s]", this.pluginId);
    }
}

