/*
 * Decompiled with CFR 0.152.
 */
package pt.webdetails.cdf.dd.api;

import java.io.IOException;
import java.util.Map;
import java.util.UUID;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.pentaho.platform.api.engine.ILogger;
import org.pentaho.platform.api.engine.IParameterProvider;
import org.pentaho.platform.api.engine.IPentahoSession;
import org.pentaho.platform.engine.core.solution.SimpleParameterProvider;
import org.pentaho.platform.engine.core.system.PentahoSessionHolder;
import org.pentaho.platform.util.logging.SimpleLogger;
import pt.webdetails.cdf.dd.DashboardManager;
import pt.webdetails.cdf.dd.InterPluginBroker;
import pt.webdetails.cdf.dd.MetaModelManager;
import pt.webdetails.cdf.dd.editor.DashboardEditor;
import pt.webdetails.cdf.dd.localization.MessageBundlesHelper;
import pt.webdetails.cdf.dd.model.core.writer.ThingWriteException;
import pt.webdetails.cdf.dd.model.inst.writer.cdfrunjs.dashboard.CdfRunJsDashboardWriteOptions;
import pt.webdetails.cdf.dd.model.inst.writer.cdfrunjs.dashboard.CdfRunJsDashboardWriteResult;
import pt.webdetails.cdf.dd.structure.DashboardWcdfDescriptor;
import pt.webdetails.cdf.dd.util.CdeEnvironment;
import pt.webdetails.cdf.dd.util.Utils;
import pt.webdetails.cpf.Util;
import pt.webdetails.cpf.audit.CpfAuditHelper;
import pt.webdetails.cpf.repository.api.IReadAccess;

@Path(value="pentaho-cdf-dd/api/renderer")
public class RenderApi {
    private static final Log logger = LogFactory.getLog(RenderApi.class);

    @GET
    @Path(value="/getComponentDefinitions")
    @Produces(value={"text/javascript"})
    public String getComponentDefinitions(@Context HttpServletResponse response) throws IOException {
        return MetaModelManager.getInstance().getJsDefinition();
    }

    @GET
    @Path(value="/getContent")
    @Produces(value={"text/javascript"})
    public String getContent(@QueryParam(value="solution") @DefaultValue(value="") String solution, @QueryParam(value="path") @DefaultValue(value="") String path, @QueryParam(value="file") @DefaultValue(value="") String file, @QueryParam(value="inferScheme") @DefaultValue(value="false") boolean inferScheme, @QueryParam(value="root") @DefaultValue(value="") String root, @QueryParam(value="absolute") @DefaultValue(value="false") boolean absolute, @QueryParam(value="bypassCache") @DefaultValue(value="false") boolean bypassCache, @QueryParam(value="debug") @DefaultValue(value="false") boolean debug, @Context HttpServletRequest request, @Context HttpServletResponse response) throws IOException, ThingWriteException {
        String scheme = inferScheme ? "" : request.getScheme();
        String filePath = this.getWcdfRelativePath(solution, path, file);
        CdfRunJsDashboardWriteResult dashboardWrite = this.loadDashboard(filePath, scheme, root, absolute, bypassCache, debug, null);
        return dashboardWrite.getContent();
    }

    @GET
    @Path(value="/getHeaders")
    @Produces(value={"text/plain"})
    public String getHeaders(@QueryParam(value="solution") @DefaultValue(value="") String solution, @QueryParam(value="path") @DefaultValue(value="") String path, @QueryParam(value="file") @DefaultValue(value="") String file, @QueryParam(value="inferScheme") @DefaultValue(value="false") boolean inferScheme, @QueryParam(value="root") @DefaultValue(value="") String root, @QueryParam(value="absolute") @DefaultValue(value="true") boolean absolute, @QueryParam(value="bypassCache") @DefaultValue(value="false") boolean bypassCache, @QueryParam(value="debug") @DefaultValue(value="false") boolean debug, @Context HttpServletRequest request, @Context HttpServletResponse response) throws IOException, ThingWriteException {
        String scheme = inferScheme ? "" : request.getScheme();
        String filePath = this.getWcdfRelativePath(solution, path, file);
        CdfRunJsDashboardWriteResult dashboardWrite = this.loadDashboard(filePath, scheme, root, absolute, bypassCache, debug, null);
        return dashboardWrite.getHeader();
    }

    @GET
    @Path(value="/render")
    @Produces(value={"text/html"})
    public String render(@QueryParam(value="solution") @DefaultValue(value="") String solution, @QueryParam(value="path") @DefaultValue(value="") String path, @QueryParam(value="file") @DefaultValue(value="") String file, @QueryParam(value="inferScheme") @DefaultValue(value="false") boolean inferScheme, @QueryParam(value="root") @DefaultValue(value="") String root, @QueryParam(value="absolute") @DefaultValue(value="true") boolean absolute, @QueryParam(value="bypassCache") @DefaultValue(value="false") boolean bypassCache, @QueryParam(value="debug") @DefaultValue(value="false") boolean debug, @QueryParam(value="viewId") @DefaultValue(value="") String viewId, @QueryParam(value="style") @DefaultValue(value="") String style, @Context HttpServletRequest request) throws IOException {
        String scheme = inferScheme ? "" : request.getScheme();
        String filePath = this.getWcdfRelativePath(solution, path, file);
        IReadAccess readAccess = Utils.getSystemOrUserReadAccess((String)filePath);
        if (readAccess == null) {
            return "Access Denied or File Not Found.";
        }
        long start = System.currentTimeMillis();
        ILogger iLogger = this.getAuditLogger();
        IParameterProvider requestParams = this.getParameterProvider(request.getParameterMap());
        UUID uuid = CpfAuditHelper.startAudit((String)this.getPluginName(), (String)filePath, (String)this.getObjectName(), (IPentahoSession)this.getPentahoSession(), (ILogger)iLogger, (IParameterProvider)requestParams);
        try {
            logger.info((Object)"[Timing] CDE Starting Dashboard Rendering");
            CdfRunJsDashboardWriteResult dashboard = this.loadDashboard(filePath, scheme, root, absolute, bypassCache, debug, style);
            String result = dashboard.render(InterPluginBroker.getCdfContext(filePath, "", viewId));
            if (!StringUtils.isEmpty((String)result)) {
                String msgDir = FilenameUtils.getPath((String)FilenameUtils.separatorsToUnix((String)filePath));
                result = new MessageBundlesHelper(msgDir, null).replaceParameters(result, null);
            }
            logger.info((Object)("[Timing] CDE Finished Dashboard Rendering: " + Utils.ellapsedSeconds((long)start) + "s"));
            long end = System.currentTimeMillis();
            CpfAuditHelper.endAudit((String)this.getPluginName(), (String)filePath, (String)this.getObjectName(), (IPentahoSession)this.getPentahoSession(), (ILogger)iLogger, (long)start, (UUID)uuid, (long)end);
            return result;
        }
        catch (Exception ex) {
            String msg = "Could not load dashboard: " + ex.getMessage();
            logger.error((Object)msg, (Throwable)ex);
            long end = System.currentTimeMillis();
            CpfAuditHelper.endAudit((String)this.getPluginName(), (String)filePath, (String)this.getObjectName(), (IPentahoSession)this.getPentahoSession(), (ILogger)iLogger, (long)start, (UUID)uuid, (long)end);
            return msg;
        }
    }

    @GET
    @Path(value="/edit")
    @Produces(value={"text/html"})
    public String edit(@QueryParam(value="solution") @DefaultValue(value="") String solution, @QueryParam(value="path") @DefaultValue(value="") String path, @QueryParam(value="file") @DefaultValue(value="") String file, @QueryParam(value="debug") @DefaultValue(value="false") boolean debug, @QueryParam(value="isDefault") @DefaultValue(value="false") boolean isDefault, @Context HttpServletRequest request, @Context HttpServletResponse response) throws Exception {
        String wcdfPath = this.getWcdfRelativePath(solution, path, file);
        response.setContentType("text/html");
        if (Utils.getSystemOrUserReadAccess((String)wcdfPath) == null) {
            return "Access Denied to file " + wcdfPath;
        }
        return DashboardEditor.getEditor((String)wcdfPath, (boolean)debug, (String)request.getScheme(), (boolean)isDefault);
    }

    @GET
    @Path(value="/new")
    @Produces(value={"text/html"})
    public String newDashboard(@QueryParam(value="path") @DefaultValue(value="") String path, @QueryParam(value="debug") @DefaultValue(value="false") boolean debug, @QueryParam(value="isDefault") @DefaultValue(value="false") boolean isDefault, @Context HttpServletRequest request, @Context HttpServletResponse response) throws Exception {
        response.setContentType("text/html");
        return DashboardEditor.getEditor((String)path, (boolean)debug, (String)request.getScheme(), (boolean)isDefault);
    }

    @GET
    @Path(value="/listRenderers")
    @Produces(value={"application/json"})
    public String listRenderers() {
        return "{\"result\": [\"" + DashboardWcdfDescriptor.DashboardRendererType.BLUEPRINT.getType() + "\",\"" + DashboardWcdfDescriptor.DashboardRendererType.MOBILE.getType() + "\",\"" + DashboardWcdfDescriptor.DashboardRendererType.BOOTSTRAP.getType() + "\"]}";
    }

    @GET
    @Path(value="/refresh")
    public void refresh() throws Exception {
        DashboardManager.getInstance().refreshAll();
    }

    private CdfRunJsDashboardWriteResult loadDashboard(String filePath, String scheme, String root, boolean absolute, boolean bypassCache, boolean debug, String style) throws ThingWriteException {
        CdfRunJsDashboardWriteOptions options = new CdfRunJsDashboardWriteOptions(absolute, debug, root, scheme);
        return DashboardManager.getInstance().getDashboardCdfRunJs(filePath, options, bypassCache, style);
    }

    private String getWcdfRelativePath(String solution, String path, String file) {
        return Util.joinPath((String[])new String[]{solution, path, file});
    }

    private IPentahoSession getPentahoSession() {
        return PentahoSessionHolder.getSession();
    }

    private String getObjectName() {
        return RenderApi.class.getName();
    }

    private String getPluginName() {
        return CdeEnvironment.getPluginId();
    }

    private ILogger getAuditLogger() {
        return new SimpleLogger(RenderApi.class.getName());
    }

    private IParameterProvider getParameterProvider(Map<String, String> params) {
        return new SimpleParameterProvider(params);
    }

    private class MethodParams {
        public static final String SOLUTION = "solution";
        public static final String PATH = "path";
        public static final String FILE = "file";
        public static final String INFERSCHEME = "inferScheme";
        public static final String ABSOLUTE = "absolute";
        public static final String ROOT = "root";
        public static final String BYPASSCACHE = "bypassCache";
        public static final String DEBUG = "debug";
        public static final String VIEWID = "viewId";
        public static final String STYLE = "style";

        private MethodParams() {
        }
    }
}

