/*
 * Decompiled with CFR 0.152.
 */
package pt.webdetails.cdf.dd.api;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import javax.servlet.http.HttpServletResponse;
import javax.ws.rs.Consumes;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.FormParam;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import pt.webdetails.cdf.dd.reader.factory.IResourceLoader;
import pt.webdetails.cdf.dd.reader.factory.ResourceLoaderFactory;
import pt.webdetails.cdf.dd.util.CdeEnvironment;
import pt.webdetails.cdf.dd.util.JsonUtils;
import pt.webdetails.cpf.repository.api.FileAccess;
import pt.webdetails.cpf.repository.api.IACAccess;
import pt.webdetails.cpf.repository.api.IRWAccess;
import pt.webdetails.cpf.repository.api.IReadAccess;
import pt.webdetails.cpf.utils.CharsetHelper;

@Path(value="pentaho-cdf-dd/api/editor")
public class EditorApi {
    private static final int NO_CACHE_DURATION = 0;
    private static final Log logger = LogFactory.getLog(EditorApi.class);
    private static final String EXTERNAL_EDITOR_PAGE = "resources/ext-editor.html";
    private static final String COMPONENT_EDITOR_PAGE = "resources/cdf-dd-component-editor.html";

    @GET
    @Path(value="/file/get")
    @Produces(value={"text/plain"})
    @Consumes(value={"application/xml", "application/json"})
    public String getFile(@QueryParam(value="path") @DefaultValue(value="") String path, @Context HttpServletResponse response) throws IOException {
        IResourceLoader loader = this.getResourceLoader(path);
        IReadAccess reader = loader.getReader();
        if (reader.fileExists(path) && loader.getAccessControl().hasAccess(path, FileAccess.READ)) {
            response.setHeader("Cache-Control", "max-age=0");
            return IOUtils.toString((InputStream)reader.getFileInputStream(path));
        }
        String msg = "File: " + path + " does not exist, or you do not have permissions to access it";
        logger.error((Object)msg);
        return msg;
    }

    @POST
    @Path(value="/file/delete")
    @Produces(value={"text/javascript"})
    @Consumes(value={"application/xml", "application/json"})
    public void deleteFile(@FormParam(value="path") @DefaultValue(value="") String path, @Context HttpServletResponse response) throws IOException {
        IResourceLoader loader = this.getResourceLoader(path);
        IACAccess access = loader.getAccessControl();
        IRWAccess writer = loader.getWriter();
        if (access.hasAccess(path, FileAccess.DELETE) && writer.deleteFile(path)) {
            logger.debug((Object)("File: " + path + " removed"));
            JsonUtils.buildJsonResult((OutputStream)response.getOutputStream(), (Boolean)true, null);
        } else {
            logger.debug((Object)("File: " + path + "not removed"));
            JsonUtils.buildJsonResult((OutputStream)response.getOutputStream(), (Boolean)false, null);
        }
    }

    @POST
    @Path(value="/file/write")
    @Produces(value={"text/plain"})
    @Consumes(value={"application/xml", "application/json", "application/x-www-form-urlencoded"})
    public String writeFile(@FormParam(value="path") @DefaultValue(value="") String path, @FormParam(value="data") @DefaultValue(value="") String data, @Context HttpServletResponse response) throws IOException {
        String msg;
        IResourceLoader loader = this.getResourceLoader(path);
        IACAccess access = loader.getAccessControl();
        IRWAccess writer = loader.getWriter();
        if (access.hasAccess(path, FileAccess.WRITE)) {
            if (writer.saveFile(path, (InputStream)new ByteArrayInputStream(data.getBytes(CharsetHelper.getEncoding())))) {
                msg = "file '" + path + "' saved ok";
                logger.debug((Object)msg);
            } else {
                msg = "error saving file " + path;
                logger.error((Object)msg);
            }
        } else {
            msg = "no permissions to write file " + path;
            logger.error((Object)msg);
        }
        return msg;
    }

    @PUT
    @Path(value="/file/write")
    @Produces(value={"text/plain"})
    @Consumes(value={"application/xml", "application/json", "application/x-www-form-urlencoded"})
    public String createFile(@FormParam(value="path") @DefaultValue(value="") String path, @FormParam(value="data") @DefaultValue(value="") String data, @Context HttpServletResponse response) throws IOException {
        String msg;
        IResourceLoader loader = this.getResourceLoader(path);
        IACAccess access = loader.getAccessControl();
        IRWAccess writer = loader.getWriter();
        if (access.hasAccess(FilenameUtils.getFullPath((String)path), FileAccess.WRITE)) {
            if (writer.saveFile(path, (InputStream)new ByteArrayInputStream(data.getBytes(CharsetHelper.getEncoding())))) {
                msg = "file '" + path + "' saved ok";
                logger.debug((Object)msg);
            } else {
                msg = "error saving file " + path;
                logger.error((Object)msg);
            }
        } else {
            msg = "no permissions to write file " + path;
            logger.error((Object)msg);
        }
        return msg;
    }

    @GET
    @Path(value="/file/canEdit")
    @Produces(value={"text/plain"})
    @Consumes(value={"application/xml", "application/json"})
    public String canEdit(@QueryParam(value="path") @DefaultValue(value="") String path) {
        IResourceLoader loader = this.getResourceLoader(path);
        IACAccess contentAccess = loader.getAccessControl();
        return String.valueOf(contentAccess.hasAccess(path, FileAccess.WRITE));
    }

    @POST
    @Path(value="/createFolder")
    @Consumes(value={"application/xml", "application/json"})
    public String createFolder(@FormParam(value="path") @DefaultValue(value="") String path, @Context HttpServletResponse response) throws IOException {
        String msg;
        IResourceLoader loader = this.getResourceLoader(path);
        IReadAccess reader = loader.getReader();
        IRWAccess writer = loader.getWriter();
        IACAccess access = loader.getAccessControl();
        if (access.hasAccess(path, FileAccess.WRITE)) {
            if (reader.fileExists(path)) {
                msg = "already exists: " + path;
                logger.debug((Object)msg);
            } else if (writer.createFolder(path)) {
                msg = path + "created ok";
                logger.debug((Object)msg);
            } else {
                msg = "error creating folder " + path;
                logger.debug((Object)msg);
            }
        } else {
            msg = "no permissions to create folder " + path;
            logger.error((Object)msg);
        }
        return msg;
    }

    @GET
    @Path(value="/getExternalEditor")
    @Produces(value={"text/html"})
    @Consumes(value={"application/xml", "application/json"})
    public String externalEditor() throws IOException {
        IReadAccess access = CdeEnvironment.getPluginSystemReader();
        if (access.fileExists(EXTERNAL_EDITOR_PAGE)) {
            return IOUtils.toString((InputStream)access.getFileInputStream(EXTERNAL_EDITOR_PAGE));
        }
        String msg = "External editor not found: resources/ext-editor.html";
        logger.error((Object)msg);
        return msg;
    }

    @GET
    @Path(value="/getComponentEditor")
    @Produces(value={"text/html"})
    @Consumes(value={"application/xml", "application/json"})
    public String componentEditor() throws IOException {
        IReadAccess access = CdeEnvironment.getPluginSystemReader();
        if (access.fileExists(COMPONENT_EDITOR_PAGE)) {
            return IOUtils.toString((InputStream)access.getFileInputStream(COMPONENT_EDITOR_PAGE));
        }
        String msg = "no external editor found: resources/cdf-dd-component-editor.html";
        logger.error((Object)msg);
        return msg;
    }

    protected IResourceLoader getResourceLoader(String path) {
        return new ResourceLoaderFactory().getResourceLoader(path);
    }

    private class MethodParams {
        public static final String PATH = "path";
        public static final String DATA = "data";

        private MethodParams() {
        }
    }
}

