/*
 * Decompiled with CFR 0.152.
 */
package pt.webdetails.cdf.dd;

import java.io.InputStream;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.Node;
import org.dom4j.io.SAXReader;
import org.pentaho.platform.api.engine.IFileInfo;
import org.pentaho.platform.api.engine.ILogger;
import org.pentaho.platform.api.engine.ISolutionFile;
import org.pentaho.platform.api.engine.ISolutionFileMetaProvider;
import org.pentaho.platform.engine.core.solution.FileInfo;
import org.pentaho.platform.util.xml.dom4j.XmlDom4JHelper;

public class DashboardDesignerFileInfoGenerator
implements ISolutionFileMetaProvider {
    private ILogger logger;

    public IFileInfo getFileInfo(ISolutionFile solutionFile, InputStream in) {
        String solution = solutionFile.getSolution();
        String path = solutionFile.getFullPath();
        String fileName = solutionFile.getFileName();
        SAXReader reader = new SAXReader();
        try {
            Document doc = reader.read(in);
            return this.getFileInfo(solution, path, fileName, doc);
        }
        catch (DocumentException e) {
            if (this.logger != null) {
                this.logger.error("Error parsing document", (Throwable)e);
            }
            return null;
        }
    }

    public IFileInfo getFileInfo(String solution, String path, String filename, Document doc) {
        String result = "dashboard";
        doc.asXML();
        String author = XmlDom4JHelper.getNodeText((String)"/cdf/author", (Node)doc, (String)"");
        String description = XmlDom4JHelper.getNodeText((String)"/cdf/description", (Node)doc, (String)"");
        String icon = XmlDom4JHelper.getNodeText((String)"/cdf/icon", (Node)doc, (String)"");
        String title = XmlDom4JHelper.getNodeText((String)"/cdf/title", (Node)doc, (String)"");
        FileInfo info = new FileInfo();
        info.setAuthor(author);
        info.setDescription(description);
        info.setDisplayType(result);
        info.setIcon(icon);
        info.setTitle(title);
        return info;
    }

    public void setLogger(ILogger logger) {
        this.logger = logger;
    }
}

