/*
 * Decompiled with CFR 0.152.
 */
package ofc4j.model.elements;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import ofc4j.model.elements.Element;
import ofc4j.model.metadata.Alias;
import ofc4j.model.metadata.Converter;
import ofc4j.util.PieChartSliceConverter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PieChart
extends Element {
    @Alias(value="start-angle")
    private Integer startAngle;
    private Collection<String> colours;
    private Boolean animate;
    private Integer border;

    public PieChart() {
        super("pie");
    }

    public PieChart setAnimate(boolean animate) {
        this.animate = animate;
        return this;
    }

    public Boolean getAnimate() {
        return this.animate;
    }

    public Integer getStartAngle() {
        return this.startAngle;
    }

    public PieChart setStartAngle(Integer startAngle) {
        this.startAngle = startAngle;
        return this;
    }

    public Collection<String> getColours() {
        return this.colours;
    }

    public PieChart setColours(Collection<String> colours) {
        this.checkColours();
        this.colours = colours;
        return this;
    }

    public PieChart setColours(String ... colours) {
        this.checkColours();
        this.colours.clear();
        this.colours.addAll(Arrays.asList(colours));
        return this;
    }

    public PieChart setColours(List<String> colours) {
        this.checkColours();
        this.colours.clear();
        this.colours.addAll(colours);
        return this;
    }

    public Integer getBorder() {
        return this.border;
    }

    public PieChart setBorder(Integer border) {
        this.border = border;
        return this;
    }

    public PieChart addValues(Number ... values) {
        this.getValues().addAll(Arrays.asList(values));
        return this;
    }

    public PieChart addValues(List<Number> values) {
        this.getValues().addAll(values);
        return this;
    }

    public PieChart addSlice(Number value, String text) {
        return this.addSlices(new Slice(value, text));
    }

    public PieChart addSlices(Slice ... s) {
        this.getValues().addAll(Arrays.asList(s));
        return this;
    }

    public PieChart addSlices(List<Slice> values) {
        this.getValues().addAll(values);
        return this;
    }

    private synchronized void checkColours() {
        if (this.colours == null) {
            this.colours = new ArrayList<String>();
        }
    }

    @Converter(value=PieChartSliceConverter.class)
    public static class Slice {
        private final String text;
        private final Number value;
        private final String label;
        private String tip;
        private String onClick;

        public Slice(Number value, String text) {
            this.text = text;
            this.value = value;
            this.label = null;
        }

        public Slice(Number value, String text, String label) {
            this.text = text;
            this.value = value;
            this.label = label;
        }

        public Number getValue() {
            return this.value;
        }

        public String getText() {
            return this.text;
        }

        public String getLabel() {
            return this.label;
        }

        public String getTooltip() {
            return this.tip;
        }

        public void setTooltip(String tip) {
            this.tip = tip;
        }

        public String getOnClick() {
            return this.onClick;
        }

        public void setOnClick(String onClick) {
            this.onClick = onClick;
        }
    }
}

