/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.s3.vfs;

import org.apache.commons.vfs.FileName;
import org.apache.commons.vfs.FileSystemException;
import org.apache.commons.vfs.provider.FileNameParser;
import org.apache.commons.vfs.provider.URLFileName;
import org.apache.commons.vfs.provider.URLFileNameParser;
import org.apache.commons.vfs.provider.VfsComponentContext;
import org.pentaho.s3.vfs.S3FileName;

public class S3FileNameParser
extends URLFileNameParser {
    private static final S3FileNameParser INSTANCE = new S3FileNameParser();

    public S3FileNameParser() {
        super(843);
    }

    public static FileNameParser getInstance() {
        return INSTANCE;
    }

    public FileName parseUri(VfsComponentContext vfsComponentContext, FileName fileName, String s) throws FileSystemException {
        if (fileName == null) {
            s = this.encodeAccessKeys(s);
        }
        URLFileName name = (URLFileName)super.parseUri(vfsComponentContext, fileName, s);
        String user = name.getUserName();
        String password = name.getPassword();
        return new S3FileName(name.getScheme(), name.getHostName(), name.getPort(), this.getDefaultPort(), user, password, name.getPath(), name.getType(), name.getQueryString());
    }

    public String encodeAccessKeys(String url) {
        int hostNameIndex;
        int n = hostNameIndex = url.indexOf("@s3") == -1 ? url.indexOf("@S3") : url.indexOf("@s3");
        if (url.startsWith("s3://") && hostNameIndex != -1) {
            try {
                String auth = url.substring(5, hostNameIndex);
                String accessKey = auth.substring(0, auth.indexOf(":")).replaceAll("\\+", "%2B").replaceAll("/", "%2F");
                String secretKey = auth.substring(auth.indexOf(":") + 1).replaceAll("\\+", "%2B").replaceAll("/", "%2F");
                return "s3://" + accessKey + ":" + secretKey + url.substring(hostNameIndex);
            }
            catch (StringIndexOutOfBoundsException e) {
                return url;
            }
        }
        return url;
    }
}

