/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.platform.security.policy.rolebased.springsecurity;

import org.pentaho.platform.api.engine.IAuthorizationPolicy;
import org.springframework.security.Authentication;
import org.springframework.security.ConfigAttribute;
import org.springframework.security.ConfigAttributeDefinition;
import org.springframework.security.vote.AccessDecisionVoter;
import org.springframework.util.Assert;

public class AuthorizationPolicyVoter
implements AccessDecisionVoter {
    private String prefix;
    private IAuthorizationPolicy policy;

    public AuthorizationPolicyVoter(IAuthorizationPolicy policy, String prefix) {
        Assert.notNull((Object)policy);
        Assert.notNull((Object)prefix);
        this.policy = policy;
        this.prefix = prefix;
    }

    public boolean supports(ConfigAttribute attribute) {
        return attribute.getAttribute() != null && attribute.getAttribute().startsWith(this.prefix);
    }

    public boolean supports(Class clazz) {
        return true;
    }

    public int vote(Authentication authentication, Object object, ConfigAttributeDefinition config) {
        int result = 0;
        for (ConfigAttribute attribute : config.getConfigAttributes()) {
            if (!this.supports(attribute)) continue;
            String actionName = attribute.getAttribute().substring(this.prefix.length());
            if (this.policy.isAllowed(actionName)) {
                return 1;
            }
            return -1;
        }
        return result;
    }
}

