/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.platform.repository2.unified.webservices.jaxws;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import org.pentaho.platform.api.locale.IPentahoLocale;
import org.pentaho.platform.api.repository2.unified.IRepositoryFileData;
import org.pentaho.platform.api.repository2.unified.IUnifiedRepository;
import org.pentaho.platform.api.repository2.unified.RepositoryFile;
import org.pentaho.platform.api.repository2.unified.RepositoryFileAce;
import org.pentaho.platform.api.repository2.unified.RepositoryFileAcl;
import org.pentaho.platform.api.repository2.unified.RepositoryFilePermission;
import org.pentaho.platform.api.repository2.unified.RepositoryFileTree;
import org.pentaho.platform.api.repository2.unified.RepositoryRequest;
import org.pentaho.platform.api.repository2.unified.VersionSummary;
import org.pentaho.platform.api.repository2.unified.data.node.NodeRepositoryFileData;
import org.pentaho.platform.api.repository2.unified.data.simple.SimpleRepositoryFileData;
import org.pentaho.platform.repository2.locale.PentahoLocale;
import org.pentaho.platform.repository2.unified.webservices.NodeRepositoryFileDataAdapter;
import org.pentaho.platform.repository2.unified.webservices.NodeRepositoryFileDataDto;
import org.pentaho.platform.repository2.unified.webservices.RepositoryFileAclAceAdapter;
import org.pentaho.platform.repository2.unified.webservices.RepositoryFileAclAceDto;
import org.pentaho.platform.repository2.unified.webservices.RepositoryFileAclAdapter;
import org.pentaho.platform.repository2.unified.webservices.RepositoryFileAdapter;
import org.pentaho.platform.repository2.unified.webservices.RepositoryFileDto;
import org.pentaho.platform.repository2.unified.webservices.RepositoryFileTreeAdapter;
import org.pentaho.platform.repository2.unified.webservices.StringKeyStringValueDto;
import org.pentaho.platform.repository2.unified.webservices.VersionSummaryAdapter;
import org.pentaho.platform.repository2.unified.webservices.VersionSummaryDto;
import org.pentaho.platform.repository2.unified.webservices.jaxws.IUnifiedRepositoryJaxwsWebService;
import org.pentaho.platform.repository2.unified.webservices.jaxws.SimpleRepositoryFileDataDto;
import org.springframework.util.Assert;

public class UnifiedRepositoryToWebServiceAdapter
implements IUnifiedRepository {
    private volatile List<Character> cachedReservedChars;
    private IUnifiedRepositoryJaxwsWebService repoWebService;
    private RepositoryFileAdapter repositoryFileAdapter = new RepositoryFileAdapter();
    private RepositoryFileTreeAdapter repositoryFileTreeAdapter = new RepositoryFileTreeAdapter();
    private NodeRepositoryFileDataAdapter nodeRepositoryFileDataAdapter = new NodeRepositoryFileDataAdapter();
    private RepositoryFileAclAdapter repositoryFileAclAdapter = new RepositoryFileAclAdapter();
    private RepositoryFileAclAceAdapter repositoryFileAclAceAdapter = new RepositoryFileAclAceAdapter();
    private VersionSummaryAdapter versionSummaryAdapter = new VersionSummaryAdapter();

    public UnifiedRepositoryToWebServiceAdapter(IUnifiedRepositoryJaxwsWebService repoWebService) {
        this.repoWebService = repoWebService;
    }

    public RepositoryFile createFile(Serializable parentFolderId, RepositoryFile file, IRepositoryFileData data, String versionMessage) {
        if (data instanceof NodeRepositoryFileData) {
            return this.repositoryFileAdapter.unmarshal(this.repoWebService.createFile(parentFolderId != null ? parentFolderId.toString() : null, this.repositoryFileAdapter.marshal(file), this.nodeRepositoryFileDataAdapter.marshal((NodeRepositoryFileData)data), versionMessage));
        }
        if (data instanceof SimpleRepositoryFileData) {
            SimpleRepositoryFileData simpleData = (SimpleRepositoryFileData)data;
            return this.repositoryFileAdapter.unmarshal(this.repoWebService.createBinaryFile(parentFolderId != null ? parentFolderId.toString() : null, this.repositoryFileAdapter.marshal(file), SimpleRepositoryFileDataDto.convert(simpleData), versionMessage));
        }
        throw new IllegalArgumentException();
    }

    public RepositoryFile createFolder(Serializable parentFolderId, RepositoryFile file, String versionMessage) {
        return this.repositoryFileAdapter.unmarshal(this.repoWebService.createFolder(parentFolderId != null ? parentFolderId.toString() : null, this.repositoryFileAdapter.marshal(file), versionMessage));
    }

    public void deleteFile(Serializable fileId, boolean permanent, String versionMessage) {
        this.repoWebService.deleteFileWithPermanentFlag(fileId != null ? fileId.toString() : null, permanent, versionMessage);
    }

    public void deleteFile(Serializable fileId, String versionMessage) {
        this.repoWebService.deleteFile(fileId != null ? fileId.toString() : null, versionMessage);
    }

    public void deleteFileAtVersion(Serializable fileId, Serializable versionId) {
        this.repoWebService.deleteFileAtVersion(fileId != null ? fileId.toString() : null, versionId.toString() != null ? versionId.toString() : null);
    }

    public RepositoryFileAcl getAcl(Serializable fileId) {
        return this.repositoryFileAclAdapter.unmarshal(this.repoWebService.getAcl(fileId != null ? fileId.toString() : null));
    }

    public List<RepositoryFile> getChildren(RepositoryRequest repositoryRequest) {
        return this.unmarshalFiles(this.repoWebService.getChildrenFromRequest(repositoryRequest));
    }

    @Deprecated
    public List<RepositoryFile> getChildren(Serializable folderId) {
        return this.unmarshalFiles(this.repoWebService.getChildren(folderId.toString() != null ? folderId.toString() : null));
    }

    @Deprecated
    public List<RepositoryFile> getChildren(Serializable folderId, String filter) {
        return this.unmarshalFiles(this.repoWebService.getChildrenWithFilter(folderId.toString() != null ? folderId.toString() : null, filter));
    }

    private List<RepositoryFile> unmarshalFiles(List<RepositoryFileDto> dtos) {
        ArrayList<RepositoryFile> files = new ArrayList<RepositoryFile>();
        for (RepositoryFileDto dto : dtos) {
            files.add(this.repositoryFileAdapter.unmarshal(dto));
        }
        return files;
    }

    public List<RepositoryFile> getChildren(Serializable folderId, String filter, Boolean showHiddenFiles) {
        return this.unmarshalFiles(this.repoWebService.getChildrenWithFilterAndHidden(folderId.toString() != null ? folderId.toString() : null, filter, showHiddenFiles));
    }

    public <T extends IRepositoryFileData> T getDataForExecute(Serializable fileId, Class<T> dataClass) {
        throw new UnsupportedOperationException();
    }

    public <T extends IRepositoryFileData> List<T> getDataForExecuteInBatch(List<RepositoryFile> files, Class<T> dataClass) {
        throw new UnsupportedOperationException();
    }

    public <T extends IRepositoryFileData> T getDataAtVersionForExecute(Serializable fileId, Serializable versionId, Class<T> dataClass) {
        throw new UnsupportedOperationException();
    }

    public <T extends IRepositoryFileData> T getDataForRead(Serializable fileId, Class<T> dataClass) {
        if (dataClass.equals(NodeRepositoryFileData.class)) {
            return (T)this.nodeRepositoryFileDataAdapter.unmarshal(this.repoWebService.getDataAsNodeForRead(fileId != null ? fileId.toString() : null));
        }
        if (dataClass.equals(SimpleRepositoryFileData.class)) {
            SimpleRepositoryFileDataDto simpleJaxWsData = this.repoWebService.getDataAsBinaryForRead(fileId != null ? fileId.toString() : null);
            return (T)SimpleRepositoryFileDataDto.convert(simpleJaxWsData);
        }
        throw new IllegalArgumentException();
    }

    public <T extends IRepositoryFileData> List<T> getDataForReadInBatch(List<RepositoryFile> files, Class<T> dataClass) {
        ArrayList<Object> data;
        List<Object> nodeData;
        ArrayList<RepositoryFileDto> fileDtos = new ArrayList<RepositoryFileDto>(files.size());
        for (RepositoryFile file : files) {
            fileDtos.add(this.repositoryFileAdapter.marshal(file));
        }
        if (dataClass.equals(NodeRepositoryFileData.class)) {
            nodeData = this.repoWebService.getDataAsNodeForReadInBatch(fileDtos);
            data = new ArrayList<Object>(nodeData.size());
            for (NodeRepositoryFileDataDto nodeRepositoryFileDataDto : nodeData) {
                data.add(this.nodeRepositoryFileDataAdapter.unmarshal(nodeRepositoryFileDataDto));
            }
            return data;
        }
        if (dataClass.equals(SimpleRepositoryFileData.class)) {
            nodeData = this.repoWebService.getDataAsBinaryForReadInBatch(fileDtos);
            data = new ArrayList(nodeData.size());
            for (SimpleRepositoryFileDataDto simpleRepositoryFileDataDto : nodeData) {
                data.add(SimpleRepositoryFileDataDto.convert(simpleRepositoryFileDataDto));
            }
            return data;
        }
        throw new IllegalArgumentException();
    }

    public <T extends IRepositoryFileData> T getDataAtVersionForRead(Serializable fileId, Serializable versionId, Class<T> dataClass) {
        if (dataClass.equals(NodeRepositoryFileData.class)) {
            return (T)this.nodeRepositoryFileDataAdapter.unmarshal(this.repoWebService.getDataAsNodeForReadAtVersion(fileId != null ? fileId.toString() : null, versionId != null ? versionId.toString() : null));
        }
        if (dataClass.equals(SimpleRepositoryFileData.class)) {
            SimpleRepositoryFileDataDto simpleJaxWsData = this.repoWebService.getDataAsBinaryForReadAtVersion(fileId != null ? fileId.toString() : null, versionId != null ? versionId.toString() : null);
            return (T)SimpleRepositoryFileDataDto.convert(simpleJaxWsData);
        }
        throw new IllegalArgumentException();
    }

    public List<RepositoryFile> getDeletedFiles(String origParentFolderPath) {
        return this.unmarshalFiles(this.repoWebService.getDeletedFilesInFolder(origParentFolderPath));
    }

    public List<RepositoryFile> getDeletedFiles(String origParentFolderPath, String filter) {
        return this.unmarshalFiles(this.repoWebService.getDeletedFilesInFolderWithFilter(origParentFolderPath, filter));
    }

    public List<RepositoryFile> getDeletedFiles() {
        return this.unmarshalFiles(this.repoWebService.getDeletedFiles());
    }

    public List<RepositoryFileAce> getEffectiveAces(Serializable fileId) {
        return this.unmarshalAces(this.repoWebService.getEffectiveAces(fileId != null ? fileId.toString() : null));
    }

    private List<RepositoryFileAce> unmarshalAces(List<RepositoryFileAclAceDto> dtos) {
        ArrayList<RepositoryFileAce> aces = new ArrayList<RepositoryFileAce>();
        for (RepositoryFileAclAceDto dto : dtos) {
            aces.add(this.repositoryFileAclAceAdapter.unmarshal(dto));
        }
        return aces;
    }

    public List<RepositoryFileAce> getEffectiveAces(Serializable fileId, boolean forceEntriesInheriting) {
        return this.unmarshalAces(this.repoWebService.getEffectiveAcesWithForceFlag(fileId != null ? fileId.toString() : null, forceEntriesInheriting));
    }

    public RepositoryFile getFile(String path) {
        path = path.replaceAll(";", "/");
        return this.repositoryFileAdapter.unmarshal(this.repoWebService.getFile(path, false, null));
    }

    public RepositoryFile getFileAtVersion(Serializable fileId, Serializable versionId) {
        return this.repositoryFileAdapter.unmarshal(this.repoWebService.getFileAtVersion(fileId != null ? fileId.toString() : null, versionId != null ? versionId.toString() : null));
    }

    public RepositoryFile getFileById(Serializable fileId) {
        return this.repositoryFileAdapter.unmarshal(this.repoWebService.getFileById(fileId != null ? fileId.toString() : null, false, null));
    }

    public RepositoryFile getFile(String path, boolean loadLocaleMaps) {
        return this.repositoryFileAdapter.unmarshal(this.repoWebService.getFile(path, loadLocaleMaps, null));
    }

    public RepositoryFile getFileById(Serializable fileId, boolean loadLocaleMaps) {
        return this.repositoryFileAdapter.unmarshal(this.repoWebService.getFileById(fileId != null ? fileId.toString() : null, loadLocaleMaps, null));
    }

    public RepositoryFile getFile(String path, IPentahoLocale locale) {
        return this.repositoryFileAdapter.unmarshal(this.repoWebService.getFile(path, false, (PentahoLocale)locale));
    }

    public RepositoryFile getFileById(Serializable fileId, IPentahoLocale locale) {
        return this.repositoryFileAdapter.unmarshal(this.repoWebService.getFileById(fileId != null ? fileId.toString() : null, false, (PentahoLocale)locale));
    }

    public RepositoryFile getFile(String path, boolean loadLocaleMaps, IPentahoLocale locale) {
        return this.repositoryFileAdapter.unmarshal(this.repoWebService.getFile(path, loadLocaleMaps, (PentahoLocale)locale));
    }

    public RepositoryFile getFileById(Serializable fileId, boolean loadLocaleMaps, IPentahoLocale locale) {
        return this.repositoryFileAdapter.unmarshal(this.repoWebService.getFileById(fileId != null ? fileId.toString() : null, loadLocaleMaps, (PentahoLocale)locale));
    }

    public List<VersionSummary> getVersionSummaries(Serializable fileId) {
        return this.unmarshalVersionSummaries(this.repoWebService.getVersionSummaries(fileId != null ? fileId.toString() : null));
    }

    private List<VersionSummary> unmarshalVersionSummaries(List<VersionSummaryDto> dtos) {
        ArrayList<VersionSummary> versionSummaries = new ArrayList<VersionSummary>();
        for (VersionSummaryDto dto : dtos) {
            versionSummaries.add(this.versionSummaryAdapter.unmarshal(dto));
        }
        return versionSummaries;
    }

    public VersionSummary getVersionSummary(Serializable fileId, Serializable versionId) {
        return this.versionSummaryAdapter.unmarshal(this.repoWebService.getVersionSummary(fileId != null ? fileId.toString() : null, versionId != null ? versionId.toString() : null));
    }

    public List<VersionSummary> getVersionSummaryInBatch(List<RepositoryFile> files) {
        ArrayList<RepositoryFileDto> fileDtos = new ArrayList<RepositoryFileDto>(files.size());
        for (RepositoryFile file : files) {
            fileDtos.add(this.repositoryFileAdapter.marshal(file));
        }
        return this.unmarshalVersionSummaries(this.repoWebService.getVersionSummaryInBatch(fileDtos));
    }

    public boolean hasAccess(String path, EnumSet<RepositoryFilePermission> permissions) {
        return this.repoWebService.hasAccess(path, RepositoryFileAclAceAdapter.toIntPerms(permissions));
    }

    public void lockFile(Serializable fileId, String message) {
        this.repoWebService.lockFile(fileId != null ? fileId.toString() : null, message);
    }

    public void moveFile(Serializable fileId, String destAbsPath, String versionMessage) {
        this.repoWebService.moveFile(fileId != null ? fileId.toString() : null, destAbsPath, versionMessage);
    }

    public void copyFile(Serializable fileId, String destAbsPath, String versionMessage) {
        this.repoWebService.copyFile(fileId != null ? fileId.toString() : null, destAbsPath, versionMessage);
    }

    public void undeleteFile(Serializable fileId, String versionMessage) {
        this.repoWebService.undeleteFile(fileId != null ? fileId.toString() : null, versionMessage);
    }

    public void unlockFile(Serializable fileId) {
        this.repoWebService.unlockFile(fileId != null ? fileId.toString() : null);
    }

    public RepositoryFileAcl updateAcl(RepositoryFileAcl acl) {
        return this.repositoryFileAclAdapter.unmarshal(this.repoWebService.updateAcl(this.repositoryFileAclAdapter.marshal(acl)));
    }

    public RepositoryFile updateFile(RepositoryFile file, IRepositoryFileData data, String versionMessage) {
        if (data instanceof NodeRepositoryFileData) {
            return this.repositoryFileAdapter.unmarshal(this.repoWebService.updateFile(this.repositoryFileAdapter.marshal(file), this.nodeRepositoryFileDataAdapter.marshal((NodeRepositoryFileData)data), versionMessage));
        }
        if (data instanceof SimpleRepositoryFileData) {
            SimpleRepositoryFileData simpleData = (SimpleRepositoryFileData)data;
            return this.repositoryFileAdapter.unmarshal(this.repoWebService.updateBinaryFile(this.repositoryFileAdapter.marshal(file), SimpleRepositoryFileDataDto.convert(simpleData), versionMessage));
        }
        throw new IllegalArgumentException();
    }

    public void restoreFileAtVersion(Serializable fileId, Serializable versionId, String versionMessage) {
        this.repoWebService.restoreFileAtVersion(fileId.toString(), versionId.toString(), versionMessage);
    }

    public boolean canUnlockFile(Serializable fileId) {
        return this.repoWebService.canUnlockFile(fileId.toString());
    }

    public RepositoryFileTree getTree(RepositoryRequest repositoryRequest) {
        return this.repositoryFileTreeAdapter.unmarshal(this.repoWebService.getTreeFromRequest(repositoryRequest));
    }

    @Deprecated
    public RepositoryFileTree getTree(String path, int depth, String filter, boolean showHidden) {
        return this.repositoryFileTreeAdapter.unmarshal(this.repoWebService.getTree(path, depth, filter, showHidden));
    }

    public RepositoryFile createFile(Serializable parentFolderId, RepositoryFile file, IRepositoryFileData data, RepositoryFileAcl acl, String versionMessage) {
        if (data instanceof NodeRepositoryFileData) {
            return this.repositoryFileAdapter.unmarshal(this.repoWebService.createFileWithAcl(parentFolderId != null ? parentFolderId.toString() : null, this.repositoryFileAdapter.marshal(file), this.nodeRepositoryFileDataAdapter.marshal((NodeRepositoryFileData)data), this.repositoryFileAclAdapter.marshal(acl), versionMessage));
        }
        if (data instanceof SimpleRepositoryFileData) {
            SimpleRepositoryFileData simpleData = (SimpleRepositoryFileData)data;
            return this.repositoryFileAdapter.unmarshal(this.repoWebService.createBinaryFileWithAcl(parentFolderId != null ? parentFolderId.toString() : null, this.repositoryFileAdapter.marshal(file), SimpleRepositoryFileDataDto.convert(simpleData), this.repositoryFileAclAdapter.marshal(acl), versionMessage));
        }
        throw new IllegalArgumentException();
    }

    public RepositoryFile createFolder(Serializable parentFolderId, RepositoryFile file, RepositoryFileAcl acl, String versionMessage) {
        return this.repositoryFileAdapter.unmarshal(this.repoWebService.createFolderWithAcl(parentFolderId != null ? parentFolderId.toString() : null, this.repositoryFileAdapter.marshal(file), this.repositoryFileAclAdapter.marshal(acl), versionMessage));
    }

    public List<RepositoryFile> getReferrers(Serializable fileId) {
        ArrayList<RepositoryFile> fileList = new ArrayList<RepositoryFile>();
        for (RepositoryFileDto fileDto : this.repoWebService.getReferrers(fileId != null ? fileId.toString() : null)) {
            fileList.add(this.repositoryFileAdapter.unmarshal(fileDto));
        }
        return fileList;
    }

    public void setFileMetadata(Serializable fileId, Map<String, Serializable> metadataMap) {
        Assert.notNull((Object)fileId);
        Assert.notNull(metadataMap);
        ArrayList<StringKeyStringValueDto> fileMetadataMap = new ArrayList<StringKeyStringValueDto>(metadataMap.size());
        for (String key : metadataMap.keySet()) {
            fileMetadataMap.add(new StringKeyStringValueDto(key, metadataMap.get(key).toString()));
        }
        this.repoWebService.setFileMetadata(fileId.toString(), fileMetadataMap);
    }

    public Map<String, Serializable> getFileMetadata(Serializable fileId) {
        List<StringKeyStringValueDto> fileMetadata = this.repoWebService.getFileMetadata(fileId.toString());
        Assert.notNull(fileMetadata);
        HashMap<String, Serializable> repoFileMetadata = new HashMap<String, Serializable>(fileMetadata.size());
        for (StringKeyStringValueDto entry : fileMetadata) {
            repoFileMetadata.put(entry.getKey(), (Serializable)((Object)entry.getValue()));
        }
        return repoFileMetadata;
    }

    public List<Character> getReservedChars() {
        if (this.cachedReservedChars == null) {
            this.cachedReservedChars = Collections.unmodifiableList(this.repoWebService.getReservedChars());
        }
        return this.cachedReservedChars;
    }

    public List<Locale> getAvailableLocalesForFileById(Serializable fileId) {
        throw new UnsupportedOperationException();
    }

    public List<Locale> getAvailableLocalesForFileByPath(String relPath) {
        throw new UnsupportedOperationException();
    }

    public List<Locale> getAvailableLocalesForFile(RepositoryFile repositoryFile) {
        throw new UnsupportedOperationException();
    }

    public Properties getLocalePropertiesForFileById(Serializable fileId, String locale) {
        throw new UnsupportedOperationException();
    }

    public Properties getLocalePropertiesForFileByPath(String relPath, String locale) {
        throw new UnsupportedOperationException();
    }

    public Properties getLocalePropertiesForFile(RepositoryFile repositoryFile, String locale) {
        throw new UnsupportedOperationException();
    }

    public void setLocalePropertiesForFileById(Serializable fileId, String locale, Properties properties) {
        throw new UnsupportedOperationException();
    }

    public void setLocalePropertiesForFileByPath(String relPath, String locale, Properties properties) {
        throw new UnsupportedOperationException();
    }

    public void setLocalePropertiesForFile(RepositoryFile repositoryFile, String locale, Properties properties) {
        throw new UnsupportedOperationException();
    }

    public void deleteLocalePropertiesForFile(RepositoryFile repositoryFile, String locale) {
        throw new UnsupportedOperationException();
    }

    public RepositoryFile updateFolder(RepositoryFile folder, String versionMessage) {
        return this.repositoryFileAdapter.unmarshal(this.repoWebService.updateFolder(this.repositoryFileAdapter.marshal(folder), versionMessage));
    }
}

