/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.platform.repository2.unified.jcr.jackrabbit.security;

import java.security.Principal;
import java.security.acl.Group;
import java.util.HashSet;
import java.util.List;
import java.util.Properties;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.jcr.Session;
import org.apache.commons.collections.map.LRUMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.jackrabbit.api.security.principal.PrincipalIterator;
import org.apache.jackrabbit.core.security.AnonymousPrincipal;
import org.apache.jackrabbit.core.security.UserPrincipal;
import org.apache.jackrabbit.core.security.principal.AdminPrincipal;
import org.apache.jackrabbit.core.security.principal.EveryonePrincipal;
import org.apache.jackrabbit.core.security.principal.PrincipalIteratorAdapter;
import org.apache.jackrabbit.core.security.principal.PrincipalProvider;
import org.pentaho.platform.api.engine.IUserRoleListService;
import org.pentaho.platform.engine.core.system.PentahoSystem;
import org.pentaho.platform.repository2.unified.jcr.JcrAclMetadataStrategy;
import org.pentaho.platform.repository2.unified.jcr.JcrTenantUtils;
import org.pentaho.platform.repository2.unified.jcr.jackrabbit.security.SpringSecurityRolePrincipal;
import org.pentaho.platform.repository2.unified.jcr.jackrabbit.security.messages.Messages;
import org.springframework.security.Authentication;
import org.springframework.security.GrantedAuthority;
import org.springframework.security.GrantedAuthorityImpl;
import org.springframework.security.context.SecurityContextHolder;
import org.springframework.security.userdetails.User;
import org.springframework.security.userdetails.UserDetails;
import org.springframework.security.userdetails.UserDetailsService;
import org.springframework.security.userdetails.UsernameNotFoundException;
import org.springframework.util.Assert;

public class SpringSecurityPrincipalProvider
implements PrincipalProvider {
    private Log logger = LogFactory.getLog(SpringSecurityPrincipalProvider.class);
    private UserDetailsService userDetailsService;
    private IUserRoleListService userRoleListService;
    private String adminId;
    private AdminPrincipal adminPrincipal;
    private String anonymousId;
    private AnonymousPrincipal anonymousPrincipal = new AnonymousPrincipal();
    final boolean ACCOUNT_NON_EXPIRED = true;
    final boolean CREDS_NON_EXPIRED = true;
    final boolean ACCOUNT_NON_LOCKED = true;
    private final AtomicBoolean initialized = new AtomicBoolean(false);
    private final LRUMap userCache = new LRUMap(4096);
    private final LRUMap roleCache = new LRUMap(512);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void init(Properties options) {
        AtomicBoolean atomicBoolean = this.initialized;
        synchronized (atomicBoolean) {
            if (this.initialized.get()) {
                throw new IllegalStateException(Messages.getInstance().getString("SpringSecurityPrincipalProvider.ERROR_0001_ALREADY_INITIALIZED"));
            }
        }
        this.adminId = options.getProperty("adminId", "admin");
        this.adminPrincipal = new AdminPrincipal(this.adminId);
        if (this.logger.isTraceEnabled()) {
            this.logger.trace((Object)String.format("using adminId [%s]", this.adminId));
        }
        this.anonymousId = options.getProperty("anonymousId", "anonymous");
        if (this.logger.isTraceEnabled()) {
            this.logger.trace((Object)String.format("using anonymousId [%s]", this.anonymousId));
        }
        this.initialized.set(true);
    }

    public void close() {
        this.checkInitialized();
        this.clearCaches();
        this.initialized.set(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void clearCaches() {
        LRUMap lRUMap = this.userCache;
        synchronized (lRUMap) {
            this.userCache.clear();
        }
        lRUMap = this.roleCache;
        synchronized (lRUMap) {
            this.roleCache.clear();
        }
    }

    public synchronized boolean canReadPrincipal(Session session, Principal principalToRead) {
        this.checkInitialized();
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized Principal getPrincipal(String principalName) {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("principalName: [" + principalName + "]"));
        }
        this.checkInitialized();
        Assert.notNull((Object)principalName);
        if (JcrAclMetadataStrategy.AclMetadataPrincipal.isAclMetadataPrincipal(principalName)) {
            return new JcrAclMetadataStrategy.AclMetadataPrincipal(principalName);
        }
        if (this.adminId.equals(principalName)) {
            return this.adminPrincipal;
        }
        if (this.anonymousId.equals(principalName)) {
            return this.anonymousPrincipal;
        }
        if (EveryonePrincipal.getInstance().getName().equals(principalName)) {
            return EveryonePrincipal.getInstance();
        }
        if (JcrTenantUtils.isTenantedUser(principalName)) {
            UserDetails userDetails;
            Principal userFromUserCache;
            LRUMap lRUMap = this.userCache;
            synchronized (lRUMap) {
                userFromUserCache = (Principal)this.userCache.get((Object)JcrTenantUtils.getTenantedUser(principalName));
            }
            if (userFromUserCache != null) {
                if (this.logger.isTraceEnabled()) {
                    this.logger.trace((Object)("user " + principalName + " found in cache"));
                }
                return userFromUserCache;
            }
            if (this.logger.isTraceEnabled()) {
                this.logger.trace((Object)("user " + principalName + " not found in cache"));
            }
            if ((userDetails = this.internalGetUserDetails(principalName)) != null) {
                UserPrincipal user = new UserPrincipal(principalName);
                LRUMap lRUMap2 = this.userCache;
                synchronized (lRUMap2) {
                    this.userCache.put((Object)principalName, (Object)user);
                }
                return user;
            }
        } else if (JcrTenantUtils.isTenatedRole(principalName)) {
            Principal roleFromCache = (Principal)this.roleCache.get((Object)JcrTenantUtils.getTenantedRole(principalName));
            if (roleFromCache != null) {
                if (this.logger.isTraceEnabled()) {
                    this.logger.trace((Object)("role " + principalName + " found in cache"));
                }
                return roleFromCache;
            }
            if (this.logger.isTraceEnabled()) {
                this.logger.trace((Object)("role " + principalName + " not found in cache"));
            }
            SpringSecurityRolePrincipal roleToCache = this.createSpringSecurityRolePrincipal(principalName);
            this.roleCache.put((Object)principalName, (Object)roleToCache);
            if (this.logger.isTraceEnabled()) {
                this.logger.trace((Object)("assuming " + principalName + " is a role"));
            }
            return roleToCache;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PrincipalIterator getGroupMembership(Principal principal) {
        this.checkInitialized();
        Assert.notNull((Object)principal);
        HashSet<Object> groups = new HashSet<Object>();
        if (principal instanceof AnonymousPrincipal) {
            return PrincipalIteratorAdapter.EMPTY;
        }
        if (principal instanceof EveryonePrincipal) {
            return PrincipalIteratorAdapter.EMPTY;
        }
        if (!(principal instanceof Group || principal instanceof AdminPrincipal || principal instanceof JcrAclMetadataStrategy.AclMetadataPrincipal)) {
            UserDetails user = this.internalGetUserDetails(principal.getName());
            if (user == null) {
                return new PrincipalIteratorAdapter(groups);
            }
            for (GrantedAuthority role : user.getAuthorities()) {
                Principal fromCache;
                String roleAuthority = role.getAuthority();
                LRUMap lRUMap = this.roleCache;
                synchronized (lRUMap) {
                    fromCache = (Principal)this.roleCache.get((Object)roleAuthority);
                }
                if (fromCache != null) {
                    groups.add(fromCache);
                    continue;
                }
                groups.add(this.createSpringSecurityRolePrincipal(roleAuthority));
            }
        }
        groups.add(EveryonePrincipal.getInstance());
        if (this.logger.isTraceEnabled()) {
            this.logger.trace((Object)("group membership for principal=" + principal + " is " + groups));
        }
        return new PrincipalIteratorAdapter(groups);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected UserDetails internalGetUserDetails(String username) {
        Object ssPrincipal;
        if (username != null && username.equals("administrators")) {
            return null;
        }
        Authentication auth = SecurityContextHolder.getContext().getAuthentication();
        if (auth != null && (ssPrincipal = auth.getPrincipal()) instanceof UserDetails && username.equals(((UserDetails)ssPrincipal).getUsername())) {
            return (UserDetails)ssPrincipal;
        }
        UserDetails user = null;
        GrantedAuthority[] auths = null;
        GrantedAuthority[] authorities = null;
        User newUser = null;
        if (this.getUserDetailsService() != null) {
            block17: {
                try {
                    user = this.getUserDetailsService().loadUserByUsername(username);
                    if (auth == null || auth.getAuthorities() == null || auth.getAuthorities().length == 0) {
                        if (this.logger.isTraceEnabled()) {
                            this.logger.trace((Object)("Authentication object from SecurityContextHolder is null, so getting the roles for [ " + user.getUsername() + " ]  from IUserRoleListService "));
                        }
                        List roles = this.getUserRoleListService().getRolesForUser(JcrTenantUtils.getCurrentTenant(), username);
                        authorities = new GrantedAuthority[roles.size()];
                        for (int i = 0; i < roles.size(); ++i) {
                            authorities[i] = new GrantedAuthorityImpl((String)roles.get(i));
                        }
                    } else {
                        authorities = auth.getAuthorities();
                    }
                    auths = new GrantedAuthority[authorities.length];
                    for (int i = 0; i < authorities.length; ++i) {
                        String role = authorities[i].getAuthority();
                        String tenatedRoleString = JcrTenantUtils.getTenantedRole(role);
                        LRUMap lRUMap = this.roleCache;
                        synchronized (lRUMap) {
                            if (!this.roleCache.containsKey((Object)role)) {
                                SpringSecurityRolePrincipal ssRolePrincipal = new SpringSecurityRolePrincipal(tenatedRoleString);
                                this.roleCache.put((Object)role, (Object)ssRolePrincipal);
                            }
                        }
                        auths[i] = new GrantedAuthorityImpl(tenatedRoleString);
                    }
                    if (this.logger.isTraceEnabled()) {
                        this.logger.trace((Object)("found user in back-end " + user.getUsername()));
                    }
                }
                catch (UsernameNotFoundException e) {
                    if (!this.logger.isTraceEnabled()) break block17;
                    this.logger.trace((Object)("username " + username + " not in cache or back-end; returning null"));
                }
            }
            if (user != null) {
                if (auths == null || auths.length <= 0) {
                    this.logger.trace((Object)("Authorities are null, so creating an empty Auth array ==  " + user.getUsername()));
                    auths = new GrantedAuthority[]{};
                }
                String password = user.getPassword() != null ? user.getPassword() : "";
                newUser = new User(user.getUsername(), password, user.isEnabled(), true, true, true, auths);
            }
        }
        return newUser;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void checkInitialized() {
        AtomicBoolean atomicBoolean = this.initialized;
        synchronized (atomicBoolean) {
            if (!this.initialized.get()) {
                throw new IllegalStateException(Messages.getInstance().getString("SpringSecurityPrincipalProvider.ERROR_0003_NOT_INITIALIZED"));
            }
        }
    }

    public PrincipalIterator findPrincipals(String simpleFilter) {
        throw new UnsupportedOperationException();
    }

    public PrincipalIterator findPrincipals(String simpleFilter, int searchType) {
        throw new UnsupportedOperationException();
    }

    public PrincipalIterator getPrincipals(int searchType) {
        throw new UnsupportedOperationException();
    }

    protected UserDetailsService getUserDetailsService() {
        if (null != this.userDetailsService) {
            return this.userDetailsService;
        }
        if (PentahoSystem.getInitializedOK()) {
            this.userDetailsService = (UserDetailsService)PentahoSystem.get(UserDetailsService.class);
            return this.userDetailsService;
        }
        return null;
    }

    protected IUserRoleListService getUserRoleListService() {
        if (null != this.userRoleListService) {
            return this.userRoleListService;
        }
        if (PentahoSystem.getInitializedOK()) {
            this.userRoleListService = (IUserRoleListService)PentahoSystem.get(IUserRoleListService.class);
            return this.userRoleListService;
        }
        return null;
    }

    private SpringSecurityRolePrincipal createSpringSecurityRolePrincipal(String principal) {
        return new SpringSecurityRolePrincipal(JcrTenantUtils.getTenantedRole(principal));
    }
}

