/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.platform.repository2.unified.jcr.jackrabbit.security;

import java.security.Principal;
import java.security.acl.Group;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.jcr.Credentials;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.SimpleCredentials;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.login.LoginException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.jackrabbit.core.security.authentication.AbstractLoginModule;
import org.apache.jackrabbit.core.security.authentication.Authentication;
import org.pentaho.platform.engine.core.system.PentahoSystem;
import org.pentaho.platform.repository2.unified.jcr.jackrabbit.security.messages.Messages;
import org.springframework.security.AuthenticationException;
import org.springframework.security.AuthenticationManager;
import org.springframework.security.context.SecurityContextHolder;
import org.springframework.security.providers.UsernamePasswordAuthenticationToken;

public class SpringSecurityLoginModule
extends AbstractLoginModule {
    private static final Log logger = LogFactory.getLog(SpringSecurityLoginModule.class);
    private static final String KEY_PRE_AUTHENTICATION_TOKENS = "preAuthenticationTokens";
    private static final String PRE_AUTHENTICATION_TOKEN_SEPARATOR = ",";
    private AuthenticationManager authenticationManager;
    private static Set<String> preAuthenticationTokens = new HashSet<String>();
    protected static AuthenticationManager authManager = null;

    protected void doInit(CallbackHandler callbackHandler, Session session, Map options) throws LoginException {
        if (options.containsKey(KEY_PRE_AUTHENTICATION_TOKENS)) {
            String preAuthenticationTokensString = (String)options.get(KEY_PRE_AUTHENTICATION_TOKENS);
            String[] tokens = preAuthenticationTokensString.split(PRE_AUTHENTICATION_TOKEN_SEPARATOR);
            if (tokens.length == 0) {
                throw new LoginException(Messages.getInstance().getString("AbstractPentahoLoginModule.ERROR_0001_PRE_AUTH_TOKENS_MALFORMED", new Object[]{KEY_PRE_AUTHENTICATION_TOKENS}));
            }
            for (String token : tokens) {
                preAuthenticationTokens.add(token.trim());
            }
            logger.debug((Object)("preAuthenticationTokens=" + preAuthenticationTokens));
        }
        this.authenticationManager = this.getAuthenticationManager(callbackHandler, session, options);
    }

    protected AuthenticationManager getAuthenticationManager(CallbackHandler callbackHandler, Session session, Map options) {
        if (authManager == null && PentahoSystem.getInitializedOK()) {
            authManager = (AuthenticationManager)PentahoSystem.get(AuthenticationManager.class);
        }
        return authManager;
    }

    protected Authentication getAuthentication(Principal principal, Credentials credentials) throws RepositoryException {
        if (!(credentials instanceof SimpleCredentials)) {
            logger.debug((Object)"credentials not instance of SimpleCredentials; returning null");
            return null;
        }
        SimpleCredentials simpleCredentials = (SimpleCredentials)credentials;
        UsernamePasswordAuthenticationToken token = new UsernamePasswordAuthenticationToken((Object)simpleCredentials.getUserID(), (Object)String.valueOf(simpleCredentials.getPassword()));
        boolean authenticated = false;
        try {
            org.springframework.security.Authentication authentication = SecurityContextHolder.getContext().getAuthentication();
            if (authentication != null && authentication.getName().equals(simpleCredentials.getUserID())) {
                authenticated = true;
            } else {
                this.authenticationManager.authenticate((org.springframework.security.Authentication)token);
                authenticated = true;
            }
        }
        catch (AuthenticationException e) {
            logger.debug((Object)"authentication exception", (Throwable)e);
        }
        final boolean authenticateResult = authenticated;
        return new Authentication(){

            public boolean canHandle(Credentials credentials) {
                return true;
            }

            public boolean authenticate(Credentials credentials) throws RepositoryException {
                return authenticateResult;
            }
        };
    }

    protected Principal getPrincipal(Credentials credentials) {
        String userId = this.getUserID(credentials);
        Principal principal = this.principalProvider.getPrincipal(userId);
        if (principal == null || principal instanceof Group) {
            return null;
        }
        return principal;
    }

    protected boolean impersonate(Principal principal, Credentials credentials) throws RepositoryException, LoginException {
        throw new UnsupportedOperationException();
    }

    protected boolean isPreAuthenticated(Credentials creds) {
        if (super.isPreAuthenticated(creds)) {
            SimpleCredentials simpleCreds = (SimpleCredentials)creds;
            String preAuth = (String)simpleCreds.getAttribute(this.getPreAuthAttributeName());
            boolean preAuthenticated = preAuthenticationTokens.contains(preAuth);
            if (preAuthenticated) {
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)(simpleCreds.getUserID() + " is pre-authenticated"));
                }
            } else if (logger.isDebugEnabled()) {
                logger.debug((Object)"pre-authentication token rejected");
            }
            return preAuthenticated;
        }
        return false;
    }
}

