/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.platform.repository2.unified.jcr;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.regex.Pattern;
import javax.jcr.Item;
import javax.jcr.ItemNotFoundException;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.PathNotFoundException;
import javax.jcr.Property;
import javax.jcr.PropertyIterator;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.UnsupportedRepositoryOperationException;
import javax.jcr.lock.Lock;
import javax.jcr.version.Version;
import javax.jcr.version.VersionHistory;
import javax.jcr.version.VersionManager;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.mutable.MutableBoolean;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.jackrabbit.core.VersionManagerImpl;
import org.pentaho.platform.api.engine.IPentahoSession;
import org.pentaho.platform.api.locale.IPentahoLocale;
import org.pentaho.platform.api.repository2.unified.IRepositoryAccessVoterManager;
import org.pentaho.platform.api.repository2.unified.IRepositoryFileData;
import org.pentaho.platform.api.repository2.unified.RepositoryFile;
import org.pentaho.platform.api.repository2.unified.RepositoryFileAcl;
import org.pentaho.platform.api.repository2.unified.RepositoryFilePermission;
import org.pentaho.platform.api.repository2.unified.RepositoryFileSid;
import org.pentaho.platform.api.repository2.unified.RepositoryFileTree;
import org.pentaho.platform.api.repository2.unified.RepositoryRequest;
import org.pentaho.platform.api.repository2.unified.VersionSummary;
import org.pentaho.platform.engine.core.system.PentahoSessionHolder;
import org.pentaho.platform.engine.core.system.PentahoSystem;
import org.pentaho.platform.repository2.locale.PentahoLocale;
import org.pentaho.platform.repository2.messages.Messages;
import org.pentaho.platform.repository2.unified.exception.RepositoryFileDaoMalformedNameException;
import org.pentaho.platform.repository2.unified.jcr.ILockHelper;
import org.pentaho.platform.repository2.unified.jcr.IPathConversionHelper;
import org.pentaho.platform.repository2.unified.jcr.ITransformer;
import org.pentaho.platform.repository2.unified.jcr.JcrRepositoryFileAclUtils;
import org.pentaho.platform.repository2.unified.jcr.JcrStringHelper;
import org.pentaho.platform.repository2.unified.jcr.LocalePropertyResolver;
import org.pentaho.platform.repository2.unified.jcr.LocalizationUtil;
import org.pentaho.platform.repository2.unified.jcr.NodeHelper;
import org.pentaho.platform.repository2.unified.jcr.PentahoJcrConstants;
import org.pentaho.platform.repository2.unified.jcr.RepositoryFileProxyFactory;
import org.pentaho.platform.repository2.unified.jcr.sejcr.CredentialsStrategySessionFactory;
import org.pentaho.platform.util.messages.LocaleHelper;
import org.springframework.util.Assert;

public class JcrRepositoryFileUtils {
    private static final Log logger;
    private static List<Character> reservedChars;
    private static boolean versioningEnabled;
    private static boolean versionCommentsEnabled;
    private static RepositoryFileProxyFactory fileProxyFactory;

    private static Pattern makePattern(List<Character> list) {
        StringBuilder buf = new StringBuilder();
        buf.append(".*");
        buf.append("[");
        for (Character ch : list) {
            buf.append("\\");
            buf.append(ch);
        }
        buf.append("]");
        buf.append("+");
        buf.append(".*");
        return Pattern.compile(buf.toString());
    }

    public static RepositoryFile getFileById(Session session, PentahoJcrConstants pentahoJcrConstants, IPathConversionHelper pathConversionHelper, ILockHelper lockHelper, Serializable fileId) throws RepositoryException {
        Node fileNode = session.getNodeByIdentifier(fileId.toString());
        Assert.notNull((Object)fileNode);
        return JcrRepositoryFileUtils.nodeToFile(session, pentahoJcrConstants, pathConversionHelper, lockHelper, fileNode);
    }

    public static RepositoryFile nodeToFile(Session session, PentahoJcrConstants pentahoJcrConstants, IPathConversionHelper pathConversionHelper, ILockHelper lockHelper, Node node) throws RepositoryException {
        return JcrRepositoryFileUtils.nodeToFile(session, pentahoJcrConstants, pathConversionHelper, lockHelper, node, false, null);
    }

    private static RepositoryFile getRootFolder(Session session) throws RepositoryException {
        Node node = session.getRootNode();
        RepositoryFile file = new RepositoryFile.Builder((Serializable)((Object)node.getIdentifier()), "").folder(true).versioned(false).path(JcrStringHelper.pathDecode(node.getPath())).build();
        return file;
    }

    public static RepositoryFile nodeToFileOld(Session session, PentahoJcrConstants pentahoJcrConstants, IPathConversionHelper pathConversionHelper, ILockHelper lockHelper, Node node, boolean loadMaps, IPentahoLocale pentahoLocale) throws RepositoryException {
        Calendar tmpCal;
        Calendar tmpCal2;
        if (session.getRootNode().isSame((Item)node)) {
            return JcrRepositoryFileUtils.getRootFolder(session);
        }
        Serializable id = null;
        String name = null;
        String path = null;
        long fileSize = 0L;
        Date created = null;
        String creatorId = null;
        Boolean hidden = false;
        Date lastModified = null;
        boolean folder = false;
        boolean versioned = false;
        String versionId = null;
        boolean locked = false;
        String lockOwner = null;
        Date lockDate = null;
        String lockMessage = null;
        String title = null;
        String description = null;
        Map<String, Properties> localePropertiesMap = null;
        id = JcrRepositoryFileUtils.getNodeId(session, pentahoJcrConstants, node);
        if (logger.isDebugEnabled()) {
            logger.debug((Object)String.format("reading file with id '%s' and path '%s'", id, node.getPath()));
        }
        String string = name = "/".equals(path = pathConversionHelper.absToRel(JcrRepositoryFileUtils.getAbsolutePath(session, pentahoJcrConstants, node))) ? "" : JcrRepositoryFileUtils.getNodeName(session, pentahoJcrConstants, node);
        if (JcrRepositoryFileUtils.isPentahoFolder(pentahoJcrConstants, node)) {
            folder = true;
        }
        if (node.hasProperty(pentahoJcrConstants.getJCR_CREATED()) && (tmpCal2 = node.getProperty(pentahoJcrConstants.getJCR_CREATED()).getDate()) != null) {
            created = tmpCal2.getTime();
        }
        Map<String, Serializable> metadata = JcrRepositoryFileUtils.getFileMetadata(session, id);
        creatorId = (String)((Object)metadata.get(PentahoJcrConstants.PHO_CONTENTCREATOR));
        if (node.hasProperty(pentahoJcrConstants.getPHO_HIDDEN())) {
            hidden = node.getProperty(pentahoJcrConstants.getPHO_HIDDEN()).getBoolean();
        }
        if (node.hasProperty(pentahoJcrConstants.getPHO_FILESIZE())) {
            fileSize = node.getProperty(pentahoJcrConstants.getPHO_FILESIZE()).getLong();
        }
        if (JcrRepositoryFileUtils.isPentahoFile(pentahoJcrConstants, node) && !node.isNodeType(pentahoJcrConstants.getNT_FROZENNODE()) && (tmpCal = node.getProperty(pentahoJcrConstants.getPHO_LASTMODIFIED()).getDate()) != null) {
            lastModified = tmpCal.getTime();
        }
        if (pentahoLocale == null) {
            Locale currentLocale = LocaleHelper.getLocale();
            pentahoLocale = currentLocale != null ? new PentahoLocale(currentLocale) : new PentahoLocale();
        }
        if (JcrRepositoryFileUtils.isPentahoHierarchyNode(session, pentahoJcrConstants, node)) {
            if (node.hasNode(pentahoJcrConstants.getPHO_LOCALES())) {
                localePropertiesMap = JcrRepositoryFileUtils.getLocalePropertiesMap(session, pentahoJcrConstants, node.getNode(pentahoJcrConstants.getPHO_LOCALES()));
                LocalePropertyResolver lpr = new LocalePropertyResolver(name);
                LocalizationUtil localizationUtil = new LocalizationUtil(localePropertiesMap, pentahoLocale.getLocale());
                title = localizationUtil.resolveLocalizedString(lpr.resolveDefaultTitleKey(), null);
                if (StringUtils.isBlank((String)title) && StringUtils.isBlank((String)(title = localizationUtil.resolveLocalizedString(lpr.resolveTitleKey(), null)))) {
                    title = localizationUtil.resolveLocalizedString(lpr.resolveNameKey(), title);
                }
                if (StringUtils.isBlank((String)(description = localizationUtil.resolveLocalizedString(lpr.resolveDefaultDescriptionKey(), null)))) {
                    description = localizationUtil.resolveLocalizedString(lpr.resolveDescriptionKey(), description);
                }
            }
            if (title == null && node.hasNode(pentahoJcrConstants.getPHO_TITLE())) {
                title = JcrRepositoryFileUtils.getLocalizedString(session, pentahoJcrConstants, node.getNode(pentahoJcrConstants.getPHO_TITLE()), pentahoLocale);
            }
            if (description == null && node.hasNode(pentahoJcrConstants.getPHO_DESCRIPTION())) {
                description = JcrRepositoryFileUtils.getLocalizedString(session, pentahoJcrConstants, node.getNode(pentahoJcrConstants.getPHO_DESCRIPTION()), pentahoLocale);
            }
        }
        if (!loadMaps) {
            localePropertiesMap = null;
        }
        if (versioned = JcrRepositoryFileUtils.isVersioned(session, pentahoJcrConstants, node)) {
            versionId = JcrRepositoryFileUtils.getVersionId(session, pentahoJcrConstants, node);
        }
        if (locked = JcrRepositoryFileUtils.isLocked(pentahoJcrConstants, node)) {
            Lock lock = session.getWorkspace().getLockManager().getLock(node.getPath());
            lockOwner = lockHelper.getLockOwner(session, pentahoJcrConstants, lock);
            lockDate = lockHelper.getLockDate(session, pentahoJcrConstants, lock);
            lockMessage = lockHelper.getLockMessage(session, pentahoJcrConstants, lock);
        }
        RepositoryFile file = new RepositoryFile.Builder(id, name).createdDate(created).creatorId(creatorId).lastModificationDate(lastModified).folder(folder).versioned(versioned).path(path).versionId((Serializable)((Object)versionId)).fileSize(fileSize).locked(locked).lockDate(lockDate).hidden(hidden.booleanValue()).lockMessage(lockMessage).lockOwner(lockOwner).title(title).description(description).locale(pentahoLocale.toString()).localePropertiesMap(localePropertiesMap).build();
        return file;
    }

    public static RepositoryFile nodeToFile(Session session, PentahoJcrConstants pentahoJcrConstants, IPathConversionHelper pathConversionHelper, ILockHelper lockHelper, Node node, boolean loadMaps, IPentahoLocale pentahoLocale) throws RepositoryException {
        if (session.getRootNode().isSame((Item)node)) {
            return JcrRepositoryFileUtils.getRootFolder(session);
        }
        if (pentahoLocale == null) {
            Locale currentLocale = LocaleHelper.getLocale();
            pentahoLocale = currentLocale != null ? new PentahoLocale(currentLocale) : new PentahoLocale();
        }
        return JcrRepositoryFileUtils.getRepositoryFileProxyFactory().getProxy(node, pentahoLocale);
    }

    private static RepositoryFileProxyFactory getRepositoryFileProxyFactory() {
        if (fileProxyFactory == null) {
            fileProxyFactory = (RepositoryFileProxyFactory)PentahoSystem.get(RepositoryFileProxyFactory.class);
        }
        return fileProxyFactory;
    }

    public static String getLocalizedString(Session session, PentahoJcrConstants pentahoJcrConstants, Node localizedStringNode, IPentahoLocale pentahoLocale) throws RepositoryException {
        boolean isLocaleNull;
        Assert.isTrue((boolean)JcrRepositoryFileUtils.isLocalizedString(session, pentahoJcrConstants, localizedStringNode));
        boolean bl = isLocaleNull = pentahoLocale == null;
        if (pentahoLocale == null) {
            pentahoLocale = new PentahoLocale();
        }
        Locale locale = pentahoLocale.getLocale();
        String UNDERSCORE = "_";
        String COLON = ":";
        boolean hasLanguage = org.springframework.util.StringUtils.hasText((String)locale.getLanguage());
        boolean hasCountry = org.springframework.util.StringUtils.hasText((String)locale.getCountry());
        boolean hasVariant = org.springframework.util.StringUtils.hasText((String)locale.getVariant());
        ArrayList<String> candidatePropertyNames = new ArrayList<String>(3);
        if (hasVariant) {
            candidatePropertyNames.add(locale.getLanguage() + "_" + locale.getCountry() + "_" + locale.getVariant());
        }
        if (hasCountry) {
            candidatePropertyNames.add(locale.getLanguage() + "_" + locale.getCountry());
        }
        if (hasLanguage) {
            candidatePropertyNames.add(locale.getLanguage());
        }
        for (String propertyName : candidatePropertyNames) {
            if (!localizedStringNode.hasProperty(propertyName)) continue;
            return localizedStringNode.getProperty(propertyName).getString();
        }
        String prefix = session.getNamespacePrefix("http://www.pentaho.org/jcr/2.0");
        Assert.hasText((String)prefix);
        String propertyStr = isLocaleNull ? pentahoJcrConstants.getPHO_ROOTLOCALE() : prefix + ":" + locale.getLanguage();
        return localizedStringNode.getProperty(propertyStr).getString();
    }

    public static Map<String, Properties> getLocalePropertiesMap(Session session, PentahoJcrConstants pentahoJcrConstants, Node localesNode) throws RepositoryException {
        String prefix = session.getNamespacePrefix("http://www.pentaho.org/jcr/2.0");
        Assert.hasText((String)prefix);
        HashMap<String, Properties> localePropertiesMap = new HashMap<String, Properties>();
        NodeIterator nodeItr = localesNode.getNodes();
        while (nodeItr.hasNext()) {
            Node node = nodeItr.nextNode();
            String locale = node.getName();
            Properties properties = new Properties();
            PropertyIterator propertyIterator = node.getProperties();
            while (propertyIterator.hasNext()) {
                Property property = propertyIterator.nextProperty();
                if (property.isMultiple()) continue;
                properties.put(property.getName(), property.getValue().getString());
            }
            localePropertiesMap.put(locale, properties);
        }
        return localePropertiesMap;
    }

    private static void setLocalePropertiesMap(Session session, PentahoJcrConstants pentahoJcrConstants, Node localeRootNode, Map<String, Properties> localePropertiesMap) throws RepositoryException {
        String prefix = session.getNamespacePrefix("http://www.pentaho.org/jcr/2.0");
        Assert.hasText((String)prefix);
        if (localePropertiesMap != null && !localePropertiesMap.isEmpty()) {
            for (String locale : localePropertiesMap.keySet()) {
                Properties properties = localePropertiesMap.get(locale);
                if (properties == null) continue;
                Node localeNode = !NodeHelper.checkHasNode(localeRootNode, locale) ? localeRootNode.addNode(locale, pentahoJcrConstants.getNT_UNSTRUCTURED()) : NodeHelper.checkGetNode(localeRootNode, locale);
                for (String propertyName : properties.stringPropertyNames()) {
                    try {
                        localeNode.setProperty(propertyName, properties.getProperty(propertyName));
                    }
                    catch (Throwable th) {}
                }
            }
        }
    }

    private static Map<String, String> getLocalizedStringMap(Session session, PentahoJcrConstants pentahoJcrConstants, Node localizedStringNode) throws RepositoryException {
        Assert.isTrue((boolean)JcrRepositoryFileUtils.isLocalizedString(session, pentahoJcrConstants, localizedStringNode));
        String prefix = session.getNamespacePrefix("http://www.pentaho.org/jcr/2.0");
        Assert.hasText((String)prefix);
        HashMap<String, String> localizedStringMap = new HashMap<String, String>();
        PropertyIterator propertyIter = localizedStringNode.getProperties();
        while (propertyIter.hasNext()) {
            Property property = propertyIter.nextProperty();
            String propertyKey = property.getName().substring(prefix.length() + 1);
            localizedStringMap.put(propertyKey, property.getString());
        }
        return localizedStringMap;
    }

    private static void setLocalizedStringMap(Session session, PentahoJcrConstants pentahoJcrConstants, Node localizedStringNode, Map<String, String> map) throws RepositoryException {
        Assert.isTrue((boolean)JcrRepositoryFileUtils.isLocalizedString(session, pentahoJcrConstants, localizedStringNode));
        String prefix = session.getNamespacePrefix("http://www.pentaho.org/jcr/2.0");
        Assert.hasText((String)prefix);
        PropertyIterator propertyIter = localizedStringNode.getProperties();
        while (propertyIter.hasNext()) {
            Property prop = propertyIter.nextProperty();
            if (!prop.getName().startsWith(prefix)) continue;
            prop.remove();
        }
        for (Map.Entry<String, String> entry : map.entrySet()) {
            localizedStringNode.setProperty(prefix + ":" + entry.getKey(), entry.getValue());
        }
    }

    public static String getAbsolutePath(Session session, PentahoJcrConstants pentahoJcrConstants, Node node) throws RepositoryException {
        if (node.isNodeType(pentahoJcrConstants.getNT_FROZENNODE())) {
            return JcrStringHelper.pathDecode(session.getNodeByIdentifier(node.getProperty(pentahoJcrConstants.getJCR_FROZENUUID()).getString()).getPath());
        }
        return JcrStringHelper.pathDecode(node.getPath());
    }

    public static Serializable getNodeId(Session session, PentahoJcrConstants pentahoJcrConstants, Node node) throws RepositoryException {
        if (node.isNodeType(pentahoJcrConstants.getNT_FROZENNODE())) {
            return node.getProperty(pentahoJcrConstants.getJCR_FROZENUUID()).getString();
        }
        return node.getIdentifier();
    }

    public static String getNodeName(Session session, PentahoJcrConstants pentahoJcrConstants, Node node) throws RepositoryException {
        if (node.isNodeType(pentahoJcrConstants.getNT_FROZENNODE())) {
            return JcrStringHelper.fileNameDecode(session.getNodeByIdentifier(node.getProperty(pentahoJcrConstants.getJCR_FROZENUUID()).getString()).getName());
        }
        return JcrStringHelper.fileNameDecode(node.getName());
    }

    public static String getVersionId(Session session, PentahoJcrConstants pentahoJcrConstants, Node node) throws RepositoryException {
        if (node.isNodeType(pentahoJcrConstants.getNT_FROZENNODE())) {
            return JcrStringHelper.fileNameDecode(node.getParent().getName());
        }
        Version version = JcrRepositoryFileUtils.getBaseVersion(session, node);
        return version != null ? JcrStringHelper.fileNameDecode(version.getName()) : null;
    }

    private static Version getBaseVersion(Session session, Node node) throws UnsupportedRepositoryOperationException, RepositoryException {
        Version version = null;
        VersionManager versionManager = session.getWorkspace().getVersionManager();
        try {
            version = versionManager.getBaseVersion(node.getPath());
        }
        catch (NullPointerException ex) {
            logger.warn((Object)Messages.getInstance().getString("JcrRepositoryFileUtils.WARN_0001_NPE_FROM_CR"), (Throwable)ex);
        }
        return version;
    }

    public static Node createFolderNode(Session session, PentahoJcrConstants pentahoJcrConstants, Serializable parentFolderId, RepositoryFile folder) throws RepositoryException {
        JcrRepositoryFileUtils.checkName(folder.getName());
        Node parentFolderNode = parentFolderId != null ? session.getNodeByIdentifier(parentFolderId.toString()) : session.getRootNode();
        Assert.notNull((Object)parentFolderNode);
        String encodedfolderName = JcrStringHelper.fileNameEncode(folder.getName());
        Node folderNode = parentFolderNode.addNode(encodedfolderName, pentahoJcrConstants.getPHO_NT_PENTAHOFOLDER());
        folderNode.setProperty(pentahoJcrConstants.getPHO_HIDDEN(), folder.isHidden());
        Node localeNodes = null;
        if (folder.getTitle() != folder.getName()) {
            localeNodes = folderNode.addNode(pentahoJcrConstants.getPHO_LOCALES(), pentahoJcrConstants.getPHO_NT_LOCALE());
            HashMap<String, Properties> localPropertiesMap = new HashMap<String, Properties>();
            String defaultLocale = LocaleHelper.getLocale().toString();
            Properties titleProps = new Properties();
            titleProps.put("file.title", folder.getTitle());
            localPropertiesMap.put(defaultLocale, titleProps);
            JcrRepositoryFileUtils.setLocalePropertiesMap(session, pentahoJcrConstants, localeNodes, localPropertiesMap);
        }
        if (folder.isVersioned()) {
            folderNode.addMixin(pentahoJcrConstants.getPHO_MIX_VERSIONABLE());
        }
        folderNode.addNode(pentahoJcrConstants.getPHO_METADATA(), "nt:unstructured");
        folderNode.addMixin(pentahoJcrConstants.getMIX_REFERENCEABLE());
        return folderNode;
    }

    public static Node createFileNode(Session session, PentahoJcrConstants pentahoJcrConstants, Serializable parentFolderId, RepositoryFile file, IRepositoryFileData content, ITransformer<IRepositoryFileData> transformer) throws RepositoryException {
        JcrRepositoryFileUtils.checkName(file.getName());
        String encodedFileName = JcrStringHelper.fileNameEncode(file.getName());
        Node parentFolderNode = parentFolderId != null ? session.getNodeByIdentifier(parentFolderId.toString()) : session.getRootNode();
        Assert.notNull((Object)parentFolderNode);
        Node fileNode = parentFolderNode.addNode(encodedFileName, pentahoJcrConstants.getPHO_NT_PENTAHOFILE());
        fileNode.setProperty(pentahoJcrConstants.getPHO_CONTENTTYPE(), transformer.getContentType());
        fileNode.setProperty(pentahoJcrConstants.getPHO_LASTMODIFIED(), Calendar.getInstance());
        fileNode.setProperty(pentahoJcrConstants.getPHO_HIDDEN(), file.isHidden());
        fileNode.setProperty(pentahoJcrConstants.getPHO_FILESIZE(), content.getDataSize());
        if (file.getLocalePropertiesMap() != null && !file.getLocalePropertiesMap().isEmpty()) {
            Node localeNodes = fileNode.addNode(pentahoJcrConstants.getPHO_LOCALES(), pentahoJcrConstants.getPHO_NT_LOCALE());
            JcrRepositoryFileUtils.setLocalePropertiesMap(session, pentahoJcrConstants, localeNodes, file.getLocalePropertiesMap());
        }
        Node metaNode = fileNode.addNode(pentahoJcrConstants.getPHO_METADATA(), "nt:unstructured");
        JcrRepositoryFileUtils.setMetadataItemForFile(session, PentahoJcrConstants.PHO_CONTENTCREATOR, (Serializable)((Object)file.getCreatorId()), metaNode);
        fileNode.addMixin(pentahoJcrConstants.getMIX_LOCKABLE());
        fileNode.addMixin(pentahoJcrConstants.getMIX_REFERENCEABLE());
        if (file.isVersioned()) {
            fileNode.addMixin(pentahoJcrConstants.getPHO_MIX_VERSIONABLE());
        }
        transformer.createContentNode(session, pentahoJcrConstants, content, fileNode);
        return fileNode;
    }

    private static void preventLostUpdate(Session session, PentahoJcrConstants pentahoJcrConstants, RepositoryFile file) throws RepositoryException {
        Node fileNode = session.getNodeByIdentifier(file.getId().toString());
        Assert.notNull((Object)fileNode);
        if (JcrRepositoryFileUtils.isVersioned(session, pentahoJcrConstants, fileNode)) {
            Assert.notNull((Object)file.getVersionId(), (String)"updating a versioned file requires a non-null version id");
            Assert.state((boolean)session.getWorkspace().getVersionManager().getBaseVersion(fileNode.getPath()).getName().equals(file.getVersionId().toString()), (String)"update to this file has occurred since its last read");
        }
    }

    public static Node updateFileNode(Session session, PentahoJcrConstants pentahoJcrConstants, RepositoryFile file, IRepositoryFileData content, ITransformer<IRepositoryFileData> transformer) throws RepositoryException {
        Node fileNode = session.getNodeByIdentifier(file.getId().toString());
        Assert.notNull((Object)fileNode);
        JcrRepositoryFileUtils.preventLostUpdate(session, pentahoJcrConstants, file);
        fileNode.setProperty(pentahoJcrConstants.getPHO_CONTENTTYPE(), transformer.getContentType());
        fileNode.setProperty(pentahoJcrConstants.getPHO_LASTMODIFIED(), Calendar.getInstance());
        fileNode.setProperty(pentahoJcrConstants.getPHO_HIDDEN(), file.isHidden());
        fileNode.setProperty(pentahoJcrConstants.getPHO_FILESIZE(), content.getDataSize());
        if (file.getLocalePropertiesMap() != null && !file.getLocalePropertiesMap().isEmpty()) {
            Node localePropertiesMapNode = null;
            localePropertiesMapNode = !fileNode.hasNode(pentahoJcrConstants.getPHO_LOCALES()) ? fileNode.addNode(pentahoJcrConstants.getPHO_LOCALES(), pentahoJcrConstants.getPHO_NT_LOCALE()) : fileNode.getNode(pentahoJcrConstants.getPHO_LOCALES());
            JcrRepositoryFileUtils.setLocalePropertiesMap(session, pentahoJcrConstants, localePropertiesMapNode, file.getLocalePropertiesMap());
        }
        if (file.getCreatorId() != null) {
            Node metadataNode = null;
            metadataNode = !fileNode.hasNode(pentahoJcrConstants.getPHO_METADATA()) ? fileNode.addNode(pentahoJcrConstants.getPHO_METADATA(), "nt:unstructured") : fileNode.getNode(pentahoJcrConstants.getPHO_METADATA());
            JcrRepositoryFileUtils.setMetadataItemForFile(session, PentahoJcrConstants.PHO_CONTENTCREATOR, (Serializable)((Object)file.getCreatorId()), metadataNode);
        }
        transformer.updateContentNode(session, pentahoJcrConstants, content, fileNode);
        return fileNode;
    }

    public static Node updateFolderNode(Session session, PentahoJcrConstants pentahoJcrConstants, RepositoryFile folder) throws RepositoryException {
        Node folderNode = session.getNodeByIdentifier(folder.getId().toString());
        Assert.notNull((Object)folderNode);
        JcrRepositoryFileUtils.preventLostUpdate(session, pentahoJcrConstants, folder);
        folderNode.setProperty(pentahoJcrConstants.getPHO_HIDDEN(), folder.isHidden());
        if (folder.getLocalePropertiesMap() != null && !folder.getLocalePropertiesMap().isEmpty()) {
            Node localePropertiesMapNode = null;
            localePropertiesMapNode = !folderNode.hasNode(pentahoJcrConstants.getPHO_LOCALES()) ? folderNode.addNode(pentahoJcrConstants.getPHO_LOCALES(), pentahoJcrConstants.getPHO_NT_LOCALE()) : folderNode.getNode(pentahoJcrConstants.getPHO_LOCALES());
            JcrRepositoryFileUtils.setLocalePropertiesMap(session, pentahoJcrConstants, localePropertiesMapNode, folder.getLocalePropertiesMap());
        }
        return folderNode;
    }

    public static IRepositoryFileData getContent(Session session, PentahoJcrConstants pentahoJcrConstants, Serializable fileId, Serializable versionId, ITransformer<IRepositoryFileData> transformer) throws RepositoryException {
        Node fileNode = session.getNodeByIdentifier(fileId.toString());
        if (JcrRepositoryFileUtils.isVersioned(session, pentahoJcrConstants, fileNode)) {
            VersionManager vMgr = session.getWorkspace().getVersionManager();
            Version version = null;
            version = versionId != null ? vMgr.getVersionHistory(fileNode.getPath()).getVersion(versionId.toString()) : vMgr.getBaseVersion(fileNode.getPath());
            fileNode = JcrRepositoryFileUtils.getNodeAtVersion(pentahoJcrConstants, version);
        }
        Assert.isTrue((!JcrRepositoryFileUtils.isPentahoFolder(pentahoJcrConstants, fileNode) ? 1 : 0) != 0);
        return transformer.fromContentNode(session, pentahoJcrConstants, fileNode);
    }

    public static List<RepositoryFile> getChildren(Session session, PentahoJcrConstants pentahoJcrConstants, IPathConversionHelper pathConversionHelper, ILockHelper lockHelper, RepositoryRequest repositoryRequest) throws RepositoryException {
        Node folderNode = session.getNodeByIdentifier(JcrStringHelper.idEncode(repositoryRequest.getPath()));
        Assert.isTrue((boolean)JcrRepositoryFileUtils.isPentahoFolder(pentahoJcrConstants, folderNode));
        ArrayList<RepositoryFile> children = new ArrayList<RepositoryFile>();
        NodeIterator nodeIterator = null;
        nodeIterator = repositoryRequest.getChildNodeFilter() != null ? folderNode.getNodes(repositoryRequest.getChildNodeFilter()) : folderNode.getNodes();
        while (nodeIterator.hasNext()) {
            Node node = nodeIterator.nextNode();
            if (!JcrRepositoryFileUtils.isSupportedNodeType(pentahoJcrConstants, node)) continue;
            RepositoryFile file = JcrRepositoryFileUtils.nodeToFile(session, pentahoJcrConstants, pathConversionHelper, lockHelper, node);
            if (!repositoryRequest.isShowHidden()) {
                if (file.isHidden()) continue;
                children.add(file);
                continue;
            }
            children.add(file);
        }
        Collections.sort(children);
        return children;
    }

    @Deprecated
    public static List<RepositoryFile> getChildren(Session session, PentahoJcrConstants pentahoJcrConstants, IPathConversionHelper pathConversionHelper, ILockHelper lockHelper, Serializable folderId, String filter) throws RepositoryException {
        return JcrRepositoryFileUtils.getChildren(session, pentahoJcrConstants, pathConversionHelper, lockHelper, folderId, filter, null);
    }

    @Deprecated
    public static List<RepositoryFile> getChildren(Session session, PentahoJcrConstants pentahoJcrConstants, IPathConversionHelper pathConversionHelper, ILockHelper lockHelper, Serializable folderId, String filter, Boolean showHiddenFiles) throws RepositoryException {
        RepositoryRequest repositoryRequest = new RepositoryRequest(folderId.toString(), showHiddenFiles, Integer.valueOf(0), filter);
        return JcrRepositoryFileUtils.getChildren(session, pentahoJcrConstants, pathConversionHelper, lockHelper, repositoryRequest);
    }

    public static boolean isPentahoFolder(PentahoJcrConstants pentahoJcrConstants, Node node) throws RepositoryException {
        Assert.notNull((Object)node);
        if (node.isNodeType(pentahoJcrConstants.getNT_FROZENNODE())) {
            String nodeTypeName = node.getProperty(pentahoJcrConstants.getJCR_FROZENPRIMARYTYPE()).getString();
            return pentahoJcrConstants.getPHO_NT_PENTAHOFOLDER().equals(nodeTypeName);
        }
        return node.isNodeType(pentahoJcrConstants.getPHO_NT_PENTAHOFOLDER());
    }

    public static boolean isPentahoHierarchyNode(Session session, PentahoJcrConstants pentahoJcrConstants, Node node) throws RepositoryException {
        Assert.notNull((Object)node);
        if (node.isNodeType(pentahoJcrConstants.getNT_FROZENNODE())) {
            String nodeTypeName = node.getProperty(pentahoJcrConstants.getJCR_FROZENPRIMARYTYPE()).getString();
            return pentahoJcrConstants.getPHO_NT_PENTAHOFOLDER().equals(nodeTypeName) || pentahoJcrConstants.getPHO_NT_PENTAHOFILE().equals(nodeTypeName);
        }
        return node.isNodeType(pentahoJcrConstants.getPHO_NT_PENTAHOHIERARCHYNODE());
    }

    public static boolean isLocked(PentahoJcrConstants pentahoJcrConstants, Node node) throws RepositoryException {
        Assert.notNull((Object)node);
        if (node.isNodeType(pentahoJcrConstants.getNT_FROZENNODE())) {
            return false;
        }
        boolean locked = node.isLocked();
        if (locked) {
            Assert.isTrue((boolean)node.isNodeType(pentahoJcrConstants.getMIX_LOCKABLE()));
        }
        return locked;
    }

    public static boolean isPentahoFile(PentahoJcrConstants pentahoJcrConstants, Node node) throws RepositoryException {
        Assert.notNull((Object)node);
        if (node.isNodeType(pentahoJcrConstants.getNT_FROZENNODE())) {
            String primaryTypeName = node.getProperty(pentahoJcrConstants.getJCR_FROZENPRIMARYTYPE()).getString();
            return pentahoJcrConstants.getPHO_NT_PENTAHOFILE().equals(primaryTypeName);
        }
        return node.isNodeType(pentahoJcrConstants.getPHO_NT_PENTAHOFILE());
    }

    private static boolean isLocalizedString(Session session, PentahoJcrConstants pentahoJcrConstants, Node node) throws RepositoryException {
        Assert.notNull((Object)node);
        if (node.isNodeType(pentahoJcrConstants.getNT_FROZENNODE())) {
            String frozenPrimaryType = node.getProperty(pentahoJcrConstants.getJCR_FROZENPRIMARYTYPE()).getString();
            return pentahoJcrConstants.getPHO_NT_LOCALIZEDSTRING().equals(frozenPrimaryType);
        }
        return node.isNodeType(pentahoJcrConstants.getPHO_NT_LOCALIZEDSTRING());
    }

    public static boolean isVersioned(Session session, PentahoJcrConstants pentahoJcrConstants, Node node) throws RepositoryException {
        Assert.notNull((Object)node);
        if (node.isNodeType(pentahoJcrConstants.getNT_FROZENNODE())) {
            return true;
        }
        return node.isNodeType(pentahoJcrConstants.getPHO_MIX_VERSIONABLE());
    }

    public static boolean isSupportedNodeType(PentahoJcrConstants pentahoJcrConstants, Node node) throws RepositoryException {
        Assert.notNull((Object)node);
        if (node.isNodeType(pentahoJcrConstants.getNT_FROZENNODE())) {
            String nodeTypeName = node.getProperty(pentahoJcrConstants.getJCR_FROZENPRIMARYTYPE()).getString();
            return pentahoJcrConstants.getPHO_NT_PENTAHOFILE().equals(nodeTypeName) || pentahoJcrConstants.getPHO_NT_PENTAHOFOLDER().equals(nodeTypeName);
        }
        return node.isNodeType(pentahoJcrConstants.getPHO_NT_PENTAHOFILE()) || node.isNodeType(pentahoJcrConstants.getPHO_NT_PENTAHOFOLDER());
    }

    public static void checkoutNearestVersionableFileIfNecessary(Session session, PentahoJcrConstants pentahoJcrConstants, Serializable fileId) throws RepositoryException {
        if (fileId != null) {
            Node node = session.getNodeByIdentifier(fileId.toString());
            JcrRepositoryFileUtils.checkoutNearestVersionableNodeIfNecessary(session, pentahoJcrConstants, node);
        }
    }

    public static void checkoutNearestVersionableNodeIfNecessary(Session session, PentahoJcrConstants pentahoJcrConstants, Node node) throws RepositoryException {
        Assert.notNull((Object)node);
        Node versionableNode = JcrRepositoryFileUtils.findNearestVersionableNode(session, pentahoJcrConstants, node);
        if (versionableNode != null) {
            session.getWorkspace().getVersionManager().checkout(versionableNode.getPath());
        }
    }

    public static void checkinNearestVersionableFileIfNecessary(Session session, PentahoJcrConstants pentahoJcrConstants, Serializable fileId, String versionMessage) throws RepositoryException {
        JcrRepositoryFileUtils.checkinNearestVersionableFileIfNecessary(session, pentahoJcrConstants, fileId, versionMessage, null, false);
    }

    public static void checkinNearestVersionableFileIfNecessary(Session session, PentahoJcrConstants pentahoJcrConstants, Serializable fileId, String versionMessage, Date versionDate, boolean aclOnlyChange) throws RepositoryException {
        if (fileId != null) {
            Node node = session.getNodeByIdentifier(fileId.toString());
            JcrRepositoryFileUtils.checkinNearestVersionableNodeIfNecessary(session, pentahoJcrConstants, node, versionMessage, versionDate, aclOnlyChange);
        }
    }

    public static void checkinNearestVersionableNodeIfNecessary(Session session, PentahoJcrConstants pentahoJcrConstants, Node node, String versionMessage) throws RepositoryException {
        JcrRepositoryFileUtils.checkinNearestVersionableNodeIfNecessary(session, pentahoJcrConstants, node, versionMessage, null, false);
    }

    public static void checkinNearestVersionableNodeIfNecessary(Session session, PentahoJcrConstants pentahoJcrConstants, Node node, String versionMessage, Date versionDate, boolean aclOnlyChange) throws RepositoryException {
        Assert.notNull((Object)node);
        session.save();
        Node versionableNode = JcrRepositoryFileUtils.findNearestVersionableNode(session, pentahoJcrConstants, node);
        if (versionableNode != null) {
            VersionSummary versionSummary;
            List versionSummaries;
            versionableNode.setProperty(pentahoJcrConstants.getPHO_VERSIONAUTHOR(), JcrRepositoryFileUtils.getUsername());
            if (org.springframework.util.StringUtils.hasText((String)versionMessage)) {
                versionableNode.setProperty(pentahoJcrConstants.getPHO_VERSIONMESSAGE(), versionMessage);
            } else if (versionableNode.hasProperty(pentahoJcrConstants.getPHO_VERSIONMESSAGE())) {
                versionableNode.setProperty(pentahoJcrConstants.getPHO_VERSIONMESSAGE(), (String)null);
            }
            if (aclOnlyChange) {
                versionableNode.setProperty(pentahoJcrConstants.getPHO_ACLONLYCHANGE(), true);
            } else if (versionableNode.hasProperty(pentahoJcrConstants.getPHO_ACLONLYCHANGE())) {
                versionableNode.getProperty(pentahoJcrConstants.getPHO_ACLONLYCHANGE()).remove();
            }
            session.save();
            Calendar cal = Calendar.getInstance();
            if (versionDate != null) {
                cal.setTime(versionDate);
            } else {
                cal.setTime(new Date());
            }
            ((VersionManagerImpl)session.getWorkspace().getVersionManager()).checkin(versionableNode.getPath(), cal);
            if (Boolean.FALSE.equals(versioningEnabled) && (versionSummaries = (List)JcrRepositoryFileUtils.getVersionSummaries(session, pentahoJcrConstants, (Serializable)((Object)versionableNode.getIdentifier()), Boolean.TRUE)) != null && versionSummaries.size() > 1 && (versionSummary = (VersionSummary)versionSummaries.toArray()[versionSummaries.size() - 2]) != null) {
                String versionId = (String)((Object)versionSummary.getId());
                session.getWorkspace().getVersionManager().getVersionHistory(versionableNode.getPath()).removeVersion(versionId);
                session.save();
            }
        }
    }

    private static String getUsername() {
        IPentahoSession pentahoSession = PentahoSessionHolder.getSession();
        Assert.state((pentahoSession != null ? 1 : 0) != 0);
        return pentahoSession.getName();
    }

    private static Node findNearestVersionableNode(Session session, PentahoJcrConstants pentahoJcrConstants, Node node) throws RepositoryException {
        Node currentNode = node;
        while (!currentNode.isNodeType(pentahoJcrConstants.getPHO_MIX_VERSIONABLE())) {
            try {
                currentNode = currentNode.getParent();
            }
            catch (ItemNotFoundException e) {
                return null;
            }
        }
        return currentNode;
    }

    public static void deleteFile(Session session, PentahoJcrConstants pentahoJcrConstants, Serializable fileId, ILockHelper lockTokenHelper) throws RepositoryException {
        Node fileNode = session.getNodeByIdentifier(fileId.toString());
        Assert.notNull((Object)fileNode);
        if (fileNode.isLocked()) {
            Lock lock = session.getWorkspace().getLockManager().getLock(fileNode.getPath());
            lockTokenHelper.removeLockToken(session, pentahoJcrConstants, lock);
        }
        fileNode.remove();
    }

    public static RepositoryFile nodeIdToFile(Session session, PentahoJcrConstants pentahoJcrConstants, IPathConversionHelper pathConversionHelper, ILockHelper lockHelper, Serializable fileId) throws RepositoryException {
        Node fileNode = session.getNodeByIdentifier(fileId.toString());
        return JcrRepositoryFileUtils.nodeToFile(session, pentahoJcrConstants, pathConversionHelper, lockHelper, fileNode);
    }

    public static Object getVersionSummaries(Session session, PentahoJcrConstants pentahoJcrConstants, Serializable fileId, boolean includeAclOnlyChanges) throws RepositoryException {
        Node fileNode = session.getNodeByIdentifier(fileId.toString());
        VersionHistory versionHistory = session.getWorkspace().getVersionManager().getVersionHistory(fileNode.getPath());
        Version version = versionHistory.getRootVersion();
        Version[] successors = version.getSuccessors();
        ArrayList<VersionSummary> versionSummaries = new ArrayList<VersionSummary>();
        while (successors != null && successors.length > 0) {
            version = successors[0];
            VersionSummary sum = JcrRepositoryFileUtils.toVersionSummary(pentahoJcrConstants, versionHistory, version);
            if (!sum.isAclOnlyChange() || includeAclOnlyChanges && sum.isAclOnlyChange()) {
                versionSummaries.add(sum);
            }
            successors = version.getSuccessors();
        }
        return versionSummaries;
    }

    private static VersionSummary toVersionSummary(PentahoJcrConstants pentahoJcrConstants, VersionHistory versionHistory, Version version) throws RepositoryException {
        List<String> labels = Arrays.asList(versionHistory.getVersionLabels(version));
        Node nodeAtVersion = JcrRepositoryFileUtils.getNodeAtVersion(pentahoJcrConstants, version);
        String author = "BASE_VERSION";
        if (nodeAtVersion.hasProperty(pentahoJcrConstants.getPHO_VERSIONAUTHOR())) {
            author = nodeAtVersion.getProperty(pentahoJcrConstants.getPHO_VERSIONAUTHOR()).getString();
        }
        String message = null;
        if (nodeAtVersion.hasProperty(pentahoJcrConstants.getPHO_VERSIONMESSAGE())) {
            message = nodeAtVersion.getProperty(pentahoJcrConstants.getPHO_VERSIONMESSAGE()).getString();
        }
        boolean aclOnlyChange = false;
        if (nodeAtVersion.hasProperty(pentahoJcrConstants.getPHO_ACLONLYCHANGE()) && nodeAtVersion.getProperty(pentahoJcrConstants.getPHO_ACLONLYCHANGE()).getBoolean()) {
            aclOnlyChange = true;
        }
        return new VersionSummary((Serializable)((Object)version.getName()), (Serializable)((Object)versionHistory.getVersionableIdentifier()), aclOnlyChange, version.getCreated().getTime(), author, message, labels);
    }

    private static Node getNodeAtVersion(PentahoJcrConstants pentahoJcrConstants, Version version) throws RepositoryException {
        return version.getNode(pentahoJcrConstants.getJCR_FROZENNODE());
    }

    public static RepositoryFile getFileAtVersion(Session session, PentahoJcrConstants pentahoJcrConstants, IPathConversionHelper pathConversionHelper, ILockHelper lockHelper, Serializable fileId, Serializable versionId) throws RepositoryException {
        Node fileNode = session.getNodeByIdentifier(fileId.toString());
        Version version = session.getWorkspace().getVersionManager().getVersionHistory(fileNode.getPath()).getVersion(versionId.toString());
        return JcrRepositoryFileUtils.nodeToFile(session, pentahoJcrConstants, pathConversionHelper, lockHelper, JcrRepositoryFileUtils.getNodeAtVersion(pentahoJcrConstants, version));
    }

    public static String getFileContentType(Session session, PentahoJcrConstants pentahoJcrConstants, Serializable fileId, Serializable versionId) throws RepositoryException {
        Assert.notNull((Object)fileId);
        Node fileNode = session.getNodeByIdentifier(fileId.toString());
        if (versionId != null) {
            Version version = session.getWorkspace().getVersionManager().getVersionHistory(fileNode.getPath()).getVersion(versionId.toString());
            Node nodeAtVersion = JcrRepositoryFileUtils.getNodeAtVersion(pentahoJcrConstants, version);
            return nodeAtVersion.getProperty(pentahoJcrConstants.getPHO_CONTENTTYPE()).getString();
        }
        return fileNode.getProperty(pentahoJcrConstants.getPHO_CONTENTTYPE()).getString();
    }

    public static Serializable getParentId(Session session, Serializable fileId) throws RepositoryException {
        Node node = session.getNodeByIdentifier(fileId.toString());
        return node.getParent().getIdentifier();
    }

    public static Serializable getBaseVersionId(Session session, Serializable fileId) throws RepositoryException {
        Node node = session.getNodeByIdentifier(fileId.toString());
        return session.getWorkspace().getVersionManager().getBaseVersion(node.getPath()).getName();
    }

    public static Object getVersionSummary(Session session, PentahoJcrConstants pentahoJcrConstants, Serializable fileId, Serializable versionId) throws RepositoryException {
        VersionManager vMgr = session.getWorkspace().getVersionManager();
        Node fileNode = session.getNodeByIdentifier(fileId.toString());
        VersionHistory versionHistory = vMgr.getVersionHistory(fileNode.getPath());
        Version version = null;
        version = versionId != null ? versionHistory.getVersion(versionId.toString()) : vMgr.getBaseVersion(fileNode.getPath());
        return JcrRepositoryFileUtils.toVersionSummary(pentahoJcrConstants, versionHistory, version);
    }

    public static boolean getVersioningEnabled() {
        return versioningEnabled;
    }

    public static boolean getVersionCommentsEnabled() {
        return versionCommentsEnabled;
    }

    public static RepositoryFileTree getTree(Session session, PentahoJcrConstants pentahoJcrConstants, IPathConversionHelper pathConversionHelper, ILockHelper lockHelper, String absPath, RepositoryRequest repositoryRequest, IRepositoryAccessVoterManager accessVoterManager) throws RepositoryException {
        Item fileItem = session.getItem(JcrStringHelper.pathEncode(absPath));
        Assert.isTrue((boolean)fileItem.isNode());
        Node fileNode = (Node)fileItem;
        return JcrRepositoryFileUtils.getTreeByNode(session, pentahoJcrConstants, pathConversionHelper, lockHelper, fileNode, repositoryRequest.getDepth(), repositoryRequest.getChildNodeFilter(), repositoryRequest.isShowHidden(), accessVoterManager, repositoryRequest.getTypes(), new MutableBoolean(false));
    }

    private static RepositoryFileTree getTreeByNode(Session session, PentahoJcrConstants pentahoJcrConstants, IPathConversionHelper pathConversionHelper, ILockHelper lockHelper, Node fileNode, int depth, String childNodeFilter, boolean showHidden, IRepositoryAccessVoterManager accessVoterManager, RepositoryRequest.FILES_TYPE_FILTER types, MutableBoolean foundFiltered) throws RepositoryException {
        ArrayList<RepositoryFileTree> children;
        RepositoryFile rootFile = JcrRepositoryFileUtils.nodeToFile(session, pentahoJcrConstants, pathConversionHelper, lockHelper, fileNode, false, null);
        if (!showHidden && rootFile.isHidden() || !accessVoterManager.hasAccess(rootFile, RepositoryFilePermission.READ, JcrRepositoryFileAclUtils.getAcl(session, pentahoJcrConstants, rootFile.getId()), PentahoSessionHolder.getSession())) {
            return null;
        }
        if (depth != 0) {
            boolean pentahoFolder;
            Node childNode;
            children = new ArrayList<RepositoryFileTree>();
            int numberOfPasses = childNodeFilter != null && !childNodeFilter.equals("*") ? 2 : 1;
            HashSet<Node> filteredChildrenSet = new HashSet<Node>();
            NodeIterator childNodes = fileNode.getNodes(childNodeFilter);
            while (childNodes.hasNext()) {
                childNode = childNodes.nextNode();
                pentahoFolder = JcrRepositoryFileUtils.isPentahoFolder(pentahoJcrConstants, childNode);
                if (!pentahoFolder && types == RepositoryRequest.FILES_TYPE_FILTER.FOLDERS || pentahoFolder && types == RepositoryRequest.FILES_TYPE_FILTER.FILES) continue;
                filteredChildrenSet.add(childNode);
            }
            HashSet<Node> childrenFolderSet = new HashSet<Node>();
            if (numberOfPasses == 2 && JcrRepositoryFileUtils.isPentahoFolder(pentahoJcrConstants, fileNode)) {
                childNodes = fileNode.getNodes();
                while (childNodes.hasNext()) {
                    childNode = childNodes.nextNode();
                    pentahoFolder = JcrRepositoryFileUtils.isPentahoFolder(pentahoJcrConstants, childNode);
                    if (!pentahoFolder) continue;
                    childrenFolderSet.add(childNode);
                }
            }
            for (Node childNode2 : childrenFolderSet) {
                JcrRepositoryFileUtils.checkNodeForTree(childNode2, children, session, pentahoJcrConstants, pathConversionHelper, childNodeFilter, lockHelper, depth, showHidden, accessVoterManager, types, foundFiltered, false);
            }
            for (Node childNode3 : filteredChildrenSet) {
                foundFiltered.setValue(true);
                JcrRepositoryFileUtils.checkNodeForTree(childNode3, children, session, pentahoJcrConstants, pathConversionHelper, childNodeFilter, lockHelper, depth, showHidden, accessVoterManager, types, foundFiltered, true);
            }
            Collections.sort(children);
        } else {
            children = null;
        }
        return new RepositoryFileTree(rootFile, children);
    }

    private static void checkNodeForTree(Node childNode, List<RepositoryFileTree> children, Session session, PentahoJcrConstants pentahoJcrConstants, IPathConversionHelper pathConversionHelper, String childNodeFilter, ILockHelper lockHelper, int depth, boolean showHidden, IRepositoryAccessVoterManager accessVoterManager, RepositoryRequest.FILES_TYPE_FILTER types, MutableBoolean foundFiltered, boolean isRootFiltered) throws RepositoryException {
        MutableBoolean foundFilteredAtomic;
        RepositoryFileTree repositoryFileTree;
        RepositoryFile file = JcrRepositoryFileUtils.nodeToFile(session, pentahoJcrConstants, pathConversionHelper, lockHelper, childNode);
        if (JcrRepositoryFileUtils.isSupportedNodeType(pentahoJcrConstants, childNode) && accessVoterManager.hasAccess(file, RepositoryFilePermission.READ, JcrRepositoryFileAclUtils.getAcl(session, pentahoJcrConstants, file.getId()), PentahoSessionHolder.getSession()) && (repositoryFileTree = JcrRepositoryFileUtils.getTreeByNode(session, pentahoJcrConstants, pathConversionHelper, lockHelper, childNode, depth - 1, childNodeFilter, showHidden, accessVoterManager, types, foundFilteredAtomic = new MutableBoolean(!JcrRepositoryFileUtils.isPentahoFolder(pentahoJcrConstants, childNode)))) != null && (foundFilteredAtomic.booleanValue() || isRootFiltered)) {
            foundFiltered.setValue(true);
            children.add(repositoryFileTree);
        }
    }

    public static Node updateFileLocaleProperties(Session session, Serializable fileId, String locale, Properties properties) throws RepositoryException {
        PentahoJcrConstants pentahoJcrConstants = new PentahoJcrConstants(session);
        Node fileNode = session.getNodeByIdentifier(fileId.toString());
        String prefix = session.getNamespacePrefix("http://www.pentaho.org/jcr/2.0");
        Assert.hasText((String)prefix);
        Node localesNode = null;
        localesNode = !fileNode.hasNode(pentahoJcrConstants.getPHO_LOCALES()) ? fileNode.addNode(pentahoJcrConstants.getPHO_LOCALES(), pentahoJcrConstants.getPHO_NT_LOCALE()) : fileNode.getNode(pentahoJcrConstants.getPHO_LOCALES());
        try {
            Node localeNode = NodeHelper.checkGetNode(localesNode, locale);
            for (String propertyName : properties.stringPropertyNames()) {
                localeNode.setProperty(propertyName, properties.getProperty(propertyName));
            }
        }
        catch (PathNotFoundException pnfe) {
            HashMap<String, Properties> propertiesMap = new HashMap<String, Properties>();
            propertiesMap.put(locale, properties);
            JcrRepositoryFileUtils.setLocalePropertiesMap(session, pentahoJcrConstants, localesNode, propertiesMap);
        }
        return fileNode;
    }

    public static Node deleteFileLocaleProperties(Session session, Serializable fileId, String locale) throws RepositoryException {
        PentahoJcrConstants pentahoJcrConstants = new PentahoJcrConstants(session);
        Node fileNode = session.getNodeByIdentifier(fileId.toString());
        String prefix = session.getNamespacePrefix("http://www.pentaho.org/jcr/2.0");
        Assert.hasText((String)prefix);
        Node localesNode = fileNode.getNode(pentahoJcrConstants.getPHO_LOCALES());
        Assert.notNull((Object)localesNode);
        try {
            Node localeNode = NodeHelper.checkGetNode(localesNode, locale);
            localeNode.remove();
        }
        catch (PathNotFoundException pnfe) {
            // empty catch block
        }
        return fileNode;
    }

    public static void setFileMetadata(Session session, Serializable fileId, Map<String, Serializable> metadataMap) throws ItemNotFoundException, RepositoryException {
        PentahoJcrConstants pentahoJcrConstants = new PentahoJcrConstants(session);
        Node fileNode = session.getNodeByIdentifier(fileId.toString());
        String prefix = session.getNamespacePrefix("http://www.pentaho.org/jcr/2.0");
        Assert.hasText((String)prefix);
        Node metadataNode = fileNode.getNode(pentahoJcrConstants.getPHO_METADATA());
        JcrRepositoryFileUtils.checkoutNearestVersionableNodeIfNecessary(session, pentahoJcrConstants, metadataNode);
        PropertyIterator propertyIter = metadataNode.getProperties(prefix + ":*");
        while (propertyIter.hasNext()) {
            propertyIter.nextProperty().remove();
        }
        for (String key : metadataMap.keySet()) {
            JcrRepositoryFileUtils.setMetadataItemForFile(session, key, metadataMap.get(key), metadataNode);
        }
        JcrRepositoryFileUtils.checkinNearestVersionableNodeIfNecessary(session, pentahoJcrConstants, metadataNode, null);
    }

    private static void setMetadataItemForFile(Session session, String metadataKey, Serializable metadataObj, Node metadataNode) throws ItemNotFoundException, RepositoryException {
        JcrRepositoryFileUtils.checkName(metadataKey);
        Assert.notNull((Object)metadataNode);
        String prefix = session.getNamespacePrefix("http://www.pentaho.org/jcr/2.0");
        Assert.hasText((String)prefix);
        if (metadataObj instanceof String) {
            metadataNode.setProperty(prefix + ":" + metadataKey, (String)((Object)metadataObj));
        } else if (metadataObj instanceof Calendar) {
            metadataNode.setProperty(prefix + ":" + metadataKey, (Calendar)metadataObj);
        } else if (metadataObj instanceof Double) {
            metadataNode.setProperty(prefix + ":" + metadataKey, ((Double)metadataObj).doubleValue());
        } else if (metadataObj instanceof Long) {
            metadataNode.setProperty(prefix + ":" + metadataKey, ((Long)metadataObj).longValue());
        } else if (metadataObj instanceof Boolean) {
            metadataNode.setProperty(prefix + ":" + metadataKey, ((Boolean)metadataObj).booleanValue());
        }
    }

    public static Map<String, Serializable> getFileMetadata(Session session, Serializable fileId) throws ItemNotFoundException, RepositoryException {
        HashMap<String, Serializable> values = new HashMap<String, Serializable>();
        String prefix = session.getNamespacePrefix("http://www.pentaho.org/jcr/2.0");
        Node fileNode = session.getNodeByIdentifier(fileId.toString());
        PentahoJcrConstants pentahoJcrConstants = new PentahoJcrConstants(session);
        String metadataNodeName = pentahoJcrConstants.getPHO_METADATA();
        Node metadataNode = null;
        try {
            metadataNode = NodeHelper.checkGetNode(fileNode, metadataNodeName);
        }
        catch (PathNotFoundException pathNotFound) {
            return values;
        }
        PropertyIterator iter = metadataNode.getProperties(prefix + ":*");
        while (iter.hasNext()) {
            Property property = iter.nextProperty();
            String key = property.getName().substring(property.getName().indexOf(58) + 1);
            Object value = null;
            switch (property.getType()) {
                case 1: {
                    value = property.getString();
                    break;
                }
                case 5: {
                    value = property.getDate();
                    break;
                }
                case 4: {
                    value = property.getDouble();
                    break;
                }
                case 3: {
                    value = property.getLong();
                    break;
                }
                case 6: {
                    value = property.getBoolean();
                }
            }
            if (value == null) continue;
            values.put(key, (Serializable)value);
        }
        return values;
    }

    public static List<Character> getReservedChars() {
        return reservedChars;
    }

    public static void checkName(String name) {
        Pattern containsReservedCharsPattern = JcrRepositoryFileUtils.makePattern(JcrRepositoryFileUtils.getReservedChars());
        if (!org.springframework.util.StringUtils.hasLength((String)name) || !name.trim().equals(name) || containsReservedCharsPattern.matcher(name).matches() || ".".equals(name) || "..".equals(name)) {
            throw new RepositoryFileDaoMalformedNameException(name);
        }
    }

    public static RepositoryFile createFolder(Session session, CredentialsStrategySessionFactory sessionFactory, RepositoryFile parentFolder, RepositoryFile folder, boolean inheritAces, RepositoryFileSid ownerSid, IPathConversionHelper pathConversionHelper, String versionMessage) throws RepositoryException {
        Serializable parentFolderId = parentFolder == null ? null : parentFolder.getId();
        PentahoJcrConstants pentahoJcrConstants = new PentahoJcrConstants(session);
        JcrRepositoryFileUtils.checkoutNearestVersionableFileIfNecessary(session, pentahoJcrConstants, parentFolderId);
        Node folderNode = JcrRepositoryFileUtils.createFolderNode(session, pentahoJcrConstants, parentFolderId, folder);
        session.save();
        JcrRepositoryFileAclUtils.createAcl(session, pentahoJcrConstants, (Serializable)((Object)folderNode.getIdentifier()), new RepositoryFileAcl.Builder(ownerSid).entriesInheriting(inheritAces).build());
        session.save();
        if (folder.isVersioned()) {
            JcrRepositoryFileUtils.checkinNearestVersionableNodeIfNecessary(session, pentahoJcrConstants, folderNode, versionMessage);
        }
        JcrRepositoryFileUtils.checkinNearestVersionableFileIfNecessary(session, pentahoJcrConstants, parentFolderId, Messages.getInstance().getString("JcrRepositoryFileDao.USER_0001_VER_COMMENT_ADD_FOLDER", new Object[]{folder.getName(), parentFolderId == null ? "root" : parentFolderId.toString()}));
        return JcrRepositoryFileUtils.getFileById(session, pentahoJcrConstants, pathConversionHelper, null, (Serializable)((Object)folderNode.getIdentifier()));
    }

    public static RepositoryFile getFileByAbsolutePath(Session session, String absPath, IPathConversionHelper pathConversionHelper, ILockHelper lockHelper, boolean loadMaps, IPentahoLocale locale) throws RepositoryException {
        Item fileNode;
        PentahoJcrConstants pentahoJcrConstants = new PentahoJcrConstants(session);
        try {
            fileNode = session.getItem(JcrStringHelper.pathEncode(absPath));
            Assert.isTrue((boolean)fileNode.isNode());
        }
        catch (PathNotFoundException e) {
            fileNode = null;
        }
        return fileNode != null ? JcrRepositoryFileUtils.nodeToFile(session, pentahoJcrConstants, pathConversionHelper, lockHelper, (Node)fileNode, loadMaps, locale) : null;
    }

    public static void setVersioningEnabled(boolean versioningEnabled) {
        JcrRepositoryFileUtils.versioningEnabled = versioningEnabled;
    }

    public static void setVersionCommentsEnabled(boolean versionCommentsEnabled) {
        JcrRepositoryFileUtils.versionCommentsEnabled = versionCommentsEnabled;
    }

    static {
        Boolean systemVersionCommentsEnabled;
        Boolean systemVersioningEnabled;
        logger = LogFactory.getLog(JcrRepositoryFileUtils.class);
        reservedChars = Collections.unmodifiableList(Arrays.asList(Character.valueOf('/'), Character.valueOf('\\'), Character.valueOf('\t'), Character.valueOf('\r'), Character.valueOf('\n')));
        versioningEnabled = true;
        versionCommentsEnabled = true;
        List newOverrideReservedChars = (List)PentahoSystem.get(ArrayList.class, (String)"reservedChars", (IPentahoSession)PentahoSessionHolder.getSession());
        if (newOverrideReservedChars != null) {
            reservedChars = newOverrideReservedChars;
        }
        if ((systemVersioningEnabled = (Boolean)PentahoSystem.get(Boolean.class, (String)"versioningEnabled", (IPentahoSession)PentahoSessionHolder.getSession())) != null) {
            versioningEnabled = systemVersioningEnabled;
        }
        if ((systemVersionCommentsEnabled = (Boolean)PentahoSystem.get(Boolean.class, (String)"versionCommentsEnabled", (IPentahoSession)PentahoSessionHolder.getSession())) != null) {
            versionCommentsEnabled = systemVersionCommentsEnabled;
        }
    }
}

