/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.platform.repository2.unified.jcr;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.Property;
import javax.jcr.PropertyIterator;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.lock.Lock;
import javax.jcr.query.QueryResult;
import javax.jcr.query.qom.And;
import javax.jcr.query.qom.Comparison;
import javax.jcr.query.qom.Constraint;
import javax.jcr.query.qom.DescendantNode;
import javax.jcr.query.qom.DynamicOperand;
import javax.jcr.query.qom.QueryObjectModel;
import javax.jcr.query.qom.QueryObjectModelFactory;
import javax.jcr.query.qom.Selector;
import javax.jcr.query.qom.Source;
import javax.jcr.query.qom.StaticOperand;
import org.pentaho.platform.api.engine.IPentahoSession;
import org.pentaho.platform.api.mt.ITenant;
import org.pentaho.platform.api.repository2.unified.RepositoryFile;
import org.pentaho.platform.core.mt.Tenant;
import org.pentaho.platform.engine.core.system.PentahoSessionHolder;
import org.pentaho.platform.repository2.messages.Messages;
import org.pentaho.platform.repository2.unified.ServerRepositoryPaths;
import org.pentaho.platform.repository2.unified.exception.RepositoryFileDaoFileExistsException;
import org.pentaho.platform.repository2.unified.exception.RepositoryFileDaoReferentialIntegrityException;
import org.pentaho.platform.repository2.unified.jcr.IDeleteHelper;
import org.pentaho.platform.repository2.unified.jcr.ILockHelper;
import org.pentaho.platform.repository2.unified.jcr.IPathConversionHelper;
import org.pentaho.platform.repository2.unified.jcr.JcrRepositoryFileUtils;
import org.pentaho.platform.repository2.unified.jcr.JcrStringHelper;
import org.pentaho.platform.repository2.unified.jcr.NodeHelper;
import org.pentaho.platform.repository2.unified.jcr.PentahoJcrConstants;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

public class DefaultDeleteHelper
implements IDeleteHelper {
    final ILockHelper lockHelper;
    final IPathConversionHelper pathConversionHelper;
    private static final String FOLDER_NAME_TRASH = ".trash";

    public DefaultDeleteHelper(ILockHelper lockHelper, IPathConversionHelper pathConversionHelper) {
        this.lockHelper = lockHelper;
        this.pathConversionHelper = pathConversionHelper;
    }

    @Override
    public void deleteFile(Session session, PentahoJcrConstants pentahoJcrConstants, Serializable fileId) throws RepositoryException {
        Node fileToDeleteNode = session.getNodeByIdentifier(fileId.toString());
        Node trashFileIdNode = this.getOrCreateTrashFileIdNode(session, pentahoJcrConstants, fileId);
        trashFileIdNode.setProperty(pentahoJcrConstants.getPHO_DELETEDDATE(), Calendar.getInstance());
        trashFileIdNode.setProperty(pentahoJcrConstants.getPHO_ORIGPARENTFOLDERPATH(), this.pathConversionHelper.absToRel(fileToDeleteNode.getParent().getPath()));
        trashFileIdNode.setProperty(pentahoJcrConstants.getPHO_ORIGNAME(), fileToDeleteNode.getName());
        session.move(fileToDeleteNode.getPath(), trashFileIdNode.getPath() + "/" + fileToDeleteNode.getName());
    }

    private Node getOrCreateTrashFileIdNode(Session session, PentahoJcrConstants pentahoJcrConstants, Serializable fileId) throws RepositoryException {
        String prefix = session.getNamespacePrefix("http://www.pentaho.org/jcr/2.0") + ":";
        String folderName = fileId.toString();
        Node trashInternalFolderNode = this.getOrCreateTrashInternalFolderNode(session, pentahoJcrConstants);
        if (NodeHelper.hasNode(trashInternalFolderNode, prefix, folderName)) {
            return NodeHelper.getNode(trashInternalFolderNode, prefix, folderName);
        }
        return trashInternalFolderNode.addNode(prefix + folderName, pentahoJcrConstants.getPHO_NT_INTERNALFOLDER());
    }

    private Node legacyGetTrashFolderIdNode(Session session, PentahoJcrConstants pentahoJcrConstants, String origParentFolderPath) throws RepositoryException {
        String folderId = null;
        if (!session.itemExists(origParentFolderPath)) {
            throw new RuntimeException(Messages.getInstance().getString("DefaultDeleteHelper.ERROR_0001_PATH_NOT_FOUND"));
        }
        folderId = ((Node)session.getItem(origParentFolderPath)).getIdentifier();
        String prefix = session.getNamespacePrefix("http://www.pentaho.org/jcr/2.0") + ":";
        Node trashInternalFolderNode = this.getOrCreateTrashInternalFolderNode(session, pentahoJcrConstants);
        if (NodeHelper.hasNode(trashInternalFolderNode, prefix, folderId)) {
            return NodeHelper.getNode(trashInternalFolderNode, prefix, folderId);
        }
        return null;
    }

    private Node getOrCreateTrashInternalFolderNode(Session session, PentahoJcrConstants pentahoJcrConstants) throws RepositoryException {
        IPentahoSession pentahoSession = PentahoSessionHolder.getSession();
        String tenantId = (String)pentahoSession.getAttribute("org.pentaho.tenantId");
        Node userHomeFolderNode = (Node)session.getItem(ServerRepositoryPaths.getUserHomeFolderPath((ITenant)new Tenant(tenantId, Boolean.valueOf(true)), JcrStringHelper.fileNameEncode(PentahoSessionHolder.getSession().getName())));
        if (userHomeFolderNode.hasNode(FOLDER_NAME_TRASH)) {
            return userHomeFolderNode.getNode(FOLDER_NAME_TRASH);
        }
        return userHomeFolderNode.addNode(FOLDER_NAME_TRASH, pentahoJcrConstants.getPHO_NT_INTERNALFOLDER());
    }

    @Override
    public List<RepositoryFile> getDeletedFiles(Session session, PentahoJcrConstants pentahoJcrConstants, String origParentFolderPath, String filter) throws RepositoryException {
        Node trashNode = this.getOrCreateTrashInternalFolderNode(session, pentahoJcrConstants);
        QueryObjectModelFactory fac = session.getWorkspace().getQueryManager().getQOMFactory();
        String selectorName = "selector";
        Selector selector = fac.selector("nt:base", "selector");
        Comparison origParentFolderPathConstraint = fac.comparison((DynamicOperand)fac.propertyValue("selector", pentahoJcrConstants.getPHO_ORIGPARENTFOLDERPATH()), "jcr.operator.equal.to", (StaticOperand)fac.literal(session.getValueFactory().createValue(origParentFolderPath)));
        Comparison origNameConstraint = null;
        if (StringUtils.hasLength((String)filter)) {
            String convertedFilter = filter.replace('*', '%');
            origNameConstraint = fac.comparison((DynamicOperand)fac.propertyValue("selector", pentahoJcrConstants.getPHO_ORIGNAME()), "jcr.operator.like", (StaticOperand)fac.literal(session.getValueFactory().createValue(convertedFilter)));
        }
        DescendantNode descendantNodeConstraint = fac.descendantNode("selector", trashNode.getPath());
        And allConstraints = fac.and((Constraint)descendantNodeConstraint, (Constraint)origParentFolderPathConstraint);
        if (StringUtils.hasLength((String)filter)) {
            allConstraints = fac.and((Constraint)allConstraints, origNameConstraint);
        }
        QueryObjectModel query = fac.createQuery((Source)selector, (Constraint)allConstraints, null, null);
        QueryResult result = session.getWorkspace().getQueryManager().createQuery(query.getStatement(), "JCR-JQOM").execute();
        NodeIterator nodeIter = result.getNodes();
        ArrayList<RepositoryFile> deletedFiles = new ArrayList<RepositoryFile>();
        while (nodeIter.hasNext()) {
            Node trashFileIdNode = nodeIter.nextNode();
            if (trashFileIdNode.hasNodes()) {
                deletedFiles.add(this.nodeToDeletedFile(session, pentahoJcrConstants, trashFileIdNode.getNodes().nextNode()));
                continue;
            }
            throw new RuntimeException(Messages.getInstance().getString("DefaultDeleteHelper.ERROR_0002_NOT_CLEAN"));
        }
        HashSet<RepositoryFile> mergedDeletedFiles = new HashSet<RepositoryFile>();
        mergedDeletedFiles.addAll(deletedFiles);
        mergedDeletedFiles.addAll(this.legacyGetDeletedFiles(session, pentahoJcrConstants, this.pathConversionHelper.relToAbs(origParentFolderPath), filter));
        ArrayList<RepositoryFile> mergedList = new ArrayList<RepositoryFile>(mergedDeletedFiles);
        Collections.sort(mergedList);
        return mergedList;
    }

    private List<RepositoryFile> legacyGetDeletedFiles(Session session, PentahoJcrConstants pentahoJcrConstants, String origParentFolderPath, String filter) throws RepositoryException {
        ArrayList<RepositoryFile> deletedFiles = new ArrayList<RepositoryFile>();
        Node trashFolderIdNode = this.legacyGetTrashFolderIdNode(session, pentahoJcrConstants, origParentFolderPath);
        if (trashFolderIdNode == null) {
            return Collections.emptyList();
        }
        NodeIterator nodes = trashFolderIdNode.getNodes();
        while (nodes.hasNext()) {
            Node trashFileIdNode = nodes.nextNode();
            NodeIterator trashFileIdNodes = null;
            trashFileIdNodes = filter != null ? trashFileIdNode.getNodes(filter) : trashFileIdNode.getNodes();
            if (!trashFileIdNodes.hasNext()) continue;
            deletedFiles.add(this.nodeToDeletedFile(session, pentahoJcrConstants, trashFileIdNodes.nextNode()));
        }
        return deletedFiles;
    }

    @Override
    public List<RepositoryFile> getDeletedFiles(Session session, PentahoJcrConstants pentahoJcrConstants) throws RepositoryException {
        Node trashNode = this.getOrCreateTrashInternalFolderNode(session, pentahoJcrConstants);
        if (trashNode == null) {
            return Collections.emptyList();
        }
        ArrayList<RepositoryFile> deletedFiles = new ArrayList<RepositoryFile>();
        NodeIterator nodes = trashNode.getNodes();
        while (nodes.hasNext()) {
            NodeIterator trashFileNodeIterator;
            Node trashFileNode = nodes.nextNode();
            if (trashFileNode == null || trashFileNode.getProperty(pentahoJcrConstants.getPHO_DELETEDDATE()) == null || !(trashFileNodeIterator = trashFileNode.getNodes()).hasNext()) continue;
            deletedFiles.add(this.nodeToDeletedFile(session, pentahoJcrConstants, trashFileNodeIterator.nextNode()));
        }
        Collections.sort(deletedFiles);
        return deletedFiles;
    }

    private RepositoryFile nodeToDeletedFile(Session session, PentahoJcrConstants pentahoJcrConstants, Node trashFileNode) throws RepositoryException {
        RepositoryFile deletedFile = JcrRepositoryFileUtils.nodeToFile(session, pentahoJcrConstants, this.pathConversionHelper, this.lockHelper, trashFileNode);
        Date deletedDate = this.getDeletedDate(trashFileNode, pentahoJcrConstants);
        String originalParentFolderPath = this.getOriginalParentFolderPath(session, pentahoJcrConstants, trashFileNode, true);
        return new RepositoryFile.Builder(deletedFile).deletedDate(deletedDate).originalParentFolderPath(originalParentFolderPath).build();
    }

    private String getOriginalParentFolderPath(Session session, PentahoJcrConstants pentahoJcrConstants, Node trashFileNode, boolean relative) throws RepositoryException {
        if (trashFileNode.getParent().hasProperty(pentahoJcrConstants.getPHO_ORIGPARENTFOLDERPATH())) {
            String relPath = trashFileNode.getParent().getProperty(pentahoJcrConstants.getPHO_ORIGPARENTFOLDERPATH()).getString();
            return relative ? relPath : this.pathConversionHelper.relToAbs(relPath);
        }
        String prefix = session.getNamespacePrefix("http://www.pentaho.org/jcr/2.0");
        String originalParentFolderId = trashFileNode.getParent().getParent().getName().substring(prefix.length() + 1);
        String absPath = session.getNodeByIdentifier(originalParentFolderId).getPath();
        return relative ? this.pathConversionHelper.absToRel(absPath) : absPath;
    }

    private Date getDeletedDate(Node trashFileNode, PentahoJcrConstants pentahoJcrConstants) throws RepositoryException {
        if (trashFileNode.getParent().hasProperty(pentahoJcrConstants.getPHO_DELETEDDATE())) {
            return trashFileNode.getParent().getProperty(pentahoJcrConstants.getPHO_DELETEDDATE()).getDate().getTime();
        }
        return trashFileNode.getParent().getProperty(pentahoJcrConstants.getPHO_DELETEDDATE()).getDate().getTime();
    }

    @Override
    public void permanentlyDeleteFile(Session session, PentahoJcrConstants pentahoJcrConstants, Serializable fileId) throws RepositoryException {
        Assert.notNull((Object)fileId);
        Node fileNode = session.getNodeByIdentifier(fileId.toString());
        Assert.notNull((Object)fileNode);
        HashSet<RepositoryFile> referrers = new HashSet<RepositoryFile>();
        PropertyIterator refIter = fileNode.getReferences();
        if (refIter.hasNext()) {
            while (refIter.hasNext()) {
                RepositoryFile referrer = this.getReferrerFile(session, pentahoJcrConstants, refIter.nextProperty());
                if (referrer == null) continue;
                referrers.add(referrer);
            }
            if (!referrers.isEmpty()) {
                RepositoryFile referee = JcrRepositoryFileUtils.nodeToFile(session, pentahoJcrConstants, this.pathConversionHelper, this.lockHelper, fileNode);
                throw new RepositoryFileDaoReferentialIntegrityException(referee, referrers);
            }
        }
        if (fileNode.isLocked()) {
            Lock lock = session.getWorkspace().getLockManager().getLock(fileNode.getPath());
            this.lockHelper.removeLockToken(session, pentahoJcrConstants, lock);
        }
        IPentahoSession pentahoSession = PentahoSessionHolder.getSession();
        String tenantId = (String)pentahoSession.getAttribute("org.pentaho.tenantId");
        String trashFolder = ServerRepositoryPaths.getUserHomeFolderPath((ITenant)new Tenant(tenantId, Boolean.valueOf(true)), PentahoSessionHolder.getSession().getName()) + "/" + FOLDER_NAME_TRASH;
        if (fileNode.getPath().startsWith(trashFolder)) {
            fileNode.getParent().remove();
        } else {
            fileNode.remove();
        }
    }

    protected RepositoryFile getReferrerFile(Session session, PentahoJcrConstants pentahoJcrConstants, Property referrerProperty) throws RepositoryException {
        Node currentNode = referrerProperty.getParent();
        while (!currentNode.isNodeType(pentahoJcrConstants.getPHO_NT_PENTAHOHIERARCHYNODE())) {
            currentNode = currentNode.getParent();
        }
        if (currentNode.isNodeType(pentahoJcrConstants.getPHO_NT_PENTAHOFOLDER())) {
            return null;
        }
        return JcrRepositoryFileUtils.nodeToFile(session, pentahoJcrConstants, this.pathConversionHelper, this.lockHelper, currentNode);
    }

    @Override
    public void undeleteFile(Session session, PentahoJcrConstants pentahoJcrConstants, Serializable fileId) throws RepositoryException {
        Node fileToUndeleteNode = session.getNodeByIdentifier(fileId.toString());
        String trashFileIdNodePath = fileToUndeleteNode.getParent().getPath();
        String origParentFolderPath = this.getOriginalParentFolderPath(session, pentahoJcrConstants, fileToUndeleteNode, false);
        String absDestPath = origParentFolderPath + "/" + fileToUndeleteNode.getName();
        if (session.itemExists(absDestPath)) {
            RepositoryFile file = JcrRepositoryFileUtils.nodeToFile(session, pentahoJcrConstants, this.pathConversionHelper, this.lockHelper, (Node)session.getItem(absDestPath));
            throw new RepositoryFileDaoFileExistsException(file);
        }
        session.move(fileToUndeleteNode.getPath(), absDestPath);
        session.getItem(trashFileIdNodePath).remove();
    }

    @Override
    public String getOriginalParentFolderPath(Session session, PentahoJcrConstants pentahoJcrConstants, Serializable fileId) throws RepositoryException {
        return JcrStringHelper.pathDecode(this.getOriginalParentFolderPath(session, pentahoJcrConstants, session.getNodeByIdentifier(fileId.toString()), false));
    }
}

