/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.platform.repository.solution.filebased;

import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.net.URLDecoder;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.vfs.FileContent;
import org.apache.commons.vfs.FileName;
import org.apache.commons.vfs.FileObject;
import org.apache.commons.vfs.FileSelector;
import org.apache.commons.vfs.FileSystem;
import org.apache.commons.vfs.FileSystemException;
import org.apache.commons.vfs.FileType;
import org.apache.commons.vfs.NameScope;
import org.apache.commons.vfs.operations.FileOperations;
import org.pentaho.platform.api.repository2.unified.Converter;
import org.pentaho.platform.api.repository2.unified.IRepositoryContentConverterHandler;
import org.pentaho.platform.api.repository2.unified.IUnifiedRepository;
import org.pentaho.platform.api.repository2.unified.RepositoryFile;
import org.pentaho.platform.api.repository2.unified.UnifiedRepositoryException;
import org.pentaho.platform.api.repository2.unified.data.simple.SimpleRepositoryFileData;
import org.pentaho.platform.engine.core.system.PentahoSystem;
import org.pentaho.platform.repository.solution.filebased.SolutionRepositoryFileName;
import org.pentaho.platform.repository.solution.filebased.SolutionRepositoryVfsFileContent;

public class SolutionRepositoryVfsFileObject
implements FileObject {
    private String fileRef;
    private static final IUnifiedRepository REPOSITORY = (IUnifiedRepository)PentahoSystem.get(IUnifiedRepository.class, null);
    private FileContent content = null;
    private boolean fileInitialized;
    private RepositoryFile repositoryFile = null;
    private IRepositoryContentConverterHandler converterHandler;

    public SolutionRepositoryVfsFileObject(String fileRef) {
        this.fileRef = fileRef;
    }

    public IUnifiedRepository getRepository() {
        return REPOSITORY;
    }

    public IRepositoryContentConverterHandler getConverterHandler() {
        if (this.converterHandler == null) {
            this.converterHandler = (IRepositoryContentConverterHandler)PentahoSystem.get(IRepositoryContentConverterHandler.class);
        }
        return this.converterHandler;
    }

    public String getFileRef() {
        return this.fileRef;
    }

    public FileName getName() {
        this.initFile();
        FileType fileType = null;
        try {
            fileType = this.getType();
        }
        catch (Exception ex) {
            fileType = FileType.FOLDER;
        }
        return new SolutionRepositoryFileName(this.fileRef, fileType);
    }

    public URL getURL() throws FileSystemException {
        URL url = null;
        try {
            url = new URL("solution:" + this.fileRef);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return url;
    }

    private void initFile() {
        if (!this.fileInitialized) {
            String fileUrl = this.fileRef;
            try {
                fileUrl = URLDecoder.decode(fileUrl, Charset.defaultCharset().name());
            }
            catch (UnsupportedEncodingException e) {
                fileUrl = this.fileRef;
            }
            this.repositoryFile = REPOSITORY.getFile(fileUrl);
            this.fileInitialized = true;
        }
    }

    public boolean exists() throws FileSystemException {
        this.initFile();
        return this.repositoryFile != null;
    }

    public boolean isHidden() throws FileSystemException {
        return false;
    }

    public boolean isReadable() throws FileSystemException {
        return this.exists();
    }

    public boolean isWriteable() throws FileSystemException {
        return false;
    }

    public FileType getType() throws FileSystemException {
        return this.repositoryFile != null && !this.repositoryFile.isFolder() ? FileType.FILE : FileType.FOLDER;
    }

    public FileObject getParent() throws FileSystemException {
        return null;
    }

    public FileSystem getFileSystem() {
        return null;
    }

    public FileObject[] getChildren() throws FileSystemException {
        ArrayList<SolutionRepositoryVfsFileObject> fileList = new ArrayList<SolutionRepositoryVfsFileObject>();
        if (this.exists()) {
            for (RepositoryFile child : REPOSITORY.getChildren(this.repositoryFile.getId())) {
                SolutionRepositoryVfsFileObject fileInfo = new SolutionRepositoryVfsFileObject(child.getPath());
                fileList.add(fileInfo);
            }
        }
        return fileList.toArray(new FileObject[0]);
    }

    public FileObject getChild(String arg0) throws FileSystemException {
        return null;
    }

    public FileObject resolveFile(String arg0, NameScope arg1) throws FileSystemException {
        return null;
    }

    public FileObject resolveFile(String arg0) throws FileSystemException {
        return null;
    }

    public FileObject[] findFiles(FileSelector arg0) throws FileSystemException {
        return null;
    }

    public void findFiles(FileSelector arg0, boolean arg1, List arg2) throws FileSystemException {
    }

    public boolean delete() throws FileSystemException {
        return false;
    }

    public int delete(FileSelector arg0) throws FileSystemException {
        return 0;
    }

    public void createFolder() throws FileSystemException {
    }

    public void createFile() throws FileSystemException {
    }

    public void copyFrom(FileObject arg0, FileSelector arg1) throws FileSystemException {
    }

    public void moveTo(FileObject arg0) throws FileSystemException {
    }

    public boolean canRenameTo(FileObject arg0) {
        return false;
    }

    public FileContent getContent() throws FileSystemException {
        this.content = new SolutionRepositoryVfsFileContent(this);
        return this.content;
    }

    public void close() throws FileSystemException {
        if (this.content != null) {
            this.content.close();
            this.content = null;
        }
    }

    public void refresh() throws FileSystemException {
    }

    public boolean isAttached() {
        return false;
    }

    public boolean isContentOpen() {
        return this.content != null && this.content.isOpen();
    }

    public FileOperations getFileOperations() throws FileSystemException {
        return null;
    }

    public InputStream getInputStream() throws UnifiedRepositoryException, FileSystemException {
        InputStream inputStream = null;
        if (this.exists()) {
            Converter converter;
            String extension = FilenameUtils.getExtension((String)this.repositoryFile.getPath());
            if (this.getConverterHandler() != null && (converter = this.getConverterHandler().getConverter(extension)) != null) {
                inputStream = converter.convert(this.repositoryFile.getId());
            }
            if (inputStream == null) {
                inputStream = ((SimpleRepositoryFileData)REPOSITORY.getDataForRead(this.repositoryFile.getId(), SimpleRepositoryFileData.class)).getStream();
            }
        }
        return inputStream;
    }
}

