/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.azurenative;

import com.microsoft.windowsazure.storage.OperationContext;
import com.microsoft.windowsazure.storage.RequestResult;
import com.microsoft.windowsazure.storage.ResponseReceivedEvent;
import com.microsoft.windowsazure.storage.SendingRequestEvent;
import com.microsoft.windowsazure.storage.StorageEvent;
import java.net.HttpURLConnection;
import java.util.Date;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class SelfThrottlingIntercept {
    public static final Log LOG = LogFactory.getLog(SelfThrottlingIntercept.class);
    private final float readFactor;
    private final float writeFactor;
    private final OperationContext operationContext;
    private long lastE2Elatency;

    public SelfThrottlingIntercept(OperationContext operationContext, float readFactor, float writeFactor) {
        this.operationContext = operationContext;
        this.readFactor = readFactor;
        this.writeFactor = writeFactor;
    }

    public static void hook(OperationContext operationContext, float readFactor, float writeFactor) {
        SelfThrottlingIntercept throttler = new SelfThrottlingIntercept(operationContext, readFactor, writeFactor);
        ResponseReceivedListener responseListener = throttler.new ResponseReceivedListener();
        SendingRequestListener sendingListener = throttler.new SendingRequestListener();
        operationContext.getResponseReceivedEventHandler().addListener((StorageEvent)responseListener);
        operationContext.getSendingRequestEventHandler().addListener((StorageEvent)sendingListener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void responseReceived(ResponseReceivedEvent event) {
        RequestResult result = event.getRequestResult();
        Date startDate = result.getStartDate();
        Date stopDate = result.getStopDate();
        long elapsed = stopDate.getTime() - startDate.getTime();
        SelfThrottlingIntercept selfThrottlingIntercept = this;
        synchronized (selfThrottlingIntercept) {
            this.lastE2Elatency = elapsed;
        }
        if (LOG.isDebugEnabled()) {
            int statusCode = result.getStatusCode();
            String etag = result.getEtag();
            HttpURLConnection urlConnection = (HttpURLConnection)event.getConnectionObject();
            int contentLength = urlConnection.getContentLength();
            String requestMethod = urlConnection.getRequestMethod();
            long threadId = Thread.currentThread().getId();
            LOG.debug((Object)String.format("SelfThrottlingIntercept:: ResponseReceived: threadId=%d, Status=%d, Elapsed(ms)=%d, ETAG=%s, contentLength=%d, requestMethod=%s", threadId, statusCode, elapsed, etag, contentLength, requestMethod));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sendingRequest(SendingRequestEvent sendEvent) {
        float sleepMultiple;
        boolean operationIsRead;
        long lastLatency;
        SelfThrottlingIntercept selfThrottlingIntercept = this;
        synchronized (selfThrottlingIntercept) {
            lastLatency = this.lastE2Elatency;
        }
        HttpURLConnection urlConnection = (HttpURLConnection)sendEvent.getConnectionObject();
        if (urlConnection.getRequestMethod().equalsIgnoreCase("PUT")) {
            operationIsRead = false;
            sleepMultiple = 1.0f / this.writeFactor - 1.0f;
        } else {
            operationIsRead = true;
            sleepMultiple = 1.0f / this.readFactor - 1.0f;
        }
        long sleepDuration = (long)(sleepMultiple * (float)lastLatency);
        if (sleepDuration < 0L) {
            sleepDuration = 0L;
        }
        if (sleepDuration > 0L) {
            try {
                Thread.sleep(sleepDuration);
            }
            catch (InterruptedException ie) {
                // empty catch block
            }
            sendEvent.getRequestResult().setStartDate(new Date());
        }
        if (LOG.isDebugEnabled()) {
            boolean isFirstRequest = lastLatency == 0L;
            long threadId = Thread.currentThread().getId();
            LOG.debug((Object)String.format(" SelfThrottlingIntercept:: SendingRequest:   threadId=%d, requestType=%s, isFirstRequest=%b, sleepDuration=%d", threadId, operationIsRead ? "read " : "write", isFirstRequest, sleepDuration));
        }
    }

    class ResponseReceivedListener
    extends StorageEvent<ResponseReceivedEvent> {
        ResponseReceivedListener() {
        }

        public void eventOccurred(ResponseReceivedEvent event) {
            SelfThrottlingIntercept.this.responseReceived(event);
        }
    }

    class SendingRequestListener
    extends StorageEvent<SendingRequestEvent> {
        SendingRequestListener() {
        }

        public void eventOccurred(SendingRequestEvent event) {
            SelfThrottlingIntercept.this.sendingRequest(event);
        }
    }
}

