/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.azurenative;

import com.microsoft.windowsazure.storage.OperationContext;
import com.microsoft.windowsazure.storage.RequestResult;
import com.microsoft.windowsazure.storage.ResponseReceivedEvent;
import com.microsoft.windowsazure.storage.StorageEvent;
import org.apache.hadoop.fs.azurenative.AzureFileSystemInstrumentation;

public class ErrorMetricUpdater
extends StorageEvent<ResponseReceivedEvent> {
    private final AzureFileSystemInstrumentation instrumentation;
    private final OperationContext operationContext;

    private ErrorMetricUpdater(OperationContext operationContext, AzureFileSystemInstrumentation instrumentation) {
        this.instrumentation = instrumentation;
        this.operationContext = operationContext;
    }

    public static void hook(OperationContext operationContext, AzureFileSystemInstrumentation instrumentation) {
        ErrorMetricUpdater listener = new ErrorMetricUpdater(operationContext, instrumentation);
        operationContext.getResponseReceivedEventHandler().addListener((StorageEvent)listener);
    }

    public void eventOccurred(ResponseReceivedEvent eventArg) {
        RequestResult currentResult = this.operationContext.getLastResult();
        int statusCode = currentResult.getStatusCode();
        if (statusCode >= 400 && statusCode < 500 && statusCode != 404) {
            this.instrumentation.clientErrorEncountered();
        } else if (statusCode >= 500) {
            this.instrumentation.serverErrorEncountered();
        }
    }
}

