/*
 * Decompiled with CFR 0.152.
 */
package parquet.hadoop;

import java.io.IOException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.mapreduce.Job;
import org.apache.hadoop.mapreduce.JobContext;
import org.apache.hadoop.mapreduce.OutputCommitter;
import org.apache.hadoop.mapreduce.RecordWriter;
import org.apache.hadoop.mapreduce.TaskAttemptContext;
import org.apache.hadoop.mapreduce.lib.output.FileOutputFormat;
import parquet.Log;
import parquet.hadoop.BadConfigurationException;
import parquet.hadoop.CodecFactory;
import parquet.hadoop.ParquetFileWriter;
import parquet.hadoop.ParquetOutputCommitter;
import parquet.hadoop.ParquetRecordWriter;
import parquet.hadoop.api.WriteSupport;
import parquet.hadoop.codec.CodecConfig;
import parquet.hadoop.metadata.CompressionCodecName;
import parquet.hadoop.util.ContextUtil;

public class ParquetOutputFormat<T>
extends FileOutputFormat<Void, T> {
    private static final Log LOG = Log.getLog(ParquetOutputFormat.class);
    public static final String BLOCK_SIZE = "parquet.block.size";
    public static final String PAGE_SIZE = "parquet.page.size";
    public static final String COMPRESSION = "parquet.compression";
    public static final String WRITE_SUPPORT_CLASS = "parquet.write.support.class";
    public static final String DICTIONARY_PAGE_SIZE = "parquet.dictionary.page.size";
    public static final String ENABLE_DICTIONARY = "parquet.enable.dictionary";
    public static final String VALIDATION = "parquet.validation";
    private WriteSupport<T> writeSupport;
    private ParquetOutputCommitter committer;

    public static void setWriteSupportClass(Job job, Class<?> writeSupportClass) {
        ContextUtil.getConfiguration((JobContext)job).set(WRITE_SUPPORT_CLASS, writeSupportClass.getName());
    }

    public static Class<?> getWriteSupportClass(Configuration configuration) {
        String className = configuration.get(WRITE_SUPPORT_CLASS);
        if (className == null) {
            return null;
        }
        try {
            Class<?> writeSupportClass = Class.forName(className);
            if (!WriteSupport.class.isAssignableFrom(writeSupportClass)) {
                throw new BadConfigurationException("class " + className + " set in job conf at " + WRITE_SUPPORT_CLASS + " is not a subclass of WriteSupport");
            }
            return writeSupportClass;
        }
        catch (ClassNotFoundException e) {
            throw new BadConfigurationException("could not instanciate class " + className + " set in job conf at " + WRITE_SUPPORT_CLASS, e);
        }
    }

    public static void setBlockSize(Job job, int blockSize) {
        ContextUtil.getConfiguration((JobContext)job).setInt(BLOCK_SIZE, blockSize);
    }

    public static void setPageSize(Job job, int pageSize) {
        ContextUtil.getConfiguration((JobContext)job).setInt(PAGE_SIZE, pageSize);
    }

    public static void setDictionaryPageSize(Job job, int pageSize) {
        ContextUtil.getConfiguration((JobContext)job).setInt(DICTIONARY_PAGE_SIZE, pageSize);
    }

    public static void setCompression(Job job, CompressionCodecName compression) {
        ContextUtil.getConfiguration((JobContext)job).set(COMPRESSION, compression.name());
    }

    public static void setEnableDictionary(Job job, boolean enableDictionary) {
        ContextUtil.getConfiguration((JobContext)job).setBoolean(ENABLE_DICTIONARY, enableDictionary);
    }

    public static boolean getEnableDictionary(JobContext jobContext) {
        return ParquetOutputFormat.getEnableDictionary(ContextUtil.getConfiguration(jobContext));
    }

    public static int getBlockSize(JobContext jobContext) {
        return ParquetOutputFormat.getBlockSize(ContextUtil.getConfiguration(jobContext));
    }

    public static int getPageSize(JobContext jobContext) {
        return ParquetOutputFormat.getPageSize(ContextUtil.getConfiguration(jobContext));
    }

    public static int getDictionaryPageSize(JobContext jobContext) {
        return ParquetOutputFormat.getDictionaryPageSize(ContextUtil.getConfiguration(jobContext));
    }

    public static CompressionCodecName getCompression(JobContext jobContext) {
        return ParquetOutputFormat.getCompression(ContextUtil.getConfiguration(jobContext));
    }

    public static boolean isCompressionSet(JobContext jobContext) {
        return ParquetOutputFormat.isCompressionSet(ContextUtil.getConfiguration(jobContext));
    }

    public static void setValidation(JobContext jobContext, boolean validating) {
        ParquetOutputFormat.setValidation(ContextUtil.getConfiguration(jobContext), validating);
    }

    public static boolean getValidation(JobContext jobContext) {
        return ParquetOutputFormat.getValidation(ContextUtil.getConfiguration(jobContext));
    }

    public static boolean getEnableDictionary(Configuration configuration) {
        return configuration.getBoolean(ENABLE_DICTIONARY, true);
    }

    public static int getBlockSize(Configuration configuration) {
        return configuration.getInt(BLOCK_SIZE, 0x8000000);
    }

    public static int getPageSize(Configuration configuration) {
        return configuration.getInt(PAGE_SIZE, 0x100000);
    }

    public static int getDictionaryPageSize(Configuration configuration) {
        return configuration.getInt(DICTIONARY_PAGE_SIZE, 0x100000);
    }

    public static CompressionCodecName getCompression(Configuration configuration) {
        return CodecConfig.getParquetCompressionCodec(configuration);
    }

    public static boolean isCompressionSet(Configuration configuration) {
        return CodecConfig.isParquetCompressionSet(configuration);
    }

    public static void setValidation(Configuration configuration, boolean validating) {
        configuration.setBoolean(VALIDATION, validating);
    }

    public static boolean getValidation(Configuration configuration) {
        return configuration.getBoolean(VALIDATION, false);
    }

    private CompressionCodecName getCodec(TaskAttemptContext taskAttemptContext) {
        return CodecConfig.from(taskAttemptContext).getCodec();
    }

    public <S extends WriteSupport<T>> ParquetOutputFormat(S writeSupport) {
        this.writeSupport = writeSupport;
    }

    public <S extends WriteSupport<T>> ParquetOutputFormat() {
    }

    public RecordWriter<Void, T> getRecordWriter(TaskAttemptContext taskAttemptContext) throws IOException, InterruptedException {
        Configuration conf = ContextUtil.getConfiguration((JobContext)taskAttemptContext);
        CompressionCodecName codec = this.getCodec(taskAttemptContext);
        String extension = codec.getExtension() + ".parquet";
        Path file = this.getDefaultWorkFile(taskAttemptContext, extension);
        return this.getRecordWriter(conf, file, codec);
    }

    public RecordWriter<Void, T> getRecordWriter(TaskAttemptContext taskAttemptContext, Path file) throws IOException, InterruptedException {
        return this.getRecordWriter(ContextUtil.getConfiguration((JobContext)taskAttemptContext), file, this.getCodec(taskAttemptContext));
    }

    public RecordWriter<Void, T> getRecordWriter(Configuration conf, Path file, CompressionCodecName codec) throws IOException, InterruptedException {
        WriteSupport<T> writeSupport = this.getWriteSupport(conf);
        CodecFactory codecFactory = new CodecFactory(conf);
        int blockSize = ParquetOutputFormat.getBlockSize(conf);
        if (Log.INFO) {
            LOG.info("Parquet block size to " + blockSize);
        }
        int pageSize = ParquetOutputFormat.getPageSize(conf);
        if (Log.INFO) {
            LOG.info("Parquet page size to " + pageSize);
        }
        int dictionaryPageSize = ParquetOutputFormat.getDictionaryPageSize(conf);
        if (Log.INFO) {
            LOG.info("Parquet dictionary page size to " + pageSize);
        }
        boolean enableDictionary = ParquetOutputFormat.getEnableDictionary(conf);
        WriteSupport.WriteContext init = writeSupport.init(conf);
        ParquetFileWriter w = new ParquetFileWriter(conf, init.getSchema(), file);
        w.start();
        boolean validating = ParquetOutputFormat.getValidation(conf);
        if (Log.INFO) {
            LOG.info("Validation is " + (validating ? "on" : "off"));
        }
        return new ParquetRecordWriter<T>(w, writeSupport, init.getSchema(), init.getExtraMetaData(), blockSize, pageSize, codecFactory.getCompressor(codec, pageSize), dictionaryPageSize, enableDictionary, validating);
    }

    public WriteSupport<T> getWriteSupport(Configuration configuration) {
        if (this.writeSupport != null) {
            return this.writeSupport;
        }
        Class<?> writeSupportClass = ParquetOutputFormat.getWriteSupportClass(configuration);
        try {
            return (WriteSupport)writeSupportClass.newInstance();
        }
        catch (InstantiationException e) {
            throw new BadConfigurationException("could not instantiate write support class: " + writeSupportClass, e);
        }
        catch (IllegalAccessException e) {
            throw new BadConfigurationException("could not instantiate write support class: " + writeSupportClass, e);
        }
    }

    public OutputCommitter getOutputCommitter(TaskAttemptContext context) throws IOException {
        if (this.committer == null) {
            Path output = ParquetOutputFormat.getOutputPath((JobContext)context);
            this.committer = new ParquetOutputCommitter(output, context);
        }
        return this.committer;
    }
}

