/*
 * Decompiled with CFR 0.152.
 */
package parquet.column.values.rle;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import parquet.Ints;
import parquet.bytes.BytesUtils;
import parquet.column.values.ValuesReader;
import parquet.column.values.rle.RunLengthBitPackingHybridDecoder;
import parquet.io.ParquetDecodingException;

public class RunLengthBitPackingHybridValuesReader
extends ValuesReader {
    private final int bitWidth;
    private RunLengthBitPackingHybridDecoder decoder;

    public RunLengthBitPackingHybridValuesReader(int bitWidth) {
        this.bitWidth = bitWidth;
    }

    @Override
    public int initFromPage(long valueCountL, byte[] page, int offset) throws IOException {
        int valueCount = Ints.checkedCast(valueCountL);
        if (valueCount <= 0) {
            return offset;
        }
        ByteArrayInputStream in = new ByteArrayInputStream(page, offset, page.length - offset);
        int length = BytesUtils.readIntLittleEndian(in);
        this.decoder = new RunLengthBitPackingHybridDecoder(this.bitWidth, in);
        return offset + length + 4;
    }

    @Override
    public int readInteger() {
        try {
            return this.decoder.readInt();
        }
        catch (IOException e) {
            throw new ParquetDecodingException(e);
        }
    }

    @Override
    public void skip() {
        this.readInteger();
    }
}

