/*
 * Decompiled with CFR 0.152.
 */
package parquet.column.values.dictionary;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import parquet.Log;
import parquet.bytes.BytesUtils;
import parquet.column.Dictionary;
import parquet.column.values.ValuesReader;
import parquet.column.values.rle.RunLengthBitPackingHybridDecoder;
import parquet.io.ParquetDecodingException;
import parquet.io.api.Binary;

public class DictionaryValuesReader
extends ValuesReader {
    private static final Log LOG = Log.getLog(DictionaryValuesReader.class);
    private ByteArrayInputStream in;
    private Dictionary dictionary;
    private RunLengthBitPackingHybridDecoder decoder;

    public DictionaryValuesReader(Dictionary dictionary) {
        this.dictionary = dictionary;
    }

    @Override
    public int initFromPage(long valueCount, byte[] page, int offset) throws IOException {
        if (Log.DEBUG) {
            LOG.debug("init from page at offset " + offset + " for length " + (page.length - offset));
        }
        this.in = new ByteArrayInputStream(page, offset, page.length - offset);
        int bitWidth = BytesUtils.readIntLittleEndianOnOneByte(this.in);
        if (Log.DEBUG) {
            LOG.debug("bit width " + bitWidth);
        }
        this.decoder = new RunLengthBitPackingHybridDecoder(bitWidth, this.in);
        return page.length;
    }

    @Override
    public int readValueDictionaryId() {
        try {
            return this.decoder.readInt();
        }
        catch (IOException e) {
            throw new ParquetDecodingException(e);
        }
    }

    @Override
    public Binary readBytes() {
        try {
            return this.dictionary.decodeToBinary(this.decoder.readInt());
        }
        catch (IOException e) {
            throw new ParquetDecodingException(e);
        }
    }

    @Override
    public float readFloat() {
        try {
            return this.dictionary.decodeToFloat(this.decoder.readInt());
        }
        catch (IOException e) {
            throw new ParquetDecodingException(e);
        }
    }

    @Override
    public double readDouble() {
        try {
            return this.dictionary.decodeToDouble(this.decoder.readInt());
        }
        catch (IOException e) {
            throw new ParquetDecodingException(e);
        }
    }

    @Override
    public int readInteger() {
        try {
            return this.dictionary.decodeToInt(this.decoder.readInt());
        }
        catch (IOException e) {
            throw new ParquetDecodingException(e);
        }
    }

    @Override
    public long readLong() {
        try {
            return this.dictionary.decodeToLong(this.decoder.readInt());
        }
        catch (IOException e) {
            throw new ParquetDecodingException(e);
        }
    }

    @Override
    public void skip() {
        try {
            this.decoder.readInt();
        }
        catch (IOException e) {
            throw new ParquetDecodingException(e);
        }
    }
}

