/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.vfs.util;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.commons.io.IOUtils;
import org.apache.commons.vfs.FileObject;
import org.apache.commons.vfs.FileSystemException;
import org.apache.commons.vfs.FileSystemManager;
import org.pentaho.vfs.messages.Messages;

public class VfsHelper {
    private FileSystemManager fsManager = null;
    private FileObject rootFile = null;

    public VfsHelper(FileSystemManager fsManager, String root) throws FileSystemException {
        this.fsManager = fsManager;
        this.rootFile = fsManager.resolveFile(root);
    }

    public FileObject saveFile(String uri, InputStream is) throws IOException {
        if (this.fsManager != null) {
            FileObject savedFile = this.fsManager.resolveFile(uri);
            if (!savedFile.exists()) {
                throw new FileSystemException(Messages.getString("VfsHelper.fileDoesNotExist"));
            }
            IOUtils.copy((InputStream)is, (OutputStream)savedFile.getContent().getOutputStream());
            return savedFile;
        }
        throw new FileSystemException(Messages.getString("VfsHelper.operationFailed"));
    }

    public FileObject saveFileAs(String uri, InputStream is) throws FileSystemException, IOException {
        if (this.fsManager != null) {
            FileObject savedFile = this.fsManager.resolveFile(uri);
            if (!savedFile.exists()) {
                savedFile.createFile();
            }
            IOUtils.copy((InputStream)is, (OutputStream)savedFile.getContent().getOutputStream());
            return savedFile;
        }
        throw new FileSystemException(Messages.getString("VfsHelper.operationFailed"));
    }

    public FileObject getFileObject(String uri) throws FileSystemException {
        if (this.fsManager != null) {
            FileObject file = this.fsManager.resolveFile(uri);
            if (!file.exists()) {
                throw new FileSystemException(Messages.getString("VfsHelper.fileDoesNotExist"));
            }
            return file;
        }
        throw new FileSystemException(Messages.getString("VfsHelper.operationFailed"));
    }

    public byte[] getFileContentAsByteArray(FileObject fileObject) throws IOException {
        if (fileObject != null && fileObject.exists()) {
            IOUtils.toByteArray((InputStream)fileObject.getContent().getInputStream());
        }
        throw new FileSystemException(Messages.getString("VfsHelper.operationFailed"));
    }

    public byte[] getFileContentAsByteArray(String uri) throws IOException {
        if (this.fsManager != null) {
            return this.getFileContentAsByteArray(this.fsManager.resolveFile(uri));
        }
        throw new FileSystemException(Messages.getString("VfsHelper.operationFailed"));
    }

    public FileSystemManager getFsManager() {
        return this.fsManager;
    }

    public void setFsManager(FileSystemManager fsManager) {
        this.fsManager = fsManager;
    }

    public FileObject getRootFile() {
        return this.rootFile;
    }

    public void setRootFile(FileObject rootFile) {
        this.rootFile = rootFile;
    }
}

