/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sqoop.util;

import java.net.MalformedURLException;
import java.net.URL;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public final class JdbcUrl {
    public static final Log LOG = LogFactory.getLog((String)JdbcUrl.class.getName());

    private JdbcUrl() {
    }

    public static String getDatabaseName(String connectString) {
        try {
            String sanitizedString = null;
            int schemeEndOffset = connectString.indexOf("://");
            if (-1 == schemeEndOffset) {
                sanitizedString = "http://" + connectString;
                LOG.warn((Object)("Could not find database access scheme in connect string " + connectString));
            } else {
                sanitizedString = "http" + connectString.substring(schemeEndOffset);
            }
            URL connectUrl = new URL(sanitizedString);
            String databaseName = connectUrl.getPath();
            if (null == databaseName) {
                return null;
            }
            while (databaseName.startsWith("/")) {
                databaseName = databaseName.substring(1);
            }
            return databaseName;
        }
        catch (MalformedURLException mue) {
            LOG.error((Object)("Malformed connect string URL: " + connectString + "; reason is " + mue.toString()));
            return null;
        }
    }

    public static String getHostName(String connectString) {
        try {
            String sanitizedString = null;
            int schemeEndOffset = connectString.indexOf("://");
            sanitizedString = -1 == schemeEndOffset ? connectString : "http" + connectString.substring(schemeEndOffset);
            URL connectUrl = new URL(sanitizedString);
            return connectUrl.getHost();
        }
        catch (MalformedURLException mue) {
            LOG.error((Object)("Malformed connect string URL: " + connectString + "; reason is " + mue.toString()));
            return null;
        }
    }

    public static int getPort(String connectString) {
        try {
            String sanitizedString = null;
            int schemeEndOffset = connectString.indexOf("://");
            sanitizedString = -1 == schemeEndOffset ? connectString : "http" + connectString.substring(schemeEndOffset);
            URL connectUrl = new URL(sanitizedString);
            return connectUrl.getPort();
        }
        catch (MalformedURLException mue) {
            LOG.error((Object)("Malformed connect string URL: " + connectString + "; reason is " + mue.toString()));
            return -1;
        }
    }
}

