/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sqoop.mapreduce.db.netezza;

import java.io.IOException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.io.LongWritable;
import org.apache.hadoop.mapreduce.Mapper;
import org.apache.hcatalog.data.HCatRecord;
import org.apache.sqoop.lib.SqoopRecord;
import org.apache.sqoop.mapreduce.db.netezza.NetezzaExternalTableExportMapper;
import org.apache.sqoop.mapreduce.hcat.SqoopHCatExportHelper;

public class NetezzaExternalTableHCatExportMapper
extends NetezzaExternalTableExportMapper<LongWritable, HCatRecord> {
    private SqoopHCatExportHelper helper;
    public static final Log LOG = LogFactory.getLog((String)NetezzaExternalTableHCatExportMapper.class.getName());

    @Override
    protected void setup(Mapper.Context context) throws IOException, InterruptedException {
        super.setup(context);
        Configuration conf = context.getConfiguration();
        this.helper = new SqoopHCatExportHelper(conf);
        conf.setInt("sqoop.output.escaped.by", 39);
    }

    public void map(LongWritable key, HCatRecord hcr, Mapper.Context context) throws IOException, InterruptedException {
        SqoopRecord sqr = this.helper.convertToSqoopRecord(hcr);
        this.writeSqoopRecord(sqr);
        context.progress();
    }
}

