/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.common.profiler;

import com.orientechnologies.common.io.OIOUtils;
import com.orientechnologies.common.log.OLogManager;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;

public class OProfilerData {
    private long recordingFrom = 0L;
    private long recordingTo = Long.MAX_VALUE;
    private final Map<String, Long> counters = new HashMap<String, Long>();
    private final Map<String, OProfilerEntry> chronos = new HashMap<String, OProfilerEntry>();
    private final Map<String, OProfilerEntry> stats = new HashMap<String, OProfilerEntry>();
    private final Map<String, Object> hooks = new WeakHashMap<String, Object>();

    public OProfilerData() {
        this.recordingFrom = System.currentTimeMillis();
    }

    public void clear() {
        this.counters.clear();
        this.chronos.clear();
        this.stats.clear();
        this.hooks.clear();
    }

    public void clear(String iFilter) {
        ArrayList<String> names = new ArrayList<String>(this.hooks.keySet());
        Collections.sort(names);
        for (String k : names) {
            if (iFilter != null && !k.startsWith(iFilter)) continue;
            this.hooks.remove(k);
        }
        names = new ArrayList<String>(this.chronos.keySet());
        Collections.sort(names);
        for (String k : names) {
            if (iFilter != null && !k.startsWith(iFilter)) continue;
            this.chronos.remove(k);
        }
        names = new ArrayList<String>(this.stats.keySet());
        Collections.sort(names);
        for (String k : names) {
            if (iFilter != null && !k.startsWith(iFilter)) continue;
            this.stats.remove(k);
        }
        names = new ArrayList<String>(this.counters.keySet());
        Collections.sort(names);
        for (String k : names) {
            if (iFilter != null && !k.startsWith(iFilter)) continue;
            this.counters.remove(k);
        }
    }

    public long endRecording() {
        this.recordingTo = System.currentTimeMillis();
        return this.recordingTo;
    }

    public void mergeWith(OProfilerData iToMerge) {
        Object currentValue;
        if (iToMerge.recordingFrom < this.recordingFrom) {
            this.recordingFrom = iToMerge.recordingFrom;
        }
        if (iToMerge.recordingTo > this.recordingTo) {
            this.recordingTo = iToMerge.recordingTo;
        }
        for (Map.Entry<String, Long> entry : iToMerge.counters.entrySet()) {
            currentValue = this.counters.get(entry.getKey());
            if (currentValue == null) {
                currentValue = 0L;
            }
            this.counters.put(entry.getKey(), (Long)currentValue + entry.getValue());
        }
        for (Map.Entry<String, Object> entry : iToMerge.hooks.entrySet()) {
            currentValue = this.hooks.get(entry.getKey());
            if (currentValue == null) {
                currentValue = entry.getValue();
            } else {
                Object otherValue = entry.getValue();
                if (currentValue instanceof Long) {
                    currentValue = (Long)currentValue + (Long)otherValue;
                } else if (currentValue instanceof Integer) {
                    currentValue = (Integer)currentValue + (Integer)otherValue;
                } else if (currentValue instanceof Short) {
                    currentValue = (Short)currentValue + (Short)otherValue;
                } else if (currentValue instanceof Float) {
                    currentValue = Float.valueOf(((Float)currentValue).floatValue() + ((Float)otherValue).floatValue());
                } else if (currentValue instanceof Double) {
                    currentValue = (Double)currentValue + (Double)otherValue;
                } else if (currentValue instanceof Boolean) {
                    currentValue = otherValue;
                } else if (currentValue instanceof String) {
                    currentValue = otherValue;
                } else {
                    OLogManager.instance().warn((Object)this, "Type of value '%s' not support on profiler hook '%s' to merge with value: %s", currentValue, entry.getKey(), entry.getValue());
                }
            }
            this.hooks.put(entry.getKey(), currentValue);
        }
        this.mergeEntries(this.chronos, iToMerge.chronos);
        this.mergeEntries(this.stats, iToMerge.stats);
    }

    public void toJSON(StringBuilder buffer, String iFilter) {
        buffer.append("{");
        buffer.append(String.format("\"from\": %d,", this.recordingFrom));
        buffer.append(String.format("\"to\": %d,", this.recordingTo));
        buffer.append("\"hookValues\":{ ");
        ArrayList<String> names = new ArrayList<String>(this.hooks.keySet());
        Collections.sort(names);
        boolean firstItem = true;
        for (String k : names) {
            if (iFilter != null && !k.startsWith(iFilter)) continue;
            Object value = this.hooks.get(k);
            if (firstItem) {
                firstItem = false;
            } else {
                buffer.append(',');
            }
            if (value == null) {
                buffer.append(String.format("\"%s\":null", OIOUtils.encode(k)));
                continue;
            }
            if (value instanceof Number) {
                buffer.append(String.format("\"%s\":%d", OIOUtils.encode(k), value));
                continue;
            }
            if (value instanceof Boolean) {
                buffer.append(String.format("\"%s\":%s", OIOUtils.encode(k), value));
                continue;
            }
            buffer.append(String.format("\"%s\":\"%s\"", OIOUtils.encode(k), OIOUtils.encode(value)));
        }
        buffer.append("}");
        buffer.append(",\"chronos\":{");
        names = new ArrayList<String>(this.chronos.keySet());
        Collections.sort(names);
        firstItem = true;
        for (String k : names) {
            if (iFilter != null && !k.startsWith(iFilter)) continue;
            if (firstItem) {
                firstItem = false;
            } else {
                buffer.append(',');
            }
            this.chronos.get(k).toJSON(buffer);
        }
        buffer.append("}");
        buffer.append(",\"statistics\":{");
        names = new ArrayList<String>(this.stats.keySet());
        Collections.sort(names);
        firstItem = true;
        for (String k : names) {
            if (iFilter != null && !k.startsWith(iFilter)) continue;
            if (firstItem) {
                firstItem = false;
            } else {
                buffer.append(',');
            }
            this.stats.get(k).toJSON(buffer);
        }
        buffer.append("}");
        buffer.append(",\"counters\":{");
        names = new ArrayList<String>(this.counters.keySet());
        Collections.sort(names);
        firstItem = true;
        for (String k : names) {
            if (iFilter != null && !k.startsWith(iFilter)) continue;
            if (firstItem) {
                firstItem = false;
            } else {
                buffer.append(',');
            }
            buffer.append(String.format("\"%s\":%d", OIOUtils.encode(k), this.counters.get(k)));
        }
        buffer.append("}");
        buffer.append("}");
    }

    public String dump() {
        StringBuilder buffer = new StringBuilder();
        buffer.append("Dump of profiler data from " + new Date(this.recordingFrom) + " to " + new Date(this.recordingFrom) + "\n");
        buffer.append(this.dumpHookValues());
        buffer.append("\n");
        buffer.append(this.dumpCounters());
        buffer.append("\n\n");
        buffer.append(this.dumpStats());
        buffer.append("\n\n");
        buffer.append(this.dumpChronos());
        return buffer.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateCounter(String iStatName, long iPlus) {
        if (iStatName == null) {
            return;
        }
        Map<String, Long> map = this.counters;
        synchronized (map) {
            Long stat = this.counters.get(iStatName);
            long oldValue = stat == null ? 0L : stat;
            this.counters.put(iStatName, new Long(oldValue + iPlus));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getCounter(String iStatName) {
        if (iStatName == null) {
            return -1L;
        }
        Map<String, Long> map = this.counters;
        synchronized (map) {
            Long stat = this.counters.get(iStatName);
            if (stat == null) {
                return -1L;
            }
            return stat;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String dumpCounters() {
        Map<String, Long> map = this.counters;
        synchronized (map) {
            StringBuilder buffer = new StringBuilder();
            buffer.append("Dumping COUNTERS:");
            buffer.append(String.format("\n%50s +-------------------------------------------------------------------+", ""));
            buffer.append(String.format("\n%50s | Value                                                             |", "Name"));
            buffer.append(String.format("\n%50s +-------------------------------------------------------------------+", ""));
            ArrayList<String> keys = new ArrayList<String>(this.counters.keySet());
            Collections.sort(keys);
            for (String k : keys) {
                Long stat = this.counters.get(k);
                buffer.append(String.format("\n%-50s | %-65d |", k, stat));
            }
            buffer.append(String.format("\n%50s +-------------------------------------------------------------------+", ""));
            return buffer.toString();
        }
    }

    public long stopChrono(String iName, long iStartTime, String iPayload) {
        return this.updateEntry(this.chronos, iName, System.currentTimeMillis() - iStartTime, iPayload);
    }

    public String dumpChronos() {
        return this.dumpEntries(this.chronos, new StringBuilder("Dumping CHRONOS. Times in ms:"));
    }

    public long updateStat(String iName, long iValue) {
        return this.updateEntry(this.stats, iName, iValue, null);
    }

    public String dumpStats() {
        return this.dumpEntries(this.stats, new StringBuilder("Dumping STATISTICS. Times in ms:"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String dumpHookValues() {
        StringBuilder buffer = new StringBuilder();
        Map<String, Object> map = this.hooks;
        synchronized (map) {
            if (this.hooks.size() == 0) {
                return "";
            }
            buffer.append("Dumping HOOK VALUES:");
            buffer.append(String.format("\n%50s +-------------------------------------------------------------------+", ""));
            buffer.append(String.format("\n%50s | Value                                                             |", "Name"));
            buffer.append(String.format("\n%50s +-------------------------------------------------------------------+", ""));
            ArrayList<String> names = new ArrayList<String>(this.hooks.keySet());
            Collections.sort(names);
            for (String k : names) {
                Object hookValue = this.hooks.get(k);
                buffer.append(String.format("\n%-50s | %-65s |", k, hookValue != null ? hookValue.toString() : "null"));
            }
        }
        buffer.append(String.format("\n%50s +-------------------------------------------------------------------+", ""));
        return buffer.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object getHookValue(String iName) {
        if (iName == null) {
            return null;
        }
        Map<String, Object> map = this.hooks;
        synchronized (map) {
            return this.hooks.get(iName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setHookValues(Map<String, Object> iHooks) {
        Map<String, Object> map = this.hooks;
        synchronized (map) {
            this.hooks.clear();
            if (iHooks != null) {
                this.hooks.putAll(iHooks);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String[] getCountersAsString() {
        Map<String, Long> map = this.counters;
        synchronized (map) {
            String[] output = new String[this.counters.size()];
            int i = 0;
            for (Map.Entry<String, Long> entry : this.counters.entrySet()) {
                output[i++] = entry.getKey() + ": " + entry.getValue().toString();
            }
            return output;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String[] getChronosAsString() {
        Map<String, OProfilerEntry> map = this.chronos;
        synchronized (map) {
            String[] output = new String[this.chronos.size()];
            int i = 0;
            for (Map.Entry<String, OProfilerEntry> entry : this.chronos.entrySet()) {
                output[i++] = entry.getKey() + ": " + entry.getValue().toString();
            }
            return output;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String[] getStatsAsString() {
        Map<String, OProfilerEntry> map = this.stats;
        synchronized (map) {
            String[] output = new String[this.stats.size()];
            int i = 0;
            for (Map.Entry<String, OProfilerEntry> entry : this.stats.entrySet()) {
                output[i++] = entry.getKey() + ": " + entry.getValue().toString();
            }
            return output;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<String> getCounters() {
        Map<String, Long> map = this.counters;
        synchronized (map) {
            ArrayList<String> list = new ArrayList<String>(this.counters.keySet());
            Collections.sort(list);
            return list;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<String> getHooks() {
        Map<String, Object> map = this.hooks;
        synchronized (map) {
            ArrayList<String> list = new ArrayList<String>(this.hooks.keySet());
            Collections.sort(list);
            return list;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<String> getChronos() {
        Map<String, OProfilerEntry> map = this.chronos;
        synchronized (map) {
            ArrayList<String> list = new ArrayList<String>(this.chronos.keySet());
            Collections.sort(list);
            return list;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<String> getStats() {
        Map<String, OProfilerEntry> map = this.stats;
        synchronized (map) {
            ArrayList<String> list = new ArrayList<String>(this.stats.keySet());
            Collections.sort(list);
            return list;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OProfilerEntry getStat(String iStatName) {
        if (iStatName == null) {
            return null;
        }
        Map<String, OProfilerEntry> map = this.stats;
        synchronized (map) {
            return this.stats.get(iStatName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OProfilerEntry getChrono(String iChronoName) {
        if (iChronoName == null) {
            return null;
        }
        Map<String, OProfilerEntry> map = this.chronos;
        synchronized (map) {
            return this.chronos.get(iChronoName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected synchronized long updateEntry(Map<String, OProfilerEntry> iValues, String iName, long iValue, String iPayload) {
        Map<String, OProfilerEntry> map = iValues;
        synchronized (map) {
            OProfilerEntry c = iValues.get(iName);
            if (c == null) {
                c = new OProfilerEntry();
                iValues.put(iName, c);
            }
            c.name = iName;
            c.payLoad = iPayload;
            ++c.entries;
            c.last = iValue;
            c.total += c.last;
            c.average = c.total / c.entries;
            if (c.last < c.min) {
                c.min = c.last;
            }
            if (c.last > c.max) {
                c.max = c.last;
            }
            return c.last;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected synchronized String dumpEntries(Map<String, OProfilerEntry> iValues, StringBuilder iBuffer) {
        Map<String, OProfilerEntry> map = iValues;
        synchronized (map) {
            if (iValues.size() == 0) {
                return "";
            }
            iBuffer.append(String.format("\n%50s +-------------------------------------------------------------------+", ""));
            iBuffer.append(String.format("\n%50s | %10s %10s %10s %10s %10s %10s |", "Name", "last", "total", "min", "max", "average", "items"));
            iBuffer.append(String.format("\n%50s +-------------------------------------------------------------------+", ""));
            ArrayList<String> keys = new ArrayList<String>(iValues.keySet());
            Collections.sort(keys);
            for (String k : keys) {
                OProfilerEntry c = iValues.get(k);
                iBuffer.append(String.format("\n%-50s | %10d %10d %10d %10d %10d %10d |", k, c.last, c.total, c.min, c.max, c.average, c.entries));
            }
            iBuffer.append(String.format("\n%50s +-------------------------------------------------------------------+", ""));
            return iBuffer.toString();
        }
    }

    protected void mergeEntries(Map<String, OProfilerEntry> iMyEntries, Map<String, OProfilerEntry> iOthersEntries) {
        for (Map.Entry<String, OProfilerEntry> entry : iOthersEntries.entrySet()) {
            OProfilerEntry currentValue = iMyEntries.get(entry.getKey());
            if (currentValue == null) {
                currentValue = entry.getValue();
                iMyEntries.put(entry.getKey(), currentValue);
                continue;
            }
            currentValue.entries += entry.getValue().entries;
            currentValue.last = entry.getValue().last;
            currentValue.min = Math.min(currentValue.min, entry.getValue().min);
            currentValue.max = Math.max(currentValue.max, entry.getValue().max);
            currentValue.average = (currentValue.total + entry.getValue().total) / currentValue.entries;
            currentValue.total += entry.getValue().total;
        }
    }

    public boolean isInRange(long from, long to) {
        return this.recordingFrom >= from && this.recordingTo <= to;
    }

    public class OProfilerEntry {
        public String name = null;
        public long entries = 0L;
        public long last = 0L;
        public long min = 999999999L;
        public long max = 0L;
        public long average = 0L;
        public long total = 0L;
        public String payLoad;
        public String description;

        public void toJSON(StringBuilder buffer) {
            buffer.append(String.format("\"%s\":{", OIOUtils.encode(this.name)));
            buffer.append(String.format("\"%s\":%d,", "entries", this.entries));
            buffer.append(String.format("\"%s\":%d,", "last", this.last));
            buffer.append(String.format("\"%s\":%d,", "min", this.min));
            buffer.append(String.format("\"%s\":%d,", "max", this.max));
            buffer.append(String.format("\"%s\":%d,", "average", this.average));
            buffer.append(String.format("\"%s\":%d", "total", this.total));
            if (this.payLoad != null) {
                buffer.append(String.format("\"%s\":%d", "payload", this.payLoad));
            }
            buffer.append("}");
        }

        public String toString() {
            return String.format("Profiler entry [%s]: total=%d, average=%d, items=%d, last=%d, max=%d, min=%d", this.total, this.name, this.average, this.entries, this.last, this.max, this.min);
        }
    }
}

