/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.common.directmemory.collections;

import com.orientechnologies.common.directmemory.ODirectMemory;
import com.orientechnologies.common.directmemory.collections.ODirectMemoryHashMapBucket;
import com.orientechnologies.common.hash.OMurmurHash3;
import com.orientechnologies.common.serialization.types.OBinarySerializer;

public class ODirectMemoryHashMap<K, V> {
    private static final int SEED = 362498820;
    private static final int BUCKET_SIZE = 8;
    private static final int INITIAL_CAPACITY = 1024;
    private final ODirectMemory memory;
    private final OBinarySerializer<V> valueSerializer;
    private final OBinarySerializer<K> keySerializer;
    private final int bucketSize;
    private int size;
    private int capacity;
    private int nextThreshold;
    private ODirectMemoryHashMapBucket<K, V>[] entries;

    public ODirectMemoryHashMap(ODirectMemory memory, OBinarySerializer<V> valueSerializer, OBinarySerializer<K> keySerializer) {
        this(memory, valueSerializer, keySerializer, 1024, 8);
    }

    public ODirectMemoryHashMap(ODirectMemory memory, OBinarySerializer<V> valueSerializer, OBinarySerializer<K> keySerializer, int initialCapacity, int bucketSize) {
        this.memory = memory;
        this.valueSerializer = valueSerializer;
        this.keySerializer = keySerializer;
        this.size = 0;
        this.bucketSize = bucketSize;
        this.capacity = initialCapacity;
        this.nextThreshold = (int)((double)this.capacity * 0.75);
        this.entries = new ODirectMemoryHashMapBucket[this.capacity];
    }

    public V get(K key) {
        byte[] serializedKey = new byte[this.keySerializer.getObjectSize(key)];
        this.keySerializer.serialize(key, serializedKey, 0);
        long hashCode = OMurmurHash3.murmurHash3_x64_64(serializedKey, 362498820);
        long index = this.index(hashCode);
        ODirectMemoryHashMapBucket<K, V> bucket = this.entries[(int)index];
        if (bucket == null) {
            return null;
        }
        return bucket.find(serializedKey, hashCode);
    }

    public V remove(K key) {
        byte[] serializedKey = new byte[this.keySerializer.getObjectSize(key)];
        this.keySerializer.serialize(key, serializedKey, 0);
        long hashCode = OMurmurHash3.murmurHash3_x64_64(serializedKey, 362498820);
        long index = this.index(hashCode);
        ODirectMemoryHashMapBucket<K, V> bucket = this.entries[(int)index];
        if (bucket == null) {
            return null;
        }
        V removedValue = bucket.remove(serializedKey, hashCode);
        if (removedValue != null) {
            --this.size;
        }
        return removedValue;
    }

    public boolean put(K key, V value) {
        byte[] serializedKey = new byte[this.keySerializer.getObjectSize(key)];
        this.keySerializer.serialize(key, serializedKey, 0);
        long hashCode = OMurmurHash3.murmurHash3_x64_64(serializedKey, 362498820);
        long index = this.index(hashCode);
        ODirectMemoryHashMapBucket<K, V> bucket = this.entries[(int)index];
        if (bucket == null) {
            this.entries[(int)index] = bucket = new ODirectMemoryHashMapBucket(this.memory, this.bucketSize, this.valueSerializer);
        }
        if (this.entries[(int)index].put(serializedKey, hashCode, value)) {
            ++this.size;
        }
        if (this.size >= this.nextThreshold) {
            this.rehash();
        }
        return true;
    }

    private void rehash() {
        ODirectMemoryHashMapBucket<K, V>[] oldEntries = this.entries;
        int oldCapacity = this.capacity;
        try {
            this.capacity <<= 1;
            this.entries = new ODirectMemoryHashMapBucket[this.capacity];
            for (ODirectMemoryHashMapBucket<K, V> oldBucket : oldEntries) {
                if (oldBucket == null) continue;
                for (ODirectMemoryHashMapBucket.Entry oldEntry : oldBucket) {
                    long index = this.index(oldEntry.hashCode);
                    ODirectMemoryHashMapBucket<K, V> bucket = this.entries[(int)index];
                    if (bucket == null) {
                        this.entries[(int)index] = bucket = new ODirectMemoryHashMapBucket(this.memory, this.bucketSize, this.valueSerializer);
                    }
                    this.entries[(int)index].add(oldEntry.key, oldEntry.hashCode, oldEntry.value);
                }
            }
            for (ODirectMemoryHashMapBucket<K, V> oldBucket : oldEntries) {
                if (oldBucket == null) continue;
                oldBucket.clear();
            }
            this.nextThreshold = (int)((double)this.capacity * 0.75);
        }
        catch (OutOfMemoryError e) {
            for (ODirectMemoryHashMapBucket<K, V> bucket : this.entries) {
                if (bucket == null) continue;
                bucket.clear();
            }
            this.entries = oldEntries;
            this.capacity = oldCapacity;
            throw e;
        }
    }

    public long size() {
        return this.size;
    }

    public void clear() {
        for (ODirectMemoryHashMapBucket<K, V> bucket : this.entries) {
            if (bucket == null) continue;
            bucket.clear();
        }
        this.size = 0;
    }

    protected void finalize() throws Throwable {
        super.finalize();
        this.clear();
    }

    private long index(long hashCode) {
        return hashCode & (long)(this.capacity - 1);
    }
}

