/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.common.concur.lock;

import com.orientechnologies.common.concur.lock.OModificationOperationProhibitedException;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.locks.LockSupport;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;

public class OModificationLock {
    private volatile boolean veto = false;
    private volatile boolean throwException = false;
    private final ConcurrentLinkedQueue<Thread> waiters = new ConcurrentLinkedQueue();
    private final ReadWriteLock lock = new ReentrantReadWriteLock();

    public void requestModificationLock() {
        this.lock.readLock().lock();
        if (!this.veto) {
            return;
        }
        if (this.throwException) {
            this.lock.readLock().unlock();
            throw new OModificationOperationProhibitedException("Modification requests are prohibited");
        }
        boolean wasInterrupted = false;
        Thread thread = Thread.currentThread();
        this.waiters.add(thread);
        while (this.veto) {
            LockSupport.park(this);
            if (!Thread.interrupted()) continue;
            wasInterrupted = true;
        }
        this.waiters.remove(thread);
        if (wasInterrupted) {
            thread.interrupt();
        }
    }

    public void releaseModificationLock() {
        this.lock.readLock().unlock();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void prohibitModifications() {
        this.lock.writeLock().lock();
        try {
            this.throwException = false;
            this.veto = true;
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void prohibitModifications(boolean throwException) {
        this.lock.writeLock().lock();
        try {
            this.throwException = throwException;
            this.veto = true;
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    public void allowModifications() {
        this.veto = false;
        for (Thread thread : this.waiters) {
            LockSupport.unpark(thread);
        }
    }
}

