/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.hadoop.shim.mapr31;

import java.util.List;
import org.apache.commons.vfs.provider.FileProvider;
import org.apache.hive.jdbc.HiveDriver;
import org.pentaho.hadoop.shim.HadoopConfiguration;
import org.pentaho.hadoop.shim.HadoopConfigurationFileSystemManager;
import org.pentaho.hadoop.shim.api.Configuration;
import org.pentaho.hadoop.shim.common.CommonHadoopShim;
import org.pentaho.hadoop.shim.common.ShimUtils;
import org.pentaho.hadoop.shim.mapr31.MapR3DistributedCacheUtilImpl;
import org.pentaho.hdfs.vfs.MapRFileProvider;

public class HadoopShim
extends CommonHadoopShim {
    protected static final String SUPER_USER = "authentication.superuser.provider";
    protected static final String PROVIDER_LIST = "authentication.provider.list";
    protected static final String DEFAULT_CLUSTER = "/";
    protected static final String MFS_SCHEME = "maprfs://";
    protected static final String[] EMPTY_CONNECTION_INFO = new String[2];

    @Override
    public String[] getNamenodeConnectionInfo(Configuration c) {
        return EMPTY_CONNECTION_INFO;
    }

    @Override
    public String[] getJobtrackerConnectionInfo(Configuration c) {
        return EMPTY_CONNECTION_INFO;
    }

    @Override
    public void configureConnectionInformation(String namenodeHost, String namenodePort, String jobtrackerHost, String jobtrackerPort, Configuration conf, List<String> logMessages) throws Exception {
        if (namenodeHost == null || namenodeHost.length() == 0) {
            namenodeHost = DEFAULT_CLUSTER;
            logMessages.add("Using MapR default cluster for filesystem");
        } else if (namenodePort == null || namenodePort.trim().length() == 0) {
            logMessages.add("Using MapR CLDB named cluster: " + namenodeHost + " for filesystem");
            namenodeHost = "/mapr/" + namenodeHost;
        } else {
            logMessages.add("Using filesystem at " + namenodeHost + ":" + namenodePort);
            namenodeHost = namenodeHost + ":" + namenodePort;
        }
        if (jobtrackerHost == null || jobtrackerHost.trim().length() == 0) {
            jobtrackerHost = DEFAULT_CLUSTER;
            logMessages.add("Using MapR default cluster for job tracker");
        } else if (jobtrackerPort == null || jobtrackerPort.trim().length() == 0) {
            logMessages.add("Using MapR CLDB named cluster: " + jobtrackerHost + " for job tracker");
            jobtrackerHost = "/mapr/" + jobtrackerHost;
        } else {
            logMessages.add("Using job tracker at " + jobtrackerHost + ":" + jobtrackerPort);
            jobtrackerHost = jobtrackerHost + ":" + jobtrackerPort;
        }
        String fsDefaultName = MFS_SCHEME + namenodeHost;
        String jobTracker = MFS_SCHEME + jobtrackerHost;
        conf.set("fs.default.name", fsDefaultName);
        conf.set("mapred.job.tracker", jobTracker);
        conf.set("fs.maprfs.impl", "com.mapr.fs.MapRFileSystem");
    }

    @Override
    public Configuration createConfiguration() {
        Configuration result = super.createConfiguration();
        ShimUtils.asConfiguration(result).addResource("hbase-site.xml");
        return result;
    }

    @Override
    public void onLoad(HadoopConfiguration config, HadoopConfigurationFileSystemManager fsm) throws Exception {
        fsm.addProvider(config, "maprfs", config.getIdentifier(), (FileProvider)new MapRFileProvider());
        this.setDistributedCacheUtil(new MapR3DistributedCacheUtilImpl(config));
    }

    static {
        JDBC_DRIVER_MAP.put("hive2", HiveDriver.class);
    }
}

