/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.metastore;

import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.Properties;
import org.pentaho.di.core.Const;
import org.pentaho.di.core.database.DatabaseInterface;
import org.pentaho.di.core.database.DatabaseMeta;
import org.pentaho.di.core.exception.KettlePluginException;
import org.pentaho.di.core.plugins.DatabasePluginType;
import org.pentaho.di.core.plugins.PluginInterface;
import org.pentaho.di.core.plugins.PluginRegistry;
import org.pentaho.di.repository.StringObjectId;
import org.pentaho.metastore.api.IMetaStore;
import org.pentaho.metastore.api.IMetaStoreAttribute;
import org.pentaho.metastore.api.IMetaStoreElement;
import org.pentaho.metastore.api.IMetaStoreElementType;
import org.pentaho.metastore.api.exceptions.MetaStoreException;
import org.pentaho.metastore.util.MetaStoreUtil;

public class DatabaseMetaStoreUtil
extends MetaStoreUtil {
    public static List<DatabaseMeta> getDatabaseElements(IMetaStore metaStore) throws MetaStoreException {
        ArrayList<DatabaseMeta> databases = new ArrayList<DatabaseMeta>();
        IMetaStoreElementType elementType = metaStore.getElementTypeByName("pentaho", "Database connection");
        if (elementType == null) {
            return databases;
        }
        List elements = metaStore.getElements("pentaho", elementType);
        for (IMetaStoreElement element : elements) {
            try {
                DatabaseMeta databaseMeta = DatabaseMetaStoreUtil.loadDatabaseMetaFromDatabaseElement(metaStore, element);
                databases.add(databaseMeta);
            }
            catch (Exception e) {
                throw new MetaStoreException("Unable to load database from element with name '" + element.getName() + "' and type '" + elementType.getName() + "'", (Throwable)e);
            }
        }
        return databases;
    }

    public static void createDatabaseElement(IMetaStore metaStore, DatabaseMeta databaseMeta) throws MetaStoreException {
        IMetaStoreElementType elementType;
        if (!metaStore.namespaceExists("pentaho")) {
            metaStore.createNamespace("pentaho");
        }
        if ((elementType = metaStore.getElementTypeByName("pentaho", "Database connection")) == null) {
            elementType = DatabaseMetaStoreUtil.populateDatabaseElementType(metaStore);
            metaStore.createElementType("pentaho", elementType);
        }
        IMetaStoreElement databaseElement = DatabaseMetaStoreUtil.populateDatabaseElement(metaStore, databaseMeta);
        metaStore.createElement("pentaho", databaseElement.getElementType(), databaseElement);
    }

    public static IMetaStoreElementType populateDatabaseElementType(IMetaStore metaStore) throws MetaStoreException {
        IMetaStoreElementType elementType = metaStore.newElementType("pentaho");
        elementType.setName("Database connection");
        elementType.setDescription("This is the official central database connection metadata");
        return elementType;
    }

    public static IMetaStoreElement populateDatabaseElement(IMetaStore metaStore, DatabaseMeta databaseMeta) throws MetaStoreException {
        if (!metaStore.namespaceExists("pentaho")) {
            throw new MetaStoreException("Namespace 'pentaho' doesn't exist.");
        }
        IMetaStoreElementType elementType = metaStore.getElementTypeByName("pentaho", "Database connection");
        if (elementType == null) {
            throw new MetaStoreException("Unable to find the database connection type");
        }
        elementType = DatabaseMetaStoreUtil.populateDatabaseElementType(metaStore);
        IMetaStoreElement element = metaStore.newElement(elementType, databaseMeta.getName(), null);
        element.addChild(metaStore.newAttribute("plugin_id", (Object)databaseMeta.getPluginId()));
        element.setName(databaseMeta.getName());
        element.addChild(metaStore.newAttribute("description", (Object)databaseMeta.getDescription()));
        element.addChild(metaStore.newAttribute("access_type", (Object)databaseMeta.getAccessTypeDesc()));
        element.addChild(metaStore.newAttribute("hostname", (Object)databaseMeta.getHostname()));
        element.addChild(metaStore.newAttribute("port", (Object)databaseMeta.getDatabasePortNumberString()));
        element.addChild(metaStore.newAttribute("database_name", (Object)databaseMeta.getDatabaseName()));
        element.addChild(metaStore.newAttribute("username", (Object)databaseMeta.getUsername()));
        element.addChild(metaStore.newAttribute("password", (Object)metaStore.getTwoWayPasswordEncoder().encode((CharSequence)databaseMeta.getPassword())));
        element.addChild(metaStore.newAttribute("servername", (Object)databaseMeta.getServername()));
        element.addChild(metaStore.newAttribute("data_tablespace", (Object)databaseMeta.getDataTablespace()));
        element.addChild(metaStore.newAttribute("index_tablespace", (Object)databaseMeta.getIndexTablespace()));
        IMetaStoreAttribute attributesChild = metaStore.newAttribute("attributes", null);
        element.addChild(attributesChild);
        Properties attributes = databaseMeta.getAttributes();
        Enumeration<Object> keys = databaseMeta.getAttributes().keys();
        while (keys.hasMoreElements()) {
            String code = (String)keys.nextElement();
            String attribute = (String)attributes.get(code);
            attributesChild.addChild(metaStore.newAttribute(code, (Object)attribute));
        }
        element.addChild(metaStore.newAttribute("driver_class", (Object)databaseMeta.getDriverClass()));
        try {
            element.addChild(metaStore.newAttribute("jdbc_url", (Object)databaseMeta.getURL()));
        }
        catch (Exception e) {
            throw new MetaStoreException("Unable to assemble URL from database '" + databaseMeta.getName() + "'", (Throwable)e);
        }
        return element;
    }

    public static DatabaseMeta loadDatabaseMetaFromDatabaseElement(IMetaStore metaStore, IMetaStoreElement element) throws KettlePluginException {
        DatabaseMeta databaseMeta = new DatabaseMeta();
        PluginRegistry pluginRegistry = PluginRegistry.getInstance();
        String pluginId = DatabaseMetaStoreUtil.getChildString((IMetaStoreAttribute)element, (String)"plugin_id");
        String driverClassName = DatabaseMetaStoreUtil.getChildString((IMetaStoreAttribute)element, (String)"driver_class");
        if (Const.isEmpty(pluginId) && Const.isEmpty(driverClassName)) {
            throw new KettlePluginException("The attributes 'plugin_id' and 'driver_class' can't be both empty");
        }
        if (Const.isEmpty(pluginId)) {
            List plugins = pluginRegistry.getPlugins(DatabasePluginType.class);
            for (PluginInterface plugin : plugins) {
                DatabaseInterface databaseInterface = (DatabaseInterface)pluginRegistry.loadClass(plugin);
                if (!driverClassName.equalsIgnoreCase(databaseInterface.getDriverClass())) continue;
                pluginId = plugin.getIds()[0];
            }
        }
        if (Const.isEmpty(pluginId)) {
            throw new KettlePluginException("The 'plugin_id' attribute could not be determined using 'driver_class' value '" + driverClassName + "'");
        }
        PluginInterface plugin = PluginRegistry.getInstance().getPlugin(DatabasePluginType.class, pluginId);
        DatabaseInterface databaseInterface = (DatabaseInterface)PluginRegistry.getInstance().loadClass(plugin);
        databaseInterface.setPluginId(pluginId);
        databaseMeta.setDatabaseInterface(databaseInterface);
        databaseMeta.setObjectId(new StringObjectId(element.getId()));
        databaseMeta.setName(element.getName());
        databaseMeta.setDescription(DatabaseMetaStoreUtil.getChildString((IMetaStoreAttribute)element, (String)"description"));
        String accessTypeString = DatabaseMetaStoreUtil.getChildString((IMetaStoreAttribute)element, (String)"access_type");
        if (Const.isEmpty(accessTypeString)) {
            accessTypeString = DatabaseMeta.getAccessTypeDesc(0);
        }
        databaseMeta.setAccessType(DatabaseMeta.getAccessType(accessTypeString));
        databaseMeta.setHostname(DatabaseMetaStoreUtil.getChildString((IMetaStoreAttribute)element, (String)"hostname"));
        databaseMeta.setDBPort(DatabaseMetaStoreUtil.getChildString((IMetaStoreAttribute)element, (String)"port"));
        databaseMeta.setDBName(DatabaseMetaStoreUtil.getChildString((IMetaStoreAttribute)element, (String)"database_name"));
        databaseMeta.setUsername(DatabaseMetaStoreUtil.getChildString((IMetaStoreAttribute)element, (String)"username"));
        databaseMeta.setPassword(metaStore.getTwoWayPasswordEncoder().decode((CharSequence)DatabaseMetaStoreUtil.getChildString((IMetaStoreAttribute)element, (String)"password")));
        databaseMeta.setServername(DatabaseMetaStoreUtil.getChildString((IMetaStoreAttribute)element, (String)"servername"));
        databaseMeta.setDataTablespace(DatabaseMetaStoreUtil.getChildString((IMetaStoreAttribute)element, (String)"data_tablespace"));
        databaseMeta.setIndexTablespace(DatabaseMetaStoreUtil.getChildString((IMetaStoreAttribute)element, (String)"index_tablespace"));
        IMetaStoreAttribute attributesChild = element.getChild("attributes");
        if (attributesChild != null) {
            Properties attributes = databaseMeta.getAttributes();
            for (IMetaStoreAttribute attr : attributesChild.getChildren()) {
                String code = attr.getId();
                String value = DatabaseMetaStoreUtil.getAttributeString((IMetaStoreAttribute)attr);
                attributes.put(code, Const.NVL(value, ""));
            }
        }
        return databaseMeta;
    }
}

