/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.core.row;

import com.wcohen.ss.Jaro;
import com.wcohen.ss.JaroWinkler;
import com.wcohen.ss.NeedlemanWunsch;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.math.BigDecimal;
import java.math.MathContext;
import java.security.MessageDigest;
import java.util.Calendar;
import java.util.Date;
import java.util.Locale;
import java.util.zip.Adler32;
import java.util.zip.CRC32;
import java.util.zip.CheckedInputStream;
import org.apache.commons.codec.language.DoubleMetaphone;
import org.apache.commons.codec.language.Metaphone;
import org.apache.commons.codec.language.RefinedSoundex;
import org.apache.commons.codec.language.Soundex;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.vfs.FileObject;
import org.apache.commons.vfs.provider.local.LocalFile;
import org.pentaho.di.core.Const;
import org.pentaho.di.core.exception.KettleValueException;
import org.pentaho.di.core.fileinput.CharsetToolkit;
import org.pentaho.di.core.row.ValueMetaInterface;
import org.pentaho.di.core.util.Utils;
import org.pentaho.di.core.vfs.KettleVFS;
import org.pentaho.di.core.xml.XMLCheck;

public class ValueDataUtil {
    @Deprecated
    public static final String leftTrim(String string) {
        return Const.ltrim(string);
    }

    @Deprecated
    public static final String rightTrim(String string) {
        return Const.rtrim(string);
    }

    @Deprecated
    public static final boolean isSpace(char c) {
        return Const.isSpace(c);
    }

    @Deprecated
    public static final String trim(String string) {
        return Const.trim(string);
    }

    public static Long getLevenshtein_Distance(ValueMetaInterface metaA, Object dataA, ValueMetaInterface metaB, Object dataB) {
        if (dataA == null || dataB == null) {
            return null;
        }
        return new Long(StringUtils.getLevenshteinDistance((String)dataA.toString(), (String)dataB.toString()));
    }

    public static Long getDamerauLevenshtein_Distance(ValueMetaInterface metaA, Object dataA, ValueMetaInterface metaB, Object dataB) {
        if (dataA == null || dataB == null) {
            return null;
        }
        return new Long(Utils.getDamerauLevenshteinDistance(dataA.toString(), dataB.toString()));
    }

    public static Long getNeedlemanWunsch_Distance(ValueMetaInterface metaA, Object dataA, ValueMetaInterface metaB, Object dataB) {
        if (dataA == null || dataB == null) {
            return null;
        }
        return new Long((int)new NeedlemanWunsch().score(dataA.toString(), dataB.toString()));
    }

    public static Double getJaro_Similitude(ValueMetaInterface metaA, Object dataA, ValueMetaInterface metaB, Object dataB) {
        if (dataA == null || dataB == null) {
            return null;
        }
        return new Double(new Jaro().score(dataA.toString(), dataB.toString()));
    }

    public static Double getJaroWinkler_Similitude(ValueMetaInterface metaA, Object dataA, ValueMetaInterface metaB, Object dataB) {
        if (dataA == null || dataB == null) {
            return null;
        }
        return new Double(new JaroWinkler().score(dataA.toString(), dataB.toString()));
    }

    public static String get_Metaphone(ValueMetaInterface metaA, Object dataA) {
        if (dataA == null) {
            return null;
        }
        return new Metaphone().metaphone(dataA.toString());
    }

    public static String get_Double_Metaphone(ValueMetaInterface metaA, Object dataA) {
        if (dataA == null) {
            return null;
        }
        return new DoubleMetaphone().doubleMetaphone(dataA.toString());
    }

    public static String get_SoundEx(ValueMetaInterface metaA, Object dataA) {
        if (dataA == null) {
            return null;
        }
        return new Soundex().encode(dataA.toString());
    }

    public static String get_RefinedSoundEx(ValueMetaInterface metaA, Object dataA) {
        if (dataA == null) {
            return null;
        }
        return new RefinedSoundex().encode(dataA.toString());
    }

    public static String initCap(ValueMetaInterface metaA, Object dataA) {
        if (dataA == null) {
            return null;
        }
        return Const.initCap(dataA.toString());
    }

    public static String upperCase(ValueMetaInterface metaA, Object dataA) {
        if (dataA == null) {
            return null;
        }
        return dataA.toString().toUpperCase();
    }

    public static String lowerCase(ValueMetaInterface metaA, Object dataA) {
        if (dataA == null) {
            return null;
        }
        return dataA.toString().toLowerCase();
    }

    public static String escapeXML(ValueMetaInterface metaA, Object dataA) {
        if (dataA == null) {
            return null;
        }
        return Const.escapeXML(dataA.toString());
    }

    public static String unEscapeXML(ValueMetaInterface metaA, Object dataA) {
        if (dataA == null) {
            return null;
        }
        return Const.unEscapeXml(dataA.toString());
    }

    public static String escapeHTML(ValueMetaInterface metaA, Object dataA) {
        if (dataA == null) {
            return null;
        }
        return Const.escapeHtml(dataA.toString());
    }

    public static String unEscapeHTML(ValueMetaInterface metaA, Object dataA) {
        if (dataA == null) {
            return null;
        }
        return Const.unEscapeHtml(dataA.toString());
    }

    public static String escapeSQL(ValueMetaInterface metaA, Object dataA) {
        if (dataA == null) {
            return null;
        }
        return Const.escapeSQL(dataA.toString());
    }

    public static String useCDATA(ValueMetaInterface metaA, Object dataA) {
        if (dataA == null) {
            return null;
        }
        return "<![CDATA[" + dataA.toString() + "]]>";
    }

    public static String removeCR(ValueMetaInterface metaA, Object dataA) {
        if (dataA == null) {
            return null;
        }
        return Const.removeCR(dataA.toString());
    }

    public static String removeLF(ValueMetaInterface metaA, Object dataA) {
        if (dataA == null) {
            return null;
        }
        return Const.removeLF(dataA.toString());
    }

    public static String removeCRLF(ValueMetaInterface metaA, Object dataA) {
        if (dataA == null) {
            return null;
        }
        return Const.removeCRLF(dataA.toString());
    }

    public static String removeTAB(ValueMetaInterface metaA, Object dataA) {
        if (dataA == null) {
            return null;
        }
        return Const.removeTAB(dataA.toString());
    }

    public static String getDigits(ValueMetaInterface metaA, Object dataA) {
        if (dataA == null) {
            return null;
        }
        return Const.getDigitsOnly(dataA.toString());
    }

    public static String removeDigits(ValueMetaInterface metaA, Object dataA) {
        if (dataA == null) {
            return null;
        }
        return Const.removeDigits(dataA.toString());
    }

    public static long stringLen(ValueMetaInterface metaA, Object dataA) {
        if (dataA == null) {
            return 0L;
        }
        return dataA.toString().length();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String createChecksum(ValueMetaInterface metaA, Object dataA, String type) {
        String md5Hash = null;
        FileInputStream in = null;
        try {
            in = new FileInputStream(dataA.toString());
            int bytes = in.available();
            byte[] buffer = new byte[bytes];
            in.read(buffer);
            StringBuffer md5HashBuff = new StringBuffer(32);
            byte[] b = MessageDigest.getInstance(type).digest(buffer);
            int len = b.length;
            for (int x = 0; x < len; ++x) {
                md5HashBuff.append(String.format("%02x", b[x]));
            }
            md5Hash = md5HashBuff.toString();
        }
        catch (Exception e) {
        }
        finally {
            try {
                if (in != null) {
                    in.close();
                }
            }
            catch (Exception e) {}
        }
        return md5Hash;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Long ChecksumCRC32(ValueMetaInterface metaA, Object dataA) {
        long checksum = 0L;
        FileObject file = null;
        try {
            file = KettleVFS.getFileObject(dataA.toString());
            CheckedInputStream cis = null;
            cis = new CheckedInputStream(((LocalFile)file).getInputStream(), new CRC32());
            byte[] buf = new byte[128];
            int readSize = 0;
            while ((readSize = cis.read(buf)) >= 0) {
            }
            checksum = cis.getChecksum().getValue();
        }
        catch (Exception e) {
        }
        finally {
            if (file != null) {
                try {
                    file.close();
                    file = null;
                }
                catch (Exception e) {}
            }
        }
        return checksum;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Long ChecksumAdler32(ValueMetaInterface metaA, Object dataA) {
        long checksum = 0L;
        FileObject file = null;
        try {
            file = KettleVFS.getFileObject(dataA.toString());
            CheckedInputStream cis = null;
            cis = new CheckedInputStream(((LocalFile)file).getInputStream(), new Adler32());
            byte[] buf = new byte[128];
            int readSize = 0;
            while ((readSize = cis.read(buf)) >= 0) {
            }
            checksum = cis.getChecksum().getValue();
        }
        catch (Exception e) {
        }
        finally {
            if (file != null) {
                try {
                    file.close();
                    file = null;
                }
                catch (Exception e) {}
            }
        }
        return checksum;
    }

    public static Object plus(ValueMetaInterface metaA, Object dataA, ValueMetaInterface metaB, Object dataB) throws KettleValueException {
        if (dataA == null || dataB == null) {
            return null;
        }
        switch (metaA.getType()) {
            case 2: {
                return metaA.getString(dataA) + metaB.getString(dataB);
            }
            case 1: {
                return new Double(metaA.getNumber(dataA) + metaB.getNumber(dataB));
            }
            case 5: {
                return new Long(metaA.getInteger(dataA) + metaB.getInteger(dataB));
            }
            case 4: {
                return metaA.getBoolean(dataA) != false || metaB.getBoolean(dataB) != false;
            }
            case 6: {
                return metaA.getBigNumber(dataA).add(metaB.getBigNumber(dataB));
            }
        }
        throw new KettleValueException("The 'plus' function only works on numeric data and Strings.");
    }

    public static Object plus3(ValueMetaInterface metaA, Object dataA, ValueMetaInterface metaB, Object dataB, ValueMetaInterface metaC, Object dataC) throws KettleValueException {
        if (dataA == null || dataB == null || dataC == null) {
            return null;
        }
        switch (metaA.getType()) {
            case 2: {
                return metaA.getString(dataA) + metaB.getString(dataB) + metaC.getString(dataC);
            }
            case 1: {
                return new Double(metaA.getNumber(dataA) + metaB.getNumber(dataB) + metaC.getNumber(dataC));
            }
            case 5: {
                return new Long(metaA.getInteger(dataA) + metaB.getInteger(dataB) + metaC.getInteger(dataC));
            }
            case 4: {
                return metaA.getBoolean(dataA) != false || metaB.getBoolean(dataB) != false || metaB.getBoolean(dataC) != false;
            }
            case 6: {
                return metaA.getBigNumber(dataA).add(metaB.getBigNumber(dataB).add(metaC.getBigNumber(dataC)));
            }
        }
        throw new KettleValueException("The 'plus' function only works on numeric data and Strings.");
    }

    public static Object sum(ValueMetaInterface metaA, Object dataA, ValueMetaInterface metaB, Object dataB) throws KettleValueException {
        if (dataA == null && dataB == null) {
            return null;
        }
        if (dataA == null && dataB != null) {
            return metaA.convertData(metaB, dataB);
        }
        if (dataA != null && dataB == null) {
            return dataA;
        }
        return ValueDataUtil.plus(metaA, dataA, metaB, dataB);
    }

    public static Object loadFileContentInBinary(ValueMetaInterface metaA, Object dataA) throws KettleValueException {
        if (dataA == null) {
            return null;
        }
        FileObject file = null;
        FileInputStream fis = null;
        try {
            file = KettleVFS.getFileObject(dataA.toString());
            fis = (FileInputStream)((LocalFile)file).getInputStream();
            int fileSize = (int)file.getContent().getSize();
            byte[] content = Const.createByteArray(fileSize);
            fis.read(content, 0, fileSize);
            byte[] byArray = content;
            return byArray;
        }
        catch (Exception e) {
            throw new KettleValueException(e);
        }
        finally {
            try {
                if (fis != null) {
                    fis.close();
                }
                fis = null;
                if (file != null) {
                    file.close();
                }
                file = null;
            }
            catch (Exception e) {}
        }
    }

    public static Object minus(ValueMetaInterface metaA, Object dataA, ValueMetaInterface metaB, Object dataB) throws KettleValueException {
        if (dataA == null || dataB == null) {
            return null;
        }
        switch (metaA.getType()) {
            case 1: {
                return new Double(metaA.getNumber(dataA) - metaB.getNumber(dataB));
            }
            case 5: {
                return new Long(metaA.getInteger(dataA) - metaB.getInteger(dataB));
            }
            case 6: {
                return metaA.getBigNumber(dataA).subtract(metaB.getBigNumber(dataB));
            }
        }
        return new Long(metaA.getInteger(dataA) - metaB.getInteger(dataB));
    }

    public static Object multiply(ValueMetaInterface metaA, Object dataA, ValueMetaInterface metaB, Object dataB) throws KettleValueException {
        if (dataA == null || dataB == null) {
            return null;
        }
        if (metaB.isString() && metaA.isNumeric() || metaB.isNumeric() && metaA.isString()) {
            return ValueDataUtil.multiplyString(metaA, dataA, metaB, dataB);
        }
        return ValueDataUtil.multiplyNumeric(metaA, dataA, metaB, dataB);
    }

    protected static Object multiplyNumeric(ValueMetaInterface metaA, Object dataA, ValueMetaInterface metaB, Object dataB) throws KettleValueException {
        switch (metaA.getType()) {
            case 1: {
                return ValueDataUtil.multiplyDoubles(metaA.getNumber(dataA), metaB.getNumber(dataB));
            }
            case 5: {
                return ValueDataUtil.multiplyLongs(metaA.getInteger(dataA), metaB.getInteger(dataB));
            }
            case 6: {
                return ValueDataUtil.multiplyBigDecimals(metaA.getBigNumber(dataA), metaB.getBigNumber(dataB), null);
            }
        }
        throw new KettleValueException("The 'multiply' function only works on numeric data optionally multiplying strings.");
    }

    public static Double multiplyDoubles(Double a, Double b) {
        return new Double(a * b);
    }

    public static Long multiplyLongs(Long a, Long b) {
        return new Long(a * b);
    }

    public static BigDecimal multiplyBigDecimals(BigDecimal a, BigDecimal b, MathContext mc) {
        if (mc == null) {
            mc = MathContext.DECIMAL64;
        }
        return a.multiply(b, mc);
    }

    protected static Object multiplyString(ValueMetaInterface metaA, Object dataA, ValueMetaInterface metaB, Object dataB) throws KettleValueException {
        int n;
        StringBuffer s;
        String append = "";
        if (metaB.isString()) {
            s = new StringBuffer(metaB.getString(dataB));
            append = metaB.getString(dataB);
            n = metaA.getInteger(dataA).intValue();
        } else {
            s = new StringBuffer(metaA.getString(dataA));
            append = metaA.getString(dataA);
            n = metaB.getInteger(dataB).intValue();
        }
        if (n == 0) {
            s.setLength(0);
        } else {
            for (int i = 1; i < n; ++i) {
                s.append(append);
            }
        }
        return s.toString();
    }

    public static Object divide(ValueMetaInterface metaA, Object dataA, ValueMetaInterface metaB, Object dataB) throws KettleValueException {
        if (dataA == null || dataB == null) {
            return null;
        }
        switch (metaA.getType()) {
            case 1: {
                return ValueDataUtil.divideDoubles(metaA.getNumber(dataA), metaB.getNumber(dataB));
            }
            case 5: {
                return ValueDataUtil.divideLongs(metaA.getInteger(dataA), metaB.getInteger(dataB));
            }
            case 6: {
                return ValueDataUtil.divideBigDecimals(metaA.getBigNumber(dataA), metaB.getBigNumber(dataB), null);
            }
        }
        throw new KettleValueException("The 'divide' function only works on numeric data.");
    }

    public static Double divideDoubles(Double a, Double b) {
        return new Double(a / b);
    }

    public static Long divideLongs(Long a, Long b) {
        return new Long(a / b);
    }

    public static BigDecimal divideBigDecimals(BigDecimal a, BigDecimal b, MathContext mc) {
        if (mc == null) {
            mc = MathContext.DECIMAL64;
        }
        return a.divide(b, mc);
    }

    public static Object sqrt(ValueMetaInterface metaA, Object dataA) throws KettleValueException {
        if (dataA == null) {
            return null;
        }
        switch (metaA.getType()) {
            case 1: {
                return new Double(Math.sqrt(metaA.getNumber(dataA)));
            }
            case 5: {
                return new Long(Math.round(Math.sqrt(metaA.getNumber(dataA))));
            }
            case 6: {
                return BigDecimal.valueOf(Math.sqrt(metaA.getNumber(dataA)));
            }
        }
        throw new KettleValueException("The 'sqrt' function only works on numeric data.");
    }

    public static Object percent1(ValueMetaInterface metaA, Object dataA, ValueMetaInterface metaB, Object dataB) throws KettleValueException {
        if (dataA == null || dataB == null) {
            return null;
        }
        switch (metaA.getType()) {
            case 1: {
                return ValueDataUtil.divideDoubles(ValueDataUtil.multiplyDoubles(100.0, metaA.getNumber(dataA)), metaB.getNumber(dataB));
            }
            case 5: {
                return ValueDataUtil.divideLongs(ValueDataUtil.multiplyLongs(100L, metaA.getInteger(dataA)), metaB.getInteger(dataB));
            }
            case 6: {
                return ValueDataUtil.divideBigDecimals(ValueDataUtil.multiplyBigDecimals(metaA.getBigNumber(dataA), new BigDecimal(100), null), metaB.getBigNumber(dataB), null);
            }
        }
        throw new KettleValueException("The 'A/B in %' function only works on numeric data");
    }

    public static Object percent2(ValueMetaInterface metaA, Object dataA, ValueMetaInterface metaB, Object dataB) throws KettleValueException {
        if (dataA == null || dataB == null) {
            return null;
        }
        switch (metaA.getType()) {
            case 1: {
                return new Double(metaA.getNumber(dataA) - ValueDataUtil.divideDoubles(ValueDataUtil.multiplyDoubles(metaA.getNumber(dataA), metaB.getNumber(dataB)), 100.0));
            }
            case 5: {
                return new Long(metaA.getInteger(dataA) - ValueDataUtil.divideLongs(ValueDataUtil.multiplyLongs(metaA.getInteger(dataA), metaB.getInteger(dataB)), 100L));
            }
            case 6: {
                return metaA.getBigNumber(dataA).subtract(ValueDataUtil.divideBigDecimals(metaA.getBigNumber(dataA), ValueDataUtil.multiplyBigDecimals(metaB.getBigNumber(dataB), new BigDecimal(100), null), null));
            }
        }
        throw new KettleValueException("The 'A-B%' function only works on numeric data");
    }

    public static Object percent3(ValueMetaInterface metaA, Object dataA, ValueMetaInterface metaB, Object dataB) throws KettleValueException {
        if (dataA == null || dataB == null) {
            return null;
        }
        switch (metaA.getType()) {
            case 1: {
                return new Double(metaA.getNumber(dataA) + ValueDataUtil.divideDoubles(ValueDataUtil.multiplyDoubles(metaA.getNumber(dataA), metaB.getNumber(dataB)), 100.0));
            }
            case 5: {
                return new Long(metaA.getInteger(dataA) + ValueDataUtil.divideLongs(ValueDataUtil.multiplyLongs(metaA.getInteger(dataA), metaB.getInteger(dataB)), 100L));
            }
            case 6: {
                return metaA.getBigNumber(dataA).add(ValueDataUtil.divideBigDecimals(metaA.getBigNumber(dataA), ValueDataUtil.multiplyBigDecimals(metaB.getBigNumber(dataB), new BigDecimal(100), null), null));
            }
        }
        throw new KettleValueException("The 'A+B%' function only works on numeric data");
    }

    public static Object combination1(ValueMetaInterface metaA, Object dataA, ValueMetaInterface metaB, Object dataB, ValueMetaInterface metaC, Object dataC) throws KettleValueException {
        if (dataA == null || dataB == null || dataC == null) {
            return null;
        }
        switch (metaA.getType()) {
            case 1: {
                return new Double(metaA.getNumber(dataA) + metaB.getNumber(dataB) * metaC.getNumber(dataC));
            }
            case 5: {
                return new Long(metaA.getInteger(dataA) + metaB.getInteger(dataB) * metaC.getInteger(dataC));
            }
            case 6: {
                return metaA.getBigNumber(dataA).add(ValueDataUtil.multiplyBigDecimals(metaB.getBigNumber(dataB), metaC.getBigNumber(dataC), null));
            }
        }
        throw new KettleValueException("The 'combination1' function only works on numeric data");
    }

    public static Object combination2(ValueMetaInterface metaA, Object dataA, ValueMetaInterface metaB, Object dataB) throws KettleValueException {
        if (dataA == null || dataB == null) {
            return null;
        }
        switch (metaA.getType()) {
            case 1: {
                return new Double(Math.sqrt(metaA.getNumber(dataA) * metaA.getNumber(dataA) + metaB.getNumber(dataB) * metaB.getNumber(dataB)));
            }
            case 5: {
                return new Long(Math.round(Math.sqrt(metaA.getInteger(dataA) * metaA.getInteger(dataA) + metaB.getInteger(dataB) / metaB.getInteger(dataB))));
            }
            case 6: {
                return BigDecimal.valueOf(Math.sqrt(metaA.getNumber(dataA) * metaA.getNumber(dataA) + metaB.getNumber(dataB) * metaB.getNumber(dataB)));
            }
        }
        throw new KettleValueException("The 'combination2' function only works on numeric data");
    }

    public static Object round(ValueMetaInterface metaA, Object dataA) throws KettleValueException {
        if (dataA == null) {
            return null;
        }
        switch (metaA.getType()) {
            case 1: {
                return new Double(Math.round(metaA.getNumber(dataA)));
            }
            case 5: {
                return metaA.getInteger(dataA);
            }
            case 6: {
                return new BigDecimal(Math.round(metaA.getNumber(dataA)));
            }
        }
        throw new KettleValueException("The 'round' function only works on numeric data");
    }

    public static Object round(ValueMetaInterface metaA, Object dataA, int roundingMode) throws KettleValueException {
        if (dataA == null) {
            return null;
        }
        switch (metaA.getType()) {
            case 1: {
                return new Double(Const.round(metaA.getNumber(dataA), 0, roundingMode));
            }
            case 5: {
                return metaA.getInteger(dataA);
            }
            case 6: {
                BigDecimal number = metaA.getBigNumber(dataA);
                return number.setScale(0, roundingMode);
            }
        }
        throw new KettleValueException("The 'round' function only works on numeric data");
    }

    public static Object round(ValueMetaInterface metaA, Object dataA, ValueMetaInterface metaB, Object dataB) throws KettleValueException {
        return ValueDataUtil.round(metaA, dataA, metaB, dataB, 6);
    }

    public static Object round(ValueMetaInterface metaA, Object dataA, ValueMetaInterface metaB, Object dataB, int roundingMode) throws KettleValueException {
        if (dataA == null || dataB == null) {
            return null;
        }
        switch (metaA.getType()) {
            case 1: {
                return new Double(Const.round(metaA.getNumber(dataA), metaB.getInteger(dataB).intValue(), roundingMode));
            }
            case 5: {
                return metaA.getInteger(dataA);
            }
            case 6: {
                BigDecimal number = metaA.getBigNumber(dataA);
                return number.setScale(metaB.getInteger(dataB).intValue(), roundingMode);
            }
        }
        throw new KettleValueException("The 'round' function only works on numeric data");
    }

    public static Object ceil(ValueMetaInterface metaA, Object dataA) throws KettleValueException {
        if (dataA == null) {
            return null;
        }
        switch (metaA.getType()) {
            case 1: {
                return new Double(Math.ceil(metaA.getNumber(dataA)));
            }
            case 5: {
                return metaA.getInteger(dataA);
            }
            case 6: {
                return new BigDecimal(Math.ceil(metaA.getNumber(dataA)));
            }
        }
        throw new KettleValueException("The 'ceil' function only works on numeric data");
    }

    public static Object floor(ValueMetaInterface metaA, Object dataA) throws KettleValueException {
        if (dataA == null) {
            return null;
        }
        switch (metaA.getType()) {
            case 1: {
                return new Double(Math.floor(metaA.getNumber(dataA)));
            }
            case 5: {
                return metaA.getInteger(dataA);
            }
            case 6: {
                return new BigDecimal(Math.floor(metaA.getNumber(dataA)));
            }
        }
        throw new KettleValueException("The 'floor' function only works on numeric data");
    }

    public static Object abs(ValueMetaInterface metaA, Object dataA) throws KettleValueException {
        if (dataA == null) {
            return null;
        }
        switch (metaA.getType()) {
            case 1: {
                return new Double(Math.abs(metaA.getNumber(dataA)));
            }
            case 5: {
                return metaA.getInteger(Math.abs(metaA.getNumber(dataA).longValue()));
            }
            case 6: {
                return new BigDecimal(Math.abs(metaA.getNumber(dataA)));
            }
        }
        throw new KettleValueException("The 'abs' function only works on numeric data");
    }

    public static Object nvl(ValueMetaInterface metaA, Object dataA, ValueMetaInterface metaB, Object dataB) throws KettleValueException {
        switch (metaA.getType()) {
            case 2: {
                if (dataA == null) {
                    return metaB.getString(dataB);
                }
                return metaA.getString(dataA);
            }
            case 1: {
                if (dataA == null) {
                    return metaB.getNumber(dataB);
                }
                return metaA.getNumber(dataA);
            }
            case 5: {
                if (dataA == null) {
                    return metaB.getInteger(dataB);
                }
                return metaA.getInteger(dataA);
            }
            case 6: {
                if (dataA == null) {
                    return metaB.getBigNumber(dataB);
                }
                return metaA.getBigNumber(dataA);
            }
            case 3: {
                if (dataA == null) {
                    return metaB.getDate(dataB);
                }
                return metaA.getDate(dataA);
            }
            case 4: {
                if (dataA == null) {
                    return metaB.getBoolean(dataB);
                }
                return metaA.getBoolean(dataA);
            }
            case 8: {
                if (dataA == null) {
                    return metaB.getBinary(dataB);
                }
                return metaA.getBinary(dataA);
            }
        }
        if (dataA == null) {
            return metaB.getNativeDataType(dataB);
        }
        return metaA.getNativeDataType(dataA);
    }

    public static Object removeTimeFromDate(ValueMetaInterface metaA, Object dataA) throws KettleValueException {
        Calendar cal = Calendar.getInstance();
        Date date = metaA.getDate(dataA);
        if (date != null) {
            cal.setTime(date);
            return Const.removeTimeFromDate(date);
        }
        return null;
    }

    public static Object addTimeToDate(ValueMetaInterface metaA, Object dataA, ValueMetaInterface metaB, Object dataB, ValueMetaInterface metaC, Object dataC) throws KettleValueException {
        if (dataA == null) {
            return null;
        }
        try {
            if (dataC == null) {
                return Const.addTimeToDate(metaA.getDate(dataA), metaB.getString(dataB), null);
            }
            return Const.addTimeToDate(metaA.getDate(dataA), metaB.getString(dataB), metaC.getString(dataC));
        }
        catch (Exception e) {
            throw new KettleValueException(e);
        }
    }

    public static Object addDays(ValueMetaInterface metaA, Object dataA, ValueMetaInterface metaB, Object dataB) throws KettleValueException {
        Calendar cal = Calendar.getInstance();
        cal.setTime(metaA.getDate(dataA));
        cal.add(6, metaB.getInteger(dataB).intValue());
        return cal.getTime();
    }

    public static Object addHours(ValueMetaInterface metaA, Object dataA, ValueMetaInterface metaB, Object dataB) throws KettleValueException {
        Calendar cal = Calendar.getInstance();
        cal.setTime(metaA.getDate(dataA));
        cal.add(11, metaB.getInteger(dataB).intValue());
        return cal.getTime();
    }

    public static Object addMinutes(ValueMetaInterface metaA, Object dataA, ValueMetaInterface metaB, Object dataB) throws KettleValueException {
        Calendar cal = Calendar.getInstance();
        cal.setTime(metaA.getDate(dataA));
        cal.add(12, metaB.getInteger(dataB).intValue());
        return cal.getTime();
    }

    public static Object addMonths(ValueMetaInterface metaA, Object dataA, ValueMetaInterface metaB, Object dataB) throws KettleValueException {
        if (dataA != null && dataB != null) {
            Calendar cal = Calendar.getInstance();
            cal.setTime(metaA.getDate(dataA));
            int year = cal.get(1);
            int month = cal.get(2);
            int day = cal.get(5);
            int newyear = year + (int)Math.floor((month += metaB.getInteger(dataB).intValue()) / 12);
            int newmonth = month % 12;
            cal.set(newyear, newmonth, 1);
            int newday = cal.getActualMaximum(5);
            if (newday < day) {
                cal.set(5, newday);
            } else {
                cal.set(5, day);
            }
            return cal.getTime();
        }
        throw new KettleValueException("Unable to add months with a null value");
    }

    public static Object DateDiff(ValueMetaInterface metaA, Object dataA, ValueMetaInterface metaB, Object dataB, String resultType) throws KettleValueException {
        if (dataA != null && dataB != null) {
            Date startDate = metaB.getDate(dataB);
            Date endDate = metaA.getDate(dataA);
            Calendar stDateCal = Calendar.getInstance();
            Calendar endDateCal = Calendar.getInstance();
            stDateCal.setTime(startDate);
            endDateCal.setTime(endDate);
            long endL = endDateCal.getTimeInMillis() + (long)endDateCal.getTimeZone().getOffset(endDateCal.getTimeInMillis());
            long startL = stDateCal.getTimeInMillis() + (long)stDateCal.getTimeZone().getOffset(stDateCal.getTimeInMillis());
            long diff = endL - startL;
            if (Const.isEmpty(resultType)) {
                return new Long(diff / 86400000L);
            }
            if (resultType.equals("ms")) {
                return new Long(diff);
            }
            if (resultType.equals("s")) {
                return new Long(diff / 1000L);
            }
            if (resultType.equals("mn")) {
                return new Long(diff / 60000L);
            }
            if (resultType.equals("h")) {
                return new Long(diff / 3600000L);
            }
            if (resultType.equals("d")) {
                return new Long(diff / 86400000L);
            }
            throw new KettleValueException("Unknown result type option '" + resultType + "'");
        }
        return null;
    }

    public static Object DateWorkingDiff(ValueMetaInterface metaA, Object dataA, ValueMetaInterface metaB, Object dataB) throws KettleValueException {
        if (dataA != null && dataB != null) {
            Date fromDate = metaB.getDate(dataB);
            Date toDate = metaA.getDate(dataA);
            boolean singminus = false;
            if (fromDate.after(toDate)) {
                singminus = true;
                Date temp = fromDate;
                fromDate = toDate;
                toDate = temp;
            }
            Calendar calFrom = Calendar.getInstance();
            calFrom.setTime(fromDate);
            Calendar calTo = Calendar.getInstance();
            calTo.setTime(toDate);
            int iNoOfWorkingDays = 0;
            do {
                if (calFrom.get(7) != 7 && calFrom.get(7) != 1) {
                    ++iNoOfWorkingDays;
                }
                calFrom.add(5, 1);
            } while (calFrom.getTimeInMillis() < calTo.getTimeInMillis());
            return new Long(singminus ? (long)(-iNoOfWorkingDays) : (long)iNoOfWorkingDays);
        }
        return null;
    }

    public static Object yearOfDate(ValueMetaInterface metaA, Object dataA) throws KettleValueException {
        if (dataA == null) {
            return null;
        }
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(metaA.getDate(dataA));
        return new Long(calendar.get(1));
    }

    public static Object monthOfDate(ValueMetaInterface metaA, Object dataA) throws KettleValueException {
        if (dataA == null) {
            return null;
        }
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(metaA.getDate(dataA));
        return new Long(calendar.get(2) + 1);
    }

    public static Object quarterOfDate(ValueMetaInterface metaA, Object dataA) throws KettleValueException {
        if (dataA == null) {
            return null;
        }
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(metaA.getDate(dataA));
        return new Long((calendar.get(2) + 3) / 3);
    }

    public static Object dayOfYear(ValueMetaInterface metaA, Object dataA) throws KettleValueException {
        if (dataA == null) {
            return null;
        }
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(metaA.getDate(dataA));
        return new Long(calendar.get(6));
    }

    public static Object dayOfMonth(ValueMetaInterface metaA, Object dataA) throws KettleValueException {
        if (dataA == null) {
            return null;
        }
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(metaA.getDate(dataA));
        return new Long(calendar.get(5));
    }

    public static Object hourOfDay(ValueMetaInterface metaA, Object dataA) throws KettleValueException {
        if (dataA == null) {
            return null;
        }
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(metaA.getDate(dataA));
        return new Long(calendar.get(11));
    }

    public static Object minuteOfHour(ValueMetaInterface metaA, Object dataA) throws KettleValueException {
        if (dataA == null) {
            return null;
        }
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(metaA.getDate(dataA));
        return new Long(calendar.get(12));
    }

    public static Object secondOfMinute(ValueMetaInterface metaA, Object dataA) throws KettleValueException {
        if (dataA == null) {
            return null;
        }
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(metaA.getDate(dataA));
        return new Long(calendar.get(13));
    }

    public static Object dayOfWeek(ValueMetaInterface metaA, Object dataA) throws KettleValueException {
        if (dataA == null) {
            return null;
        }
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(metaA.getDate(dataA));
        return new Long(calendar.get(7));
    }

    public static Object weekOfYear(ValueMetaInterface metaA, Object dataA) throws KettleValueException {
        if (dataA == null) {
            return null;
        }
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(metaA.getDate(dataA));
        return new Long(calendar.get(3));
    }

    public static Object weekOfYearISO8601(ValueMetaInterface metaA, Object dataA) throws KettleValueException {
        if (dataA == null) {
            return null;
        }
        Calendar calendar = Calendar.getInstance(Locale.ENGLISH);
        calendar.setMinimalDaysInFirstWeek(4);
        calendar.setFirstDayOfWeek(2);
        calendar.setTime(metaA.getDate(dataA));
        return new Long(calendar.get(3));
    }

    public static Object yearOfDateISO8601(ValueMetaInterface metaA, Object dataA) throws KettleValueException {
        if (dataA == null) {
            return null;
        }
        Calendar calendar = Calendar.getInstance(Locale.ENGLISH);
        calendar.setMinimalDaysInFirstWeek(4);
        calendar.setFirstDayOfWeek(2);
        calendar.setTime(metaA.getDate(dataA));
        int week = calendar.get(3);
        int month = calendar.get(2);
        int year = calendar.get(1);
        if (week >= 52 && month == 0) {
            --year;
        }
        if (week <= 2 && month == 11) {
            ++year;
        }
        return new Long(year);
    }

    public static String hexToByteDecode(ValueMetaInterface meta, Object data) throws KettleValueException {
        if (meta.isNull(data)) {
            return null;
        }
        String hexString = meta.getString(data);
        int len = hexString.length();
        char[] chArray = new char[(len + 1) / 2];
        boolean evenByte = true;
        int nextByte = 0;
        if (len % 2 == 1) {
            evenByte = false;
        }
        int j = 0;
        for (int i = 0; i < len; ++i) {
            int nibble;
            char c = hexString.charAt(i);
            if (c >= '0' && c <= '9') {
                nibble = c - 48;
            } else if (c >= 'A' && c <= 'F') {
                nibble = c - 65 + 10;
            } else if (c >= 'a' && c <= 'f') {
                nibble = c - 97 + 10;
            } else {
                throw new KettleValueException("invalid hex digit '" + c + "'.");
            }
            if (evenByte) {
                nextByte = nibble << 4;
            } else {
                chArray[j] = (char)(nextByte += nibble);
                ++j;
            }
            evenByte = !evenByte;
        }
        return new String(chArray);
    }

    public static String byteToHexEncode(ValueMetaInterface metaA, Object dataA) throws KettleValueException {
        if (dataA == null) {
            return null;
        }
        char[] hexDigits = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};
        String hex = metaA.getString(dataA);
        char[] s = hex.toCharArray();
        StringBuffer hexString = new StringBuffer(2 * s.length);
        for (int i = 0; i < s.length; ++i) {
            hexString.append(hexDigits[(s[i] & 0xF0) >> 4]);
            hexString.append(hexDigits[s[i] & 0xF]);
        }
        return hexString.toString();
    }

    public static String charToHexEncode(ValueMetaInterface meta, Object data) throws KettleValueException {
        char[] hexDigits = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};
        if (meta.isNull(data)) {
            return null;
        }
        String hex = meta.getString(data);
        char[] s = hex.toCharArray();
        StringBuffer hexString = new StringBuffer(2 * s.length);
        for (int i = 0; i < s.length; ++i) {
            hexString.append(hexDigits[(s[i] & 0xF000) >> 12]);
            hexString.append(hexDigits[(s[i] & 0xF00) >> 8]);
            hexString.append(hexDigits[(s[i] & 0xF0) >> 4]);
            hexString.append(hexDigits[s[i] & 0xF]);
        }
        return hexString.toString();
    }

    public static String hexToCharDecode(ValueMetaInterface meta, Object data) throws KettleValueException {
        if (meta.isNull(data)) {
            return null;
        }
        String hexString = meta.getString(data);
        int len = hexString.length();
        char[] chArray = new char[(len + 3) / 4];
        int nextChar = 0;
        int charNr = len % 4;
        if (charNr == 0) {
            charNr = 4;
        }
        int j = 0;
        for (int i = 0; i < len; ++i) {
            int nibble;
            char c = hexString.charAt(i);
            if (c >= '0' && c <= '9') {
                nibble = c - 48;
            } else if (c >= 'A' && c <= 'F') {
                nibble = c - 65 + 10;
            } else if (c >= 'a' && c <= 'f') {
                nibble = c - 97 + 10;
            } else {
                throw new KettleValueException("invalid hex digit '" + c + "'.");
            }
            if (charNr == 4) {
                nextChar = nibble << 12;
                --charNr;
                continue;
            }
            if (charNr == 3) {
                nextChar += nibble << 8;
                --charNr;
                continue;
            }
            if (charNr == 2) {
                nextChar += nibble << 4;
                --charNr;
                continue;
            }
            chArray[j] = (char)(nextChar += nibble);
            charNr = 4;
            ++j;
        }
        return new String(chArray);
    }

    public static final String rightPad(String ret, int limit) {
        if (ret == null) {
            return ValueDataUtil.rightPad(new StringBuffer(), limit);
        }
        return ValueDataUtil.rightPad(new StringBuffer(ret), limit);
    }

    public static final String rightPad(StringBuffer ret, int limit) {
        int len = ret.length();
        if (len > limit) {
            ret.setLength(limit);
        } else {
            for (int l = len; l < limit; ++l) {
                ret.append(' ');
            }
        }
        return ret.toString();
    }

    public static final String replace(String string, String repl, String with) {
        StringBuffer str = new StringBuffer(string);
        for (int i = str.length() - 1; i >= 0; --i) {
            if (!str.substring(i).startsWith(repl)) continue;
            str.delete(i, i + repl.length());
            str.insert(i, with);
        }
        return str.toString();
    }

    public static void replaceBuffer(StringBuffer str, String code, String repl) {
        int clength = code.length();
        for (int i = str.length() - clength; i >= 0; --i) {
            String look = str.substring(i, i + clength);
            if (!look.equalsIgnoreCase(code)) continue;
            str.replace(i, i + clength, repl);
        }
    }

    public static final int nrSpacesBefore(String field) {
        int nr;
        int len = field.length();
        for (nr = 0; nr < len && field.charAt(nr) == ' '; ++nr) {
        }
        return nr;
    }

    public static final int nrSpacesAfter(String field) {
        int nr;
        int len = field.length();
        for (nr = 0; nr < len && field.charAt(field.length() - 1 - nr) == ' '; ++nr) {
        }
        return nr;
    }

    public static final boolean onlySpaces(String str) {
        for (int i = 0; i < str.length(); ++i) {
            if (ValueDataUtil.isSpace(str.charAt(i))) continue;
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isXMLFileWellFormed(ValueMetaInterface metaA, Object dataA) {
        if (dataA == null) {
            return false;
        }
        String filename = dataA.toString();
        FileObject file = null;
        try {
            file = KettleVFS.getFileObject(filename);
            boolean bl = XMLCheck.isXMLFileWellFormed(file);
            return bl;
        }
        catch (Exception e) {
        }
        finally {
            if (file != null) {
                try {
                    file.close();
                }
                catch (Exception e) {}
            }
        }
        return false;
    }

    public static boolean isXMLWellFormed(ValueMetaInterface metaA, Object dataA) {
        if (dataA == null) {
            return false;
        }
        try {
            return XMLCheck.isXMLWellFormed(new ByteArrayInputStream(metaA.getBinary(dataA)));
        }
        catch (Exception exception) {
            return false;
        }
    }

    public static String getFileEncoding(ValueMetaInterface metaA, Object dataA) throws KettleValueException {
        if (dataA == null) {
            return null;
        }
        try {
            return CharsetToolkit.guessEncodingName(new File(metaA.getString(dataA)));
        }
        catch (Exception e) {
            throw new KettleValueException(e);
        }
    }

    public static Object getZeroForValueMetaType(ValueMetaInterface type) throws KettleValueException {
        if (type == null) {
            throw new KettleValueException("API error. ValueMetaInterface can't be null!");
        }
        switch (type.getType()) {
            case 5: {
                return new Long(0L);
            }
            case 1: {
                return new Double(0.0);
            }
            case 6: {
                return new BigDecimal(0);
            }
            case 2: {
                return "";
            }
        }
        throw new KettleValueException("get zero function undefined for data type: " + type.getType());
    }
}

