/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.core.logging;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.pentaho.di.core.Const;
import org.pentaho.di.core.logging.BufferLine;
import org.pentaho.di.core.logging.KettleLogLayout;
import org.pentaho.di.core.logging.KettleLoggingEvent;
import org.pentaho.di.core.logging.KettleLoggingEventListener;
import org.pentaho.di.core.logging.LogMessage;
import org.pentaho.di.core.logging.LoggingObjectInterface;
import org.pentaho.di.core.logging.LoggingObjectType;
import org.pentaho.di.core.logging.LoggingRegistry;

public class LoggingBuffer {
    private String name;
    private List<BufferLine> buffer;
    private int bufferSize;
    private KettleLogLayout layout;
    private List<KettleLoggingEventListener> eventListeners;

    public LoggingBuffer(int bufferSize) {
        this.bufferSize = bufferSize;
        this.buffer = Collections.synchronizedList(new LinkedList());
        this.layout = new KettleLogLayout(true);
        this.eventListeners = Collections.synchronizedList(new ArrayList());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getLastBufferLineNr() {
        List<BufferLine> list = this.buffer;
        synchronized (list) {
            if (this.buffer.size() > 0) {
                return this.buffer.get(this.buffer.size() - 1).getNr();
            }
            return 0;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<KettleLoggingEvent> getLogBufferFromTo(List<String> channelId, boolean includeGeneral, int from, int to) {
        ArrayList<KettleLoggingEvent> lines = new ArrayList<KettleLoggingEvent>();
        List<BufferLine> list = this.buffer;
        synchronized (list) {
            for (BufferLine line : this.buffer) {
                boolean include;
                Object payload;
                if (line.getNr() <= from || line.getNr() > to || !((payload = line.getEvent().getMessage()) instanceof LogMessage)) continue;
                LogMessage message = (LogMessage)payload;
                boolean bl = include = channelId == null;
                if (!include) {
                    LoggingObjectInterface loggingObject = LoggingRegistry.getInstance().getLoggingObject(message.getLogChannelId());
                    if (loggingObject != null && includeGeneral && LoggingObjectType.GENERAL.equals((Object)loggingObject.getObjectType())) {
                        include = true;
                    }
                    if (!include) {
                        for (String id : channelId) {
                            if (!message.getLogChannelId().equals(id)) continue;
                            include = true;
                            break;
                        }
                    }
                }
                if (!include) continue;
                try {
                    lines.add(line.getEvent());
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
        return lines;
    }

    public List<KettleLoggingEvent> getLogBufferFromTo(String parentLogChannelId, boolean includeGeneral, int from, int to) {
        List<String> childIds = LoggingRegistry.getInstance().getLogChannelChildren(parentLogChannelId);
        return this.getLogBufferFromTo(childIds, includeGeneral, from, to);
    }

    public StringBuffer getBuffer(String parentLogChannelId, boolean includeGeneral, int startLineNr, int endLineNr) {
        StringBuffer stringBuffer = new StringBuffer(10000);
        List<KettleLoggingEvent> events = this.getLogBufferFromTo(parentLogChannelId, includeGeneral, startLineNr, endLineNr);
        for (KettleLoggingEvent event : events) {
            stringBuffer.append(this.layout.format(event)).append(Const.CR);
        }
        return stringBuffer;
    }

    public StringBuffer getBuffer(String parentLogChannelId, boolean includeGeneral) {
        return this.getBuffer(parentLogChannelId, includeGeneral, 0);
    }

    public StringBuffer getBuffer(String parentLogChannelId, boolean includeGeneral, int startLineNr) {
        return this.getBuffer(parentLogChannelId, includeGeneral, startLineNr, this.getLastBufferLineNr());
    }

    public StringBuffer getBuffer() {
        return this.getBuffer(null, true);
    }

    public void close() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doAppend(KettleLoggingEvent event) {
        List<BufferLine> list = this.buffer;
        synchronized (list) {
            this.buffer.add(new BufferLine(event));
            while (this.bufferSize > 0 && this.buffer.size() > this.bufferSize) {
                this.buffer.remove(0);
            }
        }
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public void setLayout(KettleLogLayout layout) {
        this.layout = layout;
    }

    public KettleLogLayout getLayout() {
        return this.layout;
    }

    public boolean requiresLayout() {
        return true;
    }

    public void clear() {
        this.buffer.clear();
    }

    public int getMaxNrLines() {
        return this.bufferSize;
    }

    public void setMaxNrLines(int maxNrLines) {
        this.bufferSize = maxNrLines;
    }

    public int getNrLines() {
        return this.buffer.size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeChannelFromBuffer(String id) {
        List<BufferLine> list = this.buffer;
        synchronized (list) {
            Iterator<BufferLine> iterator = this.buffer.iterator();
            while (iterator.hasNext()) {
                LogMessage message;
                BufferLine bufferLine = iterator.next();
                Object payload = bufferLine.getEvent().getMessage();
                if (!(payload instanceof LogMessage) || !id.equals((message = (LogMessage)payload).getLogChannelId())) continue;
                iterator.remove();
            }
        }
    }

    public int size() {
        return this.buffer.size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeGeneralMessages() {
        List<BufferLine> list = this.buffer;
        synchronized (list) {
            Iterator<BufferLine> iterator = this.buffer.iterator();
            while (iterator.hasNext()) {
                BufferLine bufferLine = iterator.next();
                Object payload = bufferLine.getEvent().getMessage();
                if (!(payload instanceof LogMessage)) continue;
                LogMessage message = (LogMessage)payload;
                LoggingObjectInterface loggingObject = LoggingRegistry.getInstance().getLoggingObject(message.getLogChannelId());
                if (loggingObject == null || !LoggingObjectType.GENERAL.equals((Object)loggingObject.getObjectType())) continue;
                iterator.remove();
            }
        }
    }

    public Iterator<BufferLine> getBufferIterator() {
        return this.buffer.iterator();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String dump() {
        StringBuffer buf = new StringBuffer(50000);
        List<BufferLine> list = this.buffer;
        synchronized (list) {
            for (BufferLine line : this.buffer) {
                Object payload = line.getEvent().getMessage();
                if (!(payload instanceof LogMessage)) continue;
                LogMessage message = (LogMessage)payload;
                buf.append(message.getLogChannelId() + "\t" + message.getSubject() + "\t" + message.getMessage() + "\n");
            }
        }
        return buf.toString();
    }

    public void removeBufferLines(List<BufferLine> linesToRemove) {
        this.buffer.removeAll(linesToRemove);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<BufferLine> getBufferLinesBefore(long minTimeBoundary) {
        ArrayList<BufferLine> linesToRemove = new ArrayList<BufferLine>();
        List<BufferLine> list = this.buffer;
        synchronized (list) {
            for (BufferLine bufferLine : this.buffer) {
                if (bufferLine.getEvent().timeStamp >= minTimeBoundary) break;
                linesToRemove.add(bufferLine);
            }
        }
        return linesToRemove;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addLogggingEvent(KettleLoggingEvent loggingEvent) {
        this.doAppend(loggingEvent);
        List<KettleLoggingEventListener> list = this.eventListeners;
        synchronized (list) {
            for (KettleLoggingEventListener listener : this.eventListeners) {
                listener.eventAdded(loggingEvent);
            }
        }
    }

    public void addLoggingEventListener(KettleLoggingEventListener listener) {
        this.eventListeners.add(listener);
    }

    public void removeLoggingEventListener(KettleLoggingEventListener listener) {
        this.eventListeners.remove(listener);
    }
}

