/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.db;

import com.google.common.base.Function;
import java.nio.ByteBuffer;
import java.util.Collection;
import java.util.Iterator;
import java.util.SortedMap;
import java.util.SortedSet;
import java.util.TreeMap;
import org.apache.cassandra.config.CFMetaData;
import org.apache.cassandra.db.AbstractThreadUnsafeSortedColumns;
import org.apache.cassandra.db.Column;
import org.apache.cassandra.db.ColumnFamily;
import org.apache.cassandra.db.DeletionInfo;
import org.apache.cassandra.db.filter.ColumnSlice;
import org.apache.cassandra.db.marshal.AbstractType;
import org.apache.cassandra.utils.Allocator;

public class TreeMapBackedSortedColumns
extends AbstractThreadUnsafeSortedColumns {
    private final TreeMap<ByteBuffer, Column> map;
    public static final ColumnFamily.Factory<TreeMapBackedSortedColumns> factory = new ColumnFamily.Factory<TreeMapBackedSortedColumns>(){

        @Override
        public TreeMapBackedSortedColumns create(CFMetaData metadata, boolean insertReversed) {
            assert (!insertReversed);
            return new TreeMapBackedSortedColumns(metadata);
        }
    };

    @Override
    public AbstractType<?> getComparator() {
        return (AbstractType)this.map.comparator();
    }

    private TreeMapBackedSortedColumns(CFMetaData metadata) {
        super(metadata);
        this.map = new TreeMap(metadata.comparator);
    }

    private TreeMapBackedSortedColumns(CFMetaData metadata, SortedMap<ByteBuffer, Column> columns) {
        super(metadata);
        this.map = new TreeMap<ByteBuffer, Column>(columns);
    }

    @Override
    public ColumnFamily.Factory getFactory() {
        return factory;
    }

    @Override
    public ColumnFamily cloneMe() {
        return new TreeMapBackedSortedColumns(this.metadata, this.map);
    }

    @Override
    public boolean isInsertReversed() {
        return false;
    }

    @Override
    public void addColumn(Column column, Allocator allocator) {
        ByteBuffer name = column.name();
        Column oldColumn = this.map.put(name, column);
        if (oldColumn == null) {
            return;
        }
        this.map.put(name, column.reconcile(oldColumn, allocator));
    }

    @Override
    public void addAll(ColumnFamily cm, Allocator allocator, Function<Column, Column> transformation) {
        this.delete(cm.deletionInfo());
        for (Column column : cm) {
            this.addColumn((Column)transformation.apply((Object)column), allocator);
        }
    }

    @Override
    public boolean replace(Column oldColumn, Column newColumn) {
        if (!oldColumn.name().equals(newColumn.name())) {
            throw new IllegalArgumentException();
        }
        Column previous = this.map.put(oldColumn.name(), newColumn);
        if (previous == null) {
            this.map.remove(oldColumn.name());
            return false;
        }
        if (!previous.equals(oldColumn)) {
            this.map.put(oldColumn.name(), previous);
            return false;
        }
        return true;
    }

    @Override
    public Column getColumn(ByteBuffer name) {
        return this.map.get(name);
    }

    @Override
    public void clear() {
        this.setDeletionInfo(DeletionInfo.live());
        this.map.clear();
    }

    @Override
    public int getColumnCount() {
        return this.map.size();
    }

    @Override
    public Collection<Column> getSortedColumns() {
        return this.map.values();
    }

    @Override
    public Collection<Column> getReverseSortedColumns() {
        return this.map.descendingMap().values();
    }

    public SortedSet<ByteBuffer> getColumnNames() {
        return this.map.navigableKeySet();
    }

    @Override
    public Iterator<Column> iterator() {
        return this.map.values().iterator();
    }

    @Override
    public Iterator<Column> iterator(ColumnSlice[] slices) {
        return new ColumnSlice.NavigableMapIterator(this.map, slices);
    }

    @Override
    public Iterator<Column> reverseIterator(ColumnSlice[] slices) {
        return new ColumnSlice.NavigableMapIterator(this.map.descendingMap(), slices);
    }
}

