/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.agilebi.modeler.nodes.annotations;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.List;
import org.pentaho.agilebi.modeler.nodes.AbstractMetaDataModelNode;
import org.pentaho.agilebi.modeler.nodes.HierarchyMetaData;
import org.pentaho.agilebi.modeler.nodes.LevelMetaData;
import org.pentaho.agilebi.modeler.nodes.annotations.IAnalyzerDateFormatAnnotation;
import org.pentaho.metadata.model.olap.OlapAnnotation;
import org.pentaho.metadata.model.olap.OlapHierarchyLevel;

public class AnalyzerDateFormatAnnotation
implements IAnalyzerDateFormatAnnotation,
PropertyChangeListener {
    protected String value;

    public AnalyzerDateFormatAnnotation(String value) {
        this.value = value;
    }

    public AnalyzerDateFormatAnnotation(LevelMetaData levelMetaData) {
        this(levelMetaData.getFullTimeLevelFormat());
    }

    @Override
    public String getName() {
        return "AnalyzerDateFormat";
    }

    public String getValue() {
        return this.value;
    }

    public void setValue(String value) {
        this.value = value;
    }

    public void setValue(LevelMetaData levelMetaData) {
        this.setValue(levelMetaData.getFullTimeLevelFormat());
    }

    public String getTimeLevelFormat() {
        String[] parts;
        String value = this.getValue();
        if (value == null) {
            return null;
        }
        int numParts = (parts = value.split("\\.")).length;
        String part = parts[numParts == 0 ? 0 : numParts - 1];
        if (part.startsWith("[") && part.endsWith("]")) {
            part = part.substring(1, part.length() - 1);
        }
        return part;
    }

    public static String quoteTimeLevelFormat(String timeLevelFormat) {
        return "[" + timeLevelFormat + "]";
    }

    @Override
    public void saveAnnotations(Object obj) {
        OlapHierarchyLevel level = (OlapHierarchyLevel)obj;
        List annotations = level.getAnnotations();
        OlapAnnotation existingAnnotation = null;
        for (OlapAnnotation annotation : annotations) {
            if (!annotation.getName().equals(this.getName())) continue;
            existingAnnotation = annotation;
            break;
        }
        if (existingAnnotation == null) {
            annotations.add(new OlapAnnotation(this.getName(), this.getValue()));
        } else {
            existingAnnotation.setValue(this.getValue());
        }
    }

    @Override
    public boolean isValid(AbstractMetaDataModelNode node) {
        LevelMetaData levelMetaData = (LevelMetaData)node;
        HierarchyMetaData hierarchyMetaData = levelMetaData.getHierarchyMetaData();
        List<LevelMetaData> levels = hierarchyMetaData.getLevels();
        for (LevelMetaData ancestor : levels) {
            if (ancestor == node) {
                return true;
            }
            if (ancestor.getTimeLevelFormat() != null) continue;
            return false;
        }
        return true;
    }

    @Override
    public List<String> getValidationMessages(AbstractMetaDataModelNode node) {
        ArrayList<String> messages = null;
        LevelMetaData levelMetaData = (LevelMetaData)node;
        HierarchyMetaData hierarchyMetaData = levelMetaData.getHierarchyMetaData();
        List<LevelMetaData> levels = hierarchyMetaData.getLevels();
        for (LevelMetaData ancestor : levels) {
            if (ancestor == node) break;
            if (ancestor.getTimeLevelFormat() != null) continue;
            if (messages == null) {
                messages = new ArrayList<String>();
            }
            messages.add("Missing Time Level Format in level " + ancestor.getName());
        }
        return messages;
    }

    @Override
    public void onAttach(AbstractMetaDataModelNode node) {
        if (!(node instanceof LevelMetaData)) {
            return;
        }
        LevelMetaData levelMetaData = (LevelMetaData)node;
        levelMetaData.updateTimeLevelFormat(this);
        levelMetaData.addPropertyChangeListener("timeLevelFormat", this);
    }

    @Override
    public void onDetach(AbstractMetaDataModelNode node) {
        if (!(node instanceof LevelMetaData)) {
            return;
        }
        LevelMetaData levelMetaData = (LevelMetaData)node;
        levelMetaData.removePropertyChangeListener(this);
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        if (!"timeLevelFormat".equals(evt.getPropertyName())) {
            return;
        }
        Object source = evt.getSource();
        if (!(source instanceof LevelMetaData)) {
            return;
        }
        LevelMetaData levelMetaData = (LevelMetaData)source;
        String value = levelMetaData.getFullTimeLevelFormat();
        if (this.value == null && value == null) {
            return;
        }
        if (this.value != null && value != null && this.value.equals(value)) {
            return;
        }
        this.value = value;
    }
}

