/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.agilebi.modeler.nodes;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Vector;
import org.pentaho.agilebi.modeler.ModelerException;
import org.pentaho.agilebi.modeler.ModelerMessagesHolder;
import org.pentaho.agilebi.modeler.nodes.BaseColumnBackedMetaData;
import org.pentaho.metadata.model.LogicalColumn;
import org.pentaho.metadata.model.concept.types.AggregationType;
import org.pentaho.metadata.model.concept.types.DataType;
import org.pentaho.metadata.model.concept.types.LocalizedString;
import org.pentaho.ui.xul.stereotype.Bindable;

public abstract class BaseAggregationMetaDataNode
extends BaseColumnBackedMetaData {
    private static final long serialVersionUID = -6574834791283543091L;
    public static final String FORMAT_NONE = "NONE";
    protected String format = "NONE";
    protected String fieldTypeDesc = "---";
    protected String levelTypeDesc = "---";
    protected AggregationType defaultAggregation;
    protected String displayName;
    protected String locale;
    protected List<AggregationType> selectedAggregations = new Vector<AggregationType>();
    private List<AggregationType> possibleAggregations = new ArrayList<AggregationType>();

    public List<AggregationType> getNumericAggregationTypes() {
        return Arrays.asList(AggregationType.SUM, AggregationType.AVERAGE, AggregationType.MINIMUM, AggregationType.MAXIMUM, AggregationType.COUNT, AggregationType.COUNT_DISTINCT);
    }

    public List<AggregationType> getTextAggregationTypes() {
        return Arrays.asList(AggregationType.COUNT, AggregationType.COUNT_DISTINCT);
    }

    public BaseAggregationMetaDataNode(String locale) {
        this.locale = locale;
    }

    public BaseAggregationMetaDataNode(String fieldName, String format, String displayName, String locale) {
        super(fieldName);
        this.format = format;
        this.displayName = displayName;
        this.locale = locale;
    }

    @Override
    @Bindable
    public void setName(String name) {
        if (name != null) {
            super.setName(name);
            if (this.logicalColumn != null) {
                this.logicalColumn.setName(new LocalizedString(this.locale, name));
            }
        }
    }

    @Bindable
    public String getFormat() {
        if (this.format == null || "".equals(this.format) || "#".equals(this.format)) {
            return FORMAT_NONE;
        }
        return this.format;
    }

    @Bindable
    public void setFormat(String format) {
        String previousFormat = this.format;
        this.format = format;
        this.firePropertyChange("format", previousFormat, format);
    }

    @Bindable
    public String getFieldTypeDesc() {
        return this.fieldTypeDesc;
    }

    @Bindable
    public void setFieldTypeDesc(String fieldTypeDesc) {
        this.fieldTypeDesc = fieldTypeDesc;
    }

    @Bindable
    public String getLevelTypeDesc() {
        return this.levelTypeDesc;
    }

    @Bindable
    public void setLevelTypeDesc(String levelTypeDesc) {
        this.levelTypeDesc = levelTypeDesc;
    }

    @Bindable
    public AggregationType getDefaultAggregation() {
        if (this.logicalColumn == null) {
            return null;
        }
        if (this.defaultAggregation == null) {
            switch (this.logicalColumn.getDataType()) {
                case NUMERIC: {
                    this.defaultAggregation = AggregationType.SUM;
                    break;
                }
                default: {
                    this.defaultAggregation = AggregationType.COUNT;
                }
            }
        }
        return this.defaultAggregation;
    }

    @Bindable
    public void setDefaultAggregation(AggregationType aggType) {
        AggregationType previousAggregation = this.defaultAggregation;
        this.defaultAggregation = aggType;
        this.firePropertyChange("defaultAggregation", previousAggregation, this.defaultAggregation);
    }

    @Override
    public void setLogicalColumn(LogicalColumn col) {
        DataType previousDataType = null;
        if (this.logicalColumn != null) {
            previousDataType = this.logicalColumn.getDataType();
        }
        if (col == null) {
            super.setLogicalColumn(col);
            return;
        }
        super.setLogicalColumn(col);
        DataType newDataType = this.logicalColumn.getDataType();
        if (previousDataType == null || previousDataType != newDataType) {
            if (this.logicalColumn.getDataType() == DataType.NUMERIC) {
                this.setPossibleAggregations(this.getNumericAggregationTypes());
                this.setDefaultAggregation(AggregationType.SUM);
            } else {
                this.setPossibleAggregations(this.getTextAggregationTypes());
                this.setDefaultAggregation(AggregationType.NONE);
            }
            if (this.logicalColumn.getAggregationType() != null) {
                this.setDefaultAggregation(this.logicalColumn.getAggregationType());
            }
            if (col.getAggregationList() != null && !col.getAggregationList().isEmpty()) {
                this.setSelectedAggregations(col.getAggregationList());
            } else {
                this.setSelectedAggregations(this.possibleAggregations);
            }
        }
    }

    private void setPossibleAggregations(List<AggregationType> aggregationTypes) {
        this.possibleAggregations.clear();
        this.possibleAggregations.addAll(aggregationTypes);
        this.firePropertyChange("possibleAggregations", null, this.possibleAggregations);
    }

    public List<AggregationType> getPossibleAggregations() {
        return this.possibleAggregations;
    }

    @Bindable
    public List<AggregationType> getSelectedAggregations() {
        return this.selectedAggregations;
    }

    @Bindable
    public void setSelectedAggregations(List<AggregationType> selectedAggregations) {
        this.selectedAggregations = selectedAggregations;
        this.firePropertyChange("selectedAggregations", null, this.selectedAggregations);
    }

    public boolean equals(Object o) {
        if (o == null || !(o instanceof BaseAggregationMetaDataNode)) {
            return false;
        }
        BaseAggregationMetaDataNode f = (BaseAggregationMetaDataNode)o;
        if (o == this) {
            return true;
        }
        if (f.getLogicalColumn() == null || this.getLogicalColumn() == null) {
            return false;
        }
        return f.getLogicalColumn().getId().equals(this.getLogicalColumn().getId());
    }

    public String toString() {
        return this.name;
    }

    @Override
    public Object onDrop(Object data) throws ModelerException {
        throw new ModelerException(new IllegalArgumentException(ModelerMessagesHolder.getMessages().getString("invalid_drop", new String[0])));
    }
}

