/*
 * Decompiled with CFR 0.152.
 */
package mondrian.spi.impl;

import java.sql.Connection;
import java.sql.SQLException;
import mondrian.olap.Util;
import mondrian.spi.Dialect;
import mondrian.spi.impl.JdbcDialectFactory;
import mondrian.spi.impl.MySqlDialect;

public class InfobrightDialect
extends MySqlDialect {
    public static final JdbcDialectFactory FACTORY = new JdbcDialectFactory(InfobrightDialect.class, Dialect.DatabaseProduct.MYSQL){

        protected boolean acceptsConnection(Connection connection) {
            try {
                return super.acceptsConnection(connection) && MySqlDialect.isInfobright(connection.getMetaData());
            }
            catch (SQLException e) {
                throw Util.newError(e, "Error while instantiating dialect");
            }
        }
    };

    public InfobrightDialect(Connection connection) throws SQLException {
        super(connection);
    }

    public Dialect.DatabaseProduct getDatabaseProduct() {
        return Dialect.DatabaseProduct.INFOBRIGHT;
    }

    public boolean allowsCompoundCountDistinct() {
        return false;
    }

    public String generateOrderItem(String expr, boolean nullable, boolean ascending, boolean collateNullsLast) {
        if (ascending) {
            return expr + " ASC";
        }
        return expr + " DESC";
    }

    public boolean supportsGroupByExpressions() {
        return false;
    }

    public boolean requiresGroupByAlias() {
        return true;
    }

    public boolean allowsOrderByAlias() {
        return false;
    }

    public boolean requiresOrderByAlias() {
        return true;
    }

    public boolean supportsMultiValueInExpr() {
        return false;
    }
}

